/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.tk.Toolkit;
import java.nio.ByteBuffer;
import javafx.scene.image.PixelFormat;

public class ByteIndexed$Getter
implements BytePixelGetter {
    PixelFormat<ByteBuffer> theFormat;
    private int[] precolors;
    private int[] nonprecolors;

    ByteIndexed$Getter(PixelFormat<ByteBuffer> pixelFormat) {
        this.theFormat = pixelFormat;
    }

    int[] getPreColors() {
        if (this.precolors == null) {
            this.precolors = Toolkit.getImageAccessor().getPreColors(this.theFormat);
        }
        return this.precolors;
    }

    int[] getNonPreColors() {
        if (this.nonprecolors == null) {
            this.nonprecolors = Toolkit.getImageAccessor().getNonPreColors(this.theFormat);
        }
        return this.nonprecolors;
    }

    @Override
    public AlphaType getAlphaType() {
        if (this.theFormat.isPremultiplied()) {
            return AlphaType.PREMULTIPLIED;
        }
        return AlphaType.NONPREMULTIPLIED;
    }

    @Override
    public int getNumElements() {
        return 1;
    }

    @Override
    public int getArgb(byte[] byArray, int n2) {
        return this.getNonPreColors()[byArray[n2] & 0xFF];
    }

    @Override
    public int getArgbPre(byte[] byArray, int n2) {
        return this.getPreColors()[byArray[n2] & 0xFF];
    }

    @Override
    public int getArgb(ByteBuffer byteBuffer, int n2) {
        return this.getNonPreColors()[byteBuffer.get(n2) & 0xFF];
    }

    @Override
    public int getArgbPre(ByteBuffer byteBuffer, int n2) {
        return this.getPreColors()[byteBuffer.get(n2) & 0xFF];
    }
}

