/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import com.sun.javafx.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;

public class PulseLogger {
    public static final boolean PULSE_LOGGING_ENABLED;
    private static final String[] DEFAULT_LOGGERS;
    private static final Logger[] loggers;

    public static void pulseStart() {
        Logger[] loggerArray = loggers;
        int n2 = loggers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = loggerArray[i2];
            logger.pulseStart();
        }
    }

    public static void pulseEnd() {
        Logger[] loggerArray = loggers;
        int n2 = loggers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = loggerArray[i2];
            logger.pulseEnd();
        }
    }

    public static void renderStart() {
        Logger[] loggerArray = loggers;
        int n2 = loggers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = loggerArray[i2];
            logger.renderStart();
        }
    }

    public static void renderEnd() {
        Logger[] loggerArray = loggers;
        int n2 = loggers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = loggerArray[i2];
            logger.renderEnd();
        }
    }

    public static void addMessage(String string) {
        Logger[] loggerArray = loggers;
        int n2 = loggers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = loggerArray[i2];
            logger.addMessage(string);
        }
    }

    public static void incrementCounter(String string) {
        Logger[] loggerArray = loggers;
        int n2 = loggers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = loggerArray[i2];
            logger.incrementCounter(string);
        }
    }

    public static void newPhase(String string) {
        Logger[] loggerArray = loggers;
        int n2 = loggers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = loggerArray[i2];
            logger.newPhase(string);
        }
    }

    public static void newInput(String string) {
        Logger[] loggerArray = loggers;
        int n2 = loggers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Logger logger = loggerArray[i2];
            logger.newInput(string);
        }
    }

    public static boolean isPulseLoggingRequested() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.pulseLogger"));
    }

    private static Logger loadLogger(String object) {
        try {
            object = Class.forName((String)object);
            if (object != null) {
                object = ((Class)object).getDeclaredMethod("createInstance", new Class[0]);
                return (Logger)((Method)object).invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException throwable) {}
        return null;
    }

    static {
        DEFAULT_LOGGERS = new String[]{"com.sun.javafx.logging.PrintLogger", "com.sun.javafx.logging.jfr.JFRPulseLogger"};
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray = DEFAULT_LOGGERS;
        int n2 = DEFAULT_LOGGERS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = stringArray[i2];
            if ((object = PulseLogger.loadLogger((String)object)) == null) continue;
            arrayList.add(object);
        }
        ArrayList<Object> arrayList2 = arrayList;
        loggers = arrayList2.toArray(new Logger[arrayList2.size()]);
        PULSE_LOGGING_ENABLED = loggers.length > 0;
    }
}

