/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.property;

import com.sun.javafx.property.MethodHelper;
import com.sun.javafx.reflect.ReflectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javafx.beans.property.ReadOnlyProperty;

public final class PropertyReference<T> {
    private String name;
    private Method getter;
    private Method setter;
    private Method propertyGetter;
    private Class<?> clazz;
    private Class<?> type;
    private boolean reflected = false;

    public PropertyReference(Class<?> clazz, String string) {
        if (string == null) {
            throw new NullPointerException("Name must be specified");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Name must be specified");
        }
        if (clazz == null) {
            throw new NullPointerException("Class must be specified");
        }
        ReflectUtil.checkPackageAccess(clazz);
        this.name = string;
        this.clazz = clazz;
    }

    public final boolean isWritable() {
        this.reflect();
        return this.setter != null;
    }

    public final boolean isReadable() {
        this.reflect();
        return this.getter != null;
    }

    public final boolean hasProperty() {
        this.reflect();
        return this.propertyGetter != null;
    }

    public final String getName() {
        return this.name;
    }

    public final Class<?> getContainingClass() {
        return this.clazz;
    }

    public final Class<?> getType() {
        this.reflect();
        return this.type;
    }

    public final void set(Object object, T t2) {
        if (!this.isWritable()) {
            throw new IllegalStateException("Cannot write to readonly property " + this.name);
        }
        assert (this.setter != null);
        try {
            MethodHelper.invoke(this.setter, object, new Object[]{t2});
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public final T get(Object object) {
        if (!this.isReadable()) {
            throw new IllegalStateException("Cannot read from unreadable property " + this.name);
        }
        assert (this.getter != null);
        try {
            return (T)MethodHelper.invoke(this.getter, object, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public final ReadOnlyProperty<T> getProperty(Object object) {
        if (!this.hasProperty()) {
            throw new IllegalStateException("Cannot get property " + this.name);
        }
        assert (this.propertyGetter != null);
        try {
            return (ReadOnlyProperty)MethodHelper.invoke(this.propertyGetter, object, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public final String toString() {
        return this.name;
    }

    private void reflect() {
        block20: {
            if (!this.reflected) {
                this.reflected = true;
                try {
                    block19: {
                        Object object = this.name.length() == 1 ? this.name.substring(0, 1).toUpperCase() : Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
                        this.type = null;
                        Object object2 = "get" + (String)object;
                        try {
                            object2 = this.clazz.getMethod((String)object2, new Class[0]);
                            if (Modifier.isPublic(((Method)object2).getModifiers())) {
                                this.getter = object2;
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {}
                        if (this.getter == null) {
                            object2 = "is" + (String)object;
                            try {
                                object2 = this.clazz.getMethod((String)object2, new Class[0]);
                                if (Modifier.isPublic(((Method)object2).getModifiers())) {
                                    this.getter = object2;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {}
                        }
                        object2 = "set" + (String)object;
                        if (this.getter != null) {
                            this.type = this.getter.getReturnType();
                            try {
                                object = this.clazz.getMethod((String)object2, this.type);
                                if (Modifier.isPublic(object.getModifiers())) {
                                    this.setter = object;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {}
                        } else {
                            Method[] methodArray = this.clazz.getMethods();
                            object = methodArray;
                            object = methodArray;
                            int n2 = methodArray.length;
                            for (int i2 = 0; i2 < n2; ++i2) {
                                Method method = object[i2];
                                Class<?>[] classArray = method.getParameterTypes();
                                if (!((String)object2).equals(method.getName()) || classArray.length != 1 || !Modifier.isPublic(method.getModifiers())) continue;
                                this.setter = method;
                                this.type = classArray[0];
                                break;
                            }
                        }
                        object = this.name + "Property";
                        try {
                            object = this.clazz.getMethod((String)object, new Class[0]);
                            if (Modifier.isPublic(object.getModifiers())) {
                                this.propertyGetter = object;
                                break block19;
                            }
                            this.propertyGetter = null;
                            break block20;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {}
                    }
                    return;
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("Failed to introspect property " + this.name);
                }
            }
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PropertyReference)) {
            return false;
        }
        object = (PropertyReference)object;
        if (!(this.name == ((PropertyReference)object).name || this.name != null && this.name.equals(((PropertyReference)object).name))) {
            return false;
        }
        return this.clazz == ((PropertyReference)object).clazz || this.clazz != null && this.clazz.equals(((PropertyReference)object).clazz);
    }

    public final int hashCode() {
        int n2 = 485 + (this.name != null ? this.name.hashCode() : 0);
        n2 = n2 * 97 + (this.clazz != null ? this.clazz.hashCode() : 0);
        return n2;
    }
}

