/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.reflect;

import java.lang.reflect.Proxy;

public final class ReflectUtil {
    public static final String PROXY_PACKAGE = "com.sun.proxy";

    private ReflectUtil() {
    }

    public static void checkPackageAccess(Class<?> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ReflectUtil.privateCheckPackageAccess(securityManager, clazz);
        }
    }

    private static void privateCheckPackageAccess(SecurityManager securityManager, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String string = clazz.getPackageName();
        if (string != null && !string.isEmpty()) {
            securityManager.checkPackageAccess(string);
        }
        if (ReflectUtil.isNonPublicProxyClass(clazz)) {
            ReflectUtil.privateCheckProxyPackageAccess(securityManager, clazz);
        }
    }

    public static void checkPackageAccess(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n2;
            if ((string = string.replace('/', '.')).startsWith("[") && (n2 = string.lastIndexOf(91) + 2) > 1 && n2 < string.length()) {
                string = string.substring(n2);
            }
            if ((n2 = string.lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(string.substring(0, n2));
            }
        }
    }

    public static boolean isPackageAccessible(Class<?> clazz) {
        try {
            ReflectUtil.checkPackageAccess(clazz);
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private static void privateCheckProxyPackageAccess(SecurityManager securityManager, Class<?> classArray) {
        if (Proxy.isProxyClass(classArray)) {
            for (Class<?> clazz : classArray.getInterfaces()) {
                ReflectUtil.privateCheckPackageAccess(securityManager, clazz);
            }
        }
    }

    public static boolean isNonPublicProxyClass(Class<?> object) {
        if (!Proxy.isProxyClass(object)) {
            return false;
        }
        return (object = ((Class)object).getPackageName()) == null || !((String)object).startsWith(PROXY_PACKAGE);
    }
}

