/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.event.BasicEventDispatcher;
import com.sun.javafx.scene.KeyboardShortcutsHandler$CopyOnWriteMap;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;

public final class KeyboardShortcutsHandler
extends BasicEventDispatcher {
    private ObservableMap<KeyCombination, Runnable> accelerators;
    private KeyboardShortcutsHandler$CopyOnWriteMap<KeyCombination, Runnable> acceleratorsBackingMap;
    private ObservableMap<KeyCombination, ObservableList<Mnemonic>> mnemonics;
    private boolean mnemonicsDisplayEnabled = false;

    public final void addMnemonic(Mnemonic mnemonic) {
        ObservableListWrapper<Mnemonic> observableListWrapper = (ObservableListWrapper<Mnemonic>)this.getMnemonics().get(mnemonic.getKeyCombination());
        if (observableListWrapper == null) {
            observableListWrapper = new ObservableListWrapper<Mnemonic>(new ArrayList());
            this.getMnemonics().put(mnemonic.getKeyCombination(), observableListWrapper);
        }
        boolean bl2 = false;
        for (Mnemonic mnemonic2 : observableListWrapper) {
            if (mnemonic2 != mnemonic) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            observableListWrapper.add(mnemonic);
        }
    }

    public final void removeMnemonic(Mnemonic mnemonic) {
        ObservableList observableList = (ObservableList)this.getMnemonics().get(mnemonic.getKeyCombination());
        if (observableList != null) {
            for (int i2 = 0; i2 < observableList.size(); ++i2) {
                if (((Mnemonic)observableList.get(i2)).getNode() != mnemonic.getNode()) continue;
                observableList.remove(i2);
            }
        }
    }

    public final ObservableMap<KeyCombination, ObservableList<Mnemonic>> getMnemonics() {
        if (this.mnemonics == null) {
            this.mnemonics = new ObservableMapWrapper<KeyCombination, ObservableList<Mnemonic>>(new HashMap());
        }
        return this.mnemonics;
    }

    public final ObservableMap<KeyCombination, Runnable> getAccelerators() {
        if (this.accelerators == null) {
            this.acceleratorsBackingMap = new KeyboardShortcutsHandler$CopyOnWriteMap();
            this.accelerators = new ObservableMapWrapper<KeyCombination, Runnable>(this.acceleratorsBackingMap);
        }
        return this.accelerators;
    }

    private void traverse(Event event, Node node, Direction direction) {
        if (NodeHelper.traverse(node, direction, TraversalMethod.KEY)) {
            event.consume();
        }
    }

    public final void processTraversal(Event event) {
        if (event.getEventType() != KeyEvent.KEY_PRESSED) {
            return;
        }
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)event;
        if (!(keyEvent.isMetaDown() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof Node)) {
                return;
            }
            eventTarget = (Node)eventTarget;
            switch (keyEvent.getCode()) {
                case TAB: {
                    if (keyEvent.isShiftDown()) {
                        this.traverse(event, (Node)eventTarget, Direction.PREVIOUS);
                        return;
                    }
                    this.traverse(event, (Node)eventTarget, Direction.NEXT);
                    return;
                }
                case UP: {
                    this.traverse(event, (Node)eventTarget, Direction.UP);
                    return;
                }
                case DOWN: {
                    this.traverse(event, (Node)eventTarget, Direction.DOWN);
                    return;
                }
                case LEFT: {
                    this.traverse(event, (Node)eventTarget, Direction.LEFT);
                    return;
                }
                case RIGHT: {
                    this.traverse(event, (Node)eventTarget, Direction.RIGHT);
                }
            }
        }
    }

    @Override
    public final Event dispatchBubblingEvent(Event event) {
        if (!(event instanceof KeyEvent)) {
            return event;
        }
        boolean bl2 = event.getEventType() == KeyEvent.KEY_PRESSED;
        KeyEvent keyEvent = (KeyEvent)event;
        if (bl2) {
            if (!event.isConsumed()) {
                this.processAccelerators(keyEvent);
            }
            if (!event.isConsumed()) {
                this.processTraversal(event);
            }
        }
        return event;
    }

    @Override
    public final Event dispatchCapturingEvent(Event event) {
        if (!(event instanceof KeyEvent)) {
            return event;
        }
        boolean bl2 = event.getEventType() == KeyEvent.KEY_PRESSED;
        boolean bl3 = event.getEventType() == KeyEvent.KEY_TYPED;
        boolean bl4 = event.getEventType() == KeyEvent.KEY_RELEASED;
        KeyEvent keyEvent = (KeyEvent)event;
        if ((bl2 || bl3) && (PlatformUtil.isMac() ? keyEvent.isMetaDown() : keyEvent.isAltDown() || this.isMnemonicsDisplayEnabled())) {
            this.processMnemonics(keyEvent);
        }
        if (!PlatformUtil.isMac() && !event.isConsumed()) {
            if (bl2) {
                if (keyEvent.isAltDown()) {
                    if (!this.isMnemonicsDisplayEnabled()) {
                        this.setMnemonicsDisplayEnabled(true);
                    } else if (PlatformUtil.isWindows()) {
                        KeyboardShortcutsHandler keyboardShortcutsHandler = this;
                        keyboardShortcutsHandler.setMnemonicsDisplayEnabled(!keyboardShortcutsHandler.isMnemonicsDisplayEnabled());
                    }
                } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    this.setMnemonicsDisplayEnabled(false);
                }
            }
            if (bl4 && !keyEvent.isAltDown() && !PlatformUtil.isWindows()) {
                this.setMnemonicsDisplayEnabled(false);
            }
        }
        return event;
    }

    private void processMnemonics(KeyEvent keyEvent) {
        Map.Entry entry2;
        if (this.mnemonics == null) {
            return;
        }
        Object object = keyEvent;
        if (((Event)keyEvent).getEventType() == KeyEvent.KEY_TYPED) {
            object = new KeyEvent(null, keyEvent.getTarget(), KeyEvent.KEY_PRESSED, " ", keyEvent.getCharacter(), KeyCode.getKeyCode(keyEvent.getCharacter()), keyEvent.isShiftDown(), keyEvent.isControlDown(), this.isMnemonicsDisplayEnabled(), keyEvent.isMetaDown());
        } else if (this.isMnemonicsDisplayEnabled()) {
            object = new KeyEvent(null, keyEvent.getTarget(), KeyEvent.KEY_PRESSED, keyEvent.getCharacter(), keyEvent.getText(), keyEvent.getCode(), keyEvent.isShiftDown(), keyEvent.isControlDown(), this.isMnemonicsDisplayEnabled(), keyEvent.isMetaDown());
        }
        ObservableList observableList = null;
        for (Map.Entry entry2 : this.mnemonics.entrySet()) {
            if (!((KeyCombination)entry2.getKey()).match((KeyEvent)object)) continue;
            observableList = (ObservableList)entry2.getValue();
            break;
        }
        if (observableList == null) {
            return;
        }
        boolean bl2 = false;
        entry2 = null;
        object = null;
        int n2 = -1;
        int n3 = -1;
        for (int i2 = 0; i2 < observableList.size(); ++i2) {
            Mnemonic mnemonic = (Mnemonic)observableList.get(i2);
            Node node = mnemonic.getNode();
            if (object == null && NodeHelper.isTreeVisible(node) && !node.isDisabled()) {
                object = mnemonic;
            }
            if (NodeHelper.isTreeVisible(node) && node.isFocusTraversable() && !node.isDisabled()) {
                if (entry2 == null) {
                    entry2 = node;
                } else {
                    bl2 = true;
                    if (n2 != -1 && n3 == -1) {
                        n3 = i2;
                    }
                }
            }
            if (!node.isFocused()) continue;
            n2 = i2;
        }
        if (entry2 != null) {
            if (!(!bl2) && n2 != -1 && n2 < observableList.size() && n3 != -1) {
                ((Mnemonic)observableList.get(n3)).getNode().requestFocus();
            } else {
                ((Node)((Object)entry2)).requestFocus();
            }
            keyEvent.consume();
        }
        if (!bl2 && object != null) {
            if (((Event)keyEvent).getEventType() == KeyEvent.KEY_TYPED) {
                keyEvent.consume();
                return;
            }
            ((Mnemonic)object).fire();
            keyEvent.consume();
        }
    }

    private void processAccelerators(KeyEvent keyEvent) {
        if (this.acceleratorsBackingMap != null) {
            this.acceleratorsBackingMap.lock();
            try {
                for (Map.Entry entry : this.acceleratorsBackingMap.backingMap.entrySet()) {
                    if (!((KeyCombination)entry.getKey()).match(keyEvent) || (entry = (Runnable)entry.getValue()) == null) continue;
                    entry.run();
                    keyEvent.consume();
                }
                return;
            }
            finally {
                this.acceleratorsBackingMap.unlock();
            }
        }
    }

    private void processMnemonicsKeyDisplay() {
        if (this.mnemonics != null) {
            for (Map.Entry entry : this.mnemonics.entrySet()) {
                ObservableList object = (ObservableList)entry.getValue();
                if (object == null) continue;
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    Node node = ((Mnemonic)object.get(i2)).getNode();
                    NodeHelper.setShowMnemonics(node, this.mnemonicsDisplayEnabled);
                }
            }
        }
    }

    public final boolean isMnemonicsDisplayEnabled() {
        return this.mnemonicsDisplayEnabled;
    }

    public final void setMnemonicsDisplayEnabled(boolean bl2) {
        if (bl2 != this.mnemonicsDisplayEnabled) {
            this.mnemonicsDisplayEnabled = bl2;
            this.processMnemonicsKeyDisplay();
        }
    }

    public final void clearNodeMnemonics(Node node) {
        if (this.mnemonics != null) {
            for (Object object : this.mnemonics.values()) {
                object = object.iterator();
                while (object.hasNext()) {
                    Mnemonic mnemonic = (Mnemonic)object.next();
                    if (mnemonic.getNode() != node) continue;
                    object.remove();
                }
            }
        }
    }
}

