/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.ContextMenuContent;
import com.sun.javafx.scene.control.ContextMenuContent$2;
import com.sun.javafx.scene.control.ContextMenuContent$MenuLabel;
import com.sun.javafx.scene.control.LambdaMultiplePropertyChangeListenerHandler;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class ContextMenuContent$MenuItemContainer
extends Region {
    private final MenuItem item;
    private Node left;
    private Node graphic;
    private Node label;
    private Node right;
    private final LambdaMultiplePropertyChangeListenerHandler listener = new LambdaMultiplePropertyChangeListenerHandler();
    private EventHandler<MouseEvent> mouseEnteredEventHandler;
    private EventHandler<MouseEvent> mouseReleasedEventHandler;
    private EventHandler<ActionEvent> actionEventHandler;
    private EventHandler<MouseEvent> customMenuItemMouseClickedHandler;
    final /* synthetic */ ContextMenuContent this$0;

    protected Label getLabel() {
        return (Label)this.label;
    }

    public MenuItem getItem() {
        return this.item;
    }

    public ContextMenuContent$MenuItemContainer(ContextMenuContent object, MenuItem menuItem) {
        this.this$0 = object;
        if (menuItem == null) {
            throw new NullPointerException("MenuItem can not be null");
        }
        this.getStyleClass().addAll((Collection<String>)menuItem.getStyleClass());
        this.setId(menuItem.getId());
        this.setFocusTraversable(!(menuItem instanceof CustomMenuItem));
        this.item = menuItem;
        this.createChildren();
        if (menuItem instanceof Menu) {
            object = ((Menu)menuItem).showingProperty();
            this.listener.registerChangeListener((ObservableValue<?>)object, observableValue -> this.pseudoClassStateChanged(ContextMenuContent.SELECTED_PSEUDOCLASS_STATE, ((Menu)menuItem).isShowing()));
            this.pseudoClassStateChanged(ContextMenuContent.SELECTED_PSEUDOCLASS_STATE, object.get());
            this.setAccessibleRole(AccessibleRole.MENU);
        } else if (menuItem instanceof RadioMenuItem) {
            object = ((RadioMenuItem)menuItem).selectedProperty();
            this.listener.registerChangeListener((ObservableValue<?>)object, observableValue -> this.pseudoClassStateChanged(ContextMenuContent.CHECKED_PSEUDOCLASS_STATE, ((RadioMenuItem)menuItem).isSelected()));
            this.pseudoClassStateChanged(ContextMenuContent.CHECKED_PSEUDOCLASS_STATE, object.get());
            this.setAccessibleRole(AccessibleRole.RADIO_MENU_ITEM);
        } else if (menuItem instanceof CheckMenuItem) {
            object = ((CheckMenuItem)menuItem).selectedProperty();
            this.listener.registerChangeListener((ObservableValue<?>)object, observableValue -> this.pseudoClassStateChanged(ContextMenuContent.CHECKED_PSEUDOCLASS_STATE, ((CheckMenuItem)menuItem).isSelected()));
            this.pseudoClassStateChanged(ContextMenuContent.CHECKED_PSEUDOCLASS_STATE, object.get());
            this.setAccessibleRole(AccessibleRole.CHECK_MENU_ITEM);
        } else {
            this.setAccessibleRole(AccessibleRole.MENU_ITEM);
        }
        this.pseudoClassStateChanged(ContextMenuContent.DISABLED_PSEUDOCLASS_STATE, menuItem.disableProperty().get());
        this.listener.registerChangeListener(menuItem.disableProperty(), observableValue -> this.pseudoClassStateChanged(ContextMenuContent.DISABLED_PSEUDOCLASS_STATE, menuItem.isDisable()));
        this.getProperties().put(MenuItem.class, menuItem);
        this.listener.registerChangeListener(menuItem.graphicProperty(), observableValue -> {
            this.createChildren();
            this.this$0.computeVisualMetrics();
        });
        this.actionEventHandler = actionEvent -> {
            if (menuItem instanceof Menu) {
                if (this.this$0.openSubmenu == (menuItem = (Menu)menuItem) && this.this$0.submenu.isShowing()) {
                    return;
                }
                if (this.this$0.openSubmenu != null) {
                    this.this$0.hideSubmenu();
                }
                this.this$0.selectedBackground = this;
                this.this$0.showMenu((Menu)menuItem);
                return;
            }
            this.doSelect();
        };
        this.addEventHandler(ActionEvent.ACTION, this.actionEventHandler);
    }

    public void dispose() {
        Object object;
        if (this.item instanceof CustomMenuItem && (object = ((CustomMenuItem)this.item).getContent()) != null) {
            ((Node)object).removeEventHandler(MouseEvent.MOUSE_CLICKED, this.customMenuItemMouseClickedHandler);
        }
        this.listener.dispose();
        this.removeEventHandler(ActionEvent.ACTION, this.actionEventHandler);
        if (this.label != null) {
            ((Label)this.label).textProperty().unbind();
            this.label.styleProperty().unbind();
            this.label.idProperty().unbind();
            object = (ListChangeListener)this.item.getProperties().remove("itemStyleClassListener");
            if (object != null) {
                this.item.getStyleClass().removeListener((ListChangeListener<String>)object);
            }
        }
        this.left = null;
        this.graphic = null;
        this.label = null;
        this.right = null;
    }

    private void createChildren() {
        Object object2;
        this.getChildren().clear();
        if (this.item instanceof CustomMenuItem) {
            ContextMenuContent$MenuItemContainer contextMenuContent$MenuItemContainer = this;
            contextMenuContent$MenuItemContainer.createNodeMenuItemChildren((CustomMenuItem)contextMenuContent$MenuItemContainer.item);
            if (this.mouseEnteredEventHandler == null) {
                this.mouseEnteredEventHandler = mouseEvent -> this.requestFocus();
            } else {
                this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            }
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            return;
        }
        ContextMenuContent$MenuItemContainer contextMenuContent$MenuItemContainer = this;
        Node node = contextMenuContent$MenuItemContainer.getLeftGraphic(contextMenuContent$MenuItemContainer.item);
        if (node != null) {
            object2 = new StackPane();
            ((Node)object2).getStyleClass().add("left-container");
            ((Pane)object2).getChildren().add(node);
            this.left = object2;
            this.getChildren().add(this.left);
            this.left.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        }
        if (this.item.getGraphic() != null) {
            object2 = this.item.getGraphic();
            node = new StackPane();
            node.getStyleClass().add("graphic-container");
            ((Pane)node).getChildren().add((Node)object2);
            this.graphic = node;
            this.getChildren().add(this.graphic);
        }
        this.label = new ContextMenuContent$MenuLabel(this.this$0, this.item, this);
        ((Label)this.label).textProperty().bind(this.item.textProperty());
        this.label.styleProperty().bind(this.item.styleProperty());
        this.label.idProperty().bind(this.item.styleProperty());
        object2 = listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                this.label.getStyleClass().removeAll(listChangeListener$Change.getRemoved());
                this.label.getStyleClass().addAll(listChangeListener$Change.getAddedSubList());
            }
        };
        this.item.getStyleClass().addListener((ListChangeListener<String>)object2);
        this.item.getProperties().put("itemStyleClassListener", object2);
        this.label.setMouseTransparent(true);
        this.getChildren().add(this.label);
        this.listener.unregisterChangeListeners(this.focusedProperty());
        this.listener.registerChangeListener(this.focusedProperty(), observableValue -> {
            if (this.isFocused()) {
                this.this$0.currentFocusedIndex = this.this$0.itemsContainer.getChildren().indexOf(this);
            }
        });
        if (this.item instanceof Menu) {
            node = new Region();
            node.setMouseTransparent(true);
            node.getStyleClass().add("arrow");
            object2 = new StackPane();
            ((Region)object2).setMaxWidth(Math.max(node.prefWidth(-1.0), 10.0));
            ((Node)object2).setMouseTransparent(true);
            ((Node)object2).getStyleClass().add("right-container");
            ((Pane)object2).getChildren().add(node);
            this.right = object2;
            this.getChildren().add((Node)object2);
            if (this.mouseEnteredEventHandler == null) {
                this.mouseEnteredEventHandler = object -> {
                    if (this.this$0.openSubmenu != null && this.item != this.this$0.openSubmenu) {
                        this.this$0.hideSubmenu();
                    }
                    this.this$0.selectedBackground = this;
                    this.requestFocus();
                    object = (Menu)this.item;
                    if (((MenuItem)((Object)object)).isDisable()) {
                        return;
                    }
                    ((Menu)((Object)object)).show();
                };
            } else {
                this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            }
            if (this.mouseReleasedEventHandler == null) {
                this.mouseReleasedEventHandler = mouseEvent -> this.item.fire();
            } else {
                this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
            }
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
            return;
        }
        this.listener.unregisterChangeListeners(this.item.acceleratorProperty());
        this.updateAccelerator();
        if (this.mouseEnteredEventHandler == null) {
            this.mouseEnteredEventHandler = mouseEvent -> {
                if (this.this$0.openSubmenu != null) {
                    this.this$0.openSubmenu.hide();
                }
                this.requestFocus();
            };
        } else {
            this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
        }
        if (this.mouseReleasedEventHandler == null) {
            this.mouseReleasedEventHandler = mouseEvent -> this.doSelect();
        } else {
            this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
        }
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
        this.listener.registerChangeListener(this.item.acceleratorProperty(), observableValue -> this.updateAccelerator());
    }

    private void updateAccelerator() {
        if (this.item.getAccelerator() != null) {
            if (this.right != null) {
                this.getChildren().remove(this.right);
            }
            String string = this.item.getAccelerator().getDisplayText();
            this.right = new Label(string);
            this.right.setStyle(this.item.getStyle());
            this.right.getStyleClass().add("accelerator-text");
            this.getChildren().add(this.right);
            return;
        }
        this.getChildren().remove(this.right);
    }

    void doSelect() {
        MenuItem menuItem;
        if (this.item.isDisable()) {
            return;
        }
        if (this.item instanceof CheckMenuItem) {
            ((CheckMenuItem)menuItem).setSelected(!((CheckMenuItem)(menuItem = (CheckMenuItem)this.item)).isSelected());
        } else if (this.item instanceof RadioMenuItem) {
            ((RadioMenuItem)menuItem).setSelected(((RadioMenuItem)(menuItem = (RadioMenuItem)this.item)).getToggleGroup() != null ? true : !((RadioMenuItem)menuItem).isSelected());
        }
        this.item.fire();
        if (this.item instanceof CustomMenuItem) {
            menuItem = (CustomMenuItem)this.item;
            if (((CustomMenuItem)menuItem).isHideOnClick()) {
                this.this$0.hideAllMenus(this.item);
            }
            return;
        }
        this.this$0.hideAllMenus(this.item);
    }

    private void createNodeMenuItemChildren(CustomMenuItem customMenuItem) {
        Node node = customMenuItem.getContent();
        this.getChildren().add(node);
        this.customMenuItemMouseClickedHandler = mouseEvent -> {
            if (customMenuItem == null || customMenuItem.isDisable()) {
                return;
            }
            customMenuItem.fire();
            if (customMenuItem.isHideOnClick()) {
                this.this$0.hideAllMenus(customMenuItem);
            }
        };
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, this.customMenuItemMouseClickedHandler);
    }

    @Override
    protected void layoutChildren() {
        double d2;
        double d3 = ((Node)this).prefHeight(-1.0);
        if (this.left != null) {
            d2 = this.snappedLeftInset();
            this.left.resize(this.left.prefWidth(-1.0), this.left.prefHeight(-1.0));
            ContextMenuContent$MenuItemContainer contextMenuContent$MenuItemContainer = this;
            contextMenuContent$MenuItemContainer.positionInArea(contextMenuContent$MenuItemContainer.left, d2, 0.0, this.this$0.maxLeftWidth, d3, 0.0, HPos.LEFT, VPos.CENTER);
        }
        if (this.graphic != null) {
            d2 = this.snappedLeftInset() + this.this$0.maxLeftWidth;
            this.graphic.resize(this.graphic.prefWidth(-1.0), this.graphic.prefHeight(-1.0));
            ContextMenuContent$MenuItemContainer contextMenuContent$MenuItemContainer = this;
            contextMenuContent$MenuItemContainer.positionInArea(contextMenuContent$MenuItemContainer.graphic, d2, 0.0, this.this$0.maxGraphicWidth, d3, 0.0, HPos.LEFT, VPos.CENTER);
        }
        if (this.label != null) {
            d2 = this.snappedLeftInset() + this.this$0.maxLeftWidth + this.this$0.maxGraphicWidth;
            this.label.resize(this.label.prefWidth(-1.0), this.label.prefHeight(-1.0));
            ContextMenuContent$MenuItemContainer contextMenuContent$MenuItemContainer = this;
            contextMenuContent$MenuItemContainer.positionInArea(contextMenuContent$MenuItemContainer.label, d2, 0.0, this.this$0.maxLabelWidth, d3, 0.0, HPos.LEFT, VPos.CENTER);
        }
        if (this.right != null) {
            d2 = this.snappedLeftInset() + this.this$0.maxLeftWidth + this.this$0.maxGraphicWidth + this.this$0.maxLabelWidth;
            this.right.resize(this.right.prefWidth(-1.0), this.right.prefHeight(-1.0));
            ContextMenuContent$MenuItemContainer contextMenuContent$MenuItemContainer = this;
            contextMenuContent$MenuItemContainer.positionInArea(contextMenuContent$MenuItemContainer.right, d2, 0.0, this.this$0.maxRightWidth, d3, 0.0, HPos.RIGHT, VPos.CENTER);
        }
        if (this.item instanceof CustomMenuItem) {
            Node node = ((CustomMenuItem)this.item).getContent();
            if (this.item instanceof SeparatorMenuItem) {
                double d4 = ((Node)this).prefWidth(-1.0) - (this.snappedLeftInset() + this.this$0.maxGraphicWidth + this.snappedRightInset());
                node.resize(d4, node.prefHeight(-1.0));
                this.positionInArea(node, this.snappedLeftInset() + this.this$0.maxGraphicWidth, 0.0, ((Node)this).prefWidth(-1.0), d3, 0.0, HPos.LEFT, VPos.CENTER);
                return;
            }
            Node node2 = node;
            node2.resize(node2.prefWidth(-1.0), node.prefHeight(-1.0));
            this.positionInArea(node, this.snappedLeftInset(), 0.0, this.getWidth(), d3, 0.0, HPos.LEFT, VPos.CENTER);
        }
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3;
        if (this.item instanceof CustomMenuItem || this.item instanceof SeparatorMenuItem) {
            d3 = this.getChildren().isEmpty() ? 0.0 : ((Node)this.getChildren().get(0)).prefHeight(-1.0);
        } else {
            d3 = Math.max(0.0, this.left != null ? this.left.prefHeight(-1.0) : 0.0);
            d3 = Math.max(d3, this.graphic != null ? this.graphic.prefHeight(-1.0) : 0.0);
            d3 = Math.max(d3, this.label != null ? this.label.prefHeight(-1.0) : 0.0);
            d3 = Math.max(d3, this.right != null ? this.right.prefHeight(-1.0) : 0.0);
        }
        return this.snappedTopInset() + d3 + this.snappedBottomInset();
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3 = 0.0;
        if (this.item instanceof CustomMenuItem && !(this.item instanceof SeparatorMenuItem)) {
            d3 = this.snappedLeftInset() + ((CustomMenuItem)this.item).getContent().prefWidth(-1.0) + this.snappedRightInset();
        }
        return Math.max(d3, this.snappedLeftInset() + this.this$0.maxLeftWidth + this.this$0.maxGraphicWidth + this.this$0.maxLabelWidth + this.this$0.maxRightWidth + this.snappedRightInset());
    }

    private Node getLeftGraphic(MenuItem eventTarget) {
        if (eventTarget instanceof RadioMenuItem) {
            eventTarget = new Region();
            ((Node)eventTarget).getStyleClass().add("radio");
            return eventTarget;
        }
        if (eventTarget instanceof CheckMenuItem) {
            eventTarget = new StackPane();
            ((Node)eventTarget).getStyleClass().add("check");
            return eventTarget;
        }
        return null;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... object2) {
        switch (ContextMenuContent$2.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 3: {
                if (this.item instanceof CheckMenuItem) {
                    return ((CheckMenuItem)this.item).isSelected();
                }
                if (this.item instanceof RadioMenuItem) {
                    return ((RadioMenuItem)this.item).isSelected();
                }
                return Boolean.FALSE;
            }
            case 4: {
                return this.item.getAccelerator();
            }
            case 5: {
                object = "";
                if (this.graphic != null && (object2 = (String)this.graphic.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                    object = (String)object + (String)object2;
                }
                if ((object2 = this.getLabel()) != null && (object2 = (String)((Node)object2).queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                    object = (String)object + (String)object2;
                }
                if (this.item instanceof CustomMenuItem && (object2 = ((CustomMenuItem)this.item).getContent()) != null && (object2 = (String)((Node)object2).queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                    object = (String)object + (String)object2;
                }
                return object;
            }
            case 6: {
                object = this.getLabel();
                if (object != null && (object2 = (String)((Node)object).queryAccessibleAttribute(AccessibleAttribute.MNEMONIC, new Object[0])) != null) {
                    return object2;
                }
                return null;
            }
            case 7: {
                return this.item.isDisable();
            }
            case 8: {
                this.this$0.createSubmenu();
                if (this.this$0.submenu.getSkin() == null) {
                    this.this$0.submenu.getStyleableNode().applyCss();
                }
                object = (ContextMenuContent)this.this$0.submenu.getSkin().getNode();
                return ((ContextMenuContent)object).itemsContainer;
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), (Object[])object2);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... objectArray) {
        switch (ContextMenuContent$2.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                if (!(this.item instanceof Menu)) break;
                object = (Menu)this.item;
                if (((Menu)object).isShowing()) {
                    ((Menu)object).hide();
                    break;
                }
                ((Menu)object).show();
                return;
            }
            case 2: {
                this.doSelect();
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), new Object[0]);
            }
        }
    }
}

