/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.ControlAcceleratorSupport$1;
import com.sun.javafx.scene.control.ControlAcceleratorSupport$2;
import com.sun.javafx.scene.control.ControlAcceleratorSupport$IdentityWrapperListChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCombination;

public class ControlAcceleratorSupport {
    private static Map<Object, WeakReference<ChangeListener<Scene>>> sceneChangeListenerMap = new WeakHashMap<Object, WeakReference<ChangeListener<Scene>>>();
    private static Map<ListChangeListener<MenuItem>, WeakReference<ListChangeListener<MenuItem>>> menuListChangeListenerMap = new WeakHashMap<ListChangeListener<MenuItem>, WeakReference<ListChangeListener<MenuItem>>>();
    private static Map<MenuItem, WeakReference<ChangeListener<KeyCombination>>> changeListenerMap = new WeakHashMap<MenuItem, WeakReference<ChangeListener<KeyCombination>>>();

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, Tab tab) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, (Object)tab);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, TableColumnBase<?, ?> tableColumnBase) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, tableColumnBase);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, Node node) {
        if (observableList == null) {
            return;
        }
        if (node == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        Object object = sceneChangeListenerMap.get(node);
        if (object == null || ((Reference)object).get() == null) {
            object = node.getScene();
            if (object != null) {
                ControlAcceleratorSupport.doAcceleratorInstall(observableList, (Scene)object);
            }
            node.sceneProperty().addListener(ControlAcceleratorSupport.getSceneChangeListener(node, observableList));
        }
    }

    private static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, Object readOnlyObjectProperty) {
        if (readOnlyObjectProperty == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        Control control = (Control)(readOnlyObjectProperty = ControlAcceleratorSupport.getControlProperty(readOnlyObjectProperty)).get();
        if (control == null) {
            readOnlyObjectProperty.addListener(new ControlAcceleratorSupport$1(readOnlyObjectProperty, observableList));
            return;
        }
        ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, control);
    }

    private static ChangeListener<Scene> getSceneChangeListener(Object object, ObservableList<MenuItem> observableList) {
        Object object2 = sceneChangeListenerMap.get(object);
        object2 = object2 == null ? null : (ChangeListener<Scene>)((Reference)object2).get();
        if (object2 == null) {
            object2 = (observableValue, scene, scene2) -> {
                if (scene != null) {
                    ControlAcceleratorSupport.removeAcceleratorsFromScene((ObservableList<? extends MenuItem>)observableList, scene);
                }
                if (scene2 != null) {
                    ControlAcceleratorSupport.doAcceleratorInstall(observableList, scene2);
                }
            };
            sceneChangeListenerMap.put(object, new WeakReference<ChangeListener<Scene>>((ChangeListener<Scene>)object2));
        }
        return object2;
    }

    private static void doAcceleratorInstall(ObservableList<MenuItem> observableList, Scene scene) {
        ControlAcceleratorSupport$2 controlAcceleratorSupport$2 = new ControlAcceleratorSupport$2(observableList, scene);
        WeakReference<ListChangeListener<MenuItem>> weakReference = menuListChangeListenerMap.get(controlAcceleratorSupport$2);
        weakReference = weakReference == null ? null : (ListChangeListener)weakReference.get();
        if (weakReference != null) {
            observableList.removeListener((ListChangeListener<MenuItem>)((Object)weakReference));
        }
        menuListChangeListenerMap.put(controlAcceleratorSupport$2, new WeakReference<ControlAcceleratorSupport$2>(controlAcceleratorSupport$2));
        observableList.addListener(controlAcceleratorSupport$2);
        ControlAcceleratorSupport.doAcceleratorInstall(observableList, scene);
    }

    private static void doAcceleratorInstall(List<? extends MenuItem> object, Scene scene) {
        object = object.iterator();
        while (object.hasNext()) {
            MenuItem menuItem = (MenuItem)object.next();
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.doAcceleratorInstall(((Menu)menuItem).getItems(), scene);
                continue;
            }
            if (menuItem.getAccelerator() != null) {
                ObservableMap<KeyCombination, Runnable> observableMap = scene.getAccelerators();
                Runnable runnable = () -> {
                    MenuItem menuItem2;
                    if (menuItem.getOnMenuValidation() != null) {
                        Event.fireEvent(menuItem, new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if ((menuItem2 = menuItem.getParentMenu()) != null && menuItem2.getOnMenuValidation() != null) {
                        Event.fireEvent(menuItem2, new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if (!menuItem.isDisable()) {
                        if (menuItem instanceof RadioMenuItem) {
                            menuItem2 = (RadioMenuItem)menuItem;
                            if (((RadioMenuItem)menuItem2).getToggleGroup() == null) {
                                MenuItem menuItem3 = menuItem2;
                                ((RadioMenuItem)menuItem3).setSelected(!((RadioMenuItem)menuItem3).isSelected());
                            } else {
                                ((RadioMenuItem)menuItem2).setSelected(true);
                            }
                        } else if (menuItem instanceof CheckMenuItem) {
                            ((CheckMenuItem)menuItem).setSelected(!((CheckMenuItem)menuItem).isSelected());
                        }
                        menuItem.fire();
                    }
                };
                observableMap.put(menuItem.getAccelerator(), runnable);
            }
            menuItem.acceleratorProperty().addListener(ControlAcceleratorSupport.getListener(scene, menuItem));
        }
    }

    private static ChangeListener<KeyCombination> getListener(Scene scene, MenuItem menuItem) {
        Object object = changeListenerMap.get(menuItem);
        object = object == null ? null : (ChangeListener<KeyCombination>)((Reference)object).get();
        if (object == null) {
            object = (object2, keyCombination, keyCombination2) -> {
                scene = ((Scene)scene).getAccelerators();
                object2 = (Runnable)scene.remove(keyCombination);
                if (keyCombination2 != null) {
                    scene.put(keyCombination2, object2);
                }
            };
            changeListenerMap.put(menuItem, new WeakReference<ChangeListener<KeyCombination>>((ChangeListener<KeyCombination>)object));
        }
        return object;
    }

    public static void removeAcceleratorsFromScene(ObservableList<? extends MenuItem> observableList, Tab eventTarget) {
        if ((eventTarget = ((Tab)eventTarget).getTabPane()) == null) {
            return;
        }
        eventTarget = ((Node)eventTarget).getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(observableList, (Scene)eventTarget);
    }

    public static void removeAcceleratorsFromScene(ObservableList<? extends MenuItem> observableList, TableColumnBase<?, ?> object) {
        if ((object = ControlAcceleratorSupport.getControlProperty(object)) == null) {
            return;
        }
        if ((object = (Control)object.get()) == null) {
            return;
        }
        object = ((Node)object).getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(observableList, (Scene)object);
    }

    public static void removeAcceleratorsFromScene(ObservableList<? extends MenuItem> observableList, Node node) {
        Object object;
        Scene scene = node.getScene();
        if (scene == null && (object = sceneChangeListenerMap.get(node)) != null) {
            if ((object = (ChangeListener)((Reference)object).get()) != null) {
                node.sceneProperty().removeListener((ChangeListener<Scene>)object);
            }
            sceneChangeListenerMap.remove(node);
        }
        ControlAcceleratorSupport.removeAcceleratorsFromScene(observableList, scene);
    }

    public static void removeAcceleratorsFromScene(ObservableList<? extends MenuItem> observableList, Scene scene) {
        WeakReference<ListChangeListener<MenuItem>> weakReference = menuListChangeListenerMap.get(new ControlAcceleratorSupport$IdentityWrapperListChangeListener(observableList));
        if (weakReference != null && (weakReference = (ListChangeListener)weakReference.get()) != null) {
            observableList.removeListener((ListChangeListener<? extends MenuItem>)((Object)weakReference));
        }
        ControlAcceleratorSupport.removeAcceleratorsFromScene(observableList, scene);
    }

    private static void removeAcceleratorsFromScene(List<? extends MenuItem> object, Scene scene) {
        if (scene == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            MenuItem menuItem = (MenuItem)object.next();
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.removeAcceleratorsFromScene(((Menu)menuItem).getItems(), scene);
                continue;
            }
            WeakReference<ChangeListener<KeyCombination>> weakReference = scene.getAccelerators();
            weakReference.remove(menuItem.getAccelerator());
            weakReference = changeListenerMap.get(menuItem);
            if (weakReference == null) continue;
            if ((weakReference = (ChangeListener)weakReference.get()) != null) {
                menuItem.acceleratorProperty().removeListener((ChangeListener<KeyCombination>)((Object)weakReference));
            }
            changeListenerMap.remove(menuItem);
        }
    }

    private static ReadOnlyObjectProperty<? extends Control> getControlProperty(Object object) {
        if (object instanceof TableColumn) {
            return ((TableColumn)object).tableViewProperty();
        }
        if (object instanceof TreeTableColumn) {
            return ((TreeTableColumn)object).treeTableViewProperty();
        }
        if (object instanceof Tab) {
            return ((Tab)object).tabPaneProperty();
        }
        return null;
    }
}

