/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.IDisconnectable;
import com.sun.javafx.scene.control.ListenerHelper$1;
import com.sun.javafx.scene.control.ListenerHelper$10;
import com.sun.javafx.scene.control.ListenerHelper$11;
import com.sun.javafx.scene.control.ListenerHelper$2;
import com.sun.javafx.scene.control.ListenerHelper$3;
import com.sun.javafx.scene.control.ListenerHelper$4;
import com.sun.javafx.scene.control.ListenerHelper$5;
import com.sun.javafx.scene.control.ListenerHelper$6;
import com.sun.javafx.scene.control.ListenerHelper$7;
import com.sun.javafx.scene.control.ListenerHelper$8;
import com.sun.javafx.scene.control.ListenerHelper$9;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeItem;
import javafx.scene.transform.Transform;
import javafx.stage.Window;

public class ListenerHelper
implements IDisconnectable {
    private WeakReference<Object> ownerRef;
    private final ArrayList<IDisconnectable> items = new ArrayList(4);
    private static Function<SkinBase<?>, ListenerHelper> accessor;

    public ListenerHelper(Object object) {
        this.ownerRef = new WeakReference<Object>(object);
    }

    public ListenerHelper() {
    }

    public static void setAccessor(Function<SkinBase<?>, ListenerHelper> function) {
        accessor = function;
    }

    public static ListenerHelper get(SkinBase<?> skinBase) {
        return accessor.apply(skinBase);
    }

    public IDisconnectable addDisconnectable(Runnable object) {
        object = new ListenerHelper$1(this, (Runnable)object);
        this.items.add((IDisconnectable)object);
        return object;
    }

    @Override
    public void disconnect() {
        for (int i2 = this.items.size() - 1; i2 >= 0; --i2) {
            IDisconnectable iDisconnectable = this.items.remove(i2);
            iDisconnectable.disconnect();
        }
    }

    private boolean isAliveOrDisconnect() {
        if (this.ownerRef != null && this.ownerRef.get() == null) {
            this.disconnect();
            return false;
        }
        return true;
    }

    public IDisconnectable addChangeListener(Runnable runnable, ObservableValue<?> ... observableValueArray) {
        return this.addChangeListener(runnable, false, observableValueArray);
    }

    public IDisconnectable addChangeListener(Runnable runnable, boolean bl2, ObservableValue<?> ... observableValueArray) {
        if (runnable == null) {
            throw new NullPointerException("onChange must not be null.");
        }
        ListenerHelper$2 listenerHelper$2 = new ListenerHelper$2(this, observableValueArray, runnable);
        this.items.add(listenerHelper$2);
        for (ObservableValue<?> observableValue : observableValueArray) {
            observableValue.addListener(listenerHelper$2);
        }
        if (bl2) {
            runnable.run();
        }
        return listenerHelper$2;
    }

    public <T> IDisconnectable addChangeListener(ObservableValue<T> observableValue, ChangeListener<T> changeListener) {
        return this.addChangeListener(observableValue, false, changeListener);
    }

    public <T> IDisconnectable addChangeListener(ObservableValue<T> observableValue, boolean bl2, ChangeListener<T> changeListener) {
        if (changeListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        ListenerHelper$3 listenerHelper$3 = new ListenerHelper$3(this, observableValue, changeListener);
        this.items.add(listenerHelper$3);
        observableValue.addListener(listenerHelper$3);
        if (bl2) {
            T t2 = observableValue.getValue();
            changeListener.changed(observableValue, null, t2);
        }
        return listenerHelper$3;
    }

    public <T> IDisconnectable addChangeListener(ObservableValue<T> observableValue, Consumer<T> consumer) {
        return this.addChangeListener(observableValue, false, consumer);
    }

    public <T> IDisconnectable addChangeListener(ObservableValue<T> observableValue, boolean bl2, Consumer<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("Callback must be specified.");
        }
        ListenerHelper$4 listenerHelper$4 = new ListenerHelper$4(this, observableValue, consumer);
        this.items.add(listenerHelper$4);
        observableValue.addListener(listenerHelper$4);
        if (bl2) {
            observableValue = observableValue.getValue();
            consumer.accept(observableValue);
        }
        return listenerHelper$4;
    }

    public IDisconnectable addInvalidationListener(Runnable runnable, ObservableValue<?> ... observableValueArray) {
        return this.addInvalidationListener(runnable, false, observableValueArray);
    }

    public IDisconnectable addInvalidationListener(Runnable runnable, boolean bl2, ObservableValue<?> ... observableValueArray) {
        if (runnable == null) {
            throw new NullPointerException("Callback must be specified.");
        }
        ListenerHelper$5 listenerHelper$5 = new ListenerHelper$5(this, observableValueArray, runnable);
        this.items.add(listenerHelper$5);
        for (ObservableValue<?> observableValue : observableValueArray) {
            observableValue.addListener(listenerHelper$5);
        }
        if (bl2) {
            runnable.run();
        }
        return listenerHelper$5;
    }

    public <T> IDisconnectable addInvalidationListener(ObservableValue<T> observableValue, InvalidationListener invalidationListener) {
        return this.addInvalidationListener(observableValue, false, invalidationListener);
    }

    public <T> IDisconnectable addInvalidationListener(ObservableValue<T> observableValue, boolean bl2, InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        ListenerHelper$6 listenerHelper$6 = new ListenerHelper$6(this, observableValue, invalidationListener);
        this.items.add(listenerHelper$6);
        observableValue.addListener(listenerHelper$6);
        if (bl2) {
            invalidationListener.invalidated(observableValue);
        }
        return listenerHelper$6;
    }

    public <T> IDisconnectable addListChangeListener(ObservableList<T> observableList, ListChangeListener<T> listenerHelper$7) {
        if (listenerHelper$7 == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        listenerHelper$7 = new ListenerHelper$7(this, observableList, listenerHelper$7);
        this.items.add(listenerHelper$7);
        observableList.addListener(listenerHelper$7);
        return listenerHelper$7;
    }

    public <K, V> IDisconnectable addMapChangeListener(ObservableMap<K, V> observableMap, MapChangeListener<K, V> listenerHelper$8) {
        if (listenerHelper$8 == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        listenerHelper$8 = new ListenerHelper$8(this, observableMap, listenerHelper$8);
        this.items.add(listenerHelper$8);
        observableMap.addListener(listenerHelper$8);
        return listenerHelper$8;
    }

    public <T> IDisconnectable addSetChangeListener(ObservableSet<T> observableSet, SetChangeListener<T> listenerHelper$9) {
        if (listenerHelper$9 == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        listenerHelper$9 = new ListenerHelper$9(this, observableSet, listenerHelper$9);
        this.items.add(listenerHelper$9);
        observableSet.addListener(listenerHelper$9);
        return listenerHelper$9;
    }

    public <T extends Event> IDisconnectable addEventHandler(Object object, EventType<T> eventType, EventHandler<T> listenerHelper$10) {
        listenerHelper$10 = new ListenerHelper$10(this, listenerHelper$10, object, eventType);
        this.items.add(listenerHelper$10);
        if (object instanceof Node) {
            object = (Node)object;
            ((Node)object).addEventHandler(eventType, listenerHelper$10);
        } else if (object instanceof Window) {
            object = (Window)object;
            ((Window)object).addEventHandler(eventType, listenerHelper$10);
        } else if (object instanceof Scene) {
            object = (Scene)object;
            ((Scene)object).addEventHandler(eventType, listenerHelper$10);
        } else if (object instanceof MenuItem) {
            object = (MenuItem)object;
            ((MenuItem)object).addEventHandler(eventType, listenerHelper$10);
        } else if (object instanceof TreeItem) {
            object = (TreeItem)object;
            ((TreeItem)object).addEventHandler(eventType, listenerHelper$10);
        } else if (object instanceof TableColumnBase) {
            object = (TableColumnBase)object;
            ((TableColumnBase)object).addEventHandler(eventType, listenerHelper$10);
        } else if (object instanceof Transform) {
            object = (Transform)object;
            ((Transform)object).addEventHandler(eventType, listenerHelper$10);
        } else if (object instanceof Task) {
            object = (Task)object;
            ((Task)object).addEventHandler(eventType, listenerHelper$10);
        } else {
            throw new IllegalArgumentException("Cannot add event handler to " + String.valueOf(object));
        }
        return listenerHelper$10;
    }

    public <T extends Event> IDisconnectable addEventFilter(Object object, EventType<T> eventType, EventHandler<T> listenerHelper$11) {
        listenerHelper$11 = new ListenerHelper$11(this, listenerHelper$11, object, eventType);
        this.items.add(listenerHelper$11);
        if (object instanceof Node) {
            object = (Node)object;
            ((Node)object).addEventFilter(eventType, listenerHelper$11);
        } else if (object instanceof Window) {
            object = (Window)object;
            ((Window)object).addEventFilter(eventType, listenerHelper$11);
        } else if (object instanceof Scene) {
            object = (Scene)object;
            ((Scene)object).addEventFilter(eventType, listenerHelper$11);
        } else if (object instanceof Transform) {
            object = (Transform)object;
            ((Transform)object).addEventFilter(eventType, listenerHelper$11);
        } else if (object instanceof Task) {
            object = (Task)object;
            ((Task)object).addEventFilter(eventType, listenerHelper$11);
        } else {
            throw new IllegalArgumentException("Cannot add event filter to " + String.valueOf(object));
        }
        return listenerHelper$11;
    }
}

