/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.util.Utils;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.skin.VirtualFlow;

public class VirtualScrollBar
extends ScrollBar {
    private final VirtualFlow flow;
    private boolean adjusting;
    private BooleanProperty virtual = new SimpleBooleanProperty(this, "virtual");

    public VirtualScrollBar(VirtualFlow virtualFlow) {
        this.flow = virtualFlow;
        super.valueProperty().addListener(observable -> {
            if (this.isVirtual() && !this.adjusting) {
                virtualFlow.setPosition(this.getValue());
            }
        });
    }

    public final void setVirtual(boolean bl2) {
        this.virtual.set(bl2);
    }

    public final boolean isVirtual() {
        return this.virtual.get();
    }

    public final BooleanProperty virtualProperty() {
        return this.virtual;
    }

    @Override
    public void decrement() {
        if (this.isVirtual()) {
            this.flow.scrollPixels(-10.0);
            return;
        }
        super.decrement();
    }

    @Override
    public void increment() {
        if (this.isVirtual()) {
            this.flow.scrollPixels(10.0);
            return;
        }
        super.increment();
    }

    @Override
    public void adjustValue(double d2) {
        if (this.isVirtual()) {
            this.adjusting = true;
            double d3 = this.flow.getPosition();
            double d4 = (this.getMax() - this.getMin()) * Utils.clamp(0.0, d2, 1.0) + this.getMin();
            Object t2 = this.flow.getFirstVisibleCell();
            Object t3 = this.flow.getLastVisibleCell();
            if (t2 != null && t2 == t3) {
                int n2 = ((IndexedCell)t2).getIndex();
                if (d4 < d3) {
                    this.flow.scrollTo(n2 - 1);
                } else {
                    this.flow.scrollTo(n2 + 1);
                }
            } else if (d4 < d3) {
                if (t2 == null) {
                    return;
                }
                this.flow.scrollToBottom(t2);
            } else if (d4 > d3) {
                t2 = t3;
                if (t2 == null) {
                    return;
                }
                this.flow.scrollToTop(t2);
            }
            this.adjusting = false;
            return;
        }
        super.adjustValue(d2);
    }
}

