/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.AccordionBehavior$AccordionFocusModel$1;
import com.sun.javafx.scene.control.behavior.AccordionBehavior$AccordionFocusModel$2;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Accordion;
import javafx.scene.control.FocusModel;
import javafx.scene.control.TitledPane;

class AccordionBehavior$AccordionFocusModel
extends FocusModel<TitledPane> {
    private final Accordion accordion;
    private final ChangeListener<Boolean> focusListener = new AccordionBehavior$AccordionFocusModel$1(this);
    private final ChangeListener<Boolean> paneFocusListener = new AccordionBehavior$AccordionFocusModel$2(this);
    private final ListChangeListener<TitledPane> panesListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasAdded()) {
                for (TitledPane titledPane : listChangeListener$Change.getAddedSubList()) {
                    titledPane.focusedProperty().addListener(this.paneFocusListener);
                }
                continue;
            }
            if (!listChangeListener$Change.wasRemoved()) continue;
            for (TitledPane titledPane : listChangeListener$Change.getRemoved()) {
                titledPane.focusedProperty().removeListener(this.paneFocusListener);
            }
        }
    };

    public AccordionBehavior$AccordionFocusModel(Accordion object) {
        if (object == null) {
            throw new IllegalArgumentException("Accordion can not be null");
        }
        this.accordion = object;
        this.accordion.focusedProperty().addListener(this.focusListener);
        this.accordion.getPanes().addListener(this.panesListener);
        for (TitledPane titledPane : this.accordion.getPanes()) {
            titledPane.focusedProperty().addListener(this.paneFocusListener);
        }
    }

    void dispose() {
        this.accordion.focusedProperty().removeListener(this.focusListener);
        this.accordion.getPanes().removeListener(this.panesListener);
        for (TitledPane titledPane : this.accordion.getPanes()) {
            titledPane.focusedProperty().removeListener(this.paneFocusListener);
        }
    }

    @Override
    protected int getItemCount() {
        ObservableList<TitledPane> observableList = this.accordion.getPanes();
        if (observableList == null) {
            return 0;
        }
        return observableList.size();
    }

    @Override
    protected TitledPane getModelItem(int n2) {
        ObservableList<TitledPane> observableList = this.accordion.getPanes();
        if (observableList == null) {
            return null;
        }
        if (n2 < 0) {
            return null;
        }
        return (TitledPane)observableList.get(n2 % observableList.size());
    }

    @Override
    public void focusPrevious() {
        if (this.getFocusedIndex() <= 0) {
            AccordionBehavior$AccordionFocusModel accordionBehavior$AccordionFocusModel = this;
            accordionBehavior$AccordionFocusModel.focus(accordionBehavior$AccordionFocusModel.accordion.getPanes().size() - 1);
            return;
        }
        AccordionBehavior$AccordionFocusModel accordionBehavior$AccordionFocusModel = this;
        accordionBehavior$AccordionFocusModel.focus((accordionBehavior$AccordionFocusModel.getFocusedIndex() - 1) % this.accordion.getPanes().size());
    }

    @Override
    public void focusNext() {
        if (this.getFocusedIndex() == -1) {
            this.focus(0);
            return;
        }
        AccordionBehavior$AccordionFocusModel accordionBehavior$AccordionFocusModel = this;
        accordionBehavior$AccordionFocusModel.focus((accordionBehavior$AccordionFocusModel.getFocusedIndex() + 1) % this.accordion.getPanes().size());
    }
}

