/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.AccordionBehavior$AccordionFocusModel;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$KeyMapping;
import com.sun.javafx.scene.control.inputmap.InputMap$MouseMapping;
import com.sun.javafx.scene.control.inputmap.KeyBinding;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.FocusModel;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class AccordionBehavior
extends BehaviorBase<Accordion> {
    private final InputMap<Accordion> inputMap;
    private AccordionBehavior$AccordionFocusModel focusModel;

    public AccordionBehavior(Accordion accordion) {
        super(accordion);
        this.focusModel = new AccordionBehavior$AccordionFocusModel(accordion);
        this.inputMap = this.createInputMap();
        AccordionBehavior accordionBehavior = this;
        accordionBehavior.addDefaultMapping(accordionBehavior.inputMap, new InputMap$KeyMapping(KeyCode.UP, keyEvent -> this.pageUp(false)), new InputMap$KeyMapping(KeyCode.DOWN, keyEvent -> this.pageDown(false)), new InputMap$KeyMapping(KeyCode.LEFT, keyEvent -> {
            if (this.isRTL(accordion)) {
                this.pageDown(false);
                return;
            }
            this.pageUp(false);
        }), new InputMap$KeyMapping(KeyCode.RIGHT, keyEvent -> {
            if (this.isRTL(accordion)) {
                this.pageUp(false);
                return;
            }
            this.pageDown(false);
        }), new InputMap$KeyMapping(KeyCode.HOME, this::home), new InputMap$KeyMapping(KeyCode.END, this::end), new InputMap$KeyMapping(KeyCode.PAGE_UP, keyEvent -> this.pageUp(true)), new InputMap$KeyMapping(KeyCode.PAGE_DOWN, keyEvent -> this.pageDown(true)), new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_UP).ctrl(), this::moveBackward), new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_DOWN).ctrl(), this::moveForward), new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB).ctrl(), this::moveForward), new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB).ctrl().shift(), this::moveBackward), new InputMap$MouseMapping(MouseEvent.MOUSE_PRESSED, this::mousePressed));
    }

    @Override
    public void dispose() {
        this.focusModel.dispose();
        super.dispose();
    }

    @Override
    public InputMap<Accordion> getInputMap() {
        return this.inputMap;
    }

    private void pageUp(boolean bl2) {
        Accordion accordion = (Accordion)this.getNode();
        if (this.focusModel.getFocusedIndex() != -1 && ((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
            ((FocusModel)this.focusModel).focusPrevious();
            int n2 = this.focusModel.getFocusedIndex();
            ((TitledPane)accordion.getPanes().get(n2)).requestFocus();
            if (bl2) {
                ((TitledPane)accordion.getPanes().get(n2)).setExpanded(true);
            }
        }
    }

    private void pageDown(boolean bl2) {
        Accordion accordion = (Accordion)this.getNode();
        if (this.focusModel.getFocusedIndex() != -1 && ((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
            ((FocusModel)this.focusModel).focusNext();
            int n2 = this.focusModel.getFocusedIndex();
            ((TitledPane)accordion.getPanes().get(n2)).requestFocus();
            if (bl2) {
                ((TitledPane)accordion.getPanes().get(n2)).setExpanded(true);
            }
        }
    }

    private void moveBackward(KeyEvent object) {
        object = (Accordion)this.getNode();
        ((FocusModel)this.focusModel).focusPrevious();
        if (this.focusModel.getFocusedIndex() != -1) {
            int n2 = this.focusModel.getFocusedIndex();
            ((TitledPane)((Accordion)object).getPanes().get(n2)).requestFocus();
            ((TitledPane)((Accordion)object).getPanes().get(n2)).setExpanded(true);
        }
    }

    private void moveForward(KeyEvent object) {
        object = (Accordion)this.getNode();
        ((FocusModel)this.focusModel).focusNext();
        if (this.focusModel.getFocusedIndex() != -1) {
            int n2 = this.focusModel.getFocusedIndex();
            ((TitledPane)((Accordion)object).getPanes().get(n2)).requestFocus();
            ((TitledPane)((Accordion)object).getPanes().get(n2)).setExpanded(true);
        }
    }

    private void home(KeyEvent object) {
        object = (Accordion)this.getNode();
        if (this.focusModel.getFocusedIndex() != -1 && ((TitledPane)((Accordion)object).getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
            object = (TitledPane)((Accordion)object).getPanes().get(0);
            ((Node)object).requestFocus();
            Object object2 = object;
            ((TitledPane)object2).setExpanded(!((TitledPane)object2).isExpanded());
        }
    }

    private void end(KeyEvent object) {
        object = (Accordion)this.getNode();
        if (this.focusModel.getFocusedIndex() != -1 && ((TitledPane)((Accordion)object).getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
            object = (TitledPane)((Accordion)object).getPanes().get(((Accordion)object).getPanes().size() - 1);
            ((Node)object).requestFocus();
            Object object2 = object;
            ((TitledPane)object2).setExpanded(!((TitledPane)object2).isExpanded());
        }
    }

    public void mousePressed(MouseEvent object) {
        object = (Accordion)this.getNode();
        if (((Accordion)object).getPanes().size() > 0) {
            object = (TitledPane)((Accordion)object).getPanes().get(((Accordion)object).getPanes().size() - 1);
            ((Node)object).requestFocus();
            return;
        }
        ((Node)object).requestFocus();
    }
}

