/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import com.sun.javafx.scene.control.inputmap.InputMap$MouseMapping;
import java.util.ArrayList;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public abstract class CellBehaviorBase<T extends Cell>
extends BehaviorBase<T> {
    private static final String ANCHOR_PROPERTY_KEY = "anchor";
    private static final String IS_DEFAULT_ANCHOR_KEY = "isDefaultAnchor";
    private final InputMap<T> cellInputMap = this.createInputMap();
    private boolean latePress = false;

    public static <T> T getAnchor(Control control, T t2) {
        if (CellBehaviorBase.hasNonDefaultAnchor(control)) {
            return (T)control.getProperties().get(ANCHOR_PROPERTY_KEY);
        }
        return t2;
    }

    public static <T> void setAnchor(Control control, T t2, boolean bl2) {
        if (control == null) {
            return;
        }
        if (t2 == null) {
            CellBehaviorBase.removeAnchor(control);
            return;
        }
        control.getProperties().put(ANCHOR_PROPERTY_KEY, t2);
        control.getProperties().put(IS_DEFAULT_ANCHOR_KEY, bl2);
    }

    public static boolean hasNonDefaultAnchor(Control control) {
        Boolean bl2 = (Boolean)control.getProperties().remove(IS_DEFAULT_ANCHOR_KEY);
        return (bl2 == null || bl2 == false) && CellBehaviorBase.hasAnchor(control);
    }

    public static boolean hasDefaultAnchor(Control control) {
        Boolean bl2 = (Boolean)control.getProperties().remove(IS_DEFAULT_ANCHOR_KEY);
        return bl2 != null && bl2 == true && CellBehaviorBase.hasAnchor(control);
    }

    private static boolean hasAnchor(Control control) {
        return control.getProperties().get(ANCHOR_PROPERTY_KEY) != null;
    }

    public static void removeAnchor(Control control) {
        control.getProperties().remove(ANCHOR_PROPERTY_KEY);
        control.getProperties().remove(IS_DEFAULT_ANCHOR_KEY);
    }

    public CellBehaviorBase(T object) {
        super(object);
        InputMap$Mapping[] inputMap$MappingArray = new InputMap$Mapping[3];
        object = new InputMap$MouseMapping(MouseEvent.MOUSE_PRESSED, this::mousePressed);
        inputMap$MappingArray[0] = object;
        InputMap$MouseMapping inputMap$MouseMapping = new InputMap$MouseMapping(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        inputMap$MappingArray[1] = inputMap$MouseMapping;
        InputMap$MouseMapping inputMap$MouseMapping2 = new InputMap$MouseMapping(MouseEvent.MOUSE_DRAGGED, this::mouseDragged);
        inputMap$MappingArray[2] = inputMap$MouseMapping2;
        this.addDefaultMapping(inputMap$MappingArray);
        ((InputMap$Mapping)object).setAutoConsume(false);
        inputMap$MouseMapping.setAutoConsume(false);
        inputMap$MouseMapping2.setAutoConsume(false);
    }

    protected abstract Control getCellContainer();

    protected abstract MultipleSelectionModel<?> getSelectionModel();

    protected abstract FocusModel<?> getFocusModel();

    protected abstract void edit(T var1);

    protected boolean handleDisclosureNode(double d2, double d3) {
        return false;
    }

    protected boolean isClickPositionValid(double d2, double d3) {
        return true;
    }

    @Override
    public InputMap<T> getInputMap() {
        return this.cellInputMap;
    }

    protected int getIndex() {
        if (this.getNode() instanceof IndexedCell) {
            return ((IndexedCell)this.getNode()).getIndex();
        }
        return -1;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isSynthesized()) {
            this.latePress = true;
            return;
        }
        this.latePress = this.isSelected();
        if (!this.latePress) {
            this.doSelect(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getButton(), mouseEvent.getClickCount(), mouseEvent.isShiftDown(), mouseEvent.isShortcutDown());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getButton(), mouseEvent.getClickCount(), mouseEvent.isShiftDown(), mouseEvent.isShortcutDown());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.latePress = false;
    }

    protected void doSelect(double d2, double d3, MouseButton mouseButton, int n2, boolean bl2, boolean bl3) {
        Cell cell = (Cell)this.getNode();
        Control control = this.getCellContainer();
        if (cell.isEmpty() || !cell.contains(d2, d3)) {
            return;
        }
        int n3 = this.getIndex();
        boolean bl4 = cell.isSelected();
        MultipleSelectionModel<?> multipleSelectionModel = this.getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel<?> focusModel = this.getFocusModel();
        if (focusModel == null) {
            return;
        }
        if (this.handleDisclosureNode(d2, d3)) {
            return;
        }
        if (!this.isClickPositionValid(d2, d3)) {
            return;
        }
        if (bl2) {
            if (!CellBehaviorBase.hasNonDefaultAnchor(control)) {
                CellBehaviorBase.setAnchor(control, focusModel.getFocusedIndex(), false);
            }
        } else {
            CellBehaviorBase.removeAnchor(control);
        }
        if (mouseButton == MouseButton.PRIMARY || mouseButton == MouseButton.SECONDARY && !bl4) {
            if (multipleSelectionModel.getSelectionMode() != SelectionMode.SINGLE) {
                if (bl3) {
                    if (bl4) {
                        multipleSelectionModel.clearSelection(n3);
                        focusModel.focus(n3);
                        return;
                    }
                    multipleSelectionModel.select(n3);
                    return;
                }
                if (bl2 && n2 == 1) {
                    int n4 = CellBehaviorBase.getAnchor(control, focusModel.getFocusedIndex());
                    this.selectRows(n4, n3);
                    focusModel.focus(n3);
                    return;
                }
            }
            this.simpleSelect(mouseButton, n2, bl3);
        }
    }

    protected void simpleSelect(MouseButton mouseButton, int n2, boolean bl2) {
        boolean bl3;
        int n3 = this.getIndex();
        MultipleSelectionModel<?> multipleSelectionModel = this.getSelectionModel();
        if (multipleSelectionModel == null) {
            bl3 = false;
        } else {
            bl3 = multipleSelectionModel.isSelected(n3);
            if (bl3 && bl2) {
                multipleSelectionModel.clearSelection(n3);
                this.getFocusModel().focus(n3);
                bl3 = false;
            } else {
                multipleSelectionModel.clearAndSelect(n3);
            }
        }
        this.handleClicks(mouseButton, n2, bl3);
    }

    protected void handleClicks(MouseButton mouseButton, int n2, boolean bl2) {
        if (mouseButton == MouseButton.PRIMARY) {
            if (n2 == 1 && bl2) {
                CellBehaviorBase cellBehaviorBase = this;
                cellBehaviorBase.edit((Cell)cellBehaviorBase.getNode());
                return;
            }
            if (n2 == 1) {
                this.edit(null);
                return;
            }
            if (n2 == 2 && ((Cell)this.getNode()).isEditable()) {
                CellBehaviorBase cellBehaviorBase = this;
                cellBehaviorBase.edit((Cell)cellBehaviorBase.getNode());
            }
        }
    }

    void selectRows(int n2, int n3) {
        if (this.getSelectionModel() == null) {
            return;
        }
        boolean bl2 = n2 < n3;
        int n4 = Math.min(n2, n3);
        n2 = Math.max(n2, n3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getSelectionModel().getSelectedIndices());
        int n5 = arrayList.size();
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = (Integer)arrayList.get(i2);
            if (n6 >= n4 && n6 <= n2) continue;
            this.getSelectionModel().clearSelection(n6);
        }
        if (n4 == n2) {
            this.getSelectionModel().select(n4);
            return;
        }
        if (bl2) {
            this.getSelectionModel().selectRange(n4, n2 + 1);
            return;
        }
        this.getSelectionModel().selectRange(n2, n4 - 1);
    }

    protected boolean isSelected() {
        return ((Cell)this.getNode()).isSelected();
    }
}

