/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$KeyMapping;
import com.sun.javafx.scene.control.inputmap.InputMap$MouseMapping;
import com.sun.javafx.scene.control.inputmap.KeyBinding;
import javafx.event.Event;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class TabPaneBehavior
extends BehaviorBase<TabPane> {
    private final InputMap<TabPane> tabPaneInputMap = this.createInputMap();

    public TabPaneBehavior(TabPane tabPane) {
        super(tabPane);
        TabPaneBehavior tabPaneBehavior = this;
        tabPaneBehavior.addDefaultMapping(tabPaneBehavior.tabPaneInputMap, new InputMap$KeyMapping(KeyCode.UP, keyEvent -> this.selectPreviousTab()), new InputMap$KeyMapping(KeyCode.DOWN, keyEvent -> this.selectNextTab()), new InputMap$KeyMapping(KeyCode.LEFT, keyEvent -> this.rtl(tabPane, this::selectNextTab, this::selectPreviousTab)), new InputMap$KeyMapping(KeyCode.RIGHT, keyEvent -> this.rtl(tabPane, this::selectPreviousTab, this::selectNextTab)), new InputMap$KeyMapping(KeyCode.HOME, keyEvent -> {
            if (((TabPane)this.getNode()).isFocused()) {
                this.moveSelection(-1, 1);
            }
        }), new InputMap$KeyMapping(KeyCode.END, keyEvent -> {
            if (((TabPane)this.getNode()).isFocused()) {
                TabPaneBehavior tabPaneBehavior = this;
                tabPaneBehavior.moveSelection(((TabPane)tabPaneBehavior.getNode()).getTabs().size(), -1);
            }
        }), new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_UP).ctrl(), keyEvent -> this.selectPreviousTab()), new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_DOWN).ctrl(), keyEvent -> this.selectNextTab()), new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB).ctrl(), keyEvent -> this.selectNextTab()), new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB).ctrl().shift(), keyEvent -> this.selectPreviousTab()), new InputMap$MouseMapping(MouseEvent.MOUSE_PRESSED, mouseEvent -> ((TabPane)this.getNode()).requestFocus()));
    }

    @Override
    public InputMap<TabPane> getInputMap() {
        return this.tabPaneInputMap;
    }

    public void selectTab(Tab tab) {
        ((SelectionModel)((TabPane)this.getNode()).getSelectionModel()).select(tab);
    }

    public boolean canCloseTab(Tab tab) {
        Tab tab2 = tab;
        Event event = new Event(tab2, tab2, Tab.TAB_CLOSE_REQUEST_EVENT);
        Event.fireEvent(tab, event);
        return !event.isConsumed();
    }

    public void closeTab(Tab tab) {
        TabPane tabPane = (TabPane)this.getNode();
        int n2 = tabPane.getTabs().indexOf(tab);
        if (n2 != -1) {
            tabPane.getTabs().remove(n2);
        }
        if (tab.getOnClosed() != null) {
            Event.fireEvent(tab, new Event(Tab.CLOSED_EVENT));
        }
    }

    public void selectNextTab() {
        this.moveSelection(1);
    }

    public void selectPreviousTab() {
        this.moveSelection(-1);
    }

    private void moveSelection(int n2) {
        TabPaneBehavior tabPaneBehavior = this;
        tabPaneBehavior.moveSelection(((TabPane)tabPaneBehavior.getNode()).getSelectionModel().getSelectedIndex(), n2);
    }

    private void moveSelection(int n2, int n3) {
        TabPane tabPane = (TabPane)this.getNode();
        if (tabPane.getTabs().isEmpty()) {
            return;
        }
        if ((n2 = this.findValidTab(n2, n3)) >= 0) {
            SingleSelectionModel<Tab> singleSelectionModel = tabPane.getSelectionModel();
            ((SelectionModel)singleSelectionModel).select(n2);
        }
        tabPane.requestFocus();
    }

    private int findValidTab(int n2, int n3) {
        Object object = (TabPane)this.getNode();
        object = ((TabPane)object).getTabs();
        int n4 = object.size();
        int n5 = n2;
        do {
            Tab tab;
            if ((tab = (Tab)object.get(n5 = this.nextIndex(n5 + n3, n4))) == null || tab.isDisable()) continue;
            return n5;
        } while (n5 != n2);
        return -1;
    }

    private int nextIndex(int n2, int n3) {
        if ((n2 %= n3) > 0 && n3 < 0) {
            n2 += n3;
        } else if (n2 < 0 && n3 > 0) {
            n2 += n3;
        }
        return n2;
    }
}

