/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$KeyMapping;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class ToggleButtonBehavior<C extends ToggleButton>
extends ButtonBehavior<C> {
    public ToggleButtonBehavior(C c2) {
        super(c2);
        ObservableList<InputMap$Mapping> observableList = FXCollections.observableArrayList(new InputMap$KeyMapping(KeyCode.RIGHT, keyEvent -> this.traverse((KeyEvent)keyEvent, "ToggleNext-Right")), new InputMap$KeyMapping(KeyCode.LEFT, keyEvent -> this.traverse((KeyEvent)keyEvent, "TogglePrevious-Left")), new InputMap$KeyMapping(KeyCode.DOWN, keyEvent -> this.traverse((KeyEvent)keyEvent, "ToggleNext-Down")), new InputMap$KeyMapping(KeyCode.UP, keyEvent -> this.traverse((KeyEvent)keyEvent, "TogglePrevious-Up")));
        for (InputMap$Mapping inputMap$Mapping : observableList) {
            inputMap$Mapping.setAutoConsume(false);
        }
        InputMap<C> inputMap = new InputMap<C>(c2);
        inputMap.getMappings().addAll((Collection<InputMap$Mapping<?>>)observableList);
        ToggleButtonBehavior toggleButtonBehavior = this;
        toggleButtonBehavior.addDefaultChildMap(((BehaviorBase)toggleButtonBehavior).getInputMap(), inputMap);
    }

    private int nextToggleIndex(ObservableList<Toggle> observableList, int n2) {
        Toggle toggle;
        if (n2 < 0 || n2 >= observableList.size()) {
            return 0;
        }
        int n3 = (n2 + 1) % observableList.size();
        while (n3 != n2 && (toggle = (Toggle)observableList.get(n3)) instanceof Node && ((Node)((Object)toggle)).isDisabled()) {
            n3 = (n3 + 1) % observableList.size();
        }
        return n3;
    }

    private int previousToggleIndex(ObservableList<Toggle> observableList, int n2) {
        Toggle toggle;
        if (n2 < 0 || n2 >= observableList.size()) {
            return observableList.size();
        }
        int n3 = Math.floorMod(n2 - 1, observableList.size());
        while (n3 != n2 && (toggle = (Toggle)observableList.get(n3)) instanceof Node && ((Node)((Object)toggle)).isDisabled()) {
            n3 = Math.floorMod(n3 - 1, observableList.size());
        }
        return n3;
    }

    private void traverse(KeyEvent keyEvent, String string) {
        ToggleButton toggleButton = (ToggleButton)this.getNode();
        ToggleGroup toggleGroup = toggleButton.getToggleGroup();
        if (toggleGroup == null) {
            keyEvent.consume();
            return;
        }
        ObservableList<Toggle> observableList = toggleGroup.getToggles();
        int n2 = observableList.indexOf(toggleButton);
        int n3 = this.traversingToNext(string, toggleButton.getEffectiveNodeOrientation());
        if (!Utils.isTwoLevelFocus()) {
            if (n3 != 0) {
                n3 = this.nextToggleIndex(observableList, n2);
                if (n3 != n2) {
                    Toggle toggle = (Toggle)observableList.get(n3);
                    toggleGroup.selectToggle(toggle);
                    ((Control)((Object)toggle)).requestFocus();
                    keyEvent.consume();
                }
                return;
            }
            n3 = this.previousToggleIndex(observableList, n2);
            if (n3 != n2) {
                Toggle toggle = (Toggle)observableList.get(n3);
                toggleGroup.selectToggle(toggle);
                ((Control)((Object)toggle)).requestFocus();
                keyEvent.consume();
            }
        }
    }

    private boolean traversingToNext(String string, NodeOrientation nodeOrientation) {
        boolean bl2 = nodeOrientation == NodeOrientation.RIGHT_TO_LEFT;
        int n2 = -1;
        switch (string.hashCode()) {
            case -1226903242: {
                if (!string.equals("ToggleNext-Right")) break;
                n2 = 0;
                break;
            }
            case 1761126984: {
                if (!string.equals("ToggleNext-Down")) break;
                n2 = 1;
                break;
            }
            case 254673449: {
                if (!string.equals("TogglePrevious-Left")) break;
                n2 = 2;
                break;
            }
            case 491884861: {
                if (!string.equals("TogglePrevious-Up")) break;
                n2 = 3;
            }
        }
        switch (n2) {
            case 0: {
                return !bl2;
            }
            case 1: {
                return true;
            }
            case 2: {
                return bl2;
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalArgumentException("Not a toggle action");
    }
}

