/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalMethod;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.PopupControl;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class TwoLevelFocusPopupBehavior
extends TwoLevelFocusBehavior {
    final EventDispatcher preemptiveEventDispatcher = (event, object) -> {
        if (event instanceof KeyEvent && event.getEventType() == KeyEvent.KEY_PRESSED && !((KeyEvent)event).isMetaDown() && !((KeyEvent)event).isControlDown() && !((KeyEvent)event).isAltDown() && this.isExternalFocus()) {
            object = event.getTarget();
            switch (((KeyEvent)event).getCode()) {
                case TAB: {
                    if (((KeyEvent)event).isShiftDown()) {
                        NodeHelper.traverse((Node)((Object)object), Direction.PREVIOUS, TraversalMethod.KEY);
                    } else {
                        NodeHelper.traverse((Node)((Object)object), Direction.NEXT, TraversalMethod.KEY);
                    }
                    event.consume();
                    break;
                }
                case UP: {
                    NodeHelper.traverse((Node)((Object)object), Direction.UP, TraversalMethod.KEY);
                    event.consume();
                    break;
                }
                case DOWN: {
                    NodeHelper.traverse((Node)((Object)object), Direction.DOWN, TraversalMethod.KEY);
                    event.consume();
                    break;
                }
                case LEFT: {
                    NodeHelper.traverse((Node)((Object)object), Direction.LEFT, TraversalMethod.KEY);
                    event.consume();
                    break;
                }
                case RIGHT: {
                    NodeHelper.traverse((Node)((Object)object), Direction.RIGHT, TraversalMethod.KEY);
                    event.consume();
                    break;
                }
                case ENTER: {
                    this.setExternalFocus(false);
                    event.consume();
                    break;
                }
                default: {
                    object = this.tlNode.getScene();
                    Event.fireEvent((EventTarget)((Object)object), event);
                    event.consume();
                }
            }
        }
        return event;
    };
    final EventDispatcher preemptivePopupEventDispatcher = (event, object) -> {
        block11: {
            if (!(!(event instanceof KeyEvent) || event.getEventType() != KeyEvent.KEY_PRESSED || ((KeyEvent)event).isMetaDown() || ((KeyEvent)event).isControlDown() || ((KeyEvent)event).isAltDown() || this.isExternalFocus())) {
                object = event.getTarget();
                switch (((KeyEvent)event).getCode()) {
                    case TAB: 
                    case ENTER: {
                        event.consume();
                        break block11;
                    }
                    case UP: 
                    case DOWN: {
                        break block11;
                    }
                    case LEFT: {
                        if (object instanceof Node) {
                            NodeHelper.traverse((Node)((Object)object), Direction.LEFT, TraversalMethod.KEY);
                            break;
                        }
                        if (object instanceof Scene && (object = ((Scene)((Object)object)).getFocusOwner()) != null) {
                            NodeHelper.traverse((Node)((Object)object), Direction.LEFT, TraversalMethod.KEY);
                            event.consume();
                        }
                        break block11;
                    }
                    case RIGHT: {
                        if (object instanceof Node) {
                            NodeHelper.traverse((Node)((Object)object), Direction.RIGHT, TraversalMethod.KEY);
                            break;
                        }
                        if (object instanceof Scene && (object = ((Scene)((Object)object)).getFocusOwner()) != null) {
                            NodeHelper.traverse((Node)((Object)object), Direction.RIGHT, TraversalMethod.KEY);
                            event.consume();
                        }
                        break block11;
                    }
                    default: {
                        if (this.tlNode == null) break;
                        object = this.tlNode.getScene();
                        Event.fireEvent((EventTarget)((Object)object), event);
                    }
                }
                event.consume();
            }
        }
        return event;
    };
    final EventDispatcher tlfEventDispatcher = (event, eventDispatchChain) -> {
        if (event instanceof KeyEvent) {
            if (this.isExternalFocus()) {
                eventDispatchChain = eventDispatchChain.prepend(this.preemptiveEventDispatcher);
                return eventDispatchChain.dispatchEvent(event);
            }
            eventDispatchChain = eventDispatchChain.prepend(this.preemptivePopupEventDispatcher);
            eventDispatchChain = eventDispatchChain.prepend(this.origEventDispatcher);
            return eventDispatchChain.dispatchEvent(event);
        }
        return this.origEventDispatcher.dispatchEvent(event, eventDispatchChain);
    };
    private final EventHandler<KeyEvent> keyEventListener = keyEvent -> this.postDispatchTidyup(keyEvent);
    final ChangeListener<Boolean> focusListener;
    private final EventHandler<MouseEvent> mouseEventListener;

    public TwoLevelFocusPopupBehavior(PopupControl popupControl) {
        this.focusListener = (observableValue, bl2, bl3) -> {};
        this.mouseEventListener = mouseEvent -> this.setExternalFocus(false);
        this.tlPopup = popupControl;
        this.setExternalFocus(false);
        this.tlPopup.addEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.tlPopup.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventListener);
        this.tlPopup.focusedProperty().addListener(this.focusListener);
        this.origEventDispatcher = this.tlPopup.getEventDispatcher();
        this.tlPopup.setEventDispatcher(this.tlfEventDispatcher);
    }

    public TwoLevelFocusPopupBehavior(Node node) {
        this.focusListener = (observableValue, bl2, bl3) -> {};
        this.mouseEventListener = mouseEvent -> this.setExternalFocus(false);
        this.tlNode = node;
        this.setExternalFocus(false);
        this.tlNode.addEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.tlNode.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventListener);
        this.tlNode.focusedProperty().addListener(this.focusListener);
        this.origEventDispatcher = this.tlNode.getEventDispatcher();
        this.tlNode.setEventDispatcher(this.tlfEventDispatcher);
    }

    @Override
    public void dispose() {
        this.tlNode.removeEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.tlNode.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventListener);
        this.tlNode.focusedProperty().removeListener(this.focusListener);
        this.tlNode.setEventDispatcher(this.origEventDispatcher);
    }

    private Event postDispatchTidyup(Event event) {
        if (!(!(event instanceof KeyEvent) || event.getEventType() != KeyEvent.KEY_PRESSED || this.isExternalFocus() || ((KeyEvent)event).isMetaDown() || ((KeyEvent)event).isControlDown() || ((KeyEvent)event).isAltDown())) {
            switch (((KeyEvent)event).getCode()) {
                case TAB: 
                case UP: 
                case DOWN: 
                case LEFT: 
                case RIGHT: {
                    event.consume();
                    break;
                }
                case ENTER: {
                    this.setExternalFocus(true);
                    event.consume();
                }
            }
        }
        return event;
    }
}

