/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.inputmap;

import com.sun.javafx.scene.control.inputmap.InputMap$1;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.util.Pair;

public class InputMap<N extends Node>
implements EventHandler<Event> {
    private final N node;
    private final ObservableList<InputMap<N>> childInputMaps;
    private final ObservableList<InputMap$Mapping<?>> mappings;
    private final Map<EventType<?>, List<EventHandler<? super Event>>> installedEventHandlers;
    private final Map<EventType, List<InputMap$Mapping>> eventTypeMappings;
    private ReadOnlyObjectWrapper<InputMap<N>> parentInputMap;
    private ObjectProperty<Predicate<? extends Event>> interceptor;

    public InputMap(N n2) {
        InputMap inputMap = this;
        this.parentInputMap = new InputMap$1(inputMap, inputMap, "parentInputMap");
        this.interceptor = new SimpleObjectProperty<Predicate<? extends Event>>(this, "interceptor");
        if (n2 == null) {
            throw new IllegalArgumentException("Node can not be null");
        }
        this.node = n2;
        this.eventTypeMappings = new HashMap<EventType, List<InputMap$Mapping>>();
        this.installedEventHandlers = new HashMap();
        this.mappings = FXCollections.observableArrayList();
        this.mappings.addListener(listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                Object object2;
                if (listChangeListener$Change.wasRemoved()) {
                    for (Object object2 : listChangeListener$Change.getRemoved()) {
                        this.removeMapping((InputMap$Mapping<?>)object2);
                    }
                }
                if (!listChangeListener$Change.wasAdded()) continue;
                ArrayList arrayList = new ArrayList();
                object2 = listChangeListener$Change.getAddedSubList().iterator();
                while (object2.hasNext()) {
                    InputMap$Mapping inputMap$Mapping = (InputMap$Mapping)object2.next();
                    if (inputMap$Mapping == null) {
                        arrayList.add(null);
                        continue;
                    }
                    this.addMapping(inputMap$Mapping);
                }
                if (arrayList.isEmpty()) continue;
                this.getMappings().removeAll(arrayList);
                throw new IllegalArgumentException("Null mappings not permitted");
            }
        });
        this.childInputMaps = FXCollections.observableArrayList();
        this.childInputMaps.addListener(listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                Object object2;
                if (listChangeListener$Change.wasRemoved()) {
                    for (Object object2 : listChangeListener$Change.getRemoved()) {
                        ((InputMap)object2).setParentInputMap(null);
                    }
                }
                if (!listChangeListener$Change.wasAdded()) continue;
                ArrayList arrayList = new ArrayList();
                object2 = listChangeListener$Change.getAddedSubList().iterator();
                while (object2.hasNext()) {
                    InputMap inputMap = (InputMap)object2.next();
                    if (inputMap.getNode() != this.getNode()) {
                        arrayList.add(inputMap);
                        continue;
                    }
                    inputMap.setParentInputMap(this);
                }
                if (arrayList.isEmpty()) continue;
                this.getChildInputMaps().removeAll(arrayList);
                throw new IllegalArgumentException("Child InputMap intances need to share a common Node object");
            }
        });
    }

    private final void setParentInputMap(InputMap<N> inputMap) {
        this.parentInputMap.set(inputMap);
    }

    private final InputMap<N> getParentInputMap() {
        return (InputMap)this.parentInputMap.get();
    }

    private final ReadOnlyObjectProperty<InputMap<N>> parentInputMapProperty() {
        return this.parentInputMap.getReadOnlyProperty();
    }

    public final Predicate<? extends Event> getInterceptor() {
        return (Predicate)this.interceptor.get();
    }

    public final void setInterceptor(Predicate<? extends Event> predicate) {
        this.interceptor.set(predicate);
    }

    public final ObjectProperty<Predicate<? extends Event>> interceptorProperty() {
        return this.interceptor;
    }

    public final N getNode() {
        return this.node;
    }

    public ObservableList<InputMap$Mapping<?>> getMappings() {
        return this.mappings;
    }

    public ObservableList<InputMap<N>> getChildInputMaps() {
        return this.childInputMaps;
    }

    public void dispose() {
        for (InputMap inputMap : this.getChildInputMaps()) {
            inputMap.dispose();
        }
        this.removeAllEventHandlers();
        this.getMappings().clear();
    }

    @Override
    public void handle(Event event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        Object object = this.lookup(event, true);
        object = object.iterator();
        while (object.hasNext()) {
            InputMap$Mapping inputMap$Mapping = (InputMap$Mapping)object.next();
            EventHandler<Event> eventHandler = inputMap$Mapping.getEventHandler();
            if (eventHandler != null) {
                eventHandler.handle(event);
            }
            if (inputMap$Mapping.isAutoConsume()) {
                event.consume();
            }
            if (!event.isConsumed()) continue;
        }
    }

    public Optional<InputMap$Mapping<?>> lookupMapping(Object object) {
        if (object == null) {
            return Optional.empty();
        }
        List<InputMap$Mapping<?>> list = this.lookupMappingKey(object);
        for (int i2 = 0; i2 < this.getChildInputMaps().size(); ++i2) {
            Object object2 = (InputMap)this.getChildInputMaps().get(i2);
            object2 = ((InputMap)object2).lookupMappingKey(object);
            list.addAll(0, (Collection<InputMap$Mapping<?>>)object2);
        }
        if (list.size() > 0) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    private List<InputMap$Mapping<?>> lookupMappingKey(Object object) {
        return this.getMappings().stream().filter(inputMap$Mapping -> !inputMap$Mapping.isDisabled()).filter(inputMap$Mapping -> object.equals(inputMap$Mapping.getMappingKey())).collect(Collectors.toList());
    }

    private List<InputMap$Mapping<?>> lookup(Event event, boolean bl2) {
        boolean bl3;
        if (bl2 && (bl3 = this.testInterceptor(event, this.getInterceptor()))) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        List<Pair<Integer, InputMap$Mapping<?>>> list = this.lookupMappingAndSpecificity(event, 0);
        if (!list.isEmpty()) {
            n2 = list.get(0).getKey();
            arrayList.addAll(list.stream().map(pair -> (InputMap$Mapping)pair.getValue()).collect(Collectors.toList()));
        }
        for (int i2 = 0; i2 < this.getChildInputMaps().size(); ++i2) {
            InputMap inputMap = (InputMap)this.getChildInputMaps().get(i2);
            n2 = this.scanRecursively(inputMap, event, bl2, n2, arrayList);
        }
        return arrayList;
    }

    private int scanRecursively(InputMap<?> inputMap, Event event, boolean bl2, int n2, List<InputMap$Mapping<?>> list) {
        int n3;
        boolean bl3;
        if (bl2 && (bl3 = this.testInterceptor(event, inputMap.getInterceptor()))) {
            return n2;
        }
        List<Pair<Integer, InputMap$Mapping<Object>>> list2 = inputMap.lookupMappingAndSpecificity(event, n2);
        if (!list2.isEmpty()) {
            n3 = list2.get(0).getKey();
            list2 = list2.stream().map(pair -> (InputMap$Mapping)pair.getValue()).collect(Collectors.toList());
            if (n3 == n2) {
                list.addAll(0, list2);
            } else if (n3 > n2) {
                list.clear();
                n2 = n3;
                list.addAll(list2);
            }
        }
        for (n3 = 0; n3 < inputMap.getChildInputMaps().size(); ++n3) {
            n2 = this.scanRecursively((InputMap)inputMap.getChildInputMaps().get(n3), event, bl2, n2, list);
        }
        return n2;
    }

    private InputMap<N> getRootInputMap() {
        InputMap<N> inputMap;
        InputMap<N> inputMap2 = this;
        while (inputMap2 != null && (inputMap = inputMap2.getParentInputMap()) != null) {
            inputMap2 = inputMap;
        }
        return inputMap2;
    }

    private void addMapping(InputMap$Mapping<?> inputMap$Mapping) {
        Object object = this.getRootInputMap();
        ((InputMap)object).addEventHandler(inputMap$Mapping.eventType);
        object = inputMap$Mapping.getEventType();
        object = this.eventTypeMappings.computeIfAbsent((EventType)object, eventType -> new ArrayList());
        object.add(inputMap$Mapping);
    }

    private void removeMapping(InputMap$Mapping<?> inputMap$Mapping) {
        EventType<?> eventType = inputMap$Mapping.getEventType();
        if (this.eventTypeMappings.containsKey(eventType)) {
            eventType = this.eventTypeMappings.get(eventType);
            eventType.remove(inputMap$Mapping);
        }
    }

    private void addEventHandler(EventType eventType2) {
        List list = this.installedEventHandlers.computeIfAbsent(eventType2, eventType -> new ArrayList());
        EventHandler<Event> eventHandler = this::handle;
        if (list.isEmpty()) {
            ((Node)this.node).addEventHandler((EventType<Event>)eventType2, eventHandler);
        }
        list.add(eventHandler);
    }

    private void removeAllEventHandlers() {
        for (EventType<?> eventType : this.installedEventHandlers.keySet()) {
            Object object = this.installedEventHandlers.get(eventType);
            object = object.iterator();
            while (object.hasNext()) {
                EventHandler eventHandler = (EventHandler)object.next();
                ((Node)this.node).removeEventHandler(eventType, eventHandler);
            }
        }
    }

    private void reprocessAllMappings() {
        this.removeAllEventHandlers();
        this.mappings.stream().forEach(this::addMapping);
        for (InputMap inputMap : this.getChildInputMaps()) {
            inputMap.reprocessAllMappings();
        }
    }

    private List<Pair<Integer, InputMap$Mapping<?>>> lookupMappingAndSpecificity(Event event, int n2) {
        Object object = this.eventTypeMappings.getOrDefault(event.getEventType(), Collections.emptyList());
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            int n3;
            InputMap$Mapping inputMap$Mapping = (InputMap$Mapping)object.next();
            if (inputMap$Mapping.isDisabled() || (n3 = this.testInterceptor(event, inputMap$Mapping.getInterceptor())) != 0) continue;
            n3 = inputMap$Mapping.getSpecificity(event);
            if (n3 > 0 && n3 == n2) {
                arrayList.add(new Pair<Integer, InputMap$Mapping>(n3, inputMap$Mapping));
                continue;
            }
            if (n3 <= n2) continue;
            arrayList.clear();
            arrayList.add(new Pair<Integer, InputMap$Mapping>(n3, inputMap$Mapping));
            n2 = n3;
        }
        return arrayList;
    }

    private boolean testInterceptor(Event event, Predicate predicate) {
        return predicate != null && predicate.test(event);
    }
}

