/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.inputmap;

import com.sun.javafx.scene.control.inputmap.KeyBinding$OptionalBoolean;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class KeyBinding {
    private final KeyCode code;
    private final EventType<KeyEvent> eventType;
    private KeyBinding$OptionalBoolean shift = KeyBinding$OptionalBoolean.FALSE;
    private KeyBinding$OptionalBoolean ctrl = KeyBinding$OptionalBoolean.FALSE;
    private KeyBinding$OptionalBoolean alt = KeyBinding$OptionalBoolean.FALSE;
    private KeyBinding$OptionalBoolean meta = KeyBinding$OptionalBoolean.FALSE;

    public KeyBinding(KeyCode keyCode) {
        this(keyCode, null);
    }

    public KeyBinding(EventType<KeyEvent> eventType) {
        this(null, eventType);
    }

    public KeyBinding(KeyCode keyCode, EventType<KeyEvent> eventType) {
        this.code = keyCode;
        this.eventType = eventType != null ? eventType : KeyEvent.KEY_PRESSED;
    }

    public final KeyBinding shift() {
        return this.shift(KeyBinding$OptionalBoolean.TRUE);
    }

    public final KeyBinding shift(KeyBinding$OptionalBoolean keyBinding$OptionalBoolean) {
        this.shift = keyBinding$OptionalBoolean;
        return this;
    }

    public final KeyBinding ctrl() {
        return this.ctrl(KeyBinding$OptionalBoolean.TRUE);
    }

    public final KeyBinding ctrl(KeyBinding$OptionalBoolean keyBinding$OptionalBoolean) {
        this.ctrl = keyBinding$OptionalBoolean;
        return this;
    }

    public final KeyBinding alt() {
        return this.alt(KeyBinding$OptionalBoolean.TRUE);
    }

    public final KeyBinding alt(KeyBinding$OptionalBoolean keyBinding$OptionalBoolean) {
        this.alt = keyBinding$OptionalBoolean;
        return this;
    }

    public final KeyBinding meta() {
        return this.meta(KeyBinding$OptionalBoolean.TRUE);
    }

    public final KeyBinding meta(KeyBinding$OptionalBoolean keyBinding$OptionalBoolean) {
        this.meta = keyBinding$OptionalBoolean;
        return this;
    }

    public final KeyBinding shortcut() {
        if (Toolkit.getToolkit().getClass().getName().endsWith("StubToolkit")) {
            if (Utils.isMac()) {
                return this.meta();
            }
            return this.ctrl();
        }
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shift();
            }
            case CONTROL: {
                return this.ctrl();
            }
            case ALT: {
                return this.alt();
            }
            case META: {
                return this.meta();
            }
        }
        return this;
    }

    public final KeyCode getCode() {
        return this.code;
    }

    public final EventType<KeyEvent> getType() {
        return this.eventType;
    }

    public final KeyBinding$OptionalBoolean getShift() {
        return this.shift;
    }

    public final KeyBinding$OptionalBoolean getCtrl() {
        return this.ctrl;
    }

    public final KeyBinding$OptionalBoolean getAlt() {
        return this.alt;
    }

    public final KeyBinding$OptionalBoolean getMeta() {
        return this.meta;
    }

    public int getSpecificity(KeyEvent keyEvent) {
        if (this.code != null && this.code != keyEvent.getCode()) {
            return 0;
        }
        int n2 = 1;
        if (!this.shift.equals(keyEvent.isShiftDown())) {
            return 0;
        }
        if (this.shift != KeyBinding$OptionalBoolean.ANY) {
            ++n2;
        }
        if (!this.ctrl.equals(keyEvent.isControlDown())) {
            return 0;
        }
        if (this.ctrl != KeyBinding$OptionalBoolean.ANY) {
            ++n2;
        }
        if (!this.alt.equals(keyEvent.isAltDown())) {
            return 0;
        }
        if (this.alt != KeyBinding$OptionalBoolean.ANY) {
            ++n2;
        }
        if (!this.meta.equals(keyEvent.isMetaDown())) {
            return 0;
        }
        if (this.meta != KeyBinding$OptionalBoolean.ANY) {
            ++n2;
        }
        if (this.eventType != null && this.eventType != ((Event)keyEvent).getEventType()) {
            return 0;
        }
        return ++n2;
    }

    public String toString() {
        return "KeyBinding [code=" + String.valueOf((Object)this.code) + ", shift=" + String.valueOf((Object)this.shift) + ", ctrl=" + String.valueOf((Object)this.ctrl) + ", alt=" + String.valueOf((Object)this.alt) + ", meta=" + String.valueOf((Object)this.meta) + ", type=" + String.valueOf(this.eventType) + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyBinding)) {
            return false;
        }
        object = (KeyBinding)object;
        return Objects.equals((Object)this.getCode(), (Object)((KeyBinding)object).getCode()) && Objects.equals(this.eventType, ((KeyBinding)object).eventType) && Objects.equals((Object)this.getShift(), (Object)((KeyBinding)object).getShift()) && Objects.equals((Object)this.getCtrl(), (Object)((KeyBinding)object).getCtrl()) && Objects.equals((Object)this.getAlt(), (Object)((KeyBinding)object).getAlt()) && Objects.equals((Object)this.getMeta(), (Object)((KeyBinding)object).getMeta());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getCode(), this.eventType, this.getShift(), this.getCtrl(), this.getAlt(), this.getMeta()});
    }

    public static KeyBinding toKeyBinding(KeyEvent keyEvent) {
        KeyBinding keyBinding = new KeyBinding(keyEvent.getCode(), ((Event)keyEvent).getEventType());
        if (keyEvent.isShiftDown()) {
            keyBinding.shift();
        }
        if (keyEvent.isControlDown()) {
            keyBinding.ctrl();
        }
        if (keyEvent.isAltDown()) {
            keyBinding.alt();
        }
        if (keyEvent.isShortcutDown()) {
            keyBinding.shortcut();
        }
        return keyBinding;
    }
}

