/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.FXVK;
import com.sun.javafx.scene.control.skin.FXVKCharEntities;
import com.sun.javafx.scene.control.skin.FXVKSkin$1;
import com.sun.javafx.scene.control.skin.FXVKSkin$2;
import com.sun.javafx.scene.control.skin.FXVKSkin$3;
import com.sun.javafx.scene.control.skin.FXVKSkin$4;
import com.sun.javafx.scene.control.skin.FXVKSkin$5;
import com.sun.javafx.scene.control.skin.FXVKSkin$CharKey;
import com.sun.javafx.scene.control.skin.FXVKSkin$Key;
import com.sun.javafx.scene.control.skin.FXVKSkin$KeyCodeKey;
import com.sun.javafx.scene.control.skin.FXVKSkin$SuperKey;
import com.sun.javafx.scene.control.skin.FXVKSkin$TextInputKey;
import com.sun.javafx.util.Utils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.skin.TextAreaSkin;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Duration;

public class FXVKSkin
extends SkinBase<FXVK> {
    private static final int GAP = 6;
    private List<List<FXVKSkin$Key>> currentBoard;
    private static HashMap<String, List<List<FXVKSkin$Key>>> boardMap = new HashMap();
    private int numCols;
    private boolean capsDown = false;
    private boolean shiftDown = false;
    private boolean isSymbol = false;
    long lastTime = -1L;
    private static Popup vkPopup;
    private static Popup secondaryPopup;
    private static FXVK primaryVK;
    private static Timeline slideInTimeline;
    private static Timeline slideOutTimeline;
    private static boolean hideAfterSlideOut;
    private static FXVK secondaryVK;
    private static Timeline secondaryVKDelay;
    private static FXVKSkin$CharKey secondaryVKKey;
    private static FXVKSkin$TextInputKey repeatKey;
    private static Timeline repeatInitialDelay;
    private static Timeline repeatSubsequentDelay;
    private static double KEY_REPEAT_DELAY;
    private static double KEY_REPEAT_DELAY_MIN;
    private static double KEY_REPEAT_DELAY_MAX;
    private static double KEY_REPEAT_RATE;
    private static double KEY_REPEAT_RATE_MIN;
    private static double KEY_REPEAT_RATE_MAX;
    private Node attachedNode;
    private String vkType = null;
    FXVK fxvk;
    static final double VK_HEIGHT = 243.0;
    static final double VK_SLIDE_MILLIS = 250.0;
    static final double PREF_PORTRAIT_KEY_WIDTH = 40.0;
    static final double PREF_KEY_HEIGHT = 56.0;
    static boolean vkAdjustWindow;
    static boolean vkLookup;
    private static DoubleProperty winY;
    EventHandler<InputEvent> unHideEventHandler;
    private boolean isVKHidden = false;
    private Double origWindowYPos = null;

    void clearShift() {
        if (this.shiftDown && !this.capsDown) {
            this.shiftDown = false;
            this.updateKeys();
        }
        this.lastTime = -1L;
    }

    void pressShift() {
        long l2 = System.currentTimeMillis();
        if (this.shiftDown && !this.capsDown) {
            if (this.lastTime > 0L && l2 - this.lastTime < 400L) {
                this.shiftDown = false;
                this.capsDown = true;
            } else {
                this.shiftDown = false;
                this.capsDown = false;
            }
        } else if (!this.shiftDown && !this.capsDown) {
            this.shiftDown = true;
        } else {
            this.shiftDown = false;
            this.capsDown = false;
        }
        this.updateKeys();
        this.lastTime = l2;
    }

    void clearSymbolABC() {
        this.isSymbol = false;
        this.updateKeys();
    }

    void pressSymbolABC() {
        this.isSymbol = !this.isSymbol;
        this.updateKeys();
    }

    void clearStateKeys() {
        this.capsDown = false;
        this.shiftDown = false;
        this.isSymbol = false;
        this.lastTime = -1L;
        this.updateKeys();
    }

    private void updateKeys() {
        for (List<FXVKSkin$Key> list : this.currentBoard) {
            for (FXVKSkin$Key fXVKSkin$Key : list) {
                fXVKSkin$Key.update(this.capsDown, this.shiftDown, this.isSymbol);
            }
        }
    }

    private static void startSlideIn() {
        ((Animation)slideOutTimeline).stop();
        slideInTimeline.playFromStart();
    }

    private static void startSlideOut(boolean bl2) {
        hideAfterSlideOut = bl2;
        ((Animation)slideInTimeline).stop();
        slideOutTimeline.playFromStart();
    }

    private void adjustWindowPosition(Node node) {
        double d2;
        double d3;
        if (!(node instanceof TextInputControl)) {
            return;
        }
        double d4 = node.localToScene(0.0, 0.0).getY() + node.getScene().getY();
        double d5 = ((TextInputControl)node).getHeight();
        double d6 = d4 + d5;
        double d7 = Utils.getScreen(node).getBounds().getHeight();
        double d8 = d7 - 243.0;
        if (node instanceof TextField) {
            double d9 = d4 + d5 / 2.0;
            d3 = d6;
            Parent parent = this.attachedNode.getParent();
            d2 = parent instanceof ComboBoxBase ? Math.min(10.0 - d4, 0.0) : Math.min(d8 / 2.0 - d9, 0.0);
        } else if (node instanceof TextArea) {
            Object object = (TextAreaSkin)((TextArea)node).getSkin();
            object = ((TextAreaSkin)object).getCaretBounds();
            double d10 = ((Bounds)object).getMinY();
            double d11 = ((Bounds)object).getMaxY();
            double d12 = d4 + (d10 + d11) / 2.0;
            d3 = d4 + d11;
            d2 = d5 < d8 ? d8 / 2.0 - (d4 + d5 / 2.0) : d8 / 2.0 - d12;
            d2 = Math.min(d2, 0.0);
        } else {
            double d13 = d4 + d5 / 2.0;
            d3 = d6;
            d2 = Math.min(d8 / 2.0 - d13, 0.0);
        }
        Window window = node.getScene().getWindow();
        if (this.origWindowYPos + d3 > d8) {
            window.setY(d2);
            return;
        }
        window.setY(this.origWindowYPos);
    }

    private void saveWindowPosition(Node eventTarget) {
        eventTarget = ((Node)eventTarget).getScene().getWindow();
        this.origWindowYPos = ((Window)eventTarget).getY();
    }

    private void restoreWindowPosition(Node eventTarget) {
        if (eventTarget != null && (eventTarget = ((Node)eventTarget).getScene()) != null && (eventTarget = ((Scene)eventTarget).getWindow()) != null) {
            ((Window)eventTarget).setY(this.origWindowYPos);
        }
    }

    private void registerUnhideHandler(Node node) {
        if (this.unHideEventHandler == null) {
            this.unHideEventHandler = inputEvent -> {
                if (this.attachedNode != null && this.isVKHidden) {
                    double d2 = Utils.getScreen(this.attachedNode).getBounds().getHeight();
                    if (this.fxvk.getHeight() > 0.0 && vkPopup.getY() > d2 - this.fxvk.getHeight() && slideInTimeline.getStatus() != Animation$Status.RUNNING) {
                        FXVKSkin.startSlideIn();
                        if (vkAdjustWindow) {
                            FXVKSkin fXVKSkin = this;
                            fXVKSkin.adjustWindowPosition(fXVKSkin.attachedNode);
                        }
                    }
                }
                this.isVKHidden = false;
            };
        }
        node.addEventHandler(TouchEvent.TOUCH_PRESSED, this.unHideEventHandler);
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.unHideEventHandler);
    }

    private void unRegisterUnhideHandler(Node node) {
        if (this.unHideEventHandler != null) {
            node.removeEventHandler(TouchEvent.TOUCH_PRESSED, this.unHideEventHandler);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.unHideEventHandler);
        }
    }

    private String getNodeVKType(Node object) {
        object = (Integer)((Node)object).getProperties().get("vkType");
        String string = null;
        if (object != null && (object = FXVK.VK_TYPE_NAMES[(Integer)object]) instanceof String) {
            string = ((String)object).toLowerCase(Locale.ROOT);
        }
        if (string != null) {
            return string;
        }
        return "text";
    }

    private void updateKeyboardType(Node node) {
        String string = this.vkType;
        this.vkType = this.getNodeVKType(node);
        if (string == null || !this.vkType.equals(string)) {
            FXVKSkin fXVKSkin = this;
            fXVKSkin.rebuildPrimaryVK(fXVKSkin.vkType);
        }
    }

    private void closeSecondaryVK() {
        if (secondaryVK != null) {
            secondaryVK.setAttachedNode(null);
            ((Window)secondaryPopup).hide();
        }
    }

    private void setupPrimaryVK() {
        this.fxvk.setFocusTraversable(false);
        this.fxvk.setVisible(true);
        if (vkPopup == null) {
            vkPopup = new Popup();
            vkPopup.setAutoFix(false);
        }
        vkPopup.getContent().setAll((Node[])new Node[]{this.fxvk});
        double d2 = Utils.getScreen(this.fxvk).getBounds().getHeight();
        double d3 = Utils.getScreen(this.fxvk).getBounds().getWidth();
        slideInTimeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(250.0), new KeyValue(winY, d2 - 243.0, Interpolator.EASE_BOTH))});
        slideOutTimeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(250.0), actionEvent -> {
            if (hideAfterSlideOut && vkPopup.isShowing()) {
                ((Window)vkPopup).hide();
            }
        }, new KeyValue(winY, d2, Interpolator.EASE_BOTH))});
        this.fxvk.setPrefWidth(d3);
        this.fxvk.setMinWidth(Double.NEGATIVE_INFINITY);
        this.fxvk.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.fxvk.setPrefHeight(243.0);
        this.fxvk.setMinHeight(Double.NEGATIVE_INFINITY);
        if (secondaryVKDelay == null) {
            secondaryVKDelay = new Timeline();
        }
        KeyFrame keyFrame = new KeyFrame(Duration.millis(500.0), actionEvent -> {
            if (secondaryVKKey != null) {
                this.showSecondaryVK(secondaryVKKey);
            }
        }, new KeyValue[0]);
        secondaryVKDelay.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame});
        if (KEY_REPEAT_RATE > 0.0) {
            repeatInitialDelay = new Timeline(new KeyFrame(Duration.millis(KEY_REPEAT_DELAY), actionEvent -> {
                repeatKey.sendKeyEvents();
                repeatSubsequentDelay.playFromStart();
            }, new KeyValue[0]));
            repeatSubsequentDelay = new Timeline(new KeyFrame(Duration.millis(1000.0 / KEY_REPEAT_RATE), actionEvent -> repeatKey.sendKeyEvents(), new KeyValue[0]));
            repeatSubsequentDelay.setCycleCount(-1);
        }
    }

    void prerender(Node node) {
        if (this.fxvk != primaryVK) {
            return;
        }
        this.loadBoard("text");
        this.loadBoard("numeric");
        this.loadBoard("url");
        this.loadBoard("email");
        this.updateKeyboardType(node);
        this.fxvk.setVisible(true);
        if (!vkPopup.isShowing()) {
            Rectangle2D rectangle2D = Utils.getScreen(node).getBounds();
            vkPopup.setX((rectangle2D.getWidth() - ((Node)this.fxvk).prefWidth(-1.0)) / 2.0);
            winY.set(rectangle2D.getHeight());
            vkPopup.show(node.getScene().getWindow());
        }
    }

    public FXVKSkin(FXVK fXVK) {
        super(fXVK);
        this.fxvk = fXVK;
        if (fXVK == FXVK.vk) {
            primaryVK = fXVK;
        }
        if (fXVK == primaryVK) {
            this.setupPrimaryVK();
        }
        fXVK.attachedNodeProperty().addListener(new FXVKSkin$1(this, fXVK));
    }

    private void rebuildSecondaryVK() {
        if (FXVKSkin.secondaryVK.chars != null) {
            int n2;
            int n3;
            int n4 = FXVKSkin.secondaryVK.chars.length;
            int n5 = (int)Math.floor(Math.sqrt(Math.max(1, n4 - 2)));
            int n6 = (int)Math.ceil((double)n4 / (double)n5);
            ArrayList<List<FXVKSkin$Key>> arrayList = new ArrayList<List<FXVKSkin$Key>>(2);
            for (int i2 = 0; i2 < n5 && (n3 = i2 * n6) < (n2 = Math.min(n3 + n6, n4)); ++i2) {
                ArrayList<FXVKSkin$CharKey> object = new ArrayList<FXVKSkin$CharKey>(n6);
                for (int i3 = n3; i3 < n2; ++i3) {
                    FXVKSkin$CharKey fXVKSkin$CharKey = new FXVKSkin$CharKey(this, FXVKSkin.secondaryVK.chars[i3], null, null);
                    new FXVKSkin$CharKey(this, FXVKSkin.secondaryVK.chars[i3], null, null).col = i3 - n3 << 1;
                    fXVKSkin$CharKey.colSpan = 2;
                    for (String string : fXVKSkin$CharKey.getStyleClass()) {
                        fXVKSkin$CharKey.text.getStyleClass().add(string + "-text");
                        fXVKSkin$CharKey.altText.getStyleClass().add(string + "-alttext");
                        fXVKSkin$CharKey.icon.getStyleClass().add(string + "-icon");
                    }
                    if (FXVKSkin.secondaryVK.chars[i3] != null && FXVKSkin.secondaryVK.chars[i3].length() > 1) {
                        fXVKSkin$CharKey.text.getStyleClass().add("multi-char-text");
                    }
                    object.add(fXVKSkin$CharKey);
                }
                arrayList.add(object);
            }
            this.currentBoard = arrayList;
            this.getChildren().clear();
            this.numCols = 0;
            for (List<FXVKSkin$Key> list : this.currentBoard) {
                for (FXVKSkin$Key fXVKSkin$Key : list) {
                    this.numCols = Math.max(this.numCols, fXVKSkin$Key.col + fXVKSkin$Key.colSpan);
                }
                this.getChildren().addAll((Collection<Node>)list);
            }
        }
    }

    private void rebuildPrimaryVK(String object) {
        this.currentBoard = this.loadBoard((String)((Object)object));
        this.clearStateKeys();
        this.getChildren().clear();
        this.numCols = 0;
        for (List<FXVKSkin$Key> list : this.currentBoard) {
            for (FXVKSkin$Key fXVKSkin$Key : list) {
                this.numCols = Math.max(this.numCols, fXVKSkin$Key.col + fXVKSkin$Key.colSpan);
            }
            this.getChildren().addAll((Collection<Node>)list);
        }
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return d6 + (double)(56 * this.numCols) + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + 400.0 + d5;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        int n2 = this.currentBoard.size();
        double d6 = (d4 - (double)((this.numCols - 1) * 6)) / (double)this.numCols;
        double d7 = (d5 - (double)((n2 - 1) * 6)) / (double)n2;
        double d8 = d3;
        for (List<FXVKSkin$Key> list : this.currentBoard) {
            for (FXVKSkin$Key fXVKSkin$Key : list) {
                double d9 = d2 + (double)fXVKSkin$Key.col * (d6 + 6.0);
                double d10 = (double)fXVKSkin$Key.colSpan * (d6 + 6.0) - 6.0;
                fXVKSkin$Key.resizeRelocate((int)(d9 + 0.5), (int)(d8 + 0.5), d10, d7);
            }
            d8 += d7 + 6.0;
        }
    }

    private void showSecondaryVK(FXVKSkin$CharKey fXVKSkin$CharKey) {
        if (fXVKSkin$CharKey != null) {
            Node node = primaryVK.getAttachedNode();
            if (secondaryVK == null) {
                secondaryVK = new FXVK();
                secondaryVK.setSkin(new FXVKSkin(secondaryVK));
                secondaryVK.getStyleClass().setAll((String[])new String[]{"fxvk-secondary"});
                secondaryPopup = new Popup();
                secondaryPopup.setAutoHide(true);
                secondaryPopup.getContent().add(secondaryVK);
            }
            FXVKSkin.secondaryVK.chars = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!this.isSymbol && fXVKSkin$CharKey.letterChars != null && fXVKSkin$CharKey.letterChars.length() > 0) {
                if (this.shiftDown || this.capsDown) {
                    arrayList.add(fXVKSkin$CharKey.letterChars.toUpperCase());
                } else {
                    arrayList.add(fXVKSkin$CharKey.letterChars);
                }
            }
            if (fXVKSkin$CharKey.altChars != null && fXVKSkin$CharKey.altChars.length() > 0) {
                if (this.shiftDown || this.capsDown) {
                    arrayList.add(fXVKSkin$CharKey.altChars.toUpperCase());
                } else {
                    arrayList.add(fXVKSkin$CharKey.altChars);
                }
            }
            if (fXVKSkin$CharKey.moreChars != null && fXVKSkin$CharKey.moreChars.length > 0) {
                if (this.isSymbol) {
                    var4_6 = fXVKSkin$CharKey.moreChars;
                    var5_8 = fXVKSkin$CharKey.moreChars.length;
                    for (var6_10 = 0; var6_10 < var5_8; ++var6_10) {
                        var7_12 = var4_6[var6_10];
                        if (Character.isLetter(var7_12.charAt(0))) continue;
                        arrayList.add(var7_12);
                    }
                } else {
                    var4_6 = fXVKSkin$CharKey.moreChars;
                    var5_8 = fXVKSkin$CharKey.moreChars.length;
                    for (var6_10 = 0; var6_10 < var5_8; ++var6_10) {
                        var7_12 = var4_6[var6_10];
                        if (!Character.isLetter(var7_12.charAt(0))) continue;
                        if (this.shiftDown || this.capsDown) {
                            arrayList.add(var7_12.toUpperCase());
                            continue;
                        }
                        arrayList.add(var7_12);
                    }
                }
            }
            boolean bl2 = false;
            for (String string : arrayList) {
                if (string.length() <= 1) continue;
                bl2 = true;
            }
            ArrayList<String> arrayList2 = arrayList;
            FXVKSkin.secondaryVK.chars = arrayList2.toArray(new String[arrayList2.size()]);
            if (FXVKSkin.secondaryVK.chars.length > 1) {
                if (secondaryVK.getSkin() != null) {
                    ((FXVKSkin)secondaryVK.getSkin()).rebuildSecondaryVK();
                }
                secondaryVK.setAttachedNode(node);
                FXVKSkin cfr_ignored_0 = (FXVKSkin)primaryVK.getSkin();
                FXVKSkin cfr_ignored_1 = (FXVKSkin)secondaryVK.getSkin();
                int n2 = FXVKSkin.secondaryVK.chars.length;
                int n3 = (int)Math.floor(Math.sqrt(Math.max(1, n2 - 2)));
                int n4 = (int)Math.ceil((double)n2 / (double)n3);
                double d2 = this.snappedLeftInset() + this.snappedRightInset() + (double)n4 * 40.0 * (double)(bl2 ? 2 : 1) + (double)((n4 - 1) * 6);
                double d3 = this.snappedTopInset() + this.snappedBottomInset() + (double)n3 * 56.0 + (double)((n3 - 1) * 6);
                secondaryVK.setPrefWidth(d2);
                secondaryVK.setMinWidth(Double.NEGATIVE_INFINITY);
                secondaryVK.setPrefHeight(d3);
                secondaryVK.setMinHeight(Double.NEGATIVE_INFINITY);
                Platform.runLater(() -> {
                    Object object = Utils.pointRelativeTo(fXVKSkin$CharKey, d2, d3, HPos.CENTER, VPos.TOP, 5.0, -3.0, true);
                    double d4 = ((Point2D)object).getX();
                    double d5 = ((Point2D)object).getY();
                    object = fXVKSkin$CharKey.getScene();
                    d4 = Math.min(d4, ((Scene)object).getWindow().getX() + ((Scene)object).getWidth() - d2);
                    secondaryPopup.show(fXVKSkin$CharKey.getScene().getWindow(), d4, d5);
                });
            }
            return;
        }
        this.closeSecondaryVK();
    }

    private List<List<FXVKSkin$Key>> loadBoard(String string) {
        List<List<FXVKSkin$Key>> list = boardMap.get(string);
        if (list != null) {
            return list;
        }
        Object object = string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase() + "Board.txt";
        try {
            String string2;
            list = new ArrayList<List<FXVKSkin$Key>>(5);
            ArrayList<FXVKSkin$Key> arrayList = new ArrayList<FXVKSkin$Key>(20);
            object = FXVKSkin.class.getResourceAsStream((String)object);
            object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = false;
            ArrayList<String> arrayList2 = new ArrayList<String>(10);
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (string2.length() == 0 || string2.charAt(0) == '#') continue;
                for (int i2 = 0; i2 < string2.length(); ++i2) {
                    int n4 = string2.charAt(i2);
                    if (n4 != 32) {
                        if (n4 == 91) {
                            n3 = n2;
                            arrayList2 = new ArrayList(10);
                            bl2 = false;
                            continue;
                        }
                        if (n4 == 93) {
                            String string3 = "";
                            String string4 = null;
                            FXVKSkin$Key fXVKSkin$Key = null;
                            for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                                arrayList2.set(n4, FXVKCharEntities.get((String)arrayList2.get(n4)));
                            }
                            n4 = arrayList2.size();
                            if (n4 > 0) {
                                string3 = (String)arrayList2.get(0);
                                if (n4 > 1) {
                                    string4 = (String)arrayList2.get(1);
                                    if (n4 > 2) {
                                        fXVKSkin$Key = arrayList2.subList(2, n4).toArray(new String[n4 - 2]);
                                    }
                                }
                            }
                            n4 = n2 - n3;
                            if (bl2) {
                                if ("$shift".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$2(this, "", null, "shift");
                                    fXVKSkin$Key.getStyleClass().add("shift");
                                } else if ("$SymbolABC".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$3(this, "!#123", "ABC", "symbol");
                                } else if ("$backspace".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$4(this, "backspace", "\b", KeyCode.BACK_SPACE);
                                    fXVKSkin$Key.getStyleClass().add("backspace");
                                } else if ("$enter".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$KeyCodeKey(this, "enter", "\n", KeyCode.ENTER);
                                    fXVKSkin$Key.getStyleClass().add("enter");
                                } else if ("$tab".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$KeyCodeKey(this, "tab", "\t", KeyCode.TAB);
                                } else if ("$space".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$CharKey(this, " ", " ", null, "space");
                                } else if ("$clear".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$SuperKey(this, "clear", "");
                                } else if ("$.org".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$SuperKey(this, ".org", ".org");
                                } else if ("$.com".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$SuperKey(this, ".com", ".com");
                                } else if ("$.net".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$SuperKey(this, ".net", ".net");
                                } else if ("$oracle.com".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$SuperKey(this, "oracle.com", "oracle.com");
                                } else if ("$gmail.com".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$SuperKey(this, "gmail.com", "gmail.com");
                                } else if ("$hide".equals(string3)) {
                                    fXVKSkin$Key = new FXVKSkin$5(this, "hide", null, "hide");
                                    fXVKSkin$Key.getStyleClass().add("hide");
                                } else {
                                    fXVKSkin$Key = "$undo".equals(string3) ? new FXVKSkin$SuperKey(this, "undo", "") : ("$redo".equals(string3) ? new FXVKSkin$SuperKey(this, "redo", "") : null);
                                }
                            } else {
                                fXVKSkin$Key = new FXVKSkin$CharKey(this, string3, string4, (String[])fXVKSkin$Key);
                            }
                            if (fXVKSkin$Key == null) continue;
                            fXVKSkin$Key.col = n3;
                            fXVKSkin$Key.colSpan = n4;
                            for (String string5 : fXVKSkin$Key.getStyleClass()) {
                                fXVKSkin$Key.text.getStyleClass().add(string5 + "-text");
                                fXVKSkin$Key.altText.getStyleClass().add(string5 + "-alttext");
                                fXVKSkin$Key.icon.getStyleClass().add(string5 + "-icon");
                            }
                            if (string3 != null && string3.length() > 1) {
                                fXVKSkin$Key.text.getStyleClass().add("multi-char-text");
                            }
                            if (string4 != null && string4.length() > 1) {
                                fXVKSkin$Key.altText.getStyleClass().add("multi-char-text");
                            }
                            arrayList.add(fXVKSkin$Key);
                            continue;
                        }
                        for (int i3 = i2; i3 < string2.length(); ++i3) {
                            char c2 = string2.charAt(i3);
                            boolean bl3 = false;
                            if (c2 == '\\') {
                                ++i2;
                                bl3 = true;
                                c2 = string2.charAt(++i3);
                            }
                            if (c2 == '$' && !bl3) {
                                bl2 = true;
                            }
                            if (c2 == '|' && !bl3) {
                                arrayList2.add(string2.substring(i2, i3));
                                i2 = i3 + 1;
                                continue;
                            }
                            if (c2 != ']' && c2 != ' ' || bl3) continue;
                            arrayList2.add(string2.substring(i2, i3));
                            i2 = i3 - 1;
                            break;
                        }
                    }
                    ++n2;
                }
                n2 = 0;
                n3 = 0;
                list.add(arrayList);
                arrayList = new ArrayList(20);
            }
            ((BufferedReader)object).close();
            boardMap.put(string, list);
            return list;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return Collections.emptyList();
        }
    }

    static {
        slideInTimeline = new Timeline();
        slideOutTimeline = new Timeline();
        hideAfterSlideOut = false;
        KEY_REPEAT_DELAY = 400.0;
        KEY_REPEAT_DELAY_MIN = 100.0;
        KEY_REPEAT_DELAY_MAX = 1000.0;
        KEY_REPEAT_RATE = 25.0;
        KEY_REPEAT_RATE_MIN = 2.0;
        KEY_REPEAT_RATE_MAX = 50.0;
        vkAdjustWindow = false;
        vkLookup = false;
        AccessController.doPrivileged(() -> {
            Object object = System.getProperty("com.sun.javafx.vk.adjustwindow");
            if (object != null) {
                vkAdjustWindow = Boolean.valueOf((String)object);
            }
            if ((object = System.getProperty("com.sun.javafx.sqe.vk.lookup")) != null) {
                vkLookup = Boolean.valueOf((String)object);
            }
            if ((object = System.getProperty("com.sun.javafx.virtualKeyboard.backspaceRepeatDelay")) != null) {
                object = Double.valueOf((String)object);
                KEY_REPEAT_DELAY = Math.min(Math.max((Double)object, KEY_REPEAT_DELAY_MIN), KEY_REPEAT_DELAY_MAX);
            }
            if ((object = System.getProperty("com.sun.javafx.virtualKeyboard.backspaceRepeatRate")) != null) {
                Double d2;
                object = Double.valueOf((String)object);
                KEY_REPEAT_RATE = d2 <= 0.0 ? 0.0 : Math.min(Math.max((Double)object, KEY_REPEAT_RATE_MIN), KEY_REPEAT_RATE_MAX);
            }
            return null;
        });
        winY = new SimpleDoubleProperty();
        winY.addListener(observable -> {
            if (vkPopup != null) {
                vkPopup.setY(winY.get());
            }
        });
    }
}

