/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.ContextMenuContent;
import com.sun.javafx.scene.control.behavior.MnemonicInfo;
import com.sun.javafx.scene.control.skin.Utils$1;
import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.tk.Toolkit;
import java.net.URL;
import java.text.Bidi;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.Mnemonic;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;

public class Utils {
    static final Text helper = new Text();
    static final double DEFAULT_WRAPPING_WIDTH = helper.getWrappingWidth();
    static final double DEFAULT_LINE_SPACING = helper.getLineSpacing();
    static final String DEFAULT_TEXT = helper.getText();
    static final TextBoundsType DEFAULT_BOUNDS_TYPE = helper.getBoundsType();
    static final TextLayout layout = Toolkit.getToolkit().getTextLayoutFactory().createLayout();

    public static double getAscent(Font font, TextBoundsType textBoundsType) {
        layout.setContent("", FontHelper.getNativeFont(font));
        layout.setWrapWidth(0.0f);
        layout.setLineSpacing(0.0f);
        if (textBoundsType == TextBoundsType.LOGICAL_VERTICAL_CENTER) {
            layout.setBoundsType(16384);
        } else {
            layout.setBoundsType(0);
        }
        return -layout.getBounds().getMinY();
    }

    public static double getLineHeight(Font font, TextBoundsType textBoundsType) {
        layout.setContent("", FontHelper.getNativeFont(font));
        layout.setWrapWidth(0.0f);
        layout.setLineSpacing(0.0f);
        if (textBoundsType == TextBoundsType.LOGICAL_VERTICAL_CENTER) {
            layout.setBoundsType(16384);
        } else {
            layout.setBoundsType(0);
        }
        return ((BaseBounds)layout.getLines()[0].getBounds()).getHeight();
    }

    public static double computeTextWidth(Font font, String string, double d2) {
        layout.setContent(string != null ? string : "", FontHelper.getNativeFont(font));
        layout.setWrapWidth((float)d2);
        return layout.getBounds().getWidth();
    }

    public static double computeTextHeight(Font font, String string, double d2, TextBoundsType textBoundsType) {
        return Utils.computeTextHeight(font, string, d2, 0.0, textBoundsType);
    }

    public static double computeTextHeight(Font font, String string, double d2, double d3, TextBoundsType textBoundsType) {
        layout.setContent(string != null ? string : "", FontHelper.getNativeFont(font));
        layout.setWrapWidth((float)d2);
        layout.setLineSpacing((float)d3);
        if (textBoundsType == TextBoundsType.LOGICAL_VERTICAL_CENTER) {
            layout.setBoundsType(16384);
        } else {
            layout.setBoundsType(0);
        }
        return layout.getBounds().getHeight();
    }

    public static Point2D computeMnemonicPosition(Font font, String string, int n2, double d2, double d3, boolean bl2) {
        double d4;
        int n3;
        if (font == null || string == null || n2 < 0 || n2 > string.length()) {
            return null;
        }
        layout.setContent(string, FontHelper.getNativeFont(font));
        layout.setWrapWidth((float)d2);
        layout.setLineSpacing((float)d3);
        int n4 = 0;
        int n5 = layout.getLines().length;
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n6 = layout.getLines()[n3].getLength();
            if (n2 >= n4 && n2 < n4 + n6) break;
            n4 += n6;
        }
        double d5 = layout.getBounds().getHeight() / (float)n5;
        double d6 = Utils.computeTextWidth(font, string.substring(n4, n2), 0.0);
        if (bl2) {
            int n7 = n4;
            d4 = Utils.computeTextWidth(font, string.substring(n7, n7 + n6 - 1), 0.0);
            d6 = d4 - d6;
        }
        d4 = d5 * (double)(n3 + 1);
        if (n3 + 1 != n5) {
            d4 -= d3 / 2.0;
        }
        return new Point2D(d6, d4);
    }

    public static int computeTruncationIndex(Font object, String string, double d2) {
        helper.setText(string);
        helper.setFont((Font)object);
        helper.setWrappingWidth(0.0);
        helper.setLineSpacing(0.0);
        object = helper.getLayoutBounds();
        object = new Point2D(d2 - 2.0, ((Bounds)object).getMinY() + ((Bounds)object).getHeight() / 2.0);
        int n2 = helper.hitTest((Point2D)object).getCharIndex();
        helper.setWrappingWidth(DEFAULT_WRAPPING_WIDTH);
        helper.setLineSpacing(DEFAULT_LINE_SPACING);
        helper.setText(DEFAULT_TEXT);
        return n2;
    }

    public static String computeClippedText(Font font, String string, double d2, OverrunStyle object, String string2) {
        char c2;
        double d3;
        if (font == null) {
            throw new IllegalArgumentException("Must specify a font");
        }
        OverrunStyle overrunStyle = object == null || object == OverrunStyle.CLIP ? OverrunStyle.ELLIPSIS : object;
        Object object2 = object = object == OverrunStyle.CLIP ? "" : string2;
        if (string == null || "".equals(string)) {
            return string;
        }
        double d4 = Utils.computeTextWidth(font, string, 0.0);
        if (d3 - d2 < (double)0.001f) {
            return string;
        }
        double d5 = Utils.computeTextWidth(font, (String)object, 0.0);
        double d6 = d2 - d5;
        if (d2 < d5) {
            return "";
        }
        if (overrunStyle == OverrunStyle.ELLIPSIS || overrunStyle == OverrunStyle.WORD_ELLIPSIS || overrunStyle == OverrunStyle.LEADING_ELLIPSIS || overrunStyle == OverrunStyle.LEADING_WORD_ELLIPSIS) {
            String string3;
            int n2;
            boolean bl2;
            boolean bl3 = bl2 = overrunStyle == OverrunStyle.WORD_ELLIPSIS || overrunStyle == OverrunStyle.LEADING_WORD_ELLIPSIS;
            if (overrunStyle == OverrunStyle.ELLIPSIS && !new Bidi(string, 0).isMixed()) {
                int n3 = Utils.computeTruncationIndex(font, string, d2 - d5);
                if (n3 < 0 || n3 >= string.length()) {
                    return string;
                }
                return string.substring(0, n3) + (String)object;
            }
            int n4 = -1;
            int n5 = 0;
            int n6 = overrunStyle == OverrunStyle.LEADING_ELLIPSIS || overrunStyle == OverrunStyle.LEADING_WORD_ELLIPSIS ? string.length() - 1 : 0;
            int n7 = n6 == 0 ? string.length() - 1 : 0;
            int n8 = n2 = n6 == 0 ? 1 : -1;
            char c3 = n6 == 0 ? (n6 > n7 ? (char)'\u0001' : '\u0000') : (n6 < n7 ? (char)'\u0001' : '\u0000');
            int n9 = n6;
            while (c3 == '\u0000') {
                n5 = n9;
                c3 = string.charAt(n5);
                double d7 = Utils.computeTextWidth(font, n6 == 0 ? string.substring(0, n9 + 1) : string.substring(n9, n6 + 1), 0.0);
                if (Character.isWhitespace(c3)) {
                    n4 = n5;
                }
                if (d7 > d6) break;
                c3 = n6 == 0 ? (n9 >= n7 ? (char)'\u0001' : '\u0000') : (n9 <= n7 ? (char)'\u0001' : '\u0000');
                n9 += n2;
            }
            int n10 = n9 = !bl2 || n4 == -1 ? 1 : 0;
            String string4 = n6 == 0 ? string.substring(0, n9 != 0 ? n5 : n4) : (string3 = string.substring((n9 != 0 ? n5 : n4) + 1));
            assert (!string.equals(string3));
            if (overrunStyle == OverrunStyle.ELLIPSIS || overrunStyle == OverrunStyle.WORD_ELLIPSIS) {
                return string3 + (String)object;
            }
            return (String)object + string3;
        }
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        double d8 = 0.0;
        for (int i2 = 0; i2 <= string.length() - 1 && !((d8 += Utils.computeTextWidth(font, "" + (c2 = string.charAt(i2)), 0.0)) > d6); ++i2) {
            int n15;
            n13 = i2;
            if (Character.isWhitespace(c2)) {
                n11 = n13;
            }
            if ((d8 += Utils.computeTextWidth(font, "" + (c2 = string.charAt(n15 = string.length() - 1 - i2)), 0.0)) > d6) break;
            n14 = n15;
            if (!Character.isWhitespace(c2)) continue;
            n12 = n14;
        }
        if (n13 < 0) {
            return object;
        }
        if (overrunStyle == OverrunStyle.CENTER_ELLIPSIS) {
            if (n14 < 0) {
                return string.substring(0, n13 + 1) + (String)object;
            }
            return string.substring(0, n13 + 1) + (String)object + string.substring(n14);
        }
        boolean bl4 = Character.isWhitespace(string.charAt(n13 + 1));
        int n16 = n11 == -1 || bl4 ? n13 + 1 : n11;
        String string5 = string.substring(0, n16);
        if (n14 < 0) {
            return string5 + (String)object;
        }
        c2 = (char)(Character.isWhitespace(string.charAt(n14 - 1)) ? 1 : 0);
        n16 = n12 == -1 || c2 != '\u0000' ? n14 : n12 + 1;
        String string6 = string.substring(n16);
        return string5 + (String)object + string6;
    }

    public static String computeClippedWrappedText(Font font, String string, double d2, double d3, double d4, OverrunStyle overrunStyle, String string2, TextBoundsType object) {
        Point2D point2D;
        int n2;
        if (font == null) {
            throw new IllegalArgumentException("Must specify a font");
        }
        d3 += d4;
        string2 = overrunStyle == OverrunStyle.CLIP ? "" : string2;
        int n3 = string2.length();
        double d5 = Utils.computeTextWidth(font, string2, 0.0);
        double d6 = Utils.computeTextHeight(font, string2, 0.0, d4, (TextBoundsType)((Object)object));
        if (d2 < d5 || d3 < d6) {
            return string;
        }
        helper.setText(string);
        helper.setFont(font);
        helper.setWrappingWidth((int)Math.ceil(d2));
        helper.setBoundsType((TextBoundsType)((Object)object));
        helper.setLineSpacing(d4);
        boolean bl2 = overrunStyle == OverrunStyle.LEADING_ELLIPSIS || overrunStyle == OverrunStyle.LEADING_WORD_ELLIPSIS;
        boolean bl3 = overrunStyle == OverrunStyle.CENTER_ELLIPSIS || overrunStyle == OverrunStyle.CENTER_WORD_ELLIPSIS;
        boolean bl4 = !bl2 && !bl3;
        boolean bl5 = overrunStyle == OverrunStyle.WORD_ELLIPSIS || overrunStyle == OverrunStyle.LEADING_WORD_ELLIPSIS || overrunStyle == OverrunStyle.CENTER_WORD_ELLIPSIS;
        object = string;
        int n4 = object != null ? ((String)object).length() : 0;
        int n5 = -1;
        Point2D point2D2 = null;
        if (bl3) {
            point2D2 = new Point2D((d2 - d5) / 2.0, d3 / 2.0 - ((Node)helper).getBaselineOffset());
        }
        if ((n2 = helper.hitTest(point2D = new Point2D(0.0, d3 - ((Node)helper).getBaselineOffset())).getCharIndex()) >= n4) {
            helper.setBoundsType(TextBoundsType.LOGICAL);
            return string;
        }
        if (bl3) {
            n2 = helper.hitTest(point2D2).getCharIndex();
        }
        if (n2 > 0 && n2 < n4) {
            int n6;
            if (bl3 || bl4) {
                int n7 = n2;
                if (bl3) {
                    if (bl5) {
                        n6 = Utils.lastBreakCharIndex(string, n7 + 1);
                        if (n6 >= 0) {
                            n7 = n6 + 1;
                        } else {
                            n6 = Utils.firstBreakCharIndex(string, n7);
                            if (n6 >= 0) {
                                n7 = n6 + 1;
                            }
                        }
                    }
                    n5 = n7 + n3;
                }
                object = ((String)object).substring(0, n7) + string2;
            }
            if (bl2 || bl3) {
                int n8 = Math.max(0, n4 - n2 - 10);
                if (n8 > 0 && bl5) {
                    n6 = Utils.lastBreakCharIndex(string, n8 + 1);
                    if (n6 >= 0) {
                        n8 = n6 + 1;
                    } else {
                        n6 = Utils.firstBreakCharIndex(string, n8);
                        if (n6 >= 0) {
                            n8 = n6 + 1;
                        }
                    }
                }
                object = bl3 ? (String)object + string.substring(n8) : string2 + string.substring(n8);
            }
            while (true) {
                helper.setText((String)object);
                int n9 = helper.hitTest(point2D).getCharIndex();
                if (bl3 && n9 < n5) {
                    if (n9 > 0 && ((String)object).charAt(n9 - 1) == '\n') {
                        --n9;
                    }
                    object = string.substring(0, n9) + string2;
                    break;
                }
                if (n9 <= 0 || n9 >= ((String)object).length()) break;
                if (bl2) {
                    n6 = n3 + 1;
                    if (bl5 && (n2 = Utils.firstBreakCharIndex((String)object, n6)) >= 0) {
                        n6 = n2 + 1;
                    }
                    object = string2 + ((String)object).substring(n6);
                    continue;
                }
                if (bl3) {
                    n6 = n5 + 1;
                    if (bl5 && (n2 = Utils.firstBreakCharIndex((String)object, n6)) >= 0) {
                        n6 = n2 + 1;
                    }
                    object = ((String)object).substring(0, n5) + ((String)object).substring(n6);
                    continue;
                }
                n6 = ((String)object).length() - n3 - 1;
                if (bl5 && (n2 = Utils.lastBreakCharIndex((String)object, n6)) >= 0) {
                    n6 = n2;
                }
                object = ((String)object).substring(0, n6) + string2;
            }
        }
        helper.setWrappingWidth(DEFAULT_WRAPPING_WIDTH);
        helper.setLineSpacing(DEFAULT_LINE_SPACING);
        helper.setText(DEFAULT_TEXT);
        helper.setBoundsType(DEFAULT_BOUNDS_TYPE);
        return object;
    }

    private static int firstBreakCharIndex(String object, int n2) {
        object = ((String)object).toCharArray();
        while (n2 < ((Object)object).length) {
            if (Utils.isPreferredBreakCharacter((char)object[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static int lastBreakCharIndex(String object, int n2) {
        object = ((String)object).toCharArray();
        while (n2 >= 0) {
            if (Utils.isPreferredBreakCharacter((char)object[n2])) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    private static boolean isPreferredBreakCharacter(char c2) {
        if (Character.isWhitespace(c2)) {
            return true;
        }
        switch (c2) {
            case '.': 
            case ':': 
            case ';': {
                return true;
            }
        }
        return false;
    }

    private static boolean requiresComplexLayout(Font font, String string) {
        return false;
    }

    static int computeStartOfWord(Font font, String string, int n2) {
        if ("".equals(string) || n2 < 0) {
            return 0;
        }
        if (string.length() <= n2) {
            return string.length();
        }
        if (Character.isWhitespace(string.charAt(n2))) {
            return n2;
        }
        int n3 = Utils.requiresComplexLayout(font, string);
        if (n3 != 0) {
            return 0;
        }
        n3 = n2;
        while (--n3 >= 0) {
            if (!Character.isWhitespace(string.charAt(n3))) continue;
            return n3 + 1;
        }
        return 0;
    }

    static int computeEndOfWord(Font font, String string, int n2) {
        if (string.equals("") || n2 < 0) {
            return 0;
        }
        if (string.length() <= n2) {
            return string.length();
        }
        if (Character.isWhitespace(string.charAt(n2))) {
            return n2;
        }
        int n3 = Utils.requiresComplexLayout(font, string);
        if (n3 != 0) {
            return string.length();
        }
        n3 = n2;
        while (++n3 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n3))) continue;
            return n3;
        }
        return string.length();
    }

    public static double boundedSize(double d2, double d3, double d4) {
        return Math.min(Math.max(d2, d3), Math.max(d3, d4));
    }

    public static void addMnemonics(ContextMenu contextMenu, Scene scene) {
        Utils.addMnemonics(contextMenu, scene, false);
    }

    public static void addMnemonics(ContextMenu contextMenu, Scene scene, boolean bl2) {
        Utils.addMnemonics(contextMenu, scene, bl2, null);
    }

    public static void addMnemonics(ContextMenu contextMenu, Scene scene, boolean bl2, List<Mnemonic> list) {
        if (!PlatformUtil.isMac()) {
            ContextMenuContent contextMenuContent = (ContextMenuContent)contextMenu.getSkin().getNode();
            for (int i2 = 0; i2 < contextMenu.getItems().size(); ++i2) {
                int n2;
                Object object = (MenuItem)contextMenu.getItems().get(i2);
                if (!((MenuItem)object).isMnemonicParsing() || (n2 = ((MnemonicInfo)(object = new MnemonicInfo(((MenuItem)object).getText()))).getMnemonicIndex()) < 0) continue;
                object = ((MnemonicInfo)object).getMnemonicKeyCombination();
                object = new Mnemonic(contextMenuContent.getLabelAt(i2), (KeyCombination)object);
                scene.addMnemonic((Mnemonic)object);
                NodeHelper.setShowMnemonics(contextMenuContent.getLabelAt(i2), bl2);
                if (list == null) continue;
                list.add((Mnemonic)object);
            }
        }
    }

    public static void removeMnemonics(ContextMenu contextMenu, Scene scene) {
        if (!PlatformUtil.isMac()) {
            ContextMenuContent contextMenuContent = (ContextMenuContent)contextMenu.getSkin().getNode();
            for (int i2 = 0; i2 < contextMenu.getItems().size(); ++i2) {
                int n2;
                Object object = (MenuItem)contextMenu.getItems().get(i2);
                if (!((MenuItem)object).isMnemonicParsing() || (n2 = ((MnemonicInfo)(object = new MnemonicInfo(((MenuItem)object).getText()))).getMnemonicIndex()) < 0) continue;
                object = ((MnemonicInfo)object).getMnemonicKeyCombination();
                object = (ObservableList)scene.getMnemonics().get(object);
                if (object == null) continue;
                for (n2 = 0; n2 < object.size(); ++n2) {
                    if (((Mnemonic)object.get(n2)).getNode() != contextMenuContent.getLabelAt(i2)) continue;
                    object.remove(n2);
                }
            }
        }
    }

    public static double computeXOffset(double d2, double d3, HPos hPos) {
        if (hPos == null) {
            return 0.0;
        }
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case RIGHT: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    public static double computeYOffset(double d2, double d3, VPos vPos) {
        if (vPos == null) {
            return 0.0;
        }
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case BOTTOM: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    public static boolean isTwoLevelFocus() {
        return Platform.isSupported(ConditionalFeature.TWO_LEVEL_FOCUS);
    }

    public static <T> void executeOnceWhenPropertyIsNonNull(ObservableValue<T> observableValue, Consumer<T> object) {
        if (observableValue == null) {
            return;
        }
        T t2 = observableValue.getValue();
        if (t2 != null) {
            object.accept(t2);
            return;
        }
        object = new Utils$1(observableValue, object);
        observableValue.addListener((InvalidationListener)object);
    }

    public static String formatHexString(Color color) {
        if (color != null) {
            return String.format(null, "#%02x%02x%02x", Math.round(color.getRed() * 255.0), Math.round(color.getGreen() * 255.0), Math.round(color.getBlue() * 255.0));
        }
        return null;
    }

    public static URL getResource(String string) {
        return Utils.class.getResource(string);
    }
}

