/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.paint;

import com.sun.javafx.scene.paint.GradientUtils$Parser$Delimiter;
import com.sun.javafx.scene.paint.GradientUtils$Point;
import java.util.LinkedList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;

public class GradientUtils$Parser {
    private int index;
    private String[] tokens;
    private boolean proportional;
    private boolean proportionalSet = false;

    private String[] splitString(String object, GradientUtils$Parser$Delimiter gradientUtils$Parser$Delimiter, boolean bl2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        object = ((String)object).toCharArray();
        block0: for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            Object object2 = object[i2];
            if (gradientUtils$Parser$Delimiter.isDelimiter((char)object2)) {
                if (!bl2 || stringBuilder.length() > 0) {
                    linkedList.add(stringBuilder.toString());
                }
                stringBuilder.setLength(0);
                continue;
            }
            if (object2 == 40) {
                while (i2 < ((Object)object).length) {
                    stringBuilder.append((char)object[i2]);
                    if (object[i2] == 41) continue block0;
                    ++i2;
                }
                continue;
            }
            stringBuilder.append((char)object[i2]);
        }
        if (!bl2 || stringBuilder.length() > 0) {
            linkedList.add(stringBuilder.toString());
        }
        LinkedList<String> linkedList2 = linkedList;
        return linkedList2.toArray(new String[linkedList2.size()]);
    }

    public GradientUtils$Parser(String string) {
        this.tokens = this.splitString(string, c2 -> c2 == ',', false);
        this.index = 0;
    }

    public int getSize() {
        return this.tokens.length;
    }

    public void shift() {
        ++this.index;
    }

    public String getCurrentToken() {
        String string = this.tokens[this.index].trim();
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Invalid gradient specification: found empty token.");
        }
        return string;
    }

    public String[] splitCurrentToken() {
        return this.getCurrentToken().split("\\s");
    }

    public static void checkNumberOfArguments(String[] stringArray, int n2) {
        if (stringArray.length < n2 + 1) {
            throw new IllegalArgumentException("Invalid gradient specification: parameter '" + stringArray[0] + "' needs " + n2 + " argument(s).");
        }
    }

    public static double parseAngle(String string) {
        double d2;
        if (string.endsWith("deg")) {
            string = string.substring(0, string.length() - 3);
            d2 = Double.parseDouble(string);
        } else if (string.endsWith("grad")) {
            string = string.substring(0, string.length() - 4);
            d2 = Double.parseDouble(string);
            d2 = d2 * 9.0 / 10.0;
        } else if (string.endsWith("rad")) {
            string = string.substring(0, string.length() - 3);
            d2 = Double.parseDouble(string);
            d2 = d2 * 180.0 / Math.PI;
        } else if (string.endsWith("turn")) {
            string = string.substring(0, string.length() - 4);
            d2 = Double.parseDouble(string);
            d2 *= 360.0;
        } else {
            throw new IllegalArgumentException("Invalid gradient specification:angle must end in deg, rad, grad, or turn");
        }
        return d2;
    }

    public static double parsePercentage(String string) {
        if (!string.endsWith("%")) {
            throw new IllegalArgumentException("Invalid gradient specification: focus-distance must be specified as percentage");
        }
        string = string.substring(0, string.length() - 1);
        double d2 = Double.parseDouble(string) / 100.0;
        return d2;
    }

    public GradientUtils$Point parsePoint(String string) {
        GradientUtils$Point gradientUtils$Point = new GradientUtils$Point();
        if (string.endsWith("%")) {
            gradientUtils$Point.proportional = true;
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("px")) {
            string = string.substring(0, string.length() - 2);
        }
        gradientUtils$Point.value = Double.parseDouble(string);
        if (gradientUtils$Point.proportional) {
            gradientUtils$Point.value /= 100.0;
        }
        if (this.proportionalSet && this.proportional != gradientUtils$Point.proportional) {
            throw new IllegalArgumentException("Invalid gradient specification:cannot mix proportional and non-proportional values");
        }
        this.proportionalSet = true;
        this.proportional = gradientUtils$Point.proportional;
        return gradientUtils$Point;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Stop[] parseStops(boolean n2, double d2) {
        int n3;
        int n4;
        double d3;
        int n5 = this.tokens.length - this.index;
        Color[] colorArray = new Color[n5];
        double[] dArray = new double[n5];
        Stop[] stopArray = new Stop[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            String string = this.tokens[i2 + this.index].trim();
            String[] stringArray = this.splitString(string, c2 -> Character.isWhitespace(c2), true);
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("Invalid gradient specification, empty stop found");
            }
            string = stringArray[0];
            d3 = -1.0;
            Color color = Color.web(string);
            if (stringArray.length == 2) {
                String string2 = stringArray[1];
                if (string2.endsWith("%")) {
                    string2 = string2.substring(0, string2.length() - 1);
                    d3 = Double.parseDouble(string2) / 100.0;
                } else {
                    if (n2 != 0) throw new IllegalArgumentException("Invalid gradient specification, non-proportional stops not permited in proportional gradient: " + string2);
                    if (string2.endsWith("px")) {
                        string2 = string2.substring(0, string2.length() - 2);
                    }
                    d3 = Double.parseDouble(string2) / d2;
                }
            } else if (stringArray.length > 2) {
                throw new IllegalArgumentException("Invalid gradient specification, unexpected content in stop specification: " + stringArray[2]);
            }
            colorArray[i2] = color;
            dArray[i2] = d3;
        }
        if (dArray[0] < 0.0) {
            dArray[0] = 0.0;
        }
        if (dArray[dArray.length - 1] < 0.0) {
            dArray[dArray.length - 1] = 1.0;
        }
        double d4 = dArray[0];
        for (n4 = 1; n4 < dArray.length; ++n4) {
            if (dArray[n4] < d4 && dArray[n4] > 0.0) {
                dArray[n4] = d4;
                continue;
            }
            d4 = dArray[n4];
        }
        n4 = -1;
        for (n3 = 1; n3 < dArray.length; ++n3) {
            double d5;
            d3 = dArray[n3];
            if (d5 < 0.0 && n4 < 0) {
                n4 = n3;
                continue;
            }
            if (!(d3 >= 0.0) || n4 <= 0) continue;
            int n6 = n3 - n4 + 1;
            double d6 = (dArray[n3] - dArray[n4 - 1]) / (double)n6;
            for (n2 = 0; n2 < n6 - 1; ++n2) {
                dArray[n4 + n2] = dArray[n4 - 1] + d6 * (double)(n2 + 1);
            }
        }
        for (n3 = 0; n3 < stopArray.length; ++n3) {
            Stop stop;
            stopArray[n3] = stop = new Stop(dArray[n3], colorArray[n3]);
        }
        return stopArray;
    }
}

