/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.Hueristic2D$TargetNode;
import com.sun.javafx.scene.traversal.TabOrderHelper;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.util.Stack;
import java.util.function.Function;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;

public class Hueristic2D
implements Algorithm {
    protected Node cacheStartTraversalNode = null;
    protected Direction cacheStartTraversalDirection = null;
    protected boolean reverseDirection = false;
    protected Node cacheLastTraversalNode = null;
    protected Stack<Node> traversalNodeStack = new Stack();
    private static final Function<Bounds, Double> BOUNDS_TOP_SIDE = bounds -> bounds.getMinY();
    private static final Function<Bounds, Double> BOUNDS_BOTTOM_SIDE = bounds -> bounds.getMaxY();
    private static final Function<Bounds, Double> BOUNDS_LEFT_SIDE = bounds -> bounds.getMinX();
    private static final Function<Bounds, Double> BOUNDS_RIGHT_SIDE = bounds -> bounds.getMaxX();

    Hueristic2D() {
    }

    @Override
    public Node select(Node node, Direction direction, TraversalContext traversalContext) {
        Node node2 = null;
        this.cacheTraversal(node, direction);
        if (Direction.NEXT.equals((Object)direction) || Direction.NEXT_IN_LINE.equals((Object)direction)) {
            node2 = TabOrderHelper.findNextFocusablePeer(node, traversalContext.getRoot(), direction == Direction.NEXT);
        } else if (Direction.PREVIOUS.equals((Object)direction)) {
            node2 = TabOrderHelper.findPreviousFocusablePeer(node, traversalContext.getRoot());
        } else if (Direction.UP.equals((Object)direction) || Direction.DOWN.equals((Object)direction) || Direction.LEFT.equals((Object)direction) || Direction.RIGHT.equals((Object)direction)) {
            if (this.reverseDirection && !this.traversalNodeStack.empty()) {
                if (!this.traversalNodeStack.peek().isFocusTraversable()) {
                    this.traversalNodeStack.clear();
                } else {
                    node2 = this.traversalNodeStack.pop();
                }
            }
            if (node2 == null) {
                Node node3 = node;
                Bounds bounds = node3.localToScene(node3.getLayoutBounds());
                if (this.cacheStartTraversalNode != null) {
                    Bounds bounds2 = this.cacheStartTraversalNode.localToScene(this.cacheStartTraversalNode.getLayoutBounds());
                    switch (direction) {
                        case UP: 
                        case DOWN: {
                            node2 = this.getNearestNodeUpOrDown(bounds, bounds2, traversalContext, direction);
                            break;
                        }
                        case LEFT: 
                        case RIGHT: {
                            node2 = this.getNearestNodeLeftOrRight(bounds, bounds2, traversalContext, direction);
                        }
                    }
                }
            }
        }
        if (node2 != null) {
            this.cacheLastTraversalNode = node2;
            if (!this.reverseDirection) {
                this.traversalNodeStack.push(node);
            }
        }
        return node2;
    }

    @Override
    public Node selectFirst(TraversalContext traversalContext) {
        return TabOrderHelper.getFirstTargetNode(traversalContext.getRoot());
    }

    @Override
    public Node selectLast(TraversalContext traversalContext) {
        return TabOrderHelper.getLastTargetNode(traversalContext.getRoot());
    }

    private boolean isOnAxis(Direction direction, Bounds bounds, Bounds bounds2) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d5 = bounds.getMinX();
            d4 = bounds.getMaxX();
            d3 = bounds2.getMinX();
            d2 = bounds2.getMaxX();
        } else {
            d5 = bounds.getMinY();
            d4 = bounds.getMaxY();
            d3 = bounds2.getMinY();
            d2 = bounds2.getMaxY();
        }
        return d3 <= d4 && d2 >= d5;
    }

    private double outDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d2 = direction == Direction.UP ? bounds.getMinY() - bounds2.getMaxY() : (direction == Direction.DOWN ? bounds2.getMinY() - bounds.getMaxY() : (direction == Direction.LEFT ? bounds.getMinX() - bounds2.getMaxX() : bounds2.getMinX() - bounds.getMaxX()));
        return d2;
    }

    private double centerSideDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d2;
        double d3;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d3 = bounds.getMinX() + bounds.getWidth() / 2.0;
            d2 = bounds2.getMinX() + bounds2.getWidth() / 2.0;
        } else {
            d3 = bounds.getMinY() + bounds.getHeight() / 2.0;
            d2 = bounds2.getMinY() + bounds2.getHeight() / 2.0;
        }
        return Math.abs(d2 - d3);
    }

    private double cornerSideDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d2 = direction == Direction.UP || direction == Direction.DOWN ? (bounds2.getMinX() > bounds.getMaxX() ? bounds2.getMinX() - bounds.getMaxX() : bounds.getMinX() - bounds2.getMaxX()) : (bounds2.getMinY() > bounds.getMaxY() ? bounds2.getMinY() - bounds.getMaxY() : bounds.getMinY() - bounds2.getMaxY());
        return d2;
    }

    private void cacheTraversal(Node node, Direction direction) {
        if (!this.traversalNodeStack.empty() && node != this.cacheLastTraversalNode) {
            this.traversalNodeStack.clear();
        }
        if (direction == Direction.NEXT || direction == Direction.PREVIOUS) {
            this.traversalNodeStack.clear();
        } else if (this.cacheStartTraversalNode == null || direction != this.cacheStartTraversalDirection) {
            if (direction == Direction.UP && this.cacheStartTraversalDirection == Direction.DOWN || direction == Direction.DOWN && this.cacheStartTraversalDirection == Direction.UP || direction == Direction.LEFT && this.cacheStartTraversalDirection == Direction.RIGHT || direction == Direction.RIGHT && this.cacheStartTraversalDirection == Direction.LEFT && !this.traversalNodeStack.empty()) {
                this.reverseDirection = true;
                return;
            }
            this.cacheStartTraversalNode = node;
            this.cacheStartTraversalDirection = direction;
            this.reverseDirection = false;
            this.traversalNodeStack.clear();
            return;
        }
        this.reverseDirection = false;
    }

    protected Node getNearestNodeUpOrDown(Bounds bounds, Bounds bounds2, TraversalContext object, Direction direction) {
        object = object.getAllTargetNodes();
        Object object2 = direction == Direction.DOWN ? BOUNDS_BOTTOM_SIDE : BOUNDS_TOP_SIDE;
        Function<Bounds, Double> function = direction == Direction.DOWN ? BOUNDS_TOP_SIDE : BOUNDS_BOTTOM_SIDE;
        BoundingBox boundingBox = new BoundingBox(bounds2.getMinX(), bounds.getMinY(), bounds2.getWidth(), bounds.getHeight());
        Point2D point2D = new Point2D(bounds.getMinX() + bounds.getWidth() / 2.0, object2.apply((Bounds)bounds));
        Point2D point2D2 = new Point2D(bounds2.getMinX() + bounds2.getWidth() / 2.0, object2.apply((Bounds)bounds));
        Point2D point2D3 = new Point2D(bounds.getMinX(), object2.apply((Bounds)bounds));
        Point2D point2D4 = new Point2D(bounds2.getMinX(), object2.apply((Bounds)bounds));
        Point2D point2D5 = new Point2D(bounds.getMaxX(), object2.apply((Bounds)bounds));
        Point2D point2D6 = new Point2D(bounds2.getMaxX(), object2.apply((Bounds)bounds));
        object2 = new Point2D(bounds2.getMinX(), object2.apply((Bounds)bounds2));
        Hueristic2D$TargetNode hueristic2D$TargetNode = new Hueristic2D$TargetNode();
        Hueristic2D$TargetNode hueristic2D$TargetNode2 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode3 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode4 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode5 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode6 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode7 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode8 = null;
        for (int i2 = 0; i2 < object.size(); ++i2) {
            double d2;
            double d3;
            Node node = (Node)object.get(i2);
            Bounds bounds3 = node.localToScene(node.getLayoutBounds());
            if (!(direction == Direction.UP ? bounds.getMinY() > bounds3.getMaxY() : bounds.getMaxY() < bounds3.getMinY())) continue;
            hueristic2D$TargetNode.node = node;
            hueristic2D$TargetNode.bounds = bounds3;
            double d4 = Math.max(0.0, this.outDistance(direction, boundingBox, bounds3));
            if (this.isOnAxis(direction, boundingBox, bounds3)) {
                hueristic2D$TargetNode.biased2DMetric = d4 + this.centerSideDistance(direction, boundingBox, bounds3) / 100.0;
            } else {
                d3 = this.cornerSideDistance(direction, boundingBox, bounds3);
                double d5 = d4;
                hueristic2D$TargetNode.biased2DMetric = 100000.0 + d5 * d5 + d3 * 9.0 * d3;
            }
            d3 = Math.max(0.0, this.outDistance(direction, bounds, bounds3));
            if (this.isOnAxis(direction, bounds, bounds3)) {
                hueristic2D$TargetNode.current2DMetric = d3 + this.centerSideDistance(direction, bounds, bounds3) / 100.0;
            } else {
                d2 = this.cornerSideDistance(direction, bounds, bounds3);
                double d6 = d3;
                hueristic2D$TargetNode.current2DMetric = 100000.0 + d6 * d6 + d2 * 9.0 * d2;
            }
            hueristic2D$TargetNode.leftCornerDistance = point2D3.distance(bounds3.getMinX(), function.apply(bounds3));
            hueristic2D$TargetNode.rightCornerDistance = point2D5.distance(bounds3.getMaxX(), function.apply(bounds3));
            d2 = point2D.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function.apply(bounds3));
            double d7 = point2D3.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function.apply(bounds3));
            double d8 = point2D3.distance(bounds3.getMaxX(), function.apply(bounds3));
            double d9 = point2D5.distance(bounds3.getMinX(), function.apply(bounds3));
            double d10 = point2D5.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function.apply(bounds3));
            double d11 = point2D5.distance(bounds3.getMaxX(), function.apply(bounds3));
            double d12 = point2D.distance(bounds3.getMinX(), function.apply(bounds3));
            double d13 = point2D.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function.apply(bounds3));
            double d14 = point2D.distance(bounds3.getMaxX(), function.apply(bounds3));
            double d15 = point2D4.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function.apply(bounds3));
            double d16 = point2D4.distance(bounds3.getMaxX(), function.apply(bounds3));
            double d17 = point2D6.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function.apply(bounds3));
            double d18 = point2D2.distance(bounds3.getMaxX(), function.apply(bounds3));
            hueristic2D$TargetNode.averageDistance = (hueristic2D$TargetNode.leftCornerDistance + d15 + d16 + d9 + hueristic2D$TargetNode.rightCornerDistance + d17 + d2) / 7.0;
            hueristic2D$TargetNode.biasShortestDistance = Hueristic2D.findMin(hueristic2D$TargetNode.leftCornerDistance, d15, d16, d9, d17, hueristic2D$TargetNode.rightCornerDistance, d12, d2, d18);
            hueristic2D$TargetNode.shortestDistance = Hueristic2D.findMin(hueristic2D$TargetNode.leftCornerDistance, d7, d8, d9, d10, d11, d12, d13, d14);
            if (d4 >= 0.0 && (hueristic2D$TargetNode3 == null || hueristic2D$TargetNode.biased2DMetric < hueristic2D$TargetNode3.biased2DMetric)) {
                if (hueristic2D$TargetNode3 == null) {
                    hueristic2D$TargetNode3 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode3.copy(hueristic2D$TargetNode);
            }
            if (d3 >= 0.0 && (hueristic2D$TargetNode2 == null || hueristic2D$TargetNode.current2DMetric < hueristic2D$TargetNode2.current2DMetric)) {
                if (hueristic2D$TargetNode2 == null) {
                    hueristic2D$TargetNode2 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode2.copy(hueristic2D$TargetNode);
            }
            if (bounds2.getMaxX() > bounds3.getMinX() && bounds3.getMaxX() > bounds2.getMinX() && (hueristic2D$TargetNode5 == null || hueristic2D$TargetNode5.biasShortestDistance > hueristic2D$TargetNode.biasShortestDistance)) {
                if (hueristic2D$TargetNode5 == null) {
                    hueristic2D$TargetNode5 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode5.copy(hueristic2D$TargetNode);
            }
            if (bounds.getMaxX() > bounds3.getMinX() && bounds3.getMaxX() > bounds.getMinX() && (hueristic2D$TargetNode6 == null || hueristic2D$TargetNode6.biasShortestDistance > hueristic2D$TargetNode.biasShortestDistance)) {
                if (hueristic2D$TargetNode6 == null) {
                    hueristic2D$TargetNode6 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode6.copy(hueristic2D$TargetNode);
            }
            if ((hueristic2D$TargetNode7 == null || hueristic2D$TargetNode7.leftCornerDistance > hueristic2D$TargetNode.leftCornerDistance) && (bounds2.getMinX() >= bounds.getMinX() && bounds3.getMinX() >= bounds.getMinX() || bounds2.getMinX() <= bounds.getMinX() && bounds3.getMinX() <= bounds.getMinX())) {
                if (hueristic2D$TargetNode7 == null) {
                    hueristic2D$TargetNode7 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode7.copy(hueristic2D$TargetNode);
            }
            if ((hueristic2D$TargetNode4 == null || hueristic2D$TargetNode4.averageDistance > hueristic2D$TargetNode.averageDistance) && (bounds2.getMinX() >= bounds.getMinX() && bounds3.getMinX() >= bounds.getMinX() || bounds2.getMinX() <= bounds.getMinX() && bounds3.getMinX() <= bounds.getMinX())) {
                if (hueristic2D$TargetNode4 == null) {
                    hueristic2D$TargetNode4 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode4.copy(hueristic2D$TargetNode);
            }
            if (hueristic2D$TargetNode8 != null && !(hueristic2D$TargetNode8.shortestDistance > hueristic2D$TargetNode.shortestDistance)) continue;
            if (hueristic2D$TargetNode8 == null) {
                hueristic2D$TargetNode8 = new Hueristic2D$TargetNode();
            }
            hueristic2D$TargetNode8.copy(hueristic2D$TargetNode);
        }
        object.clear();
        if (hueristic2D$TargetNode5 != null) {
            hueristic2D$TargetNode5.originLeftCornerDistance = ((Point2D)object2).distance(hueristic2D$TargetNode5.bounds.getMinX(), function.apply(hueristic2D$TargetNode5.bounds));
        }
        if (hueristic2D$TargetNode6 != null) {
            hueristic2D$TargetNode6.originLeftCornerDistance = ((Point2D)object2).distance(hueristic2D$TargetNode6.bounds.getMinX(), function.apply(hueristic2D$TargetNode6.bounds));
        }
        if (hueristic2D$TargetNode4 != null) {
            hueristic2D$TargetNode4.originLeftCornerDistance = ((Point2D)object2).distance(hueristic2D$TargetNode4.bounds.getMinX(), function.apply(hueristic2D$TargetNode4.bounds));
        }
        if (hueristic2D$TargetNode5 != null) {
            if (hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode6.node && (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode4.node || hueristic2D$TargetNode3 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode3.node || hueristic2D$TargetNode7 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode7.node || hueristic2D$TargetNode8 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode8.node)) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode4.node) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode6 != null) {
                if (hueristic2D$TargetNode6.leftCornerDistance < hueristic2D$TargetNode5.leftCornerDistance && hueristic2D$TargetNode6.originLeftCornerDistance < hueristic2D$TargetNode5.originLeftCornerDistance && hueristic2D$TargetNode6.bounds.getMinX() - point2D3.getX() < hueristic2D$TargetNode5.bounds.getMinX() - point2D3.getX()) {
                    return hueristic2D$TargetNode6.node;
                }
                if (hueristic2D$TargetNode4 == null || hueristic2D$TargetNode5.averageDistance < hueristic2D$TargetNode4.averageDistance) {
                    return hueristic2D$TargetNode5.node;
                }
            }
        } else {
            if (hueristic2D$TargetNode6 == null && hueristic2D$TargetNode2 != null) {
                if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode4.node == hueristic2D$TargetNode7.node && hueristic2D$TargetNode4.node == hueristic2D$TargetNode8.node) {
                    return hueristic2D$TargetNode4.node;
                }
                return hueristic2D$TargetNode2.node;
            }
            if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode8 != null && hueristic2D$TargetNode4.biasShortestDistance == hueristic2D$TargetNode7.biasShortestDistance && hueristic2D$TargetNode4.biasShortestDistance == hueristic2D$TargetNode8.biasShortestDistance && hueristic2D$TargetNode4.biasShortestDistance < Double.MAX_VALUE) {
                return hueristic2D$TargetNode4.node;
            }
        }
        if (hueristic2D$TargetNode4 != null && (hueristic2D$TargetNode5 == null || hueristic2D$TargetNode4.biasShortestDistance < hueristic2D$TargetNode5.biasShortestDistance)) {
            if (hueristic2D$TargetNode5 != null && function.apply(hueristic2D$TargetNode5.bounds) >= function.apply(hueristic2D$TargetNode4.bounds)) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode3 != null) {
                if (hueristic2D$TargetNode3.current2DMetric <= hueristic2D$TargetNode4.current2DMetric) {
                    return hueristic2D$TargetNode3.node;
                }
                if (function.apply(hueristic2D$TargetNode3.bounds) >= function.apply(hueristic2D$TargetNode4.bounds)) {
                    return hueristic2D$TargetNode3.node;
                }
            }
            return hueristic2D$TargetNode4.node;
        }
        if (hueristic2D$TargetNode2 != null && hueristic2D$TargetNode6 != null && hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode8 != null && hueristic2D$TargetNode2.node == hueristic2D$TargetNode6.node && hueristic2D$TargetNode2.node == hueristic2D$TargetNode4.node && hueristic2D$TargetNode2.node == hueristic2D$TargetNode7.node && hueristic2D$TargetNode2.node == hueristic2D$TargetNode8.node) {
            return hueristic2D$TargetNode2.node;
        }
        if (hueristic2D$TargetNode5 != null && (hueristic2D$TargetNode6 == null || hueristic2D$TargetNode5.rightCornerDistance < hueristic2D$TargetNode6.rightCornerDistance)) {
            return hueristic2D$TargetNode5.node;
        }
        if (hueristic2D$TargetNode5 != null) {
            return hueristic2D$TargetNode5.node;
        }
        if (hueristic2D$TargetNode3 != null) {
            return hueristic2D$TargetNode3.node;
        }
        if (hueristic2D$TargetNode6 != null) {
            return hueristic2D$TargetNode6.node;
        }
        if (hueristic2D$TargetNode4 != null) {
            return hueristic2D$TargetNode4.node;
        }
        if (hueristic2D$TargetNode7 != null) {
            return hueristic2D$TargetNode7.node;
        }
        if (hueristic2D$TargetNode8 != null) {
            return hueristic2D$TargetNode8.node;
        }
        return null;
    }

    protected Node getNearestNodeLeftOrRight(Bounds bounds, Bounds bounds2, TraversalContext object, Direction direction) {
        object = object.getAllTargetNodes();
        Object object2 = direction == Direction.LEFT ? BOUNDS_LEFT_SIDE : BOUNDS_RIGHT_SIDE;
        Function<Bounds, Double> function = direction == Direction.LEFT ? BOUNDS_RIGHT_SIDE : BOUNDS_LEFT_SIDE;
        BoundingBox boundingBox = new BoundingBox(bounds.getMinX(), bounds2.getMinY(), bounds.getWidth(), bounds2.getHeight());
        Point2D point2D = new Point2D(object2.apply((Bounds)bounds), bounds.getMinY() + bounds.getHeight() / 2.0);
        Point2D point2D2 = new Point2D(object2.apply((Bounds)bounds), bounds2.getMinY() + bounds2.getHeight() / 2.0);
        Point2D point2D3 = new Point2D(object2.apply((Bounds)bounds), bounds.getMinY());
        Point2D point2D4 = new Point2D(object2.apply((Bounds)bounds), bounds2.getMinY());
        Point2D point2D5 = new Point2D(object2.apply((Bounds)bounds), bounds.getMaxY());
        Point2D point2D6 = new Point2D(object2.apply((Bounds)bounds), bounds2.getMaxY());
        object2 = new Point2D(object2.apply((Bounds)bounds2), bounds2.getMinY());
        Hueristic2D$TargetNode hueristic2D$TargetNode = new Hueristic2D$TargetNode();
        Hueristic2D$TargetNode hueristic2D$TargetNode2 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode3 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode4 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode5 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode6 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode7 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode8 = null;
        for (int i2 = 0; i2 < object.size(); ++i2) {
            double d2;
            double d3;
            Node node = (Node)object.get(i2);
            Bounds bounds3 = node.localToScene(node.getLayoutBounds());
            if (!(direction == Direction.LEFT ? bounds.getMinX() > bounds3.getMinX() : bounds.getMaxX() < bounds3.getMaxX())) continue;
            hueristic2D$TargetNode.node = node;
            hueristic2D$TargetNode.bounds = bounds3;
            double d4 = Math.max(0.0, this.outDistance(direction, boundingBox, bounds3));
            if (this.isOnAxis(direction, boundingBox, bounds3)) {
                hueristic2D$TargetNode.biased2DMetric = d4 + this.centerSideDistance(direction, boundingBox, bounds3) / 100.0;
            } else {
                d3 = this.cornerSideDistance(direction, boundingBox, bounds3);
                double d5 = d4;
                hueristic2D$TargetNode.biased2DMetric = 100000.0 + d5 * d5 + d3 * 9.0 * d3;
            }
            d3 = Math.max(0.0, this.outDistance(direction, bounds, bounds3));
            if (this.isOnAxis(direction, bounds, bounds3)) {
                hueristic2D$TargetNode.current2DMetric = d3 + this.centerSideDistance(direction, bounds, bounds3) / 100.0;
            } else {
                d2 = this.cornerSideDistance(direction, bounds, bounds3);
                double d6 = d3;
                hueristic2D$TargetNode.current2DMetric = 100000.0 + d6 * d6 + d2 * 9.0 * d2;
            }
            hueristic2D$TargetNode.topCornerDistance = point2D3.distance(function.apply(bounds3), bounds3.getMinY());
            hueristic2D$TargetNode.bottomCornerDistance = point2D5.distance(function.apply(bounds3), bounds3.getMaxY());
            d2 = point2D.distance(function.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d7 = point2D3.distance(function.apply(bounds3), bounds3.getMaxY());
            double d8 = point2D3.distance(function.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d9 = point2D5.distance(function.apply(bounds3), bounds3.getMinY());
            double d10 = point2D5.distance(function.apply(bounds3), bounds3.getMaxY());
            double d11 = point2D5.distance(function.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d12 = point2D.distance(function.apply(bounds3), bounds3.getMinY());
            double d13 = point2D.distance(function.apply(bounds3), bounds3.getMaxY());
            double d14 = point2D.distance(function.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d15 = point2D4.distance(function.apply(bounds3), bounds3.getMaxY());
            double d16 = point2D4.distance(function.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d17 = point2D6.distance(function.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d18 = point2D2.distance(function.apply(bounds3), bounds3.getMaxY());
            hueristic2D$TargetNode.averageDistance = (hueristic2D$TargetNode.topCornerDistance + d15 + d16 + d9 + hueristic2D$TargetNode.bottomCornerDistance + d17 + d2) / 7.0;
            hueristic2D$TargetNode.biasShortestDistance = Hueristic2D.findMin(hueristic2D$TargetNode.topCornerDistance, d15, d16, d9, hueristic2D$TargetNode.bottomCornerDistance, d17, d12, d18, d2);
            hueristic2D$TargetNode.shortestDistance = Hueristic2D.findMin(hueristic2D$TargetNode.topCornerDistance, d7, d8, d9, d10, d11, d12, d13, d14);
            if (d4 >= 0.0 && (hueristic2D$TargetNode3 == null || hueristic2D$TargetNode.biased2DMetric < hueristic2D$TargetNode3.biased2DMetric)) {
                if (hueristic2D$TargetNode3 == null) {
                    hueristic2D$TargetNode3 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode3.copy(hueristic2D$TargetNode);
            }
            if (d3 >= 0.0 && (hueristic2D$TargetNode2 == null || hueristic2D$TargetNode.current2DMetric < hueristic2D$TargetNode2.current2DMetric)) {
                if (hueristic2D$TargetNode2 == null) {
                    hueristic2D$TargetNode2 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode2.copy(hueristic2D$TargetNode);
            }
            if (bounds2.getMaxY() > bounds3.getMinY() && bounds3.getMaxY() > bounds2.getMinY() && (hueristic2D$TargetNode5 == null || hueristic2D$TargetNode5.topCornerDistance > hueristic2D$TargetNode.topCornerDistance)) {
                if (hueristic2D$TargetNode5 == null) {
                    hueristic2D$TargetNode5 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode5.copy(hueristic2D$TargetNode);
            }
            if (bounds.getMaxY() > bounds3.getMinY() && bounds3.getMaxY() > bounds.getMinY() && (hueristic2D$TargetNode6 == null || hueristic2D$TargetNode6.topCornerDistance > hueristic2D$TargetNode.topCornerDistance)) {
                if (hueristic2D$TargetNode6 == null) {
                    hueristic2D$TargetNode6 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode6.copy(hueristic2D$TargetNode);
            }
            if (hueristic2D$TargetNode7 == null || hueristic2D$TargetNode7.topCornerDistance > hueristic2D$TargetNode.topCornerDistance) {
                if (hueristic2D$TargetNode7 == null) {
                    hueristic2D$TargetNode7 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode7.copy(hueristic2D$TargetNode);
            }
            if (hueristic2D$TargetNode4 == null || hueristic2D$TargetNode4.averageDistance > hueristic2D$TargetNode.averageDistance) {
                if (hueristic2D$TargetNode4 == null) {
                    hueristic2D$TargetNode4 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode4.copy(hueristic2D$TargetNode);
            }
            if (hueristic2D$TargetNode8 != null && !(hueristic2D$TargetNode8.shortestDistance > hueristic2D$TargetNode.shortestDistance)) continue;
            if (hueristic2D$TargetNode8 == null) {
                hueristic2D$TargetNode8 = new Hueristic2D$TargetNode();
            }
            hueristic2D$TargetNode8.copy(hueristic2D$TargetNode);
        }
        object.clear();
        if (hueristic2D$TargetNode5 != null) {
            hueristic2D$TargetNode5.originTopCornerDistance = ((Point2D)object2).distance(function.apply(hueristic2D$TargetNode5.bounds), hueristic2D$TargetNode5.bounds.getMinY());
        }
        if (hueristic2D$TargetNode6 != null) {
            hueristic2D$TargetNode6.originTopCornerDistance = ((Point2D)object2).distance(function.apply(hueristic2D$TargetNode6.bounds), hueristic2D$TargetNode6.bounds.getMinY());
        }
        if (hueristic2D$TargetNode4 != null) {
            hueristic2D$TargetNode4.originTopCornerDistance = ((Point2D)object2).distance(function.apply(hueristic2D$TargetNode4.bounds), hueristic2D$TargetNode4.bounds.getMinY());
        }
        if (hueristic2D$TargetNode6 == null && hueristic2D$TargetNode5 == null) {
            this.cacheStartTraversalNode = null;
            this.cacheStartTraversalDirection = null;
            this.reverseDirection = false;
            this.traversalNodeStack.clear();
        }
        if (hueristic2D$TargetNode5 != null) {
            if (hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode6.node && (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode4.node || hueristic2D$TargetNode7 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode7.node || hueristic2D$TargetNode8 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode8.node)) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode4.node) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode6 != null) {
                if (hueristic2D$TargetNode6.bottomCornerDistance < hueristic2D$TargetNode5.bottomCornerDistance && hueristic2D$TargetNode6.originTopCornerDistance < hueristic2D$TargetNode5.originTopCornerDistance && hueristic2D$TargetNode6.bounds.getMinY() - point2D3.getY() < hueristic2D$TargetNode5.bounds.getMinY() - point2D3.getY()) {
                    return hueristic2D$TargetNode6.node;
                }
                if (hueristic2D$TargetNode4 == null || hueristic2D$TargetNode5.averageDistance < hueristic2D$TargetNode4.averageDistance) {
                    return hueristic2D$TargetNode5.node;
                }
            }
        } else {
            if (hueristic2D$TargetNode6 == null && hueristic2D$TargetNode2 != null) {
                if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode4.node == hueristic2D$TargetNode7.node && hueristic2D$TargetNode4.node == hueristic2D$TargetNode8.node) {
                    return hueristic2D$TargetNode4.node;
                }
                return hueristic2D$TargetNode2.node;
            }
            if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode8 != null && hueristic2D$TargetNode4.biasShortestDistance == hueristic2D$TargetNode7.biasShortestDistance && hueristic2D$TargetNode4.biasShortestDistance == hueristic2D$TargetNode8.biasShortestDistance && hueristic2D$TargetNode4.biasShortestDistance < Double.MAX_VALUE) {
                return hueristic2D$TargetNode4.node;
            }
        }
        if (hueristic2D$TargetNode4 != null && (hueristic2D$TargetNode5 == null || hueristic2D$TargetNode4.biasShortestDistance < hueristic2D$TargetNode5.biasShortestDistance)) {
            if (hueristic2D$TargetNode5 != null && function.apply(hueristic2D$TargetNode5.bounds) >= function.apply(hueristic2D$TargetNode4.bounds)) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode5 != null && hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5.biasShortestDistance < Double.MAX_VALUE && hueristic2D$TargetNode5.node == hueristic2D$TargetNode6.node) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5 != null && hueristic2D$TargetNode6.biasShortestDistance < Double.MAX_VALUE && hueristic2D$TargetNode6.biasShortestDistance < hueristic2D$TargetNode5.biasShortestDistance) {
                return hueristic2D$TargetNode6.node;
            }
            if (hueristic2D$TargetNode5 != null && hueristic2D$TargetNode5.biasShortestDistance < Double.MAX_VALUE && hueristic2D$TargetNode5.originTopCornerDistance < hueristic2D$TargetNode4.originTopCornerDistance) {
                return hueristic2D$TargetNode5.node;
            }
            return hueristic2D$TargetNode4.node;
        }
        if (hueristic2D$TargetNode5 != null && hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5.bottomCornerDistance < hueristic2D$TargetNode6.bottomCornerDistance) {
            return hueristic2D$TargetNode5.node;
        }
        if (hueristic2D$TargetNode6 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode6.biasShortestDistance < Double.MAX_VALUE && hueristic2D$TargetNode6.node == hueristic2D$TargetNode7.node) {
            return hueristic2D$TargetNode6.node;
        }
        if (hueristic2D$TargetNode5 != null) {
            return hueristic2D$TargetNode5.node;
        }
        if (hueristic2D$TargetNode3 != null) {
            return hueristic2D$TargetNode3.node;
        }
        if (hueristic2D$TargetNode6 != null) {
            return hueristic2D$TargetNode6.node;
        }
        if (hueristic2D$TargetNode4 != null) {
            return hueristic2D$TargetNode4.node;
        }
        if (hueristic2D$TargetNode7 != null) {
            return hueristic2D$TargetNode7.node;
        }
        if (hueristic2D$TargetNode8 != null) {
            return hueristic2D$TargetNode8.node;
        }
        return null;
    }

    public static double findMin(double ... dArray) {
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 = d2 < dArray[i2] ? d2 : dArray[i2];
        }
        return d2;
    }
}

