/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.AffineBase;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.sg.prism.CacheFilter$ScrollCacheState;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.prism.Graphics;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class CacheFilter {
    private static final Rectangle TEMP_RECT = new Rectangle();
    private static final DirtyRegionContainer TEMP_CONTAINER = new DirtyRegionContainer(1);
    private static final Affine3D TEMP_CACHEFILTER_TRANSFORM = new Affine3D();
    private static final RectBounds TEMP_BOUNDS = new RectBounds();
    private static final double EPSILON = 1.0E-7;
    private RTTexture tempTexture;
    private double lastXDelta;
    private double lastYDelta;
    private CacheFilter$ScrollCacheState scrollCacheState = CacheFilter$ScrollCacheState.CHECKING_PRECONDITIONS;
    private ImageData cachedImageData;
    private Rectangle cacheBounds = new Rectangle();
    private final Affine2D cachedXform = new Affine2D();
    private double cachedScaleX;
    private double cachedScaleY;
    private double cachedRotate;
    private double cachedX;
    private double cachedY;
    private NGNode node;
    private final Affine2D screenXform = new Affine2D();
    private boolean scaleHint;
    private boolean rotateHint;
    private CacheHint cacheHint;
    private boolean wasUnsupported = false;

    private Rectangle computeDirtyRegionForTranslate() {
        if (this.lastXDelta != 0.0) {
            if (this.lastXDelta > 0.0) {
                TEMP_RECT.setBounds(0, 0, (int)this.lastXDelta, this.cacheBounds.height);
            } else {
                TEMP_RECT.setBounds(this.cacheBounds.width + (int)this.lastXDelta, 0, -((int)this.lastXDelta), this.cacheBounds.height);
            }
        } else if (this.lastYDelta > 0.0) {
            TEMP_RECT.setBounds(0, 0, this.cacheBounds.width, (int)this.lastYDelta);
        } else {
            TEMP_RECT.setBounds(0, this.cacheBounds.height + (int)this.lastYDelta, this.cacheBounds.width, -((int)this.lastYDelta));
        }
        return TEMP_RECT;
    }

    protected CacheFilter(NGNode nGNode, CacheHint cacheHint) {
        this.node = nGNode;
        this.scrollCacheState = CacheFilter$ScrollCacheState.CHECKING_PRECONDITIONS;
        this.setHint(cacheHint);
    }

    public void setHint(CacheHint cacheHint) {
        this.cacheHint = cacheHint;
        this.scaleHint = cacheHint == CacheHint.SPEED || cacheHint == CacheHint.SCALE || cacheHint == CacheHint.SCALE_AND_ROTATE;
        this.rotateHint = cacheHint == CacheHint.SPEED || cacheHint == CacheHint.ROTATE || cacheHint == CacheHint.SCALE_AND_ROTATE;
    }

    final boolean isScaleHint() {
        return this.scaleHint;
    }

    final boolean isRotateHint() {
        return this.rotateHint;
    }

    boolean matchesHint(CacheHint cacheHint) {
        return this.cacheHint == cacheHint;
    }

    boolean unsupported(double[] dArray) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        return (d4 > 1.0E-7 || d4 < -1.0E-7) && (d2 > d3 + 1.0E-7 || d3 > d2 + 1.0E-7 || d2 < d3 - 1.0E-7 || d3 < d2 - 1.0E-7 || this.cachedScaleX > this.cachedScaleY + 1.0E-7 || this.cachedScaleY > this.cachedScaleX + 1.0E-7 || this.cachedScaleX < this.cachedScaleY - 1.0E-7 || this.cachedScaleY < this.cachedScaleX - 1.0E-7);
    }

    private boolean isXformScrollCacheCapable(double[] dArray) {
        if (this.unsupported(dArray)) {
            return false;
        }
        double d2 = dArray[2];
        return this.rotateHint || d2 == 0.0;
    }

    private boolean needToRenderCache(BaseTransform baseTransform, double[] dArray, float f2, float f3) {
        if (this.cachedImageData == null) {
            return true;
        }
        if (this.lastXDelta != 0.0 || this.lastYDelta != 0.0) {
            if (Math.abs(this.lastXDelta) >= (double)this.cacheBounds.width || Math.abs(this.lastYDelta) >= (double)this.cacheBounds.height || Math.rint(this.lastXDelta) != this.lastXDelta || Math.rint(this.lastYDelta) != this.lastYDelta) {
                this.node.clearDirtyTree();
                CacheFilter cacheFilter = this;
                cacheFilter.lastYDelta = 0.0;
                cacheFilter.lastXDelta = 0.0;
                return true;
            }
            if (this.scrollCacheState == CacheFilter$ScrollCacheState.CHECKING_PRECONDITIONS) {
                if (this.scrollCacheCapable() && this.isXformScrollCacheCapable(dArray)) {
                    this.scrollCacheState = CacheFilter$ScrollCacheState.ENABLED;
                } else {
                    this.scrollCacheState = CacheFilter$ScrollCacheState.DISABLED;
                    return true;
                }
            }
        }
        if (((BaseTransform)this.cachedXform).getMxx() == baseTransform.getMxx() && ((BaseTransform)this.cachedXform).getMyy() == baseTransform.getMyy() && ((BaseTransform)this.cachedXform).getMxy() == baseTransform.getMxy() && ((BaseTransform)this.cachedXform).getMyx() == baseTransform.getMyx()) {
            return false;
        }
        if (this.wasUnsupported || this.unsupported(dArray)) {
            return true;
        }
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        if (this.scaleHint) {
            if (this.cachedScaleX < (double)f2 || this.cachedScaleY < (double)f3) {
                return true;
            }
            if (this.rotateHint) {
                return false;
            }
            return !(this.cachedRotate - 1.0E-7 < d4) || !(d4 < this.cachedRotate + 1.0E-7);
        }
        if (this.rotateHint) {
            return !(this.cachedScaleX - 1.0E-7 < d2) || !(d2 < this.cachedScaleX + 1.0E-7) || !(this.cachedScaleY - 1.0E-7 < d3) || !(d3 < this.cachedScaleY + 1.0E-7);
        }
        return true;
    }

    void updateScreenXform(double[] dArray) {
        if (this.scaleHint) {
            if (this.rotateHint) {
                double d2 = dArray[0] / this.cachedScaleX;
                double d3 = dArray[1] / this.cachedScaleY;
                double d4 = dArray[2] - this.cachedRotate;
                this.screenXform.setToScale(d2, d3);
                this.screenXform.rotate(d4);
                return;
            }
            double d5 = dArray[0] / this.cachedScaleX;
            double d6 = dArray[1] / this.cachedScaleY;
            this.screenXform.setToScale(d5, d6);
            return;
        }
        if (this.rotateHint) {
            double d7 = dArray[2] - this.cachedRotate;
            this.screenXform.setToRotation(d7, 0.0, 0.0);
            return;
        }
        ((BaseTransform)this.screenXform).setTransform(BaseTransform.IDENTITY_TRANSFORM);
    }

    public void invalidate() {
        if (this.scrollCacheState == CacheFilter$ScrollCacheState.ENABLED) {
            this.scrollCacheState = CacheFilter$ScrollCacheState.CHECKING_PRECONDITIONS;
        }
        this.imageDataUnref();
        CacheFilter cacheFilter = this;
        cacheFilter.lastYDelta = 0.0;
        cacheFilter.lastXDelta = 0.0;
    }

    void imageDataUnref() {
        if (this.tempTexture != null) {
            this.tempTexture.dispose();
            this.tempTexture = null;
        }
        if (this.cachedImageData != null) {
            Filterable filterable = this.cachedImageData.getUntransformedImage();
            if (filterable != null) {
                filterable.lock();
            }
            this.cachedImageData.unref();
            this.cachedImageData = null;
        }
    }

    void invalidateByTranslation(double d2, double d3) {
        if (this.cachedImageData == null) {
            return;
        }
        if (this.scrollCacheState == CacheFilter$ScrollCacheState.DISABLED) {
            this.imageDataUnref();
            return;
        }
        if (d2 != 0.0 && d3 != 0.0) {
            this.imageDataUnref();
            return;
        }
        this.lastYDelta = d3;
        this.lastXDelta = d2;
    }

    public void dispose() {
        this.invalidate();
        this.node = null;
    }

    double[] unmatrix(BaseTransform object) {
        double[] dArray = new double[3];
        object = new double[][]{{((BaseTransform)object).getMxx(), ((BaseTransform)object).getMxy()}, {((BaseTransform)object).getMyx(), ((BaseTransform)object).getMyy()}};
        double d2 = this.unitDir((double)object[0][0]);
        double d3 = this.unitDir((double)object[1][1]);
        double d4 = d2 * this.v2length((double[])object[0]);
        this.v2scale((double[])object[0], d2);
        double d5 = this.v2dot((double[])object[0], (double[])object[1]);
        this.v2combine((double[])object[1], (double[])object[0], (double[])object[1], 1.0, -d5);
        double d6 = d3 * this.v2length((double[])object[1]);
        this.v2scale((double[])object[1], d3);
        Object object2 = object[1][0];
        Object object3 = object[0][0];
        double d7 = object2 >= 0.0 ? Math.acos((double)object3) : (object3 > 0.0 ? Math.PI * 2 + Math.asin((double)object2) : Math.PI + Math.acos((double)(-object3)));
        dArray[0] = d4;
        dArray[1] = d6;
        dArray[2] = d7;
        return dArray;
    }

    double unitDir(double d2) {
        if (d2 < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    void v2combine(double[] dArray, double[] dArray2, double[] dArray3, double d2, double d3) {
        dArray3[0] = d2 * dArray[0] + d3 * dArray2[0];
        dArray3[1] = d2 * dArray[1] + d3 * dArray2[1];
    }

    double v2dot(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1];
    }

    void v2scale(double[] dArray, double d2) {
        double d3 = this.v2length(dArray);
        if (d3 != 0.0) {
            dArray[0] = dArray[0] * (d2 / d3);
            dArray[1] = dArray[1] * (d2 / d3);
        }
    }

    double v2length(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
    }

    void render(Graphics graphics) {
        Object object;
        float f2;
        float f3;
        Filterable filterable;
        BaseTransform baseTransform = graphics.getTransformNoClone();
        PrFilterContext prFilterContext = PrFilterContext.getInstance(graphics.getAssociatedScreen());
        double[] dArray = this.unmatrix(baseTransform);
        boolean bl2 = this.unsupported(dArray);
        this.lastXDelta *= dArray[0];
        this.lastYDelta *= dArray[1];
        if (this.cachedImageData != null && (filterable = this.cachedImageData.getUntransformedImage()) != null) {
            filterable.lock();
            if (!this.cachedImageData.validate(prFilterContext)) {
                filterable.unlock();
                this.invalidate();
            }
        }
        if (this.needToRenderCache(baseTransform, dArray, f3 = graphics.getPixelScaleFactorX(), f2 = graphics.getPixelScaleFactorY())) {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.incrementCounter("CacheFilter rebuilding");
            }
            if (this.cachedImageData != null) {
                object = this.cachedImageData.getUntransformedImage();
                if (object != null) {
                    object.unlock();
                }
                this.invalidate();
            }
            if (this.scaleHint) {
                this.cachedScaleX = Math.max((double)f3, dArray[0]);
                this.cachedScaleY = Math.max((double)f2, dArray[1]);
                this.cachedRotate = 0.0;
                this.cachedXform.setTransform(this.cachedScaleX, 0.0, 0.0, this.cachedScaleX, 0.0, 0.0);
                this.updateScreenXform(dArray);
            } else {
                this.cachedScaleX = dArray[0];
                this.cachedScaleY = dArray[1];
                this.cachedRotate = dArray[2];
                this.cachedXform.setTransform(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), 0.0, 0.0);
                ((BaseTransform)this.screenXform).setTransform(BaseTransform.IDENTITY_TRANSFORM);
            }
            this.cacheBounds = this.getCacheBounds(this.cacheBounds, this.cachedXform);
            this.cachedImageData = this.createImageData(prFilterContext, this.cacheBounds);
            CacheFilter cacheFilter = this;
            cacheFilter.renderNodeToCache(cacheFilter.cachedImageData, this.cacheBounds, this.cachedXform, null);
            object = this.cachedImageData.getUntransformedBounds();
            this.cachedX = ((Rectangle)object).x;
            this.cachedY = ((Rectangle)object).y;
        } else {
            if (this.scrollCacheState == CacheFilter$ScrollCacheState.ENABLED && (this.lastXDelta != 0.0 || this.lastYDelta != 0.0)) {
                CacheFilter cacheFilter = this;
                cacheFilter.moveCacheBy(cacheFilter.cachedImageData, this.lastXDelta, this.lastYDelta);
                CacheFilter cacheFilter2 = this;
                cacheFilter2.renderNodeToCache(cacheFilter2.cachedImageData, this.cacheBounds, this.cachedXform, this.computeDirtyRegionForTranslate());
                CacheFilter cacheFilter3 = this;
                cacheFilter3.lastYDelta = 0.0;
                cacheFilter3.lastXDelta = 0.0;
            }
            if (bl2) {
                ((BaseTransform)this.screenXform).setTransform(BaseTransform.IDENTITY_TRANSFORM);
            } else {
                this.updateScreenXform(dArray);
            }
        }
        this.wasUnsupported = bl2;
        object = this.cachedImageData.getUntransformedImage();
        if (object == null) {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.incrementCounter("CacheFilter not used");
            }
            this.renderNodeToScreen(graphics);
            return;
        }
        double d2 = baseTransform.getMxt();
        double d3 = baseTransform.getMyt();
        this.renderCacheToScreen(graphics, (Filterable)object, d2, d3);
        object.unlock();
    }

    ImageData createImageData(FilterContext filterContext, Rectangle rectangle) {
        Filterable filterable;
        try {
            filterable = Effect.getCompatibleImage(filterContext, rectangle.width, rectangle.height);
            Object t2 = ((PrDrawable)filterable).getTextureObject();
            t2.contentsUseful();
        }
        catch (Throwable throwable) {
            filterable = null;
        }
        return new ImageData(filterContext, filterable, rectangle);
    }

    void renderNodeToCache(ImageData object, Rectangle rectangle, BaseTransform baseTransform, Rectangle rectangle2) {
        if ((object = (PrDrawable)((ImageData)object).getUntransformedImage()) != null) {
            object = ((PrDrawable)object).createGraphics();
            ((BaseTransform)TEMP_CACHEFILTER_TRANSFORM).setToIdentity();
            ((AffineBase)TEMP_CACHEFILTER_TRANSFORM).translate(-rectangle.x, -rectangle.y);
            if (baseTransform != null) {
                ((AffineBase)TEMP_CACHEFILTER_TRANSFORM).concatenate(baseTransform);
            }
            if (rectangle2 != null) {
                TEMP_CONTAINER.deriveWithNewRegion((RectBounds)((BaseBounds)TEMP_BOUNDS).deriveWithNewBounds(rectangle2));
                this.node.doPreCulling(TEMP_CONTAINER, TEMP_CACHEFILTER_TRANSFORM, new GeneralTransform3D());
                object.setHasPreCullingBits(true);
                object.setClipRectIndex(0);
                object.setClipRect(rectangle2);
            }
            object.transform(TEMP_CACHEFILTER_TRANSFORM);
            if (this.node.getClipNode() != null) {
                this.node.renderClip((Graphics)object);
                return;
            }
            if (this.node.getEffectFilter() != null) {
                this.node.renderEffect((Graphics)object);
                return;
            }
            this.node.renderContent((Graphics)object);
        }
    }

    void renderNodeToScreen(Object object) {
        object = (Graphics)object;
        if (this.node.getEffectFilter() != null) {
            this.node.renderEffect((Graphics)object);
            return;
        }
        this.node.renderContent((Graphics)object);
    }

    void renderCacheToScreen(Object object, Filterable filterable, double d2, double d3) {
        object = (Graphics)object;
        object.setTransform(((BaseTransform)this.screenXform).getMxx(), ((BaseTransform)this.screenXform).getMyx(), ((BaseTransform)this.screenXform).getMxy(), ((BaseTransform)this.screenXform).getMyy(), d2, d3);
        object.translate((float)this.cachedX, (float)this.cachedY);
        filterable = ((PrDrawable)filterable).getTextureObject();
        Rectangle rectangle = this.cachedImageData.getUntransformedBounds();
        object.drawTexture((Texture)((Object)filterable), 0.0f, 0.0f, rectangle.width, rectangle.height);
    }

    boolean scrollCacheCapable() {
        if (!(this.node instanceof NGGroup)) {
            return false;
        }
        Object object = ((NGGroup)this.node).getChildren();
        if (object.size() != 1) {
            return false;
        }
        if (!((NGNode)(object = object.get(0))).getTransform().is2D()) {
            return false;
        }
        object = this.node.getClipNode();
        if (object == null || !((NGNode)object).isRectClip(BaseTransform.IDENTITY_TRANSFORM, false)) {
            return false;
        }
        if (this.node instanceof NGRegion) {
            NGRegion nGRegion = (NGRegion)this.node;
            if (!nGRegion.getBorder().isEmpty()) {
                return false;
            }
            Object object2 = nGRegion.getBackground();
            if (!((Background)object2).isEmpty()) {
                if (!((Background)object2).getImages().isEmpty() || ((Background)object2).getFills().size() != 1) {
                    return false;
                }
                object2 = ((Background)object2).getFills().get(0);
                Paint paint = ((BackgroundFill)object2).getFill();
                object = ((NGNode)object).getCompleteBounds(TEMP_BOUNDS, BaseTransform.IDENTITY_TRANSFORM);
                return paint.isOpaque() && paint instanceof Color && ((BackgroundFill)object2).getInsets().equals(Insets.EMPTY) && ((BaseBounds)object).getMinX() == 0.0f && ((BaseBounds)object).getMinY() == 0.0f && ((BaseBounds)object).getMaxX() == nGRegion.getWidth() && ((BaseBounds)object).getMaxY() == nGRegion.getHeight();
            }
        }
        return true;
    }

    void moveCacheBy(ImageData object, double d2, double d3) {
        PrDrawable prDrawable = (PrDrawable)((ImageData)object).getUntransformedImage();
        object = ((ImageData)object).getUntransformedBounds();
        int n2 = (int)Math.max(0.0, -d2);
        int n3 = (int)Math.max(0.0, -d3);
        int n4 = (int)Math.max(0.0, d2);
        int n5 = (int)Math.max(0.0, d3);
        int n6 = ((Rectangle)object).width - (int)Math.abs(d2);
        int n7 = ((Rectangle)object).height - (int)Math.abs(d3);
        Graphics graphics = prDrawable.createGraphics();
        if (this.tempTexture != null) {
            this.tempTexture.lock();
            if (this.tempTexture.isSurfaceLost()) {
                this.tempTexture = null;
            }
        }
        if (this.tempTexture == null) {
            this.tempTexture = graphics.getResourceFactory().createRTTexture(prDrawable.getPhysicalWidth(), prDrawable.getPhysicalHeight(), Texture$WrapMode.CLAMP_NOT_NEEDED);
        }
        Graphics graphics2 = this.tempTexture.createGraphics();
        graphics2.clear();
        graphics2.drawTexture((Texture)prDrawable.getTextureObject(), 0.0f, 0.0f, n6, n7, n2, n3, n2 + n6, n3 + n7);
        graphics2.sync();
        graphics.clear();
        graphics.drawTexture(this.tempTexture, n4, n5, n4 + n6, n5 + n7, 0.0f, 0.0f, n6, n7);
        this.tempTexture.unlock();
    }

    Rectangle getCacheBounds(Rectangle rectangle, BaseTransform object) {
        object = this.node.getClippedBounds(TEMP_BOUNDS, (BaseTransform)object);
        rectangle.setBounds((BaseBounds)object);
        return rectangle;
    }

    BaseBounds computeDirtyBounds(BaseBounds baseBounds, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        baseBounds = !this.node.dirtyBounds.isEmpty() ? baseBounds.deriveWithNewBounds(this.node.dirtyBounds) : baseBounds.deriveWithNewBounds(this.node.transformedBounds);
        if (!baseBounds.isEmpty()) {
            baseBounds.roundOut();
            BaseBounds baseBounds2 = baseBounds = this.node.computePadding(baseBounds);
            BaseBounds baseBounds3 = baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
            baseBounds = generalTransform3D.transform(baseBounds3, baseBounds3);
        }
        return baseBounds;
    }
}

