/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.Texture;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.paint.Color;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.DropShadow;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.InnerShadow;

class EffectUtil {
    private static final int TEX_SIZE = 256;
    private static Texture itex;
    private static Texture dtex;

    static boolean renderEffectForRectangularNode(NGNode nGNode, Graphics graphics, Effect effect, float f2, boolean bl2, float f3, float f4, float f5, float f6) {
        if (!graphics.getTransformNoClone().is2D() && graphics.isDepthBuffer() && graphics.isDepthTest()) {
            return false;
        }
        if (effect instanceof InnerShadow && !bl2) {
            float f7;
            effect = (InnerShadow)effect;
            float f8 = ((InnerShadow)effect).getRadius();
            if (f7 > 0.0f && f8 < f5 / 2.0f && f8 < f6 / 2.0f && ((InnerShadow)effect).getChoke() == 0.0f && ((InnerShadow)effect).getShadowSourceInput() == null && ((InnerShadow)effect).getContentInput() == null) {
                nGNode.renderContent(graphics);
                EffectUtil.renderRectInnerShadow(graphics, (InnerShadow)effect, f2, f3, f4, f5, f6);
                return true;
            }
        } else if (effect instanceof DropShadow) {
            float f9;
            effect = (DropShadow)effect;
            float f10 = ((DropShadow)effect).getRadius();
            if (f9 > 0.0f && f10 < f5 / 2.0f && f10 < f6 / 2.0f && ((DropShadow)effect).getSpread() == 0.0f && ((DropShadow)effect).getShadowSourceInput() == null && ((DropShadow)effect).getContentInput() == null) {
                EffectUtil.renderRectDropShadow(graphics, (DropShadow)effect, f2, f3, f4, f5, f6);
                nGNode.renderContent(graphics);
                return true;
            }
        }
        return false;
    }

    static void renderRectInnerShadow(Graphics graphics, InnerShadow innerShadow, float f2, float f3, float f4, float f5, float f6) {
        if (itex == null || itex.isSurfaceLost()) {
            byte[] byArray = new byte[65536];
            EffectUtil.fillGaussian(byArray, 256, 128.0f, innerShadow.getChoke(), true);
            Image image = Image.fromByteAlphaData(byArray, 256, 256);
            itex = graphics.getResourceFactory().createTexture(image, Texture$Usage.STATIC, Texture$WrapMode.CLAMP_TO_EDGE);
            assert (itex.getWrapMode() == Texture$WrapMode.CLAMP_TO_EDGE);
            itex.contentsUseful();
            itex.makePermanent();
        }
        float f7 = innerShadow.getRadius();
        int n2 = itex.getPhysicalWidth();
        int n3 = itex.getContentX();
        int n4 = n3 + itex.getContentWidth();
        float f8 = ((float)n3 + 0.5f) / (float)n2;
        float f9 = ((float)n4 - 0.5f) / (float)n2;
        float f10 = f3;
        float f11 = f4;
        f3 += f5;
        f4 += f6;
        float f12 = f10 + (float)innerShadow.getOffsetX();
        float f13 = f11 + (float)innerShadow.getOffsetY();
        f5 = f12 + f5;
        f6 = f13 + f6;
        graphics.setPaint(EffectUtil.toPrismColor(innerShadow.getColor(), f2));
        float f14 = f8;
        float f15 = f8;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f10, f11, f3, f13 - f7, f14, f14, f15, f15);
        float f16 = f8;
        float f17 = f9;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f12 - f7, f13 - f7, f12 + f7, f13 + f7, f16, f16, f17, f17);
        float f18 = f9;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f12 + f7, f13 - f7, f5 - f7, f13 + f7, f9, f8, f18, f18);
        float f19 = f8;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f5 - f7, f13 - f7, f5 + f7, f13 + f7, f9, f19, f19, f9);
        float f20 = f8;
        float f21 = f8;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f10, f13 - f7, f12 - f7, f6 + f7, f20, f20, f21, f21);
        float f22 = f9;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f12 - f7, f13 + f7, f12 + f7, f6 - f7, f8, f22, f22, f9);
        float f23 = f9;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f5 - f7, f13 + f7, f5 + f7, f6 - f7, f23, f23, f8, f9);
        float f24 = f8;
        float f25 = f8;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f5 + f7, f13 - f7, f3, f6 + f7, f24, f24, f25, f25);
        float f26 = f9;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f12 - f7, f6 - f7, f12 + f7, f6 + f7, f8, f26, f26, f8);
        float f27 = f9;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f12 + f7, f6 - f7, f5 - f7, f6 + f7, f27, f27, f9, f8);
        float f28 = f9;
        float f29 = f8;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f5 - f7, f6 - f7, f5 + f7, f6 + f7, f28, f28, f29, f29);
        float f30 = f8;
        float f31 = f8;
        EffectUtil.drawClippedTexture(graphics, itex, f10, f11, f3, f4, f10, f6 + f7, f3, f4, f30, f30, f31, f31);
    }

    static void drawClippedTexture(Graphics graphics, Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        if (f6 >= f8 || f7 >= f9 || f2 >= f4 || f3 >= f5) {
            return;
        }
        if (f8 > f2 && f6 < f4) {
            if (f6 < f2) {
                f10 += (f12 - f10) * (f2 - f6) / (f8 - f6);
                f6 = f2;
            }
            if (f8 > f4) {
                float f14 = f12;
                f12 = f14 - (f14 - f10) * (f8 - f4) / (f8 - f6);
                f8 = f4;
            }
        } else {
            return;
        }
        if (f9 > f3 && f7 < f5) {
            if (f7 < f3) {
                f11 += (f13 - f11) * (f3 - f7) / (f9 - f7);
                f7 = f3;
            }
            if (f9 > f5) {
                float f15 = f13;
                f13 = f15 - (f15 - f11) * (f9 - f5) / (f9 - f7);
                f9 = f5;
            }
        } else {
            return;
        }
        graphics.drawTextureRaw(texture, f6, f7, f8, f9, f10, f11, f12, f13);
    }

    static void renderRectDropShadow(Graphics graphics, DropShadow dropShadow, float f2, float f3, float f4, float f5, float f6) {
        if (dtex == null || dtex.isSurfaceLost()) {
            byte[] byArray = new byte[65536];
            EffectUtil.fillGaussian(byArray, 256, 128.0f, dropShadow.getSpread(), false);
            Image image = Image.fromByteAlphaData(byArray, 256, 256);
            dtex = graphics.getResourceFactory().createTexture(image, Texture$Usage.STATIC, Texture$WrapMode.CLAMP_TO_EDGE);
            assert (dtex.getWrapMode() == Texture$WrapMode.CLAMP_TO_EDGE);
            dtex.contentsUseful();
            dtex.makePermanent();
        }
        float f7 = dropShadow.getRadius();
        int n2 = dtex.getPhysicalWidth();
        int n3 = dtex.getContentX();
        int n4 = n3 + dtex.getContentWidth();
        float f8 = ((float)n3 + 0.5f) / (float)n2;
        float f9 = ((float)n4 - 0.5f) / (float)n2;
        f5 = (f3 += (float)dropShadow.getOffsetX()) + f5;
        f6 = (f4 += (float)dropShadow.getOffsetY()) + f6;
        graphics.setPaint(EffectUtil.toPrismColor(dropShadow.getColor(), f2));
        float f10 = f8;
        float f11 = f9;
        graphics.drawTextureRaw(dtex, f3 - f7, f4 - f7, f3 + f7, f4 + f7, f10, f10, f11, f11);
        float f12 = f8;
        graphics.drawTextureRaw(dtex, f5 - f7, f4 - f7, f5 + f7, f4 + f7, f9, f12, f12, f9);
        float f13 = f9;
        float f14 = f8;
        graphics.drawTextureRaw(dtex, f5 - f7, f6 - f7, f5 + f7, f6 + f7, f13, f13, f14, f14);
        float f15 = f9;
        graphics.drawTextureRaw(dtex, f3 - f7, f6 - f7, f3 + f7, f6 + f7, f8, f15, f15, f8);
        float f16 = f9;
        float f17 = f9;
        graphics.drawTextureRaw(dtex, f3 + f7, f4 + f7, f5 - f7, f6 - f7, f16, f16, f17, f17);
        float f18 = f9;
        graphics.drawTextureRaw(dtex, f3 - f7, f4 + f7, f3 + f7, f6 - f7, f8, f18, f18, f9);
        float f19 = f9;
        graphics.drawTextureRaw(dtex, f5 - f7, f4 + f7, f5 + f7, f6 - f7, f19, f19, f8, f9);
        float f20 = f9;
        graphics.drawTextureRaw(dtex, f3 + f7, f4 - f7, f5 - f7, f4 + f7, f9, f8, f20, f20);
        float f21 = f9;
        graphics.drawTextureRaw(dtex, f3 + f7, f6 - f7, f5 - f7, f6 + f7, f21, f21, f9, f8);
    }

    private static void fillGaussian(byte[] byArray, int n2, float f2, float f3, boolean bl2) {
        int n3;
        int n4;
        float f4;
        f2 /= 3.0f;
        f2 = f2 * 2.0f * f2;
        if (f4 < Float.MIN_VALUE) {
            f2 = Float.MIN_VALUE;
        }
        float[] fArray = new float[n2];
        int n5 = (n2 + 1) / 2;
        float f5 = 0.0f;
        for (n4 = 0; n4 < fArray.length; ++n4) {
            int n6 = n3 = n5 - n4;
            fArray[n4] = f5 += (float)Math.exp((float)(-(n6 * n6)) / f2);
        }
        n4 = 0;
        while (n4 < fArray.length) {
            int n7 = n4++;
            fArray[n7] = fArray[n7] / f5;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                int n8;
                f2 = fArray[n4] * fArray[n3];
                if (bl2) {
                    f2 = 1.0f - f2;
                }
                if ((n8 = (int)(f2 * 255.0f)) < 0) {
                    n8 = 0;
                } else if (n8 > 255) {
                    n8 = 255;
                }
                byArray[n4 * n2 + n3] = (byte)n8;
            }
        }
    }

    private static Color toPrismColor(Color4f color4f, float f2) {
        float f3 = color4f.getRed();
        float f4 = color4f.getGreen();
        float f5 = color4f.getBlue();
        float f6 = color4f.getAlpha() * f2;
        return new Color(f3, f4, f5, f6);
    }

    private EffectUtil() {
    }
}

