/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.sg.prism.CacheFilter;
import com.sun.javafx.sg.prism.DirtyHint;
import com.sun.javafx.sg.prism.EffectFilter;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode$DirtyFlag;
import com.sun.javafx.sg.prism.NGNode$EffectDirtyBoundsHelper;
import com.sun.javafx.sg.prism.NGNode$PassThrough;
import com.sun.javafx.sg.prism.NGNode$RenderRootResult;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NodeEffectInput;
import com.sun.javafx.sg.prism.NodeEffectInput$RenderType;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Blend$Mode;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.CacheHint;

public abstract class NGNode {
    private static final GraphicsPipeline pipeline = GraphicsPipeline.getPipeline();
    private static final Boolean effectsSupported = pipeline == null ? false : pipeline.isEffectSupported();
    private String name;
    private static final BoxBounds TEMP_BOUNDS = new BoxBounds();
    private static final RectBounds TEMP_RECT_BOUNDS = new RectBounds();
    protected static final Affine3D TEMP_TRANSFORM = new Affine3D();
    static final int DIRTY_REGION_INTERSECTS_NODE_BOUNDS = 1;
    static final int DIRTY_REGION_CONTAINS_NODE_BOUNDS = 2;
    static final int DIRTY_REGION_CONTAINS_OR_INTERSECTS_NODE_BOUNDS = 3;
    private BaseTransform transform = BaseTransform.IDENTITY_TRANSFORM;
    protected BaseBounds transformedBounds = new RectBounds();
    protected BaseBounds contentBounds = new RectBounds();
    BaseBounds dirtyBounds = new RectBounds();
    private boolean visible = true;
    protected NGNode$DirtyFlag dirty = NGNode$DirtyFlag.DIRTY;
    private NGNode parent;
    private boolean isClip;
    private NGNode clipNode;
    private float opacity = 1.0f;
    private double viewOrder = 0.0;
    private Blend$Mode nodeBlendMode;
    private boolean depthTest = true;
    private CacheFilter cacheFilter;
    private EffectFilter effectFilter;
    protected boolean childDirty = false;
    protected int dirtyChildrenAccumulated = 0;
    protected static final int DIRTY_CHILDREN_ACCUMULATED_THRESHOLD = 12;
    protected int cullingBits = 0;
    private DirtyHint hint;
    private RectBounds opaqueRegion = null;
    private boolean opaqueRegionInvalid = true;
    private int painted = 0;
    private static Point2D[] TEMP_POINTS2D_4 = new Point2D[]{new Point2D(), new Point2D(), new Point2D(), new Point2D()};

    protected NGNode() {
    }

    public void setVisible(boolean bl2) {
        if (this.visible != bl2) {
            this.visible = bl2;
            this.markDirty();
        }
    }

    public void setContentBounds(BaseBounds baseBounds) {
        this.contentBounds = this.contentBounds.deriveWithNewBounds(baseBounds);
    }

    public void setTransformedBounds(BaseBounds baseBounds, boolean bl2) {
        if (this.transformedBounds.equals(baseBounds)) {
            return;
        }
        this.dirtyBounds = this.dirtyBounds.isEmpty() ? this.dirtyBounds.deriveWithNewBounds(this.transformedBounds) : this.dirtyBounds.deriveWithUnion(this.transformedBounds);
        this.dirtyBounds = this.dirtyBounds.deriveWithUnion(baseBounds);
        this.transformedBounds = this.transformedBounds.deriveWithNewBounds(baseBounds);
        if (this.hasVisuals() && !bl2) {
            this.markDirty();
        }
    }

    public void setTransformMatrix(BaseTransform baseTransform) {
        if (this.transform.equals(baseTransform)) {
            return;
        }
        boolean bl2 = false;
        if (this.parent != null && this.parent.cacheFilter != null && PrismSettings.scrollCacheOpt) {
            if (this.hint == null) {
                this.hint = new DirtyHint();
            } else if (this.transform.getMxx() == baseTransform.getMxx() && this.transform.getMxy() == baseTransform.getMxy() && this.transform.getMyy() == baseTransform.getMyy() && this.transform.getMyx() == baseTransform.getMyx() && this.transform.getMxz() == baseTransform.getMxz() && this.transform.getMyz() == baseTransform.getMyz() && this.transform.getMzx() == baseTransform.getMzx() && this.transform.getMzy() == baseTransform.getMzy() && this.transform.getMzz() == baseTransform.getMzz() && this.transform.getMzt() == baseTransform.getMzt()) {
                bl2 = true;
                this.hint.translateXDelta = baseTransform.getMxt() - this.transform.getMxt();
                this.hint.translateYDelta = baseTransform.getMyt() - this.transform.getMyt();
            }
        }
        this.transform = this.transform.deriveWithNewTransform(baseTransform);
        if (bl2) {
            this.markDirtyByTranslation();
        } else {
            this.markDirty();
        }
        this.invalidateOpaqueRegion();
    }

    public void setClipNode(NGNode nGNode) {
        if (nGNode != this.clipNode) {
            if (this.clipNode != null) {
                this.clipNode.setParent(null);
            }
            if (nGNode != null) {
                nGNode.setParent(this, true);
            }
            this.clipNode = nGNode;
            this.visualsChanged();
            this.invalidateOpaqueRegion();
        }
    }

    public void setOpacity(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Internal Error: The opacity must be between 0 and 1");
        }
        if (f2 != this.opacity) {
            float f3 = this.opacity;
            this.opacity = f2;
            this.markDirty();
            if (f3 < 1.0f && (f2 == 1.0f || f2 == 0.0f) || f2 < 1.0f && (f3 == 1.0f || f3 == 0.0f)) {
                this.invalidateOpaqueRegion();
            }
        }
    }

    public void setViewOrder(double d2) {
        if (d2 != this.viewOrder) {
            this.viewOrder = d2;
            this.visualsChanged();
        }
    }

    public void setNodeBlendMode(Blend$Mode blend$Mode) {
        if (this.nodeBlendMode != blend$Mode) {
            this.nodeBlendMode = blend$Mode;
            this.markDirty();
            this.invalidateOpaqueRegion();
        }
    }

    public void setDepthTest(boolean bl2) {
        if (bl2 != this.depthTest) {
            this.depthTest = bl2;
            this.visualsChanged();
        }
    }

    public void setCachedAsBitmap(boolean bl2, CacheHint cacheHint) {
        if (cacheHint == null) {
            throw new IllegalArgumentException("Internal Error: cacheHint must not be null");
        }
        if (bl2) {
            if (this.cacheFilter == null) {
                this.cacheFilter = new CacheFilter(this, cacheHint);
                this.markDirty();
                return;
            }
            if (!this.cacheFilter.matchesHint(cacheHint)) {
                this.cacheFilter.setHint(cacheHint);
                this.markDirty();
                return;
            }
        } else if (this.cacheFilter != null) {
            this.cacheFilter.dispose();
            this.cacheFilter = null;
            this.markDirty();
        }
    }

    public void setEffect(Effect effect) {
        Effect effect2;
        block8: {
            block7: {
                block6: {
                    effect2 = this.getEffect();
                    if (PrismSettings.disableEffects) {
                        effect = null;
                    }
                    if (this.effectFilter != null || effect == null) break block6;
                    this.effectFilter = new EffectFilter(effect, this);
                    break block7;
                }
                if (this.effectFilter == null || this.effectFilter.getEffect() == effect) break block8;
                this.effectFilter.dispose();
                this.effectFilter = null;
                if (effect != null) {
                    this.effectFilter = new EffectFilter(effect, this);
                }
            }
            this.visualsChanged();
        }
        if (effect2 != effect && (effect2 == null || effect == null)) {
            this.invalidateOpaqueRegion();
        }
    }

    public void effectChanged() {
        this.visualsChanged();
    }

    public boolean isContentBounds2D() {
        return this.contentBounds.is2D();
    }

    public NGNode getParent() {
        return this.parent;
    }

    public void setParent(NGNode nGNode) {
        this.setParent(nGNode, false);
    }

    private void setParent(NGNode nGNode, boolean bl2) {
        this.parent = nGNode;
        this.isClip = bl2;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    protected final Effect getEffect() {
        if (this.effectFilter == null) {
            return null;
        }
        return this.effectFilter.getEffect();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final BaseTransform getTransform() {
        return this.transform;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public final Blend$Mode getNodeBlendMode() {
        return this.nodeBlendMode;
    }

    public final boolean isDepthTest() {
        return this.depthTest;
    }

    public final CacheFilter getCacheFilter() {
        return this.cacheFilter;
    }

    public final EffectFilter getEffectFilter() {
        return this.effectFilter;
    }

    public final NGNode getClipNode() {
        return this.clipNode;
    }

    public BaseBounds getContentBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            baseBounds = baseBounds.deriveWithNewBounds(this.contentBounds);
            if (!baseTransform.isIdentity()) {
                float f2 = (float)baseTransform.getMxt();
                float f3 = (float)baseTransform.getMyt();
                float f4 = (float)baseTransform.getMzt();
                BaseBounds baseBounds2 = baseBounds;
                baseBounds = baseBounds2.deriveWithNewBounds(baseBounds2.getMinX() + f2, baseBounds.getMinY() + f3, baseBounds.getMinZ() + f4, baseBounds.getMaxX() + f2, baseBounds.getMaxY() + f3, baseBounds.getMaxZ() + f4);
            }
            return baseBounds;
        }
        return this.computeBounds(baseBounds, baseTransform);
    }

    private BaseBounds computeBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds = baseBounds.deriveWithNewBounds(this.contentBounds);
        return baseTransform.transform(this.contentBounds, baseBounds);
    }

    public final BaseBounds getClippedBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds = this.getEffectBounds(baseBounds, baseTransform);
        if (this.clipNode != null) {
            float f2 = baseBounds.getMinX();
            float f3 = baseBounds.getMinY();
            float f4 = baseBounds.getMinZ();
            float f5 = baseBounds.getMaxX();
            float f6 = baseBounds.getMaxY();
            float f7 = baseBounds.getMaxZ();
            baseBounds = this.clipNode.getCompleteBounds(baseBounds, baseTransform);
            baseBounds.intersectWith(f2, f3, f4, f5, f6, f7);
        }
        return baseBounds;
    }

    public final BaseBounds getEffectBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.effectFilter != null) {
            return this.effectFilter.getBounds(baseBounds, baseTransform);
        }
        return this.getContentBounds(baseBounds, baseTransform);
    }

    public final BaseBounds getCompleteBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (baseTransform.isIdentity()) {
            baseBounds = baseBounds.deriveWithNewBounds(this.transformedBounds);
            return baseBounds;
        }
        if (this.transform.isIdentity()) {
            return this.getClippedBounds(baseBounds, baseTransform);
        }
        double d2 = baseTransform.getMxx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMxz();
        double d5 = baseTransform.getMxt();
        double d6 = baseTransform.getMyx();
        double d7 = baseTransform.getMyy();
        double d8 = baseTransform.getMyz();
        double d9 = baseTransform.getMyt();
        double d10 = baseTransform.getMzx();
        double d11 = baseTransform.getMzy();
        double d12 = baseTransform.getMzz();
        double d13 = baseTransform.getMzt();
        BaseTransform baseTransform2 = baseTransform.deriveWithConcatenation(this.transform);
        baseBounds = this.getClippedBounds(baseBounds, baseTransform);
        if (baseTransform2 == baseTransform) {
            baseTransform.restoreTransform(d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13);
        }
        return baseBounds;
    }

    protected void visualsChanged() {
        this.invalidateCache();
        this.markDirty();
    }

    protected void geometryChanged() {
        this.invalidateCache();
        this.invalidateOpaqueRegion();
        if (this.hasVisuals()) {
            this.markDirty();
        }
    }

    public final void markDirty() {
        if (this.dirty != NGNode$DirtyFlag.DIRTY) {
            this.dirty = NGNode$DirtyFlag.DIRTY;
            this.markTreeDirty();
        }
    }

    private void markDirtyByTranslation() {
        if (this.dirty == NGNode$DirtyFlag.CLEAN) {
            if (this.parent != null && this.parent.dirty == NGNode$DirtyFlag.CLEAN && !this.parent.childDirty) {
                this.dirty = NGNode$DirtyFlag.DIRTY_BY_TRANSLATION;
                this.parent.childDirty = true;
                ++this.parent.dirtyChildrenAccumulated;
                this.parent.invalidateCacheByTranslation(this.hint);
                this.parent.markTreeDirty();
                return;
            }
            this.markDirty();
        }
    }

    protected final void markTreeDirtyNoIncrement() {
        if (!(this.parent == null || this.parent.childDirty && this.dirty != NGNode$DirtyFlag.DIRTY_BY_TRANSLATION)) {
            this.markTreeDirty();
        }
    }

    protected final void markTreeDirty() {
        boolean bl2;
        NGNode nGNode = this.parent;
        boolean bl3 = this.isClip;
        boolean bl4 = bl2 = this.dirty == NGNode$DirtyFlag.DIRTY_BY_TRANSLATION;
        while (nGNode != null && nGNode.dirty != NGNode$DirtyFlag.DIRTY && (!nGNode.childDirty || bl3 || bl2)) {
            if (bl3) {
                nGNode.dirty = NGNode$DirtyFlag.DIRTY;
            } else if (!bl2) {
                nGNode.childDirty = true;
                ++nGNode.dirtyChildrenAccumulated;
            }
            nGNode.invalidateCache();
            bl3 = nGNode.isClip;
            bl2 = nGNode.dirty == NGNode$DirtyFlag.DIRTY_BY_TRANSLATION;
            nGNode = nGNode.parent;
        }
        if (nGNode != null && nGNode.dirty == NGNode$DirtyFlag.CLEAN && !bl3 && !bl2) {
            ++nGNode.dirtyChildrenAccumulated;
        }
        if (nGNode != null) {
            nGNode.invalidateCache();
        }
    }

    public final boolean isClean() {
        return this.dirty == NGNode$DirtyFlag.CLEAN && !this.childDirty;
    }

    protected void clearDirty() {
        this.dirty = NGNode$DirtyFlag.CLEAN;
        this.childDirty = false;
        this.dirtyBounds.makeEmpty();
        this.dirtyChildrenAccumulated = 0;
    }

    public void clearPainted() {
        this.painted = 0;
        if (this instanceof NGGroup) {
            List<NGNode> list = ((NGGroup)this).getChildren();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                list.get(i2).clearPainted();
            }
        }
    }

    public void clearDirtyTree() {
        this.clearDirty();
        if (this.getClipNode() != null) {
            this.getClipNode().clearDirtyTree();
        }
        if (this instanceof NGGroup) {
            List<NGNode> list = ((NGGroup)this).getChildren();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                NGNode nGNode = list.get(i2);
                if (nGNode.dirty == NGNode$DirtyFlag.CLEAN && !nGNode.childDirty) continue;
                nGNode.clearDirtyTree();
            }
        }
    }

    protected final void invalidateCache() {
        if (this.cacheFilter != null) {
            this.cacheFilter.invalidate();
        }
    }

    protected final void invalidateCacheByTranslation(DirtyHint dirtyHint) {
        if (this.cacheFilter != null) {
            this.cacheFilter.invalidateByTranslation(dirtyHint.translateXDelta, dirtyHint.translateYDelta);
        }
    }

    public int accumulateDirtyRegions(RectBounds rectBounds, RectBounds rectBounds2, DirtyRegionPool dirtyRegionPool, DirtyRegionContainer dirtyRegionContainer, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        if (rectBounds == null || rectBounds2 == null || dirtyRegionPool == null || dirtyRegionContainer == null || baseTransform == null || generalTransform3D == null) {
            throw new NullPointerException();
        }
        if (this.dirty == NGNode$DirtyFlag.CLEAN && !this.childDirty) {
            return 1;
        }
        if (this.dirty != NGNode$DirtyFlag.CLEAN) {
            return this.accumulateNodeDirtyRegion(rectBounds, rectBounds2, dirtyRegionContainer, baseTransform, generalTransform3D);
        }
        assert (this.childDirty);
        return this.accumulateGroupDirtyRegion(rectBounds, rectBounds2, dirtyRegionPool, dirtyRegionContainer, baseTransform, generalTransform3D);
    }

    int accumulateNodeDirtyRegion(RectBounds rectBounds, RectBounds rectBounds2, DirtyRegionContainer dirtyRegionContainer, BaseTransform object, GeneralTransform3D generalTransform3D) {
        if ((object = this.computeDirtyRegion(rectBounds2, (BaseTransform)object, generalTransform3D)) != rectBounds2) {
            ((BaseBounds)object).flattenInto(rectBounds2);
        }
        if (((BaseBounds)rectBounds2).isEmpty() || rectBounds.disjoint(rectBounds2)) {
            return 1;
        }
        if (rectBounds2.contains(rectBounds)) {
            return 0;
        }
        ((BaseBounds)rectBounds2).intersectWith(rectBounds);
        dirtyRegionContainer.addDirtyRegion(rectBounds2);
        return 1;
    }

    int accumulateGroupDirtyRegion(RectBounds rectBounds, RectBounds rectBounds2, DirtyRegionPool dirtyRegionPool, DirtyRegionContainer dirtyRegionContainer, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        NGNode nGNode;
        Object object;
        int n2;
        Object object2;
        assert (this.childDirty);
        assert (this.dirty == NGNode$DirtyFlag.CLEAN);
        int n3 = 1;
        if (this.dirtyChildrenAccumulated > 12) {
            n3 = this.accumulateNodeDirtyRegion(rectBounds, rectBounds2, dirtyRegionContainer, baseTransform, generalTransform3D);
            return n3;
        }
        double d2 = baseTransform.getMxx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMxz();
        double d5 = baseTransform.getMxt();
        double d6 = baseTransform.getMyx();
        double d7 = baseTransform.getMyy();
        double d8 = baseTransform.getMyz();
        double d9 = baseTransform.getMyt();
        double d10 = baseTransform.getMzx();
        double d11 = baseTransform.getMzy();
        double d12 = baseTransform.getMzz();
        double d13 = baseTransform.getMzt();
        BaseTransform baseTransform2 = baseTransform;
        if (this.transform != null) {
            baseTransform2 = baseTransform2.deriveWithConcatenation(this.transform);
        }
        RectBounds rectBounds3 = rectBounds;
        DirtyRegionContainer dirtyRegionContainer2 = null;
        BaseTransform baseTransform3 = null;
        if (this.effectFilter != null) {
            try {
                rectBounds3 = new RectBounds();
                object2 = baseTransform2.inverseTransform(rectBounds, TEMP_BOUNDS);
                ((BaseBounds)object2).flattenInto(rectBounds3);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return 1;
            }
            baseTransform3 = baseTransform2;
            baseTransform2 = BaseTransform.IDENTITY_TRANSFORM;
            dirtyRegionContainer2 = dirtyRegionContainer;
            dirtyRegionContainer = dirtyRegionPool.checkOut();
        } else if (this.clipNode != null) {
            dirtyRegionContainer2 = dirtyRegionContainer;
            rectBounds3 = new RectBounds();
            Object object3 = object2 = this.clipNode.getCompleteBounds(rectBounds3, baseTransform2);
            generalTransform3D.transform((BaseBounds)object3, (BaseBounds)object3);
            ((BaseBounds)object2).flattenInto(rectBounds3);
            ((BaseBounds)rectBounds3).intersectWith(rectBounds);
            dirtyRegionContainer = dirtyRegionPool.checkOut();
        }
        object2 = ((NGGroup)this).getRemovedChildren();
        if (object2 != null) {
            for (n2 = object2.size() - 1; n2 >= 0; --n2) {
                object = (NGNode)object2.get(n2);
                ((NGNode)object2.get(n2)).dirty = NGNode$DirtyFlag.DIRTY;
                n3 = ((NGNode)object).accumulateDirtyRegions(rectBounds3, rectBounds2, dirtyRegionPool, dirtyRegionContainer, baseTransform2, generalTransform3D);
                if (n3 == 0) break;
            }
        }
        object = ((NGGroup)this).getChildren();
        n2 = object.size();
        for (int i2 = 0; i2 < n2 && n3 == 1 && (n3 = (nGNode = (NGNode)object.get(i2)).accumulateDirtyRegions(rectBounds3, rectBounds2, dirtyRegionPool, dirtyRegionContainer, baseTransform2, generalTransform3D)) != 0; ++i2) {
        }
        if (this.effectFilter != null && n3 == 1) {
            NGNode nGNode2 = this;
            nGNode2.applyEffect(nGNode2.effectFilter, dirtyRegionContainer, dirtyRegionPool);
            if (this.clipNode != null) {
                rectBounds3 = new RectBounds();
                BaseBounds baseBounds = this.clipNode.getCompleteBounds(rectBounds3, baseTransform2);
                this.applyClip(baseBounds, dirtyRegionContainer);
            }
            this.applyTransform(baseTransform3, dirtyRegionContainer);
            baseTransform2 = baseTransform3;
            dirtyRegionContainer2.merge(dirtyRegionContainer);
            dirtyRegionPool.checkIn(dirtyRegionContainer);
        }
        if (baseTransform2 == baseTransform) {
            baseTransform.restoreTransform(d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13);
        }
        if (this.clipNode != null && this.effectFilter == null) {
            if (n3 == 0) {
                n3 = this.accumulateNodeDirtyRegion(rectBounds, rectBounds2, dirtyRegionContainer2, baseTransform, generalTransform3D);
            } else {
                dirtyRegionContainer2.merge(dirtyRegionContainer);
            }
            dirtyRegionPool.checkIn(dirtyRegionContainer);
        }
        return n3;
    }

    private BaseBounds computeDirtyRegion(RectBounds baseBounds, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        if (this.cacheFilter != null) {
            return this.cacheFilter.computeDirtyBounds(baseBounds, baseTransform, generalTransform3D);
        }
        baseBounds = !this.dirtyBounds.isEmpty() ? baseBounds.deriveWithNewBounds(this.dirtyBounds) : baseBounds.deriveWithNewBounds(this.transformedBounds);
        if (!baseBounds.isEmpty()) {
            BaseBounds baseBounds2 = baseBounds = this.computePadding(baseBounds);
            BaseBounds baseBounds3 = baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
            baseBounds = generalTransform3D.transform(baseBounds3, baseBounds3);
        }
        return baseBounds;
    }

    protected BaseBounds computePadding(BaseBounds baseBounds) {
        return baseBounds;
    }

    protected boolean hasVisuals() {
        return true;
    }

    public final void doPreCulling(DirtyRegionContainer dirtyRegionContainer, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        if (dirtyRegionContainer == null || baseTransform == null || generalTransform3D == null) {
            throw new NullPointerException();
        }
        this.markCullRegions(dirtyRegionContainer, -1, baseTransform, generalTransform3D);
    }

    void markCullRegions(DirtyRegionContainer dirtyRegionContainer, int n2, BaseTransform object, GeneralTransform3D generalTransform3D) {
        if (((BaseTransform)object).isIdentity()) {
            ((BaseBounds)TEMP_BOUNDS).deriveWithNewBounds(this.transformedBounds);
        } else {
            ((BaseTransform)object).transform(this.transformedBounds, TEMP_BOUNDS);
        }
        if (!generalTransform3D.isIdentity()) {
            BoxBounds boxBounds = TEMP_BOUNDS;
            generalTransform3D.transform(boxBounds, boxBounds);
        }
        ((BaseBounds)TEMP_BOUNDS).flattenInto(TEMP_RECT_BOUNDS);
        this.cullingBits = 0;
        int n3 = 1;
        for (int i2 = 0; i2 < dirtyRegionContainer.size() && (object = dirtyRegionContainer.getDirtyRegion(i2)) != null && !((BaseBounds)object).isEmpty(); ++i2) {
            if ((n2 == -1 || (n2 & n3) != 0) && ((RectBounds)object).intersects(TEMP_RECT_BOUNDS)) {
                int n4 = 1;
                if (((RectBounds)object).contains(TEMP_RECT_BOUNDS)) {
                    n4 = 2;
                }
                this.cullingBits |= n4 << 2 * i2;
            }
            n3 <<= 2;
        }
        if (this.cullingBits == 0 && (this.dirty != NGNode$DirtyFlag.CLEAN || this.childDirty)) {
            this.clearDirtyTree();
        }
    }

    public final void printDirtyOpts(StringBuilder stringBuilder, List<NGNode> list) {
        stringBuilder.append("\n*=Render Root\n");
        stringBuilder.append("d=Dirty\n");
        stringBuilder.append("dt=Dirty By Translation\n");
        stringBuilder.append("i=Dirty Region Intersects the NGNode\n");
        stringBuilder.append("c=Dirty Region Contains the NGNode\n");
        stringBuilder.append("ef=Effect Filter\n");
        stringBuilder.append("cf=Cache Filter\n");
        stringBuilder.append("cl=This node is a clip node\n");
        stringBuilder.append("b=Blend mode is set\n");
        stringBuilder.append("or=Opaque Region\n");
        this.printDirtyOpts(stringBuilder, this, BaseTransform.IDENTITY_TRANSFORM, "", list);
    }

    private final void printDirtyOpts(StringBuilder stringBuilder, NGNode nGNode, BaseTransform baseTransform, String string, List<NGNode> list) {
        RectBounds rectBounds;
        int n2;
        int n3;
        if (!nGNode.isVisible() || nGNode.getOpacity() == 0.0f) {
            return;
        }
        baseTransform = baseTransform.copy();
        baseTransform = baseTransform.deriveWithConcatenation(nGNode.getTransform());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n3 = 0; n3 < list.size(); ++n3) {
            NGNode nGNode2 = list.get(n3);
            if (nGNode != nGNode2) continue;
            arrayList.add("*" + n3);
        }
        if (nGNode.dirty != NGNode$DirtyFlag.CLEAN) {
            arrayList.add(nGNode.dirty == NGNode$DirtyFlag.DIRTY ? "d" : "dt");
        }
        if (nGNode.cullingBits != 0) {
            n3 = 17;
            for (int i2 = 0; i2 < 15; ++i2) {
                n2 = nGNode.cullingBits & n3;
                if (n2 != 0) {
                    arrayList.add(n2 == 1 ? "i" + i2 : (n2 == 0 ? "c" + i2 : "ci" + i2));
                }
                n3 <<= 2;
            }
        }
        if (nGNode.effectFilter != null) {
            arrayList.add("ef");
        }
        if (nGNode.cacheFilter != null) {
            arrayList.add("cf");
        }
        if (nGNode.nodeBlendMode != null) {
            arrayList.add("b");
        }
        if ((rectBounds = nGNode.getOpaqueRegion()) != null) {
            RectBounds rectBounds2 = new RectBounds();
            baseTransform.transform(rectBounds, rectBounds2);
            arrayList.add("or=" + ((BaseBounds)rectBounds2).getMinX() + ", " + ((BaseBounds)rectBounds2).getMinY() + ", " + ((BaseBounds)rectBounds2).getWidth() + ", " + ((BaseBounds)rectBounds2).getHeight());
        }
        if (arrayList.isEmpty()) {
            stringBuilder.append(string + nGNode.name + "\n");
        } else {
            Object object = " [";
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = (String)object + (String)arrayList.get(n2);
                if (n2 >= arrayList.size() - 1) continue;
                object = (String)object + " ";
            }
            stringBuilder.append(string + nGNode.name + (String)object + "]\n");
        }
        if (nGNode.getClipNode() != null) {
            this.printDirtyOpts(stringBuilder, nGNode.getClipNode(), baseTransform, string + "  cl ", list);
        }
        if (nGNode instanceof NGGroup) {
            NGGroup nGGroup = (NGGroup)nGNode;
            for (n2 = 0; n2 < nGGroup.getChildren().size(); ++n2) {
                this.printDirtyOpts(stringBuilder, nGGroup.getChildren().get(n2), baseTransform, string + "  ", list);
            }
        }
    }

    public void drawDirtyOpts(BaseTransform object, GeneralTransform3D generalTransform3D, Rectangle rectangle, int[] nArray, int n2) {
        if ((this.painted & 1 << (n2 << 1)) != 0) {
            ((BaseTransform)object).copy().deriveWithConcatenation(this.getTransform()).transform(this.contentBounds, TEMP_BOUNDS);
            if (generalTransform3D != null) {
                BoxBounds boxBounds = TEMP_BOUNDS;
                generalTransform3D.transform(boxBounds, boxBounds);
            }
            object = new RectBounds();
            ((BaseBounds)TEMP_BOUNDS).flattenInto((RectBounds)object);
            assert (rectangle.width * rectangle.height == nArray.length);
            ((BaseBounds)object).intersectWith(rectangle);
            int n3 = (int)((BaseBounds)object).getMinX() - rectangle.x;
            int n4 = (int)((BaseBounds)object).getMinY() - rectangle.y;
            int n5 = (int)((double)((BaseBounds)object).getWidth() + 0.5);
            int n6 = (int)((double)((BaseBounds)object).getHeight() + 0.5);
            if (n5 == 0 || n6 == 0) {
                return;
            }
            for (int i2 = n4; i2 < n4 + n6; ++i2) {
                for (int i3 = n3; i3 < n3 + n5; ++i3) {
                    int n7 = i2 * rectangle.width + i3;
                    int n8 = nArray[n7];
                    if (n8 == 0) {
                        n8 = 134250240;
                    } else if ((this.painted & 3 << (n2 << 1)) == 3) {
                        switch (n8) {
                            case -2147451136: {
                                n8 = -2147450880;
                                break;
                            }
                            case -2147450880: {
                                n8 = -2139128064;
                                break;
                            }
                            case -2139128064: {
                                n8 = -2139062272;
                                break;
                            }
                            case -2139062272: {
                                n8 = -2139160576;
                                break;
                            }
                            default: {
                                n8 = -2139095040;
                            }
                        }
                    }
                    nArray[n7] = n8;
                }
            }
        }
    }

    public final void getRenderRoot(NodePath nodePath, RectBounds object, int n2, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        if (nodePath == null || object == null || baseTransform == null || generalTransform3D == null) {
            throw new NullPointerException();
        }
        if (n2 < -1 || n2 > 15) {
            throw new IllegalArgumentException("cullingIndex cannot be < -1 or > 15");
        }
        if ((object = this.computeRenderRoot(nodePath, (RectBounds)object, n2, baseTransform, generalTransform3D)) == NGNode$RenderRootResult.NO_RENDER_ROOT) {
            nodePath.add(this);
            return;
        }
        if (object == NGNode$RenderRootResult.HAS_RENDER_ROOT_AND_IS_CLEAN) {
            nodePath.clear();
        }
    }

    NGNode$RenderRootResult computeRenderRoot(NodePath nodePath, RectBounds rectBounds, int n2, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        return this.computeNodeRenderRoot(nodePath, rectBounds, n2, baseTransform, generalTransform3D);
    }

    private static int ccw(double d2, double d3, Point2D point2D, Point2D point2D2) {
        return (int)Math.signum((double)(point2D2.x - point2D.x) * (d3 - (double)point2D.y) - (double)(point2D2.y - point2D.y) * (d2 - (double)point2D.x));
    }

    private static boolean pointInConvexQuad(double d2, double d3, Point2D[] point2DArray) {
        int n2 = NGNode.ccw(d2, d3, point2DArray[0], point2DArray[1]);
        int n3 = NGNode.ccw(d2, d3, point2DArray[1], point2DArray[2]);
        int n4 = NGNode.ccw(d2, d3, point2DArray[2], point2DArray[3]);
        int n5 = NGNode.ccw(d2, d3, point2DArray[3], point2DArray[0]);
        int n6 = n2;
        n2 = n6 ^ n6 >>> 1;
        int n7 = n3;
        n3 = n7 ^ n7 >>> 1;
        int n8 = n4;
        n4 = n8 ^ n8 >>> 1;
        int n9 = n5;
        n5 = n9 ^ n9 >>> 1;
        return (n5 = n2 | n3 | n4 | n5) == Integer.MIN_VALUE || n5 == 1;
    }

    final NGNode$RenderRootResult computeNodeRenderRoot(NodePath nodePath, RectBounds rectBounds, int n2, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        if (n2 != -1 && ((n2 = this.cullingBits >> (n2 << 1)) & 3) == 0) {
            return NGNode$RenderRootResult.NO_RENDER_ROOT;
        }
        if (!this.isVisible()) {
            return NGNode$RenderRootResult.NO_RENDER_ROOT;
        }
        RectBounds rectBounds2 = this.getOpaqueRegion();
        if (rectBounds2 == null) {
            return NGNode$RenderRootResult.NO_RENDER_ROOT;
        }
        BaseTransform baseTransform2 = this.getTransform();
        if (NGNode.checkBoundsInQuad(rectBounds2, rectBounds, baseTransform = TEMP_TRANSFORM.deriveWithNewTransform(baseTransform).deriveWithConcatenation(baseTransform2), generalTransform3D)) {
            nodePath.add(this);
            if (this.isClean()) {
                return NGNode$RenderRootResult.HAS_RENDER_ROOT_AND_IS_CLEAN;
            }
            return NGNode$RenderRootResult.HAS_RENDER_ROOT;
        }
        return NGNode$RenderRootResult.NO_RENDER_ROOT;
    }

    static boolean checkBoundsInQuad(RectBounds point2DArray, RectBounds rectBounds, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        if (generalTransform3D.isIdentity() && (baseTransform.getType() & 0xFFFFFFF0) == 0) {
            if (baseTransform.isIdentity()) {
                ((BaseBounds)TEMP_BOUNDS).deriveWithNewBounds((BaseBounds)point2DArray);
            } else {
                baseTransform.transform((BaseBounds)point2DArray, TEMP_BOUNDS);
            }
            ((BaseBounds)TEMP_BOUNDS).flattenInto(TEMP_RECT_BOUNDS);
            return TEMP_RECT_BOUNDS.contains(rectBounds);
        }
        TEMP_POINTS2D_4[0].setLocation(point2DArray.getMinX(), point2DArray.getMinY());
        TEMP_POINTS2D_4[1].setLocation(point2DArray.getMaxX(), point2DArray.getMinY());
        TEMP_POINTS2D_4[2].setLocation(point2DArray.getMaxX(), point2DArray.getMaxY());
        TEMP_POINTS2D_4[3].setLocation(point2DArray.getMinX(), point2DArray.getMaxY());
        point2DArray = TEMP_POINTS2D_4;
        int n2 = TEMP_POINTS2D_4.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2D point2D;
            Point2D point2D2 = point2D = point2DArray[i2];
            baseTransform.transform(point2D2, point2D2);
            if (generalTransform3D.isIdentity()) continue;
            Point2D point2D3 = point2D;
            generalTransform3D.transform(point2D3, point2D3);
        }
        return NGNode.pointInConvexQuad(((BaseBounds)rectBounds).getMinX(), ((BaseBounds)rectBounds).getMinY(), TEMP_POINTS2D_4) && NGNode.pointInConvexQuad(((BaseBounds)rectBounds).getMaxX(), ((BaseBounds)rectBounds).getMinY(), TEMP_POINTS2D_4) && NGNode.pointInConvexQuad(((BaseBounds)rectBounds).getMaxX(), ((BaseBounds)rectBounds).getMaxY(), TEMP_POINTS2D_4) && NGNode.pointInConvexQuad(((BaseBounds)rectBounds).getMinX(), ((BaseBounds)rectBounds).getMaxY(), TEMP_POINTS2D_4);
    }

    protected final void invalidateOpaqueRegion() {
        while (true) {
            nGNode.opaqueRegionInvalid = true;
            if (!nGNode.isClip) break;
            NGNode nGNode = nGNode.parent;
        }
    }

    final boolean isOpaqueRegionInvalid() {
        return this.opaqueRegionInvalid;
    }

    public final RectBounds getOpaqueRegion() {
        if (this.opaqueRegionInvalid || this.getEffect() != null) {
            this.opaqueRegionInvalid = false;
            if (this.supportsOpaqueRegions() && this.hasOpaqueRegion()) {
                this.opaqueRegion = this.computeOpaqueRegion(this.opaqueRegion == null ? new RectBounds() : this.opaqueRegion);
                assert (this.opaqueRegion != null);
                if (this.opaqueRegion == null) {
                    return null;
                }
                Object object = this.getClipNode();
                if (object != null) {
                    RectBounds rectBounds = ((NGNode)object).getOpaqueRegion();
                    if (rectBounds == null || (((NGNode)object).getTransform().getType() & 0xFFFFFFF8) != 0) {
                        this.opaqueRegion = null;
                        return null;
                    }
                    object = ((NGNode)object).getTransform().transform(rectBounds, TEMP_BOUNDS);
                    ((BaseBounds)object).flattenInto(TEMP_RECT_BOUNDS);
                    ((BaseBounds)this.opaqueRegion).intersectWith(TEMP_RECT_BOUNDS);
                }
            } else {
                this.opaqueRegion = null;
            }
        }
        return this.opaqueRegion;
    }

    protected boolean supportsOpaqueRegions() {
        return false;
    }

    protected boolean hasOpaqueRegion() {
        NGNode nGNode = this.getClipNode();
        Effect effect = this.getEffect();
        return !(effect != null && effect.reducesOpaquePixels() || this.getOpacity() != 1.0f || this.nodeBlendMode != null && this.nodeBlendMode != Blend$Mode.SRC_OVER || nGNode != null && (!nGNode.supportsOpaqueRegions() || !nGNode.hasOpaqueRegion()));
    }

    protected RectBounds computeOpaqueRegion(RectBounds rectBounds) {
        return null;
    }

    protected boolean isRectClip(BaseTransform baseTransform, boolean bl2) {
        return false;
    }

    public final void render(Graphics graphics) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.incrementCounter("Nodes visited during render");
        }
        this.clearDirty();
        if (!this.visible || this.opacity == 0.0f) {
            return;
        }
        this.doRender(graphics);
    }

    public void renderForcedContent(Graphics graphics) {
    }

    boolean isShape3D() {
        return false;
    }

    protected void doRender(Graphics graphics) {
        int n2;
        graphics.setState3D(this.isShape3D());
        boolean bl2 = false;
        if (PrismSettings.dirtyOptsEnabled && graphics.hasPreCullingBits()) {
            n2 = this.cullingBits >> (graphics.getClipRectIndex() << 1);
            if ((n2 & 3) == 0) {
                return;
            }
            if ((n2 & 2) != 0) {
                graphics.setHasPreCullingBits(false);
                bl2 = true;
            }
        }
        n2 = graphics.isDepthTest();
        graphics.setDepthTest(this.isDepthTest());
        BaseTransform baseTransform = graphics.getTransformNoClone();
        double d2 = baseTransform.getMxx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMxz();
        double d5 = baseTransform.getMxt();
        double d6 = baseTransform.getMyx();
        double d7 = baseTransform.getMyy();
        double d8 = baseTransform.getMyz();
        double d9 = baseTransform.getMyt();
        double d10 = baseTransform.getMzx();
        double d11 = baseTransform.getMzy();
        double d12 = baseTransform.getMzz();
        double d13 = baseTransform.getMzt();
        graphics.transform(this.getTransform());
        boolean bl3 = false;
        if (!this.isShape3D() && graphics instanceof ReadbackGraphics && this.needsBlending()) {
            this.renderNodeBlendMode(graphics);
            v0 = true;
        } else if (!this.isShape3D() && this.getOpacity() < 1.0f) {
            this.renderOpacity(graphics);
            v0 = true;
        } else if (!this.isShape3D() && this.getCacheFilter() != null) {
            this.renderCached(graphics);
            v0 = true;
        } else if (!this.isShape3D() && this.getClipNode() != null) {
            this.renderClip(graphics);
            v0 = true;
        } else if (!this.isShape3D() && this.getEffectFilter() != null && effectsSupported.booleanValue()) {
            this.renderEffect(graphics);
            v0 = true;
        } else {
            this.renderContent(graphics);
            if (PrismSettings.showOverdraw) {
                v0 = bl3 = this instanceof NGRegion || !(this instanceof NGGroup);
            }
        }
        if (bl2) {
            graphics.setHasPreCullingBits(true);
        }
        graphics.setTransform3D(d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13);
        graphics.setDepthTest(n2 != 0);
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.incrementCounter("Nodes rendered");
        }
        if (PrismSettings.showOverdraw) {
            if (bl3) {
                this.painted |= 3 << (graphics.getClipRectIndex() << 1);
                return;
            }
            this.painted |= 1 << (graphics.getClipRectIndex() << 1);
        }
    }

    protected boolean needsBlending() {
        Blend$Mode blend$Mode = this.getNodeBlendMode();
        return blend$Mode != null && blend$Mode != Blend$Mode.SRC_OVER;
    }

    private void renderNodeBlendMode(Graphics graphics) {
        Object object = graphics.getTransformNoClone();
        Object object2 = this.getClippedBounds(new RectBounds(), (BaseTransform)object);
        if (((BaseBounds)object2).isEmpty()) {
            this.clearDirtyTree();
            return;
        }
        if (!this.isReadbackSupported(graphics)) {
            if (this.getOpacity() < 1.0f) {
                this.renderOpacity(graphics);
                return;
            }
            if (this.getClipNode() != null) {
                this.renderClip(graphics);
                return;
            }
            this.renderContent(graphics);
            return;
        }
        object2 = new Rectangle((BaseBounds)object2);
        ((Rectangle)object2).intersectWith(PrEffectHelper.getGraphicsClipNoClone(graphics));
        FilterContext filterContext = NGNode.getFilterContext(graphics);
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, ((Rectangle)object2).width, ((Rectangle)object2).height);
        if (prDrawable == null) {
            this.clearDirtyTree();
            return;
        }
        Object object3 = prDrawable.createGraphics();
        object3.setHasPreCullingBits(graphics.hasPreCullingBits());
        object3.setClipRectIndex(graphics.getClipRectIndex());
        object3.translate(-((Rectangle)object2).x, -((Rectangle)object2).y);
        object3.transform((BaseTransform)object);
        if (this.getOpacity() < 1.0f) {
            this.renderOpacity((Graphics)object3);
        } else if (this.getCacheFilter() != null) {
            this.renderCached((Graphics)object3);
        } else if (this.getClipNode() != null) {
            this.renderClip(graphics);
        } else if (this.getEffectFilter() != null) {
            this.renderEffect((Graphics)object3);
        } else {
            this.renderContent((Graphics)object3);
        }
        object = ((ReadbackGraphics)graphics).readBack((Rectangle)object2);
        object3 = PrDrawable.create(filterContext, (RTTexture)object);
        object2 = new Blend(this.getNodeBlendMode(), new NGNode$PassThrough((PrDrawable)object3, (Rectangle)object2), new NGNode$PassThrough(prDrawable, (Rectangle)object2));
        object3 = graphics.getCompositeMode();
        graphics.setTransform(null);
        graphics.setCompositeMode(CompositeMode.SRC);
        PrEffectHelper.render((Effect)object2, graphics, 0.0f, 0.0f, null);
        graphics.setCompositeMode((CompositeMode)((Object)object3));
        Effect.releaseCompatibleImage(filterContext, prDrawable);
        ((ReadbackGraphics)graphics).releaseReadBackBuffer((RTTexture)object);
    }

    private void renderRectClip(Graphics graphics, NGRectangle nGRectangle) {
        BaseBounds baseBounds = ((NGShape)nGRectangle).getShape().getBounds();
        if (!nGRectangle.getTransform().isIdentity()) {
            RectBounds rectBounds = baseBounds;
            baseBounds = nGRectangle.getTransform().transform(rectBounds, rectBounds);
        }
        BaseTransform baseTransform = graphics.getTransformNoClone();
        Rectangle rectangle = graphics.getClipRectNoClone();
        BaseBounds baseBounds2 = baseBounds;
        baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
        baseBounds.intersectWith(PrEffectHelper.getGraphicsClipNoClone(graphics));
        if (baseBounds.isEmpty() || baseBounds.getWidth() == 0.0f || baseBounds.getHeight() == 0.0f) {
            this.clearDirtyTree();
            return;
        }
        graphics.setClipRect(new Rectangle(baseBounds));
        this.renderForClip(graphics);
        graphics.setClipRect(rectangle);
        nGRectangle.clearDirty();
    }

    void renderClip(Graphics graphics) {
        Object object;
        if ((double)this.getClipNode().getOpacity() == 0.0) {
            this.clearDirtyTree();
            return;
        }
        Object object2 = graphics.getTransformNoClone();
        Object object3 = this.getClippedBounds(new RectBounds(), (BaseTransform)object2);
        if (((BaseBounds)object3).isEmpty()) {
            this.clearDirtyTree();
            return;
        }
        if (this.getClipNode() instanceof NGRectangle && ((NGRectangle)(object = (NGRectangle)this.getClipNode())).isRectClip((BaseTransform)object2, false)) {
            this.renderRectClip(graphics, (NGRectangle)object);
            return;
        }
        object = new Rectangle((BaseBounds)object3);
        ((Rectangle)object).intersectWith(PrEffectHelper.getGraphicsClipNoClone(graphics));
        if (!((BaseTransform)object2).is2D()) {
            object3 = graphics.getClipRect();
            graphics.setClipRect((Rectangle)object);
            NodeEffectInput nodeEffectInput = new NodeEffectInput(this.getClipNode(), NodeEffectInput$RenderType.FULL_CONTENT);
            NodeEffectInput nodeEffectInput2 = new NodeEffectInput(this, NodeEffectInput$RenderType.CLIPPED_CONTENT);
            Blend blend = new Blend(Blend$Mode.SRC_IN, nodeEffectInput, nodeEffectInput2);
            PrEffectHelper.render(blend, graphics, 0.0f, 0.0f, null);
            nodeEffectInput.flush();
            nodeEffectInput2.flush();
            graphics.setClipRect((Rectangle)object3);
            this.clearDirtyTree();
            return;
        }
        object3 = NGNode.getFilterContext(graphics);
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage((FilterContext)object3, ((Rectangle)object).width, ((Rectangle)object).height);
        if (prDrawable == null) {
            this.clearDirtyTree();
            return;
        }
        Graphics graphics2 = prDrawable.createGraphics();
        graphics2.setExtraAlpha(graphics.getExtraAlpha());
        graphics2.setHasPreCullingBits(graphics.hasPreCullingBits());
        graphics2.setClipRectIndex(graphics.getClipRectIndex());
        graphics2.translate(-((Rectangle)object).x, -((Rectangle)object).y);
        graphics2.transform((BaseTransform)object2);
        this.renderForClip(graphics2);
        PrDrawable prDrawable2 = (PrDrawable)Effect.getCompatibleImage((FilterContext)object3, ((Rectangle)object).width, ((Rectangle)object).height);
        if (prDrawable2 == null) {
            this.getClipNode().clearDirtyTree();
            Effect.releaseCompatibleImage((FilterContext)object3, prDrawable);
            return;
        }
        graphics2 = prDrawable2.createGraphics();
        graphics2.translate(-((Rectangle)object).x, -((Rectangle)object).y);
        graphics2.transform((BaseTransform)object2);
        this.getClipNode().render(graphics2);
        graphics.setTransform(null);
        object2 = new Blend(Blend$Mode.SRC_IN, new NGNode$PassThrough(prDrawable2, (Rectangle)object), new NGNode$PassThrough(prDrawable, (Rectangle)object));
        PrEffectHelper.render((Effect)object2, graphics, 0.0f, 0.0f, null);
        Effect.releaseCompatibleImage((FilterContext)object3, prDrawable);
        Effect.releaseCompatibleImage((FilterContext)object3, prDrawable2);
    }

    void renderForClip(Graphics graphics) {
        if (this.getEffectFilter() != null) {
            this.renderEffect(graphics);
            return;
        }
        this.renderContent(graphics);
    }

    private void renderOpacity(Graphics graphics) {
        if (this.getEffectFilter() != null || this.getCacheFilter() != null || this.getClipNode() != null || !this.hasOverlappingContents()) {
            float f2 = graphics.getExtraAlpha();
            graphics.setExtraAlpha(f2 * this.getOpacity());
            if (this.getCacheFilter() != null) {
                this.renderCached(graphics);
            } else if (this.getClipNode() != null) {
                this.renderClip(graphics);
            } else if (this.getEffectFilter() != null) {
                this.renderEffect(graphics);
            } else {
                this.renderContent(graphics);
            }
            graphics.setExtraAlpha(f2);
            return;
        }
        FilterContext filterContext = NGNode.getFilterContext(graphics);
        BaseTransform baseTransform = graphics.getTransformNoClone();
        Object object = this.getContentBounds(new RectBounds(), baseTransform);
        object = new Rectangle((BaseBounds)object);
        ((Rectangle)object).intersectWith(PrEffectHelper.getGraphicsClipNoClone(graphics));
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, ((Rectangle)object).width, ((Rectangle)object).height);
        if (prDrawable == null) {
            return;
        }
        Graphics graphics2 = prDrawable.createGraphics();
        graphics2.setHasPreCullingBits(graphics.hasPreCullingBits());
        graphics2.setClipRectIndex(graphics.getClipRectIndex());
        graphics2.translate(-((Rectangle)object).x, -((Rectangle)object).y);
        graphics2.transform(baseTransform);
        this.renderContent(graphics2);
        graphics.setTransform(null);
        float f3 = graphics.getExtraAlpha();
        graphics.setExtraAlpha(this.getOpacity() * f3);
        graphics.drawTexture((Texture)prDrawable.getTextureObject(), ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        graphics.setExtraAlpha(f3);
        Effect.releaseCompatibleImage(filterContext, prDrawable);
    }

    private void renderCached(Graphics graphics) {
        if (this.isContentBounds2D() && graphics.getTransformNoClone().is2D() && !(graphics instanceof PrinterGraphics)) {
            this.getCacheFilter().render(graphics);
            return;
        }
        this.renderContent(graphics);
    }

    protected void renderEffect(Graphics graphics) {
        this.getEffectFilter().render(graphics);
    }

    protected abstract void renderContent(Graphics var1);

    protected abstract boolean hasOverlappingContents();

    boolean isReadbackSupported(Graphics graphics) {
        return graphics instanceof ReadbackGraphics && ((ReadbackGraphics)graphics).canReadBack();
    }

    static FilterContext getFilterContext(Graphics graphics) {
        Screen screen = graphics.getAssociatedScreen();
        if (screen == null) {
            return PrFilterContext.getPrinterContext(graphics.getResourceFactory());
        }
        return PrFilterContext.getInstance(screen);
    }

    public void release() {
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    public void applyTransform(BaseTransform baseTransform, DirtyRegionContainer dirtyRegionContainer) {
        for (int i2 = 0; i2 < dirtyRegionContainer.size(); ++i2) {
            dirtyRegionContainer.setDirtyRegion(i2, (RectBounds)baseTransform.transform(dirtyRegionContainer.getDirtyRegion(i2), dirtyRegionContainer.getDirtyRegion(i2)));
            if (!dirtyRegionContainer.checkAndClearRegion(i2)) continue;
            --i2;
        }
    }

    public void applyClip(BaseBounds baseBounds, DirtyRegionContainer dirtyRegionContainer) {
        for (int i2 = 0; i2 < dirtyRegionContainer.size(); ++i2) {
            ((BaseBounds)dirtyRegionContainer.getDirtyRegion(i2)).intersectWith(baseBounds);
            if (!dirtyRegionContainer.checkAndClearRegion(i2)) continue;
            --i2;
        }
    }

    public void applyEffect(EffectFilter object, DirtyRegionContainer dirtyRegionContainer, DirtyRegionPool dirtyRegionPool) {
        object = ((EffectFilter)object).getEffect();
        NGNode$EffectDirtyBoundsHelper nGNode$EffectDirtyBoundsHelper = NGNode$EffectDirtyBoundsHelper.getInstance();
        nGNode$EffectDirtyBoundsHelper.setInputBounds(this.contentBounds);
        nGNode$EffectDirtyBoundsHelper.setDirtyRegions(dirtyRegionContainer);
        object = ((Effect)object).getDirtyRegions(nGNode$EffectDirtyBoundsHelper, dirtyRegionPool);
        dirtyRegionContainer.deriveWithNewContainer((DirtyRegionContainer)object);
        dirtyRegionPool.checkIn((DirtyRegionContainer)object);
    }
}

