/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.Translate2D;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayout$Hit;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.CharArrayIterator;
import com.sun.javafx.text.GlyphLayout;
import com.sun.javafx.text.LayoutCache;
import com.sun.javafx.text.TextLine;
import com.sun.javafx.text.TextRun;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;

public class PrismTextLayout
implements TextLayout {
    private static final BaseTransform IDENTITY = BaseTransform.IDENTITY_TRANSFORM;
    private static final int X_MIN_INDEX = 0;
    private static final int Y_MIN_INDEX = 1;
    private static final int X_MAX_INDEX = 2;
    private static final int Y_MAX_INDEX = 3;
    private static final Hashtable<Integer, LayoutCache> stringCache = new Hashtable();
    private static final Object CACHE_SIZE_LOCK = new Object();
    private static int cacheSize = 0;
    private static final int MAX_STRING_SIZE = 256;
    private static final int MAX_CACHE_SIZE = PrismFontFactory.cacheLayoutSize;
    private char[] text;
    private TextSpan[] spans;
    private PGFont font;
    private FontStrike strike;
    private Integer cacheKey;
    private TextLine[] lines;
    private TextRun[] runs;
    private int runCount;
    private BaseBounds logicalBounds = new RectBounds();
    private RectBounds visualBounds;
    private float layoutWidth;
    private float layoutHeight;
    private float wrapWidth;
    private float spacing;
    private LayoutCache layoutCache;
    private Shape shape;
    private int flags = 262144;
    private int tabSize = 8;

    private void reset() {
        this.layoutCache = null;
        this.runs = null;
        this.flags &= 0xFFFFF800;
        this.relayout();
    }

    private void relayout() {
        this.logicalBounds.makeEmpty();
        this.visualBounds = null;
        PrismTextLayout prismTextLayout = this;
        prismTextLayout.layoutHeight = 0.0f;
        prismTextLayout.layoutWidth = 0.0f;
        this.flags &= 0xFFFFF97F;
        this.lines = null;
        this.shape = null;
    }

    @Override
    public boolean setContent(TextSpan[] textSpanArray) {
        if (textSpanArray == null && this.spans == null) {
            return false;
        }
        if (textSpanArray != null && this.spans != null && textSpanArray.length == this.spans.length) {
            int n2;
            for (n2 = 0; n2 < textSpanArray.length && textSpanArray[n2] == this.spans[n2]; ++n2) {
            }
            if (n2 == textSpanArray.length) {
                return false;
            }
        }
        this.reset();
        this.spans = textSpanArray;
        this.font = null;
        this.strike = null;
        this.text = null;
        this.cacheKey = null;
        return true;
    }

    @Override
    public boolean setContent(String string, Object object) {
        int n2;
        this.reset();
        this.spans = null;
        this.font = (PGFont)object;
        this.strike = ((PGFont)object).getStrike(IDENTITY);
        this.text = string.toCharArray();
        if (MAX_CACHE_SIZE > 0 && (n2 = string.length()) > 0 && n2 <= 256) {
            this.cacheKey = string.hashCode() * this.strike.hashCode();
        }
        return true;
    }

    @Override
    public boolean setDirection(int n2) {
        if ((this.flags & 0x3C00) == n2) {
            return false;
        }
        this.flags &= 0xFFFFC3FF;
        this.flags |= n2 & 0x3C00;
        this.reset();
        return true;
    }

    @Override
    public boolean setBoundsType(int n2) {
        if ((this.flags & 0x4000) == n2) {
            return false;
        }
        this.flags &= 0xFFFFBFFF;
        this.flags |= n2 & 0x4000;
        this.reset();
        return true;
    }

    @Override
    public boolean setAlignment(int n2) {
        int n3 = 262144;
        switch (n2) {
            case 0: {
                n3 = 262144;
                break;
            }
            case 1: {
                n3 = 524288;
                break;
            }
            case 2: {
                n3 = 0x100000;
                break;
            }
            case 3: {
                n3 = 0x200000;
            }
        }
        if ((this.flags & 0x3C0000) == n3) {
            return false;
        }
        if (n3 == 0x200000 || (this.flags & 0x200000) != 0) {
            this.reset();
        }
        this.flags &= 0xFFC3FFFF;
        this.flags |= n3;
        this.relayout();
        return true;
    }

    @Override
    public boolean setWrapWidth(float f2) {
        if (Float.isInfinite(f2)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        float f3 = this.wrapWidth;
        this.wrapWidth = Math.max(0.0f, f2);
        boolean bl2 = true;
        if (this.lines != null && f3 != 0.0f && f2 != 0.0f && (this.flags & 0x40000) != 0) {
            if (f2 > f3) {
                if ((this.flags & 0x80) == 0) {
                    bl2 = false;
                }
            } else if (f2 >= this.layoutWidth) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.relayout();
        }
        return bl2;
    }

    @Override
    public boolean setLineSpacing(float f2) {
        if (this.spacing == f2) {
            return false;
        }
        this.spacing = f2;
        this.relayout();
        return true;
    }

    private void ensureLayout() {
        if (this.lines == null) {
            this.layout();
        }
    }

    @Override
    public com.sun.javafx.scene.text.TextLine[] getLines() {
        this.ensureLayout();
        return this.lines;
    }

    @Override
    public GlyphList[] getRuns() {
        this.ensureLayout();
        GlyphList[] glyphListArray = new GlyphList[this.runCount];
        int n2 = 0;
        for (int i2 = 0; i2 < this.lines.length; ++i2) {
            TextRun[] textRunArray = this.lines[i2].getRuns();
            int n3 = textRunArray.length;
            System.arraycopy(textRunArray, 0, glyphListArray, n2, n3);
            n2 += n3;
        }
        return glyphListArray;
    }

    @Override
    public BaseBounds getBounds() {
        this.ensureLayout();
        return this.logicalBounds;
    }

    @Override
    public BaseBounds getBounds(TextSpan textSpan, BaseBounds baseBounds) {
        this.ensureLayout();
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float f5 = Float.NEGATIVE_INFINITY;
        if (textSpan != null) {
            for (int i2 = 0; i2 < this.lines.length; ++i2) {
                TextLine textLine = this.lines[i2];
                TextRun[] textRunArray = textLine.getRuns();
                for (int i3 = 0; i3 < textRunArray.length; ++i3) {
                    TextRun textRun = textRunArray[i3];
                    Object object = textRun.getTextSpan();
                    if (object != textSpan) continue;
                    object = textRun.getLocation();
                    float f6 = ((Point2D)object).x;
                    if (textRun.isLeftBearing()) {
                        f6 += textLine.getLeftSideBearing();
                    }
                    float f7 = ((Point2D)object).x + textRun.getWidth();
                    if (textRun.isRightBearing()) {
                        f7 += textLine.getRightSideBearing();
                    }
                    float f8 = ((Point2D)object).y;
                    float f9 = ((Point2D)object).y + ((BaseBounds)textLine.getBounds()).getHeight() + this.spacing;
                    if (f6 < f2) {
                        f2 = f6;
                    }
                    if (f8 < f3) {
                        f3 = f8;
                    }
                    if (f7 > f4) {
                        f4 = f7;
                    }
                    if (!(f9 > f5)) continue;
                    f5 = f9;
                }
            }
        } else {
            f5 = 0.0f;
            f3 = 0.0f;
            for (int i4 = 0; i4 < this.lines.length; ++i4) {
                float f10;
                float f11;
                TextLine textLine = this.lines[i4];
                RectBounds rectBounds = textLine.getBounds();
                float f12 = ((BaseBounds)rectBounds).getMinX() + textLine.getLeftSideBearing();
                if (f11 < f2) {
                    f2 = f12;
                }
                float f13 = ((BaseBounds)rectBounds).getMaxX() + textLine.getRightSideBearing();
                if (f10 > f4) {
                    f4 = f13;
                }
                f5 += ((BaseBounds)rectBounds).getHeight();
            }
            if (this.isMirrored()) {
                float f14 = this.getMirroringWidth();
                float f15 = f2;
                f2 = f14 - f4;
                f4 = f14 - f15;
            }
        }
        return baseBounds.deriveWithNewBounds(f2, f3, 0.0f, f4, f5, 0.0f);
    }

    @Override
    public PathElement[] getCaretShape(int n2, boolean bl2, float f2, float f3) {
        float f4;
        float f5;
        float f6;
        int n3;
        int n4;
        TextLine textLine;
        int n5;
        int n6;
        this.ensureLayout();
        int n7 = this.getLineCount();
        for (n6 = 0; n6 < n7 - 1 && (n5 = (textLine = this.lines[n6]).getStart() + textLine.getLength()) <= n2; ++n6) {
        }
        int n8 = -1;
        n5 = 0;
        TextLine textLine2 = this.lines[n6];
        TextRun[] textRunArray = textLine2.getRuns();
        n6 = textRunArray.length;
        int n9 = -1;
        for (n4 = 0; n4 < n6; ++n4) {
            TextRun textRun = textRunArray[n4];
            int n10 = textRun.getStart();
            n3 = textRun.getEnd();
            if (n10 > n2 || n2 >= n3) continue;
            if (textRun.isLinebreak()) break;
            n9 = n4;
            break;
        }
        if (n9 != -1) {
            TextRun textRun = textRunArray[n9];
            int n11 = textRun.getStart();
            var14_29 = textRun.getLocation();
            f6 = var14_29.x + textRun.getXAtOffset(n2 - n11, bl2);
            f5 = var14_29.y;
            f4 = ((BaseBounds)textLine2.getBounds()).getHeight();
            if (bl2) {
                if (n9 > 0 && n2 == n11) {
                    n5 = textRun.getLevel();
                    n8 = n2 - 1;
                }
            } else {
                n3 = textRun.getEnd();
                if (n9 + 1 < textRunArray.length && n2 + 1 == n3) {
                    n5 = textRun.getLevel();
                    n8 = n2 + 1;
                }
            }
        } else {
            n4 = 0;
            n9 = 0;
            for (int i2 = 0; i2 < n6; ++i2) {
                TextRun textRun = textRunArray[i2];
                if (textRun.getStart() < n4 || textRun.isLinebreak()) continue;
                n4 = textRun.getStart();
                n9 = i2;
            }
            TextRun textRun = textRunArray[n9];
            var14_29 = textRun.getLocation();
            f6 = var14_29.x + (textRun.isLeftToRight() ? textRun.getWidth() : 0.0f);
            f5 = var14_29.y;
            f4 = ((BaseBounds)textLine2.getBounds()).getHeight();
        }
        if (this.isMirrored()) {
            f6 = this.getMirroringWidth() - f6;
        }
        f6 += f2;
        f5 += f3;
        if (n8 != -1) {
            for (int i3 = 0; i3 < textRunArray.length; ++i3) {
                TextRun textRun = textRunArray[i3];
                int n12 = textRun.getStart();
                n3 = textRun.getEnd();
                if (n12 > n8 || n8 >= n3 || (textRun.getLevel() & 1) == (n5 & 1)) continue;
                Point2D point2D = textRun.getLocation();
                float f7 = point2D.x;
                if (bl2) {
                    if ((n5 & 1) != 0) {
                        f7 += textRun.getWidth();
                    }
                } else if ((n5 & 1) == 0) {
                    f7 += textRun.getWidth();
                }
                if (this.isMirrored()) {
                    f7 = this.getMirroringWidth() - f7;
                }
                PathElement[] pathElementArray = new PathElement[4];
                PathElement[] pathElementArray2 = pathElementArray;
                pathElementArray[0] = new MoveTo(f6, f5);
                pathElementArray2[1] = new LineTo(f6, f5 + f4 / 2.0f);
                pathElementArray2[2] = new MoveTo(f7 += f2, f5 + f4 / 2.0f);
                pathElementArray2[3] = new LineTo(f7, f5 + f4);
                return pathElementArray2;
            }
        }
        PathElement[] pathElementArray = new PathElement[2];
        PathElement[] pathElementArray3 = pathElementArray;
        pathElementArray[0] = new MoveTo(f6, f5);
        pathElementArray3[1] = new LineTo(f6, f5 + f4);
        return pathElementArray3;
    }

    @Override
    public TextLayout$Hit getHitInfo(float f2, float f3) {
        int n2;
        boolean bl2 = false;
        this.ensureLayout();
        int n3 = this.getLineIndex(f3);
        if (n3 >= this.getLineCount()) {
            n2 = this.getCharCount();
            n3 = n2 + 1;
        } else {
            if (this.isMirrored()) {
                f2 = this.getMirroringWidth() - f2;
            }
            TextLine textLine = this.lines[n3];
            TextRun[] textRunArray = textLine.getRuns();
            RectBounds rectBounds = textLine.getBounds();
            TextRun textRun = null;
            f2 -= ((BaseBounds)rectBounds).getMinX();
            for (int i2 = 0; i2 < textRunArray.length && !(f2 < (textRun = textRunArray[i2]).getWidth()); ++i2) {
                if (i2 + 1 >= textRunArray.length) continue;
                if (textRunArray[i2 + 1].isLinebreak()) break;
                f2 -= textRun.getWidth();
            }
            if (textRun != null) {
                Object object = new int[1];
                n2 = textRun.getStart() + textRun.getOffsetAtX(f2, (int[])object);
                bl2 = object[0] == 0;
                n3 = n2;
                if (this.getText() != null && n3 < this.getText().length) {
                    if (!bl2) {
                        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
                        object = breakIterator;
                        breakIterator.setText(new String(this.getText()));
                        int n4 = ((BreakIterator)object).following(n3);
                        n3 = n4 == -1 ? ++n3 : n4;
                    }
                } else if (!bl2) {
                    ++n3;
                }
            } else {
                n2 = textLine.getStart();
                bl2 = true;
                n3 = n2;
            }
        }
        return new TextLayout$Hit(n2, n3, bl2);
    }

    @Override
    public PathElement[] getRange(int n2, int n3, int n4, float f2, float f3) {
        this.ensureLayout();
        int n5 = this.getLineCount();
        ArrayList<PathElement> arrayList = new ArrayList<PathElement>();
        float f4 = 0.0f;
        for (int i2 = 0; i2 < n5; ++i2) {
            TextRun[] textRunArray = this.lines[i2];
            RectBounds rectBounds = textRunArray.getBounds();
            int n6 = textRunArray.getStart();
            if (n6 >= n3) break;
            int n7 = n6 + textRunArray.getLength();
            if (n2 <= n7) {
                textRunArray = textRunArray.getRuns();
                n6 = Math.min(n7, n3) - Math.max(n6, n2);
                float f5 = -1.0f;
                float f6 = -1.0f;
                float f7 = ((BaseBounds)rectBounds).getMinX();
                for (n7 = 0; n6 > 0 && n7 < textRunArray.length; ++n7) {
                    TextRun textRun = textRunArray[n7];
                    int n8 = textRun.getStart();
                    int n9 = textRun.getEnd();
                    float f8 = textRun.getWidth();
                    int n10 = Math.max(n8, Math.min(n2, n9));
                    int n11 = Math.max(n8, Math.min(n3, n9));
                    n10 = n11 - n10;
                    if (n10 != 0) {
                        float f9;
                        n11 = textRun.isLeftToRight() ? 1 : 0;
                        float f10 = n8 > n2 ? (n11 != 0 ? f7 : f7 + f8) : f7 + textRun.getXAtOffset(n2 - n8, true);
                        if (f10 > (f9 = n9 < n3 ? (n11 != 0 ? f7 + f8 : f7) : f7 + textRun.getXAtOffset(n3 - n8, true))) {
                            float f11 = f10;
                            f10 = f9;
                            f9 = f11;
                        }
                        n6 -= n10;
                        float f12 = 0.0f;
                        float f13 = 0.0f;
                        switch (n4) {
                            case 1: {
                                f12 = f4;
                                f13 = f4 + ((BaseBounds)rectBounds).getHeight();
                                break;
                            }
                            case 2: 
                            case 4: {
                                FontStrike fontStrike;
                                Object object;
                                if (this.spans != null) {
                                    object = textRun.getTextSpan();
                                    PGFont pGFont = (PGFont)object.getFont();
                                    if (pGFont == null) break;
                                    fontStrike = pGFont.getStrike(IDENTITY);
                                } else {
                                    fontStrike = this.strike;
                                }
                                f12 = f4 - textRun.getAscent();
                                object = fontStrike.getMetrics();
                                f13 = n4 == 2 ? (f12 += object.getUnderLineOffset()) + object.getUnderLineThickness() : (f12 += object.getStrikethroughOffset()) + object.getStrikethroughThickness();
                            }
                        }
                        if (f10 != f6) {
                            if (f5 != -1.0f && f6 != -1.0f) {
                                float f14 = f5;
                                float f15 = f6;
                                if (this.isMirrored()) {
                                    float f16 = this.getMirroringWidth();
                                    f14 = f16 - f14;
                                    f15 = f16 - f15;
                                }
                                arrayList.add(new MoveTo(f2 + f14, f3 + f12));
                                arrayList.add(new LineTo(f2 + f15, f3 + f12));
                                arrayList.add(new LineTo(f2 + f15, f3 + f13));
                                arrayList.add(new LineTo(f2 + f14, f3 + f13));
                                arrayList.add(new LineTo(f2 + f14, f3 + f12));
                            }
                            f5 = f10;
                        }
                        f6 = f9;
                        if (n6 == 0) {
                            float f17 = f5;
                            float f18 = f6;
                            if (this.isMirrored()) {
                                float f19 = this.getMirroringWidth();
                                f17 = f19 - f17;
                                f18 = f19 - f18;
                            }
                            arrayList.add(new MoveTo(f2 + f17, f3 + f12));
                            arrayList.add(new LineTo(f2 + f18, f3 + f12));
                            arrayList.add(new LineTo(f2 + f18, f3 + f13));
                            arrayList.add(new LineTo(f2 + f17, f3 + f13));
                            arrayList.add(new LineTo(f2 + f17, f3 + f12));
                        }
                    }
                    f7 += f8;
                }
            }
            f4 += ((BaseBounds)rectBounds).getHeight() + this.spacing;
        }
        ArrayList<PathElement> arrayList2 = arrayList;
        return arrayList2.toArray(new PathElement[arrayList2.size()]);
    }

    @Override
    public Shape getShape(int n2, TextSpan textSpan) {
        this.ensureLayout();
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = (n2 & 4) != 0;
        int n3 = n2 = (n2 & 8) != 0 ? 1 : 0;
        if (this.shape != null && bl2 && !bl3 && !bl4 && n2 != 0) {
            return this.shape;
        }
        Path2D path2D = new Path2D();
        Translate2D translate2D = new Translate2D(0.0, 0.0);
        float f2 = 0.0f;
        if (n2 != 0) {
            f2 = -((BaseBounds)this.lines[0].getBounds()).getMinY();
        }
        for (n2 = 0; n2 < this.lines.length; ++n2) {
            Object object = this.lines[n2];
            TextRun[] textRunArray = ((TextLine)object).getRuns();
            object = ((TextLine)object).getBounds();
            float f3 = -((BaseBounds)object).getMinY();
            for (int i2 = 0; i2 < textRunArray.length; ++i2) {
                Shape shape;
                FontStrike fontStrike;
                Object object2;
                TextRun textRun = textRunArray[i2];
                if (this.spans != null) {
                    PGFont pGFont;
                    object2 = textRun.getTextSpan();
                    if (textSpan != null && object2 != textSpan || (pGFont = (PGFont)object2.getFont()) == null) continue;
                    fontStrike = pGFont.getStrike(IDENTITY);
                } else {
                    fontStrike = this.strike;
                }
                object2 = textRun.getLocation();
                float f4 = ((Point2D)object2).x;
                float f5 = ((Point2D)object2).y + f3 - f2;
                Metrics metrics = null;
                if (bl3 || bl4) {
                    metrics = fontStrike.getMetrics();
                }
                if (bl3) {
                    shape = new RoundRectangle2D();
                    new RoundRectangle2D().x = f4;
                    shape.y = f5 + metrics.getUnderLineOffset();
                    shape.width = textRun.getWidth();
                    shape.height = metrics.getUnderLineThickness();
                    path2D.append(shape, false);
                }
                if (bl4) {
                    shape = new RoundRectangle2D();
                    new RoundRectangle2D().x = f4;
                    shape.y = f5 + metrics.getStrikethroughOffset();
                    shape.width = textRun.getWidth();
                    shape.height = metrics.getStrikethroughThickness();
                    path2D.append(shape, false);
                }
                if (!bl2 || textRun.getGlyphCount() <= 0) continue;
                ((BaseTransform)translate2D).restoreTransform(1.0, 0.0, 0.0, 1.0, f4, f5);
                shape = (Path2D)fontStrike.getOutline(textRun, translate2D);
                path2D.append(shape, false);
            }
        }
        if (bl2 && !bl3 && !bl4) {
            this.shape = path2D;
        }
        return path2D;
    }

    @Override
    public boolean setTabSize(int n2) {
        if (n2 <= 0) {
            n2 = 1;
        }
        if (this.tabSize != n2) {
            this.tabSize = n2;
            this.relayout();
            return true;
        }
        return false;
    }

    private int getLineIndex(float f2) {
        int n2;
        float f3 = 0.0f;
        int n3 = this.getLineCount();
        for (n2 = 0; n2 < n3; ++n2) {
            f3 += ((BaseBounds)this.lines[n2].getBounds()).getHeight() + this.spacing;
            if (n2 + 1 == n3) {
                f3 -= this.lines[n2].getLeading();
            }
            if (f3 > f2) break;
        }
        return n2;
    }

    private boolean copyCache() {
        int n2 = this.flags & 0x3C0000;
        int n3 = this.flags & 0x4000;
        return this.wrapWidth != 0.0f || n2 != 262144 || n3 == 0 || this.isMirrored();
    }

    private void initCache() {
        if (this.cacheKey != null) {
            LayoutCache layoutCache;
            if (this.layoutCache == null && (layoutCache = stringCache.get(this.cacheKey)) != null && layoutCache.font.equals(this.font) && Arrays.equals(layoutCache.text, this.text)) {
                this.layoutCache = layoutCache;
                this.runs = layoutCache.runs;
                this.runCount = layoutCache.runCount;
                this.flags |= layoutCache.analysis;
            }
            if (this.layoutCache != null) {
                if (this.copyCache()) {
                    if (this.layoutCache.runs == this.runs) {
                        this.runs = new TextRun[this.runCount];
                        System.arraycopy(this.layoutCache.runs, 0, this.runs, 0, this.runCount);
                        return;
                    }
                } else if (this.layoutCache.lines != null) {
                    this.runs = this.layoutCache.runs;
                    this.runCount = this.layoutCache.runCount;
                    this.flags |= this.layoutCache.analysis;
                    this.lines = this.layoutCache.lines;
                    this.layoutWidth = this.layoutCache.layoutWidth;
                    this.layoutHeight = this.layoutCache.layoutHeight;
                    float f2 = ((BaseBounds)this.lines[0].getBounds()).getMinY();
                    this.logicalBounds = this.logicalBounds.deriveWithNewBounds(0.0f, f2, 0.0f, this.layoutWidth, this.layoutHeight + f2, 0.0f);
                }
            }
        }
    }

    private int getLineCount() {
        return this.lines.length;
    }

    private int getCharCount() {
        if (this.text != null) {
            return this.text.length;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.lines.length; ++i2) {
            n2 += this.lines[i2].getLength();
        }
        return n2;
    }

    public TextSpan[] getTextSpans() {
        return this.spans;
    }

    public PGFont getFont() {
        return this.font;
    }

    public int getDirection() {
        if ((this.flags & 0x400) != 0) {
            return 0;
        }
        if ((this.flags & 0x800) != 0) {
            return 1;
        }
        if ((this.flags & 0x1000) != 0) {
            return -2;
        }
        if ((this.flags & 0x2000) != 0) {
            return -1;
        }
        return -2;
    }

    public void addTextRun(TextRun textRun) {
        if (this.runCount + 1 > this.runs.length) {
            TextRun[] textRunArray = new TextRun[this.runs.length + 64];
            System.arraycopy(this.runs, 0, textRunArray, 0, this.runs.length);
            this.runs = textRunArray;
        }
        this.runs[this.runCount++] = textRun;
    }

    private void buildRuns(char[] cArray) {
        this.runCount = 0;
        if (this.runs == null) {
            int n2 = Math.max(4, Math.min(cArray.length / 16, 16));
            this.runs = new TextRun[n2];
        }
        GlyphLayout glyphLayout = GlyphLayout.getInstance();
        this.flags = glyphLayout.breakRuns(this, cArray, this.flags);
        glyphLayout.dispose();
        for (int i2 = this.runCount; i2 < this.runs.length; ++i2) {
            this.runs[i2] = null;
        }
    }

    private void shape(TextRun textRun, char[] objectArray, GlyphLayout glyphLayout) {
        float f2;
        FontStrike fontStrike;
        PGFont pGFont;
        Object object;
        if (this.spans != null) {
            if (this.spans.length == 0) {
                return;
            }
            object = textRun.getTextSpan();
            pGFont = (PGFont)object.getFont();
            if (pGFont == null) {
                RectBounds rectBounds = object.getBounds();
                textRun.setEmbedded(rectBounds, object.getText().length());
                return;
            }
            fontStrike = pGFont.getStrike(IDENTITY);
        } else {
            pGFont = this.font;
            fontStrike = this.strike;
        }
        if (textRun.getAscent() == 0.0f) {
            object = fontStrike.getMetrics();
            if ((this.flags & 0x4000) == 16384) {
                float f3;
                float f4 = object.getAscent();
                if (pGFont.getFamilyName().equals("Segoe UI")) {
                    f4 = (float)((double)f4 * 0.8);
                }
                f4 = (int)((double)f4 - 0.75);
                float f5 = (int)((double)object.getDescent() + 0.75);
                f2 = (int)((double)object.getLineGap() + 0.75);
                float f6 = (int)((double)object.getCapHeight() + 0.75);
                float f7 = -f4 - f6;
                if (f3 > f5) {
                    f5 = f7;
                } else {
                    f4 += f7 - f5;
                }
                textRun.setMetrics(f4, f5, f2);
            } else {
                textRun.setMetrics(object.getAscent(), object.getDescent(), object.getLineGap());
            }
        }
        if (textRun.isTab()) {
            return;
        }
        if (textRun.isLinebreak()) {
            return;
        }
        if (textRun.getGlyphCount() > 0) {
            return;
        }
        if (textRun.isComplex()) {
            glyphLayout.layout(textRun, pGFont, fontStrike, (char[])objectArray);
            return;
        }
        object = fontStrike.getFontResource();
        int n2 = textRun.getStart();
        int n3 = textRun.getLength();
        if (this.layoutCache == null) {
            f2 = fontStrike.getSize();
            CharToGlyphMapper charToGlyphMapper = object.getGlyphMapper();
            int[] nArray = new int[n3];
            charToGlyphMapper.charsToGlyphs(n2, n3, (char[])objectArray, nArray);
            objectArray = new float[n3 + 1 << 1];
            float f8 = 0.0f;
            for (int i2 = 0; i2 < n3; ++i2) {
                float f9 = object.getAdvance(nArray[i2], f2);
                objectArray[i2 << 1] = (char)f8;
                f8 += f9;
            }
            objectArray[n3 << 1] = (char)f8;
            textRun.shape(n3, nArray, (float[])objectArray, null);
            return;
        }
        if (!this.layoutCache.valid) {
            f2 = fontStrike.getSize();
            CharToGlyphMapper charToGlyphMapper = object.getGlyphMapper();
            charToGlyphMapper.charsToGlyphs(n2, n3, (char[])objectArray, this.layoutCache.glyphs, n2);
            int n4 = n2 + n3;
            float f10 = 0.0f;
            for (int i3 = n2; i3 < n4; ++i3) {
                float f11;
                this.layoutCache.advances[i3] = f11 = object.getAdvance(this.layoutCache.glyphs[i3], f2);
                f10 += f11;
            }
            textRun.setWidth(f10);
        }
        textRun.shape(n3, this.layoutCache.glyphs, this.layoutCache.advances);
    }

    private TextLine createLine(int n2, int n3, int n4) {
        n3 = n3 - n2 + 1;
        TextRun[] textRunArray = new TextRun[n3];
        if (n2 < this.runCount) {
            System.arraycopy(this.runs, n2, textRunArray, 0, n3);
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n5 = 0;
        for (int i2 = 0; i2 < textRunArray.length; ++i2) {
            TextRun textRun = textRunArray[i2];
            f2 += textRun.getWidth();
            f3 = Math.min(f3, textRun.getAscent());
            f4 = Math.max(f4, textRun.getDescent());
            f5 = Math.max(f5, textRun.getLeading());
            n5 += textRun.getLength();
        }
        if (f2 > this.layoutWidth) {
            this.layoutWidth = f2;
        }
        return new TextLine(n4, n5, textRunArray, f2, f3, f4, f5);
    }

    private void reorderLine(TextLine objectArray) {
        int n2 = (objectArray = objectArray.getRuns()).length;
        if (n2 > 0 && objectArray[n2 - 1].isLinebreak()) {
            --n2;
        }
        if (n2 < 2) {
            return;
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = objectArray[i2].getLevel();
        }
        Bidi.reorderVisually(byArray, 0, objectArray, 0, n2);
    }

    private char[] getText() {
        if (this.text == null) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.spans.length; ++n2) {
                n3 += this.spans[n2].getText().length();
            }
            this.text = new char[n3];
            n2 = 0;
            for (n3 = 0; n3 < this.spans.length; ++n3) {
                String string = this.spans[n3].getText();
                int n4 = string.length();
                string.getChars(0, n4, this.text, n2);
                n2 += n4;
            }
        }
        return this.text;
    }

    private boolean isSimpleLayout() {
        int n2 = this.flags & 0x3C0000;
        int n3 = n2 = this.wrapWidth > 0.0f && n2 == 0x200000 ? 1 : 0;
        return (this.flags & 0x18) == 0 && n2 == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMirrored() {
        boolean bl2 = false;
        switch (this.flags & 0x3C00) {
            case 2048: {
                return true;
            }
            case 1024: {
                return false;
            }
            case 4096: 
            case 8192: {
                if ((this.flags & 0x100) == 0) return false;
                return true;
            }
        }
        return bl2;
    }

    private float getMirroringWidth() {
        if (this.wrapWidth != 0.0f) {
            return this.wrapWidth;
        }
        return this.layoutWidth;
    }

    private void reuseRuns() {
        TextRun textRun;
        this.runCount = 0;
        int n2 = 0;
        block0: while (n2 < this.runs.length && (textRun = this.runs[n2]) != null) {
            TextRun textRun2;
            this.runs[n2] = null;
            ++n2;
            this.runs[this.runCount++] = textRun = textRun.unwrap();
            if (!textRun.isSplit()) continue;
            textRun.merge(null);
            while (n2 < this.runs.length && (textRun2 = this.runs[n2]) != null) {
                textRun.merge(textRun2);
                this.runs[n2] = null;
                ++n2;
                if (textRun2.isSplitLast()) continue block0;
            }
        }
    }

    private float getTabAdvance() {
        float f2 = 0.0f;
        if (this.spans != null) {
            for (int i2 = 0; i2 < this.spans.length; ++i2) {
                Object object = this.spans[i2];
                if ((object = (PGFont)object.getFont()) == null) continue;
                FontStrike fontStrike = object.getStrike(IDENTITY);
                f2 = fontStrike.getCharAdvance(' ');
                break;
            }
        } else {
            f2 = this.strike.getCharAdvance(' ');
        }
        return (float)this.tabSize * f2;
    }

    private void layout() {
        TextRun[] textRunArray;
        int n2;
        int n3;
        float f2;
        this.initCache();
        if (this.lines != null) {
            return;
        }
        char[] cArray = this.getText();
        if ((this.flags & 2) != 0 && this.isSimpleLayout()) {
            this.reuseRuns();
        } else {
            this.buildRuns(cArray);
        }
        GlyphLayout glyphLayout = null;
        if ((this.flags & 0x10) != 0) {
            glyphLayout = GlyphLayout.getInstance();
        }
        float f3 = 0.0f;
        if ((this.flags & 4) != 0) {
            f3 = this.getTabAdvance();
        }
        BreakIterator breakIterator = null;
        if (this.wrapWidth > 0.0f && (this.flags & 0x50) != 0) {
            breakIterator = BreakIterator.getLineInstance();
            breakIterator.setText(new CharArrayIterator(cArray));
        }
        int n4 = this.flags & 0x3C0000;
        if (this.isSimpleLayout()) {
            if (this.layoutCache == null) {
                this.layoutCache = new LayoutCache();
                this.layoutCache.glyphs = new int[cArray.length];
                this.layoutCache.advances = new float[cArray.length];
            }
        } else {
            this.layoutCache = null;
        }
        float f4 = 0.0f;
        int n5 = 0;
        int n6 = 0;
        ArrayList<TextLine> arrayList = new ArrayList<TextLine>();
        for (int i2 = 0; i2 < this.runCount; ++i2) {
            TextRun textRun = this.runs[i2];
            this.shape(textRun, cArray, glyphLayout);
            if (textRun.isTab()) {
                f2 = (float)((int)(f4 / f3) + 1) * f3;
                textRun.setWidth(f2 - f4);
            }
            f2 = textRun.getWidth();
            if (this.wrapWidth > 0.0f && f4 + f2 > this.wrapWidth && !textRun.isLinebreak()) {
                int n7;
                int n8;
                int n9;
                n3 = textRun.getStart() + textRun.getWrapIndex(this.wrapWidth - f4);
                int n10 = n3;
                if (n10 + 1 >= (n2 = textRun.getEnd()) || cArray[n10] == ' ') {
                    // empty if block
                }
                if (breakIterator != null) {
                    n9 = breakIterator.isBoundary(n10) || cArray[n10] == '\t' ? n10 : breakIterator.preceding(n10);
                } else {
                    n8 = Character.isWhitespace(cArray[n9]);
                    for (n9 = ++n10; n9 > n6; --n9) {
                        boolean bl2 = Character.isWhitespace(cArray[n9 - 1]);
                        if (n8 == 0 && bl2) break;
                        n8 = bl2 ? 1 : 0;
                    }
                }
                if (n9 < n6) {
                    n9 = n6;
                }
                TextRun textRun2 = null;
                for (n8 = n5; n8 < this.runCount && (textRun2 = this.runs[n8]).getEnd() <= n9; ++n8) {
                }
                if (n9 == n6) {
                    textRun2 = textRun;
                    n8 = i2;
                    n9 = n3;
                }
                if ((n7 = n9 - textRun2.getStart()) == 0 && n8 != n5) {
                    i2 = n8 - 1;
                } else {
                    i2 = n8;
                    if (n7 == 0) {
                        ++n7;
                    }
                    if (n7 < textRun2.getLength()) {
                        if (this.runCount >= this.runs.length) {
                            textRunArray = new TextRun[this.runs.length + 64];
                            System.arraycopy(this.runs, 0, textRunArray, 0, i2 + 1);
                            System.arraycopy(this.runs, i2 + 1, textRunArray, i2 + 2, this.runs.length - i2 - 1);
                            this.runs = textRunArray;
                        } else {
                            System.arraycopy(this.runs, i2 + 1, this.runs, i2 + 2, this.runCount - i2 - 1);
                        }
                        this.runs[i2 + 1] = textRun2.split(n7);
                        if (textRun2.isComplex()) {
                            this.shape(textRun2, cArray, glyphLayout);
                        }
                        ++this.runCount;
                    }
                }
                if (i2 + 1 < this.runCount && !this.runs[i2 + 1].isLinebreak()) {
                    textRun = this.runs[i2];
                    textRun.setSoftbreak();
                    this.flags |= 0x80;
                }
            }
            f4 += f2;
            if (!textRun.isBreak()) continue;
            TextLine textLine = this.createLine(n5, i2, n6);
            arrayList.add(textLine);
            n5 = i2 + 1;
            n6 += textLine.getLength();
            f4 = 0.0f;
        }
        if (glyphLayout != null) {
            glyphLayout.dispose();
        }
        arrayList.add(this.createLine(n5, this.runCount - 1, n6));
        this.lines = new TextLine[arrayList.size()];
        arrayList.toArray(this.lines);
        float f5 = Math.max(this.wrapWidth, this.layoutWidth);
        float f6 = 0.0f;
        if (this.isMirrored()) {
            f2 = 1.0f;
            if (n4 == 0x100000) {
                f2 = 0.0f;
            }
        } else {
            f2 = 0.0f;
            if (n4 == 0x100000) {
                f2 = 1.0f;
            }
        }
        if (n4 == 524288) {
            f2 = 0.5f;
        }
        for (n3 = 0; n3 < this.lines.length; ++n3) {
            TextRun[] textRunArray2;
            int n11;
            TextLine textLine = this.lines[n3];
            n2 = textLine.getStart();
            RectBounds rectBounds = textLine.getBounds();
            float f7 = (f5 - ((BaseBounds)rectBounds).getWidth()) * f2;
            textLine.setAlignment(f7);
            boolean bl3 = this.wrapWidth > 0.0f && n4 == 0x200000;
            if (bl3 && (n11 = (textRunArray2 = textLine.getRuns()).length) > 0 && textRunArray2[n11 - 1].isSoftbreak()) {
                int n12 = n2 + textLine.getLength();
                int n13 = 0;
                int n14 = 0;
                --n12;
                while (n12 >= n2) {
                    if (n14 == 0 && cArray[n12] != ' ') {
                        n14 = 1;
                    }
                    if (n14 != 0 && cArray[n12] == ' ') {
                        ++n13;
                    }
                    --n12;
                }
                if (n13 != 0) {
                    float f8 = (f5 - ((BaseBounds)rectBounds).getWidth()) / (float)n13;
                    block8: for (n14 = 0; n14 < n11; ++n14) {
                        TextRun textRun = textRunArray2[n14];
                        n5 = textRun.getStart();
                        n6 = textRun.getEnd();
                        for (int i3 = n5; i3 < n6; ++i3) {
                            if (cArray[i3] != ' ') continue;
                            textRun.justify(i3 - n5, f8);
                            if (--n13 == 0) break block8;
                        }
                    }
                    f7 = 0.0f;
                    textLine.setAlignment(0.0f);
                    textLine.setWidth(f5);
                }
            }
            if ((this.flags & 8) != 0) {
                this.reorderLine(textLine);
            }
            this.computeSideBearings(textLine);
            float f9 = f7;
            textRunArray = textLine.getRuns();
            for (int i4 = 0; i4 < textRunArray.length; ++i4) {
                TextRun textRun = textRunArray[i4];
                textRun.setLocation(f9, f6);
                textRun.setLine(textLine);
                f9 += textRun.getWidth();
            }
            if (n3 + 1 < this.lines.length) {
                float f10 = f6;
                f6 = Math.max(f10, f10 + ((BaseBounds)rectBounds).getHeight() + this.spacing);
                continue;
            }
            f6 += ((BaseBounds)rectBounds).getHeight() - textLine.getLeading();
        }
        float f11 = ((BaseBounds)this.lines[0].getBounds()).getMinY();
        this.layoutHeight = f6;
        this.logicalBounds = this.logicalBounds.deriveWithNewBounds(0.0f, f11, 0.0f, this.layoutWidth, this.layoutHeight + f11, 0.0f);
        if (this.layoutCache != null) {
            if (this.cacheKey != null && !this.layoutCache.valid && !this.copyCache()) {
                this.layoutCache.font = this.font;
                this.layoutCache.text = this.text;
                this.layoutCache.runs = this.runs;
                this.layoutCache.runCount = this.runCount;
                this.layoutCache.lines = this.lines;
                this.layoutCache.layoutWidth = this.layoutWidth;
                this.layoutCache.layoutHeight = this.layoutHeight;
                this.layoutCache.analysis = this.flags & 0x7FF;
                Object object = CACHE_SIZE_LOCK;
                synchronized (object) {
                    n2 = cArray.length;
                    if (cacheSize + n2 > MAX_CACHE_SIZE) {
                        stringCache.clear();
                        cacheSize = 0;
                    }
                    stringCache.put(this.cacheKey, this.layoutCache);
                    cacheSize += n2;
                }
            }
            this.layoutCache.valid = true;
        }
    }

    @Override
    public BaseBounds getVisualBounds(int n2) {
        int n3;
        this.ensureLayout();
        if (this.strike == null) {
            return null;
        }
        boolean bl2 = (n2 & 2) != 0;
        boolean bl3 = (this.flags & 0x200) != 0;
        n2 = (n2 & 4) != 0 ? 1 : 0;
        int n4 = n3 = (this.flags & 0x400) != 0 ? 1 : 0;
        if (this.visualBounds != null && bl2 == bl3 && n2 == n3) {
            return this.visualBounds;
        }
        this.flags &= 0xFFFFF9FF;
        if (bl2) {
            this.flags |= 0x200;
        }
        if (n2 != 0) {
            this.flags |= 0x400;
        }
        this.visualBounds = new RectBounds();
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float f5 = Float.NEGATIVE_INFINITY;
        float[] fArray = new float[4];
        FontResource fontResource = this.strike.getFontResource();
        Metrics metrics = this.strike.getMetrics();
        float f6 = this.strike.getSize();
        for (int i2 = 0; i2 < this.lines.length; ++i2) {
            TextRun[] textRunArray = this.lines[i2];
            textRunArray = textRunArray.getRuns();
            for (int i3 = 0; i3 < textRunArray.length; ++i3) {
                float f7;
                float f8;
                TextRun textRun = textRunArray[i3];
                Point2D point2D = textRun.getLocation();
                if (textRun.isLinebreak()) continue;
                int n5 = textRun.getGlyphCount();
                for (int i4 = 0; i4 < n5; ++i4) {
                    int n6 = textRun.getGlyphCode(i4);
                    if (n6 == 65535) continue;
                    fontResource.getGlyphBoundingBox(textRun.getGlyphCode(i4), f6, fArray);
                    if (fArray[0] == fArray[2]) continue;
                    f8 = point2D.x + textRun.getPosX(i4);
                    f7 = point2D.y + textRun.getPosY(i4);
                    float f9 = f8 + fArray[0];
                    float f10 = f7 - fArray[3];
                    f8 += fArray[2];
                    f7 -= fArray[1];
                    if (f9 < f2) {
                        f2 = f9;
                    }
                    if (f10 < f3) {
                        f3 = f10;
                    }
                    if (f8 > f4) {
                        f4 = f8;
                    }
                    if (!(f7 > f5)) continue;
                    f5 = f7;
                }
                if (bl2) {
                    float f11 = point2D.x;
                    float f12 = point2D.y + metrics.getUnderLineOffset();
                    f8 = f11 + textRun.getWidth();
                    f7 = f12 + metrics.getUnderLineThickness();
                    if (f11 < f2) {
                        f2 = f11;
                    }
                    if (f12 < f3) {
                        f3 = f12;
                    }
                    if (f8 > f4) {
                        f4 = f8;
                    }
                    if (f7 > f5) {
                        f5 = f7;
                    }
                }
                if (n2 == 0) continue;
                float f13 = point2D.x;
                float f14 = point2D.y + metrics.getStrikethroughOffset();
                f8 = f13 + textRun.getWidth();
                f7 = f14 + metrics.getStrikethroughThickness();
                if (f13 < f2) {
                    f2 = f13;
                }
                if (f14 < f3) {
                    f3 = f14;
                }
                if (f8 > f4) {
                    f4 = f8;
                }
                if (!(f7 > f5)) continue;
                f5 = f7;
            }
        }
        if (f2 < f4 && f3 < f5) {
            this.visualBounds.setBounds(f2, f3, f4, f5);
        }
        return this.visualBounds;
    }

    private void computeSideBearings(TextLine textLine) {
        int n2;
        Object object = textLine.getRuns();
        if (((TextRun[])object).length == 0) {
            return;
        }
        float[] fArray = new float[4];
        FontResource fontResource = null;
        float f2 = 0.0f;
        if (this.strike != null) {
            fontResource = this.strike.getFontResource();
            f2 = this.strike.getSize();
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        block0: for (int i2 = 0; i2 < ((TextRun[])object).length; ++i2) {
            TextRun textRun = object[i2];
            int n3 = textRun.getGlyphCount();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                float f5 = textRun.getAdvance(n2);
                if (f5 != 0.0f && (n4 = textRun.getGlyphCode(n2)) != 65535) {
                    FontResource fontResource2 = fontResource;
                    if (fontResource2 == null) {
                        Object object2 = textRun.getTextSpan();
                        object2 = (PGFont)object2.getFont();
                        f2 = object2.getSize();
                        fontResource2 = object2.getFontResource();
                    }
                    fontResource2.getGlyphBoundingBox(n4, f2, fArray);
                    float f6 = fArray[0];
                    f3 = Math.min(0.0f, f6 + f4);
                    textRun.setLeftBearing();
                    break block0;
                }
                f4 += f5;
            }
            if (n3 != 0) continue;
            f4 += textRun.getWidth();
        }
        float f7 = 0.0f;
        f4 = 0.0f;
        block2: for (int i3 = ((TextRun[])object).length - 1; i3 >= 0; --i3) {
            TextRun textRun = object[i3];
            n2 = textRun.getGlyphCount();
            for (int i4 = n2 - 1; i4 >= 0; --i4) {
                int n5;
                float f8 = textRun.getAdvance(i4);
                if (f8 != 0.0f && (n5 = textRun.getGlyphCode(i4)) != 65535) {
                    Object object3 = fontResource;
                    if (object3 == null) {
                        object3 = textRun.getTextSpan();
                        object = (PGFont)object3.getFont();
                        f2 = object.getSize();
                        object3 = object.getFontResource();
                    }
                    object3.getGlyphBoundingBox(n5, f2, fArray);
                    f7 = fArray[2] - f8;
                    f7 = Math.max(0.0f, f7 - f4);
                    textRun.setRightBearing();
                    break block2;
                }
                f4 += f8;
            }
            if (n2 != 0) continue;
            f4 += textRun.getWidth();
        }
        textLine.setSideBearings(f3, f7);
    }
}

