/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk;

import com.sun.javafx.FXPermissions;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;

public class PermissionHelper {
    private static boolean awtInitialized = false;
    private static Permission awtClipboardPermission;

    private static synchronized Permission getAWTClipboardPermission() {
        if (!awtInitialized) {
            try {
                GenericDeclaration genericDeclaration = Class.forName("java.awt.AWTPermission", false, PermissionHelper.class.getClassLoader());
                genericDeclaration = genericDeclaration.getConstructor(String.class);
                awtClipboardPermission = (Permission)((Constructor)genericDeclaration).newInstance("accessClipboard");
            }
            catch (Exception exception) {
                awtClipboardPermission = null;
            }
            awtInitialized = true;
        }
        return awtClipboardPermission;
    }

    public static void checkClipboardPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        try {
            securityManager.checkPermission(FXPermissions.ACCESS_CLIPBOARD_PERMISSION);
            return;
        }
        catch (SecurityException securityException) {
            Permission permission = PermissionHelper.getAWTClipboardPermission();
            if (permission == null) {
                throw securityException;
            }
            try {
                securityManager.checkPermission(permission);
                return;
            }
            catch (SecurityException securityException2) {
                throw securityException;
            }
        }
    }

    public static void checkClipboardPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if (accessControlContext == null) {
            throw new AccessControlException("AccessControlContext is null");
        }
        try {
            securityManager.checkPermission(FXPermissions.ACCESS_CLIPBOARD_PERMISSION, accessControlContext);
            return;
        }
        catch (SecurityException securityException) {
            Permission permission = PermissionHelper.getAWTClipboardPermission();
            if (permission == null) {
                throw securityException;
            }
            try {
                securityManager.checkPermission(permission, accessControlContext);
                return;
            }
            catch (SecurityException securityException2) {
                throw securityException;
            }
        }
    }

    private PermissionHelper() {
    }
}

