/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.AbstractEvents;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostDragStartListener;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.scene.input.KeyCodeMap;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.EmbeddedState;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.UploadingPainter;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint$Type;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.AccessController;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.scene.image.PixelFormat;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

final class EmbeddedScene
extends GlassScene
implements EmbeddedSceneInterface {
    private HostInterface host;
    private UploadingPainter painter;
    private PaintRenderJob paintRenderJob;
    private float renderScaleX;
    private float renderScaleY;
    private final EmbeddedSceneDnD embeddedDnD;
    private volatile IntBuffer texBits;
    private volatile int texLineStride;
    private volatile float texScaleFactorX = 1.0f;
    private volatile float texScaleFactorY = 1.0f;
    private volatile PixelFormat<?> pixelFormat;

    public EmbeddedScene(HostInterface object, boolean bl2, boolean bl3) {
        super(bl2, bl3);
        this.sceneState = new EmbeddedState(this);
        this.host = object;
        this.embeddedDnD = new EmbeddedSceneDnD(this);
        object = PaintCollector.getInstance();
        this.painter = new UploadingPainter(this);
        this.paintRenderJob = new PaintRenderJob(this, ((PaintCollector)object).getRendered(), this.painter);
        int n2 = Pixels.getNativeFormat();
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        if (n2 == 1 && byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.pixelFormat = PixelFormat.getIntArgbPreInstance();
        } else if (n2 == 2 && byteOrder == ByteOrder.BIG_ENDIAN) {
            this.pixelFormat = PixelFormat.getIntArgbInstance();
        }
        assert (this.pixelFormat != null);
    }

    @Override
    public final void dispose() {
        assert (this.host != null);
        QuantumToolkit.runWithRenderLock(() -> {
            this.host.setEmbeddedScene(null);
            this.host = null;
            this.updateSceneState();
            this.painter = null;
            this.paintRenderJob = null;
            this.texBits = null;
            return null;
        });
        super.dispose();
    }

    @Override
    final void setStage(GlassStage glassStage) {
        super.setStage(glassStage);
        assert (this.host != null);
        this.host.setEmbeddedScene(glassStage != null ? this : null);
    }

    @Override
    protected final boolean isSynchronous() {
        return false;
    }

    @Override
    public final void setRoot(NGNode nGNode) {
        super.setRoot(nGNode);
        this.painter.setRoot(nGNode);
    }

    @Override
    public final TKClipboard createDragboard(boolean bl2) {
        return this.embeddedDnD.createDragboard(bl2);
    }

    @Override
    public final void enableInputMethodEvents(boolean bl2) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.enableInputMethodEvents " + bl2);
        }
    }

    @Override
    public final void finishInputMethodComposition() {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.finishInputMethodComposition");
        }
    }

    @Override
    public final void setPixelScaleFactors(float f2, float f3) {
        this.renderScaleX = f2;
        this.renderScaleY = f3;
        this.entireSceneNeedsRepaint();
    }

    public final float getRenderScaleX() {
        return this.renderScaleX;
    }

    public final float getRenderScaleY() {
        return this.renderScaleY;
    }

    @Override
    public final PixelFormat<?> getPixelFormat() {
        return this.pixelFormat;
    }

    final void uploadPixels(Pixels pixels) {
        this.texBits = (IntBuffer)pixels.getPixels();
        this.texLineStride = pixels.getWidthUnsafe();
        this.texScaleFactorX = pixels.getScaleXUnsafe();
        this.texScaleFactorY = pixels.getScaleYUnsafe();
        if (this.host != null) {
            this.host.repaint();
        }
    }

    @Override
    public final void repaint() {
        Toolkit toolkit = Toolkit.getToolkit();
        toolkit.addRenderJob(this.paintRenderJob);
    }

    @Override
    public final boolean traverseOut(Direction direction) {
        if (direction == Direction.NEXT) {
            return this.host.traverseFocusOut(true);
        }
        if (direction == Direction.PREVIOUS) {
            return this.host.traverseFocusOut(false);
        }
        return false;
    }

    @Override
    public final void setSize(int n2, int n3) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener != null) {
                this.sceneListener.changedSize(n2, n3);
            }
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public final boolean getPixels(IntBuffer intBuffer, int n2, int n3) {
        return QuantumToolkit.runWithRenderLock(() -> {
            if (this.getRenderScaleX() != this.texScaleFactorX || this.getRenderScaleY() != this.texScaleFactorY || this.texBits == null) {
                return Boolean.FALSE;
            }
            n2 = (int)Math.ceil((float)n2 * this.texScaleFactorX);
            n3 = (int)Math.ceil((float)n3 * this.texScaleFactorY);
            intBuffer.rewind();
            this.texBits.rewind();
            if (intBuffer.capacity() != this.texBits.capacity()) {
                int n4 = Math.min(n2, this.texLineStride);
                n3 = Math.min(n3, this.texBits.capacity() / this.texLineStride);
                int[] nArray = new int[n4];
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.texBits.position(i2 * this.texLineStride);
                    this.texBits.get(nArray, 0, n4);
                    intBuffer.position(i2 * n2);
                    intBuffer.put(nArray);
                }
                return Boolean.TRUE;
            }
            intBuffer.put(this.texBits);
            return Boolean.TRUE;
        });
    }

    @Override
    protected final Color getClearColor() {
        if (this.fillPaint != null && this.fillPaint.getType() == Paint$Type.COLOR && ((Color)this.fillPaint).getAlpha() == 0.0f) {
            return (Color)this.fillPaint;
        }
        return super.getClearColor();
    }

    @Override
    public final void mouseEvent(int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n4, int n5, int n6, int n7, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            assert (n2 != 2);
            EventType<MouseEvent> eventType = AbstractEvents.mouseIDToFXEventID(n2);
            this.sceneListener.mouseEvent(eventType, n4, n5, n6, n7, AbstractEvents.mouseButtonToFXMouseButton(n3), bl11, false, bl7, bl8, bl9, bl10, bl2, bl3, bl4, bl5, bl6);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public final void scrollEvent(int n2, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            this.sceneListener.scrollEvent(AbstractEvents.scrollIDToFXEventType(n2), d2, d3, d4, d5, d6, d7, 0, 0, 0, 0, 0, d8, d9, d10, d11, bl2, bl3, bl4, bl5, false, bl6);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public final void inputMethodEvent(EventType<InputMethodEvent> eventType, ObservableList<InputMethodTextRun> observableList, String string, int n2) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener != null) {
                this.sceneListener.inputMethodEvent(eventType, observableList, string, n2);
            }
            return null;
        }));
    }

    @Override
    public final void menuEvent(int n2, int n3, int n4, int n5, boolean bl2) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener != null) {
                this.sceneListener.menuEvent(n2, n3, n4, n5, bl2);
            }
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public final void keyEvent(int n2, int n3, char[] cArray, int n4) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener != null) {
                boolean bl2 = (n4 & 1) != 0;
                boolean bl3 = (n4 & 2) != 0;
                boolean bl4 = (n4 & 4) != 0;
                n4 = (n4 & 8) != 0 ? 1 : 0;
                String string = new String(cArray);
                cArray = string;
                String string2 = string;
                KeyEvent keyEvent = new KeyEvent(AbstractEvents.keyIDToFXEventType(n2), (String)cArray, string2, KeyCodeMap.valueOf(n3), bl2, bl3, bl4, n4 != 0);
                this.sceneListener.keyEvent(keyEvent);
            }
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public final void zoomEvent(int n2, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            this.sceneListener.zoomEvent(AbstractEvents.zoomIDToFXEventType(n2), d2, d3, d4, d5, d6, d7, bl2, bl3, bl4, bl5, false, bl6);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public final void rotateEvent(int n2, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            this.sceneListener.rotateEvent(AbstractEvents.rotateIDToFXEventType(n2), d2, d3, d4, d5, d6, d7, bl2, bl3, bl4, bl5, false, bl6);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public final void swipeEvent(int n2, double d2, double d3, double d4, double d5, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            this.sceneListener.swipeEvent(AbstractEvents.swipeIDToFXEventType(n2), 0, d2, d3, d4, d5, bl2, bl3, bl4, bl5, false);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public final void setCursor(Object object) {
        super.setCursor(object);
        this.host.setCursor((CursorFrame)object);
    }

    @Override
    public final void setDragStartListener(HostDragStartListener hostDragStartListener) {
        this.embeddedDnD.setDragStartListener(hostDragStartListener);
    }

    @Override
    public final EmbeddedSceneDTInterface createDropTarget() {
        return this.embeddedDnD.createDropTarget();
    }

    @Override
    public final InputMethodRequests getInputMethodRequests() {
        return this.inputMethodRequests;
    }
}

