/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.embed.AbstractEvents;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.EmbeddedScene;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import javafx.application.Platform;

final class EmbeddedStage
extends GlassStage
implements EmbeddedStageInterface {
    private HostInterface host;

    public EmbeddedStage(HostInterface hostInterface) {
        this.host = hostInterface;
    }

    @Override
    public final TKScene createTKScene(boolean bl2, boolean bl3, AccessControlContext accessControlContext) {
        EmbeddedScene embeddedScene = new EmbeddedScene(this.host, bl2, bl3);
        embeddedScene.setSecurityContext(accessControlContext);
        return embeddedScene;
    }

    @Override
    public final void setScene(TKScene tKScene) {
        if (tKScene != null) assert (tKScene instanceof EmbeddedScene);
        super.setScene(tKScene);
    }

    @Override
    public final void setBounds(float f2, float f3, boolean bl2, boolean bl3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setBounds: x=" + f2 + " y=" + f3 + " xSet=" + bl2 + " ySet=" + bl3 + " w=" + f4 + " h= cw=" + f6 + " ch=" + f7);
        }
        f2 = f4 > 0.0f ? f4 : f6;
        float f12 = f3 = f5 > 0.0f ? f5 : f7;
        if (f2 > 0.0f && f3 > 0.0f) {
            this.host.setPreferredSize((int)f2, (int)f3);
        }
        GlassScene glassScene = this.getScene();
        if ((f10 > 0.0f || f11 > 0.0f) && glassScene instanceof EmbeddedScene) {
            glassScene = (EmbeddedScene)glassScene;
            if ((double)f10 <= 0.0) {
                f10 = ((EmbeddedScene)glassScene).getRenderScaleX();
            }
            if ((double)f11 <= 0.0) {
                f11 = ((EmbeddedScene)glassScene).getRenderScaleY();
            }
            ((EmbeddedScene)glassScene).setPixelScaleFactors(f10, f11);
        }
    }

    @Override
    public final float getPlatformScaleX() {
        return 1.0f;
    }

    @Override
    public final float getPlatformScaleY() {
        return 1.0f;
    }

    @Override
    public final float getOutputScaleX() {
        GlassScene glassScene = this.getScene();
        if (glassScene instanceof EmbeddedScene) {
            return ((EmbeddedScene)glassScene).getRenderScaleX();
        }
        return 1.0f;
    }

    @Override
    public final float getOutputScaleY() {
        GlassScene glassScene = this.getScene();
        if (glassScene instanceof EmbeddedScene) {
            return ((EmbeddedScene)glassScene).getRenderScaleY();
        }
        return 1.0f;
    }

    @Override
    public final void setMinimumSize(int n2, int n3) {
    }

    @Override
    public final void setMaximumSize(int n2, int n3) {
    }

    @Override
    protected final void setPlatformEnabled(boolean bl2) {
        super.setPlatformEnabled(bl2);
        this.host.setEnabled(bl2);
    }

    @Override
    public final void setIcons(List list) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setIcons");
        }
    }

    @Override
    public final void setTitle(String string) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setTitle " + string);
        }
    }

    @Override
    public final void setVisible(boolean bl2) {
        this.host.setEmbeddedStage(bl2 ? this : null);
        super.setVisible(bl2);
    }

    @Override
    public final void setOpacity(float f2) {
    }

    @Override
    public final void setIconified(boolean bl2) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.setIconified " + bl2);
        }
    }

    @Override
    public final void setMaximized(boolean bl2) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.setMaximized " + bl2);
        }
    }

    @Override
    public final void setAlwaysOnTop(boolean bl2) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.setAlwaysOnTop " + bl2);
        }
    }

    @Override
    public final void setResizable(boolean bl2) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setResizable " + bl2);
        }
    }

    @Override
    public final void setFullScreen(boolean bl2) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.setFullScreen " + bl2);
        }
    }

    @Override
    public final void requestFocus() {
        if (!this.host.requestFocus()) {
            return;
        }
        super.requestFocus();
    }

    @Override
    public final void toBack() {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.toBack");
        }
    }

    @Override
    public final void toFront() {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedStage.toFront");
        }
    }

    @Override
    public final boolean grabFocus() {
        return this.host.grabFocus();
    }

    @Override
    public final void ungrabFocus() {
        this.host.ungrabFocus();
    }

    private void notifyStageListener(Runnable runnable) {
        AccessControlContext accessControlContext = this.getAccessControlContext();
        AccessController.doPrivileged(() -> {
            runnable.run();
            return null;
        }, accessControlContext);
    }

    private void notifyStageListenerLater(Runnable runnable) {
        Platform.runLater(() -> this.notifyStageListener(runnable));
    }

    @Override
    public final void setLocation(int n2, int n3) {
        Runnable runnable = () -> {
            if (this.stageListener != null) {
                this.stageListener.changedLocation(n2, n3);
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(runnable);
            return;
        }
        this.notifyStageListenerLater(runnable);
    }

    @Override
    public final void setSize(int n2, int n3) {
        Runnable runnable = () -> {
            if (this.stageListener != null) {
                this.stageListener.changedSize(n2, n3);
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(runnable);
            return;
        }
        this.notifyStageListenerLater(runnable);
    }

    @Override
    public final void setFocused(boolean bl2, int n2) {
        Runnable runnable = () -> {
            if (this.stageListener != null) {
                this.stageListener.changedFocused(bl2, AbstractEvents.focusCauseToPeerFocusCause(n2));
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(runnable);
            return;
        }
        this.notifyStageListenerLater(runnable);
    }

    @Override
    public final void focusUngrab() {
        Runnable runnable = () -> {
            if (this.stageListener != null) {
                this.stageListener.focusUngrab();
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(runnable);
            return;
        }
        this.notifyStageListenerLater(runnable);
    }

    @Override
    public final void requestInput(String string, int n2, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final void releaseInput() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final void setRTL(boolean bl2) {
    }

    @Override
    public final void setEnabled(boolean bl2) {
    }

    @Override
    public final long getRawHandle() {
        return 0L;
    }
}

