/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.menu.CheckMenuItemBase;
import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.menu.MenuItemBase;
import com.sun.javafx.menu.RadioMenuItemBase;
import com.sun.javafx.menu.SeparatorMenuItemBase;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassMenuEventHandler;
import com.sun.javafx.tk.quantum.GlassSystemMenu$1;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.prism.Image;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableListBase;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyCombination$ModifierValue;

class GlassSystemMenu
implements TKSystemMenu {
    private List<MenuBase> systemMenus = null;
    private MenuBar glassSystemMenuBar = null;
    private InvalidationListener visibilityListener = observable -> {
        if (this.systemMenus != null) {
            GlassSystemMenu glassSystemMenu = this;
            glassSystemMenu.setMenus(glassSystemMenu.systemMenus);
        }
    };

    GlassSystemMenu() {
    }

    protected void createMenuBar() {
        if (this.glassSystemMenuBar == null) {
            Application application = Application.GetApplication();
            this.glassSystemMenuBar = application.createMenuBar();
            application.installDefaultMenus(this.glassSystemMenuBar);
            if (this.systemMenus != null) {
                GlassSystemMenu glassSystemMenu = this;
                glassSystemMenu.setMenus(glassSystemMenu.systemMenus);
            }
        }
    }

    protected MenuBar getMenuBar() {
        return this.glassSystemMenuBar;
    }

    @Override
    public boolean isSupported() {
        return Application.GetApplication().supportsSystemMenu();
    }

    @Override
    public void setMenus(List<MenuBase> list) {
        this.systemMenus = list;
        if (this.glassSystemMenuBar != null) {
            List<Menu> list2 = this.glassSystemMenuBar.getMenus();
            int n2 = list2.size();
            --n2;
            while (n2 > 0) {
                Menu object = list2.get(n2);
                this.clearMenu(object);
                this.glassSystemMenuBar.remove(n2);
                --n2;
            }
            for (MenuBase menuBase : list) {
                this.addMenu(null, menuBase);
            }
        }
    }

    private void clearMenu(Menu menu) {
        for (int i2 = menu.getItems().size() - 1; i2 >= 0; --i2) {
            Object object = menu.getItems().get(i2);
            if (object instanceof MenuItem) {
                ((MenuItem)object).setCallback(null);
                continue;
            }
            if (!(object instanceof Menu)) continue;
            this.clearMenu((Menu)object);
        }
        menu.setEventHandler(null);
    }

    private void addMenu(Menu menu, MenuBase menuBase) {
        if (menu != null) {
            this.insertMenu(menu, menuBase, menu.getItems().size());
            return;
        }
        this.insertMenu(menu, menuBase, this.glassSystemMenuBar.getMenus().size());
    }

    private void insertMenu(Menu menu, MenuBase menuBase, int n2) {
        Object object = Application.GetApplication();
        object = ((Application)object).createMenu(this.parseText(menuBase), !menuBase.isDisable());
        ((Menu)object).setEventHandler(new GlassMenuEventHandler(menuBase));
        menuBase.visibleProperty().removeListener(this.visibilityListener);
        menuBase.visibleProperty().addListener(this.visibilityListener);
        if (!menuBase.isVisible()) {
            return;
        }
        Object object2 = menuBase.getItemsBase();
        Object object3 = object2.filtered(menuItemBase -> menuItemBase.isVisible());
        ((ObservableListBase)object3).addListener(arg_0 -> this.lambda$insertMenu$2((Menu)object, arg_0));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object3 = (MenuItemBase)object2.next();
            if (object3 instanceof MenuBase) {
                this.addMenu((Menu)object, (MenuBase)object3);
                continue;
            }
            this.addMenuItem((Menu)object, (MenuItemBase)object3);
        }
        ((Menu)object).setPixels(this.getPixels(menuBase));
        this.setMenuBindings((Menu)object, menuBase);
        if (menu != null) {
            menu.insert((Menu)object, n2);
            return;
        }
        this.glassSystemMenuBar.insert((Menu)object, n2);
    }

    private void setMenuBindings(Menu menu, MenuBase menuBase) {
        menuBase.textProperty().addListener(observable -> menu.setTitle(this.parseText(menuBase)));
        menuBase.disableProperty().addListener(observable -> menu.setEnabled(!menuBase.isDisable()));
        menuBase.mnemonicParsingProperty().addListener(observable -> menu.setTitle(this.parseText(menuBase)));
    }

    private void addMenuItem(Menu menu, MenuItemBase menuItemBase) {
        this.insertMenuItem(menu, menuItemBase, menu.getItems().size());
    }

    private void insertMenuItem(Menu menu, MenuItemBase menuItemBase, int n2) {
        Object object = Application.GetApplication();
        menuItemBase.visibleProperty().removeListener(this.visibilityListener);
        menuItemBase.visibleProperty().addListener(this.visibilityListener);
        if (!menuItemBase.isVisible()) {
            return;
        }
        if (menuItemBase instanceof SeparatorMenuItemBase) {
            if (menuItemBase.isVisible()) {
                menu.insert(MenuItem.Separator, n2);
                return;
            }
        } else {
            GlassSystemMenu$1 glassSystemMenu$1 = new GlassSystemMenu$1(this, menuItemBase, menu);
            object = ((Application)object).createMenuItem(this.parseText(menuItemBase), glassSystemMenu$1);
            menuItemBase.textProperty().addListener(arg_0 -> this.lambda$insertMenuItem$6((MenuItem)object, menuItemBase, arg_0));
            ((MenuItem)object).setPixels(this.getPixels(menuItemBase));
            menuItemBase.graphicProperty().addListener(arg_0 -> this.lambda$insertMenuItem$7((MenuItem)object, menuItemBase, arg_0));
            ((MenuItem)object).setEnabled(!menuItemBase.isDisable());
            menuItemBase.disableProperty().addListener(arg_0 -> GlassSystemMenu.lambda$insertMenuItem$8((MenuItem)object, menuItemBase, arg_0));
            this.setShortcut((MenuItem)object, menuItemBase);
            menuItemBase.acceleratorProperty().addListener(arg_0 -> this.lambda$insertMenuItem$9((MenuItem)object, menuItemBase, arg_0));
            menuItemBase.mnemonicParsingProperty().addListener(arg_0 -> this.lambda$insertMenuItem$10((MenuItem)object, menuItemBase, arg_0));
            if (menuItemBase instanceof CheckMenuItemBase) {
                menuItemBase = (CheckMenuItemBase)menuItemBase;
                ((MenuItem)object).setChecked(menuItemBase.isSelected());
                menuItemBase.selectedProperty().addListener(arg_0 -> GlassSystemMenu.lambda$insertMenuItem$11((MenuItem)object, (CheckMenuItemBase)menuItemBase, arg_0));
            } else if (menuItemBase instanceof RadioMenuItemBase) {
                menuItemBase = (RadioMenuItemBase)menuItemBase;
                ((MenuItem)object).setChecked(menuItemBase.isSelected());
                menuItemBase.selectedProperty().addListener(arg_0 -> GlassSystemMenu.lambda$insertMenuItem$12((MenuItem)object, (RadioMenuItemBase)menuItemBase, arg_0));
            }
            menu.insert((MenuItem)object, n2);
        }
    }

    private String parseText(MenuItemBase menuItemBase) {
        String string = menuItemBase.getText();
        if (string == null) {
            return "";
        }
        if (!string.isEmpty() && menuItemBase.isMnemonicParsing()) {
            return string.replaceFirst("_([^_])", "$1");
        }
        return string;
    }

    private Pixels getPixels(MenuItemBase object) {
        if (object.getGraphic() instanceof ImageView) {
            object = (ImageView)object.getGraphic();
            if ((object = ((ImageView)object).getImage()) == null) {
                return null;
            }
            String string = ((javafx.scene.image.Image)object).getUrl();
            if (string == null || PixelUtils.supportedFormatType(string)) {
                object = (Image)Toolkit.getImageAccessor().getPlatformImage((javafx.scene.image.Image)object);
                if (object == null) {
                    return null;
                }
                return PixelUtils.imageToPixels((Image)object);
            }
        }
        return null;
    }

    private void setShortcut(MenuItem menuItem, MenuItemBase object) {
        block5: {
            block3: {
                block8: {
                    block6: {
                        block7: {
                            int n2;
                            Object object2;
                            block4: {
                                if ((object = object.getAccelerator()) == null) {
                                    menuItem.setShortcut(0, 0);
                                    return;
                                }
                                if (!(object instanceof KeyCodeCombination)) break block3;
                                object = (KeyCodeCombination)object;
                                object2 = ((KeyCodeCombination)object).getCode();
                                assert (PlatformUtil.isMac() || PlatformUtil.isLinux());
                                n2 = this.glassModifiers((KeyCombination)object);
                                if (!PlatformUtil.isMac()) break block4;
                                int n3 = ((KeyCode)((Object)object2)).isLetterKey() ? (int)((KeyCode)((Object)object2)).getChar().toUpperCase().charAt(0) : ((KeyCode)((Object)object2)).getCode();
                                menuItem.setShortcut(n3, n2);
                                break block5;
                            }
                            if (!PlatformUtil.isLinux()) break block6;
                            object2 = ((KeyCode)((Object)object2)).getChar().toLowerCase();
                            if ((n2 & 4) == 0) break block7;
                            menuItem.setShortcut(((String)object2).charAt(0), n2);
                            break block8;
                        }
                        menuItem.setShortcut(0, 0);
                        break block5;
                    }
                    menuItem.setShortcut(0, 0);
                }
                return;
            }
            if (object instanceof KeyCharacterCombination) {
                object = (KeyCharacterCombination)object;
                String string = ((KeyCharacterCombination)object).getCharacter();
                menuItem.setShortcut(string.charAt(0), this.glassModifiers((KeyCombination)object));
            }
        }
    }

    private int glassModifiers(KeyCombination object) {
        int n2;
        int n3 = 0;
        if (object.getShift() == KeyCombination$ModifierValue.DOWN) {
            ++n3;
        }
        if (object.getControl() == KeyCombination$ModifierValue.DOWN) {
            n3 += 4;
        }
        if (object.getAlt() == KeyCombination$ModifierValue.DOWN) {
            n3 += 8;
        }
        if (object.getShortcut() == KeyCombination$ModifierValue.DOWN) {
            if (PlatformUtil.isLinux()) {
                n3 += 4;
            } else if (PlatformUtil.isMac()) {
                n3 += 16;
            }
        }
        if (object.getMeta() == KeyCombination$ModifierValue.DOWN) {
            if (PlatformUtil.isLinux()) {
                n3 += 16;
            } else if (PlatformUtil.isMac()) {
                n3 += 16;
            }
        }
        if (object instanceof KeyCodeCombination && ((n2 = ((KeyCode)((Object)(object = ((KeyCodeCombination)object).getCode()))).getCode()) >= KeyCode.F1.getCode() && n2 <= KeyCode.F12.getCode() || n2 >= KeyCode.F13.getCode() && n2 <= KeyCode.F24.getCode())) {
            n3 += 2;
        }
        return n3;
    }

    private static /* synthetic */ void lambda$insertMenuItem$12(MenuItem menuItem, RadioMenuItemBase radioMenuItemBase, Observable observable) {
        menuItem.setChecked(radioMenuItemBase.isSelected());
    }

    private static /* synthetic */ void lambda$insertMenuItem$11(MenuItem menuItem, CheckMenuItemBase checkMenuItemBase, Observable observable) {
        menuItem.setChecked(checkMenuItemBase.isSelected());
    }

    private /* synthetic */ void lambda$insertMenuItem$10(MenuItem menuItem, MenuItemBase menuItemBase, Observable observable) {
        menuItem.setTitle(this.parseText(menuItemBase));
    }

    private /* synthetic */ void lambda$insertMenuItem$9(MenuItem menuItem, MenuItemBase menuItemBase, Observable observable) {
        this.setShortcut(menuItem, menuItemBase);
    }

    private static /* synthetic */ void lambda$insertMenuItem$8(MenuItem menuItem, MenuItemBase menuItemBase, Observable observable) {
        menuItem.setEnabled(!menuItemBase.isDisable());
    }

    private /* synthetic */ void lambda$insertMenuItem$7(MenuItem menuItem, MenuItemBase menuItemBase, Observable observable) {
        menuItem.setPixels(this.getPixels(menuItemBase));
    }

    private /* synthetic */ void lambda$insertMenuItem$6(MenuItem menuItem, MenuItemBase menuItemBase, Observable observable) {
        menuItem.setTitle(this.parseText(menuItemBase));
    }

    private /* synthetic */ void lambda$insertMenu$2(Menu menu, ListChangeListener$Change listChangeListener$Change) {
        while (listChangeListener$Change.next()) {
            Object object;
            int n2;
            int n3 = listChangeListener$Change.getFrom();
            int n4 = listChangeListener$Change.getTo();
            List list = listChangeListener$Change.getRemoved();
            for (n2 = n3 + list.size() - 1; n2 >= n3; --n2) {
                object = menu.getItems();
                if (n2 < 0 || object.size() <= n2) continue;
                menu.remove(n2);
            }
            for (n2 = n3; n2 < n4; ++n2) {
                object = (MenuItemBase)listChangeListener$Change.getList().get(n2);
                if (object instanceof MenuBase) {
                    this.insertMenu(menu, (MenuBase)object, n2);
                    continue;
                }
                this.insertMenuItem(menu, (MenuItemBase)object, n2);
            }
        }
    }
}

