/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.events.ViewEvent;
import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.View$EventHandler;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.tk.quantum.GestureRecognizers;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.GlassViewEventHandler$1;
import com.sun.javafx.tk.quantum.GlassViewEventHandler$KeyEventNotification;
import com.sun.javafx.tk.quantum.GlassViewEventHandler$MouseEventNotification;
import com.sun.javafx.tk.quantum.GlassViewEventHandler$ViewEventNotification;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.javafx.tk.quantum.ZoomGestureRecognizer;
import java.security.AccessController;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchPoint$State;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;

class GlassViewEventHandler
extends View$EventHandler {
    static boolean zoomGestureEnabled;
    static boolean rotateGestureEnabled;
    static boolean scrollGestureEnabled;
    private ViewScene scene;
    private final GlassSceneDnDEventHandler dndHandler;
    private final GestureRecognizers gestures;
    private final PaintCollector collector = PaintCollector.getInstance();
    private final GlassViewEventHandler$KeyEventNotification keyNotification = new GlassViewEventHandler$KeyEventNotification(this);
    private int mouseButtonPressedMask = 0;
    private final GlassViewEventHandler$MouseEventNotification mouseNotification = new GlassViewEventHandler$MouseEventNotification(this);
    private ClipboardAssistance dropSourceAssistant;
    private final GlassViewEventHandler$ViewEventNotification viewNotification = new GlassViewEventHandler$ViewEventNotification(this);

    public GlassViewEventHandler(ViewScene viewScene) {
        this.scene = viewScene;
        this.dndHandler = new GlassSceneDnDEventHandler(viewScene);
        this.gestures = new GestureRecognizers();
        if (PlatformUtil.isWindows() || PlatformUtil.isIOS() || PlatformUtil.isEmbedded()) {
            this.gestures.add(new SwipeGestureRecognizer(viewScene));
        }
        if (zoomGestureEnabled) {
            this.gestures.add(new ZoomGestureRecognizer(viewScene));
        }
        if (rotateGestureEnabled) {
            this.gestures.add(new RotateGestureRecognizer(viewScene));
        }
        if (scrollGestureEnabled) {
            this.gestures.add(new ScrollGestureRecognizer(viewScene));
        }
    }

    private static boolean allowableFullScreenKeys(int n2) {
        switch (n2) {
            case 9: 
            case 10: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private boolean checkFullScreenKeyEvent(int n2, int n3, char[] cArray, int n4) {
        return this.scene.getWindowStage().isTrustedFullScreen() || GlassViewEventHandler.allowableFullScreenKeys(n3);
    }

    private static EventType<KeyEvent> keyEventType(int n2) {
        switch (n2) {
            case 111: {
                return KeyEvent.KEY_PRESSED;
            }
            case 112: {
                return KeyEvent.KEY_RELEASED;
            }
            case 113: {
                return KeyEvent.KEY_TYPED;
            }
        }
        if (QuantumToolkit.verbose) {
            System.err.println("Unknown Glass key event type: " + n2);
        }
        return null;
    }

    @Override
    public void handleKeyEvent(View view, long l2, int n2, int n3, char[] cArray, int n4) {
        this.keyNotification.view = view;
        this.keyNotification.time = l2;
        this.keyNotification.type = n2;
        this.keyNotification.key = n3;
        this.keyNotification.chars = cArray;
        this.keyNotification.modifiers = n4;
        QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.keyNotification, this.scene.getAccessControlContext()));
    }

    private static EventType<MouseEvent> mouseEventType(int n2) {
        switch (n2) {
            case 221: {
                return MouseEvent.MOUSE_PRESSED;
            }
            case 222: {
                return MouseEvent.MOUSE_RELEASED;
            }
            case 225: {
                return MouseEvent.MOUSE_ENTERED;
            }
            case 226: {
                return MouseEvent.MOUSE_EXITED;
            }
            case 224: {
                return MouseEvent.MOUSE_MOVED;
            }
            case 223: {
                return MouseEvent.MOUSE_DRAGGED;
            }
            case 228: {
                throw new IllegalArgumentException("WHEEL event cannot be translated to MouseEvent, must be translated to ScrollEvent");
            }
        }
        if (QuantumToolkit.verbose) {
            System.err.println("Unknown Glass mouse event type: " + n2);
        }
        return null;
    }

    private static MouseButton mouseEventButton(int n2) {
        switch (n2) {
            case 212: {
                return MouseButton.PRIMARY;
            }
            case 213: {
                return MouseButton.SECONDARY;
            }
            case 214: {
                return MouseButton.MIDDLE;
            }
            case 215: {
                return MouseButton.BACK;
            }
            case 216: {
                return MouseButton.FORWARD;
            }
        }
        return MouseButton.NONE;
    }

    @Override
    public void handleMouseEvent(View view, long l2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2, boolean bl3) {
        this.mouseNotification.view = view;
        this.mouseNotification.time = l2;
        this.mouseNotification.type = n2;
        this.mouseNotification.button = n3;
        this.mouseNotification.x = n4;
        this.mouseNotification.y = n5;
        this.mouseNotification.xAbs = n6;
        this.mouseNotification.yAbs = n7;
        this.mouseNotification.modifiers = n8;
        this.mouseNotification.isPopupTrigger = bl2;
        this.mouseNotification.isSynthesized = bl3;
        QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.mouseNotification, this.scene.getAccessControlContext()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleMenuEvent(View view, int n2, int n3, int n4, int n5, boolean bl2) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("MENU_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    if ((view = ((View)view).getWindow()) != null) {
                        d7 = ((Window)((Object)view)).getPlatformScaleX();
                        d6 = ((Window)((Object)view)).getPlatformScaleY();
                        if ((view = ((Window)((Object)view)).getScreen()) != null) {
                            d5 = ((Screen)((Object)view)).getPlatformX();
                            d4 = ((Screen)((Object)view)).getPlatformY();
                            d3 = ((Screen)((Object)view)).getX();
                            d2 = ((Screen)((Object)view)).getY();
                        } else {
                            d2 = 0.0;
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        }
                    } else {
                        d6 = 1.0;
                        d7 = 1.0;
                        d2 = 0.0;
                        d3 = 0.0;
                        d4 = 0.0;
                        d5 = 0.0;
                    }
                    this.scene.sceneListener.menuEvent((double)n2 / d7, (double)n3 / d6, d3 + ((double)n4 - d5) / d7, d2 + ((double)n5 - d4) / d6, bl2);
                }
                return null;
            }, this.scene.getAccessControlContext()));
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleScrollEvent(View view, long l2, int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7, int n8, int n9, int n10, double d4, double d5) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SCROLL_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    if ((view = ((View)view).getWindow()) != null) {
                        d11 = ((Window)((Object)view)).getPlatformScaleX();
                        d10 = ((Window)((Object)view)).getPlatformScaleY();
                        if ((view = ((Window)((Object)view)).getScreen()) != null) {
                            d9 = ((Screen)((Object)view)).getPlatformX();
                            d8 = ((Screen)((Object)view)).getPlatformY();
                            d7 = ((Screen)((Object)view)).getX();
                            d6 = ((Screen)((Object)view)).getY();
                        } else {
                            d6 = 0.0;
                            d7 = 0.0;
                            d8 = 0.0;
                            d9 = 0.0;
                        }
                    } else {
                        d10 = 1.0;
                        d11 = 1.0;
                        d6 = 0.0;
                        d7 = 0.0;
                        d8 = 0.0;
                        d9 = 0.0;
                    }
                    this.scene.sceneListener.scrollEvent(ScrollEvent.SCROLL, d2 / d11, d3 / d10, 0.0, 0.0, d4, d5, 0, n8, n7, n10, n9, (double)n2 / d11, (double)n3 / d10, d7 + ((double)n4 - d9) / d11, d6 + ((double)n5 - d8) / d10, (n6 & 1) != 0, (n6 & 4) != 0, (n6 & 8) != 0, (n6 & 0x10) != 0, false, false);
                }
                return null;
            }, this.scene.getAccessControlContext()));
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    private static byte inputMethodEventAttrValue(int n2, int[] nArray, byte[] byArray) {
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                if (n2 < nArray[i2] || n2 >= nArray[i2 + 1]) continue;
                return byArray[i2];
            }
        }
        return 4;
    }

    private static ObservableList<InputMethodTextRun> inputMethodEventComposed(String string, int n2, int[] nArray, int[] nArray2, byte[] byArray) {
        GlassViewEventHandler$1 glassViewEventHandler$1 = new GlassViewEventHandler$1();
        if (n2 < string.length()) {
            if (nArray == null) {
                glassViewEventHandler$1.add(new InputMethodTextRun(string.substring(n2), InputMethodHighlight.UNSELECTED_RAW));
            } else {
                for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                    if (nArray[i2] < n2) continue;
                    glassViewEventHandler$1.add(new InputMethodTextRun(string.substring(nArray[i2], nArray[i2 + 1]), switch (GlassViewEventHandler.inputMethodEventAttrValue(nArray[i2], nArray2, byArray)) {
                        case 1 -> InputMethodHighlight.SELECTED_CONVERTED;
                        case 2 -> InputMethodHighlight.UNSELECTED_CONVERTED;
                        case 3 -> InputMethodHighlight.SELECTED_RAW;
                        default -> InputMethodHighlight.UNSELECTED_RAW;
                    }));
                }
            }
        }
        return glassViewEventHandler$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleInputMethodEvent(long l2, String string, int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("INPUT_METHOD_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    string = string != null ? string : "";
                    EventType<InputMethodEvent> eventType = InputMethodEvent.INPUT_METHOD_TEXT_CHANGED;
                    nArray = GlassViewEventHandler.inputMethodEventComposed(string, n2, nArray, nArray2, byArray);
                    string = string.substring(0, n2);
                    this.scene.sceneListener.inputMethodEvent(eventType, (ObservableList<InputMethodTextRun>)nArray, string, n3);
                }
                return null;
            }, this.scene.getAccessControlContext()));
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    @Override
    public double[] getInputMethodCandidatePos(int n2) {
        Point2D point2D = this.scene.inputMethodRequests.getTextLocation(n2);
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = point2D.getX();
        dArray2[1] = point2D.getY();
        return dArray2;
    }

    private static TransferMode actionToTransferMode(int n2) {
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1 || n2 == 0x40000001) {
            return TransferMode.COPY;
        }
        if (n2 == 2 || n2 == 0x40000002) {
            return TransferMode.MOVE;
        }
        if (n2 == 0x40000000) {
            return TransferMode.LINK;
        }
        if (n2 == 3) {
            if (QuantumToolkit.verbose) {
                System.err.println("Ambiguous drop action: " + Integer.toHexString(n2));
            }
        } else if (QuantumToolkit.verbose) {
            System.err.println("Unknown drop action: " + Integer.toHexString(n2));
        }
        return null;
    }

    private static int transferModeToAction(TransferMode transferMode) {
        if (transferMode == null) {
            return 0;
        }
        switch (transferMode) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        return 0;
    }

    @Override
    public int handleDragEnter(View object, int n2, int n3, int n4, int n5, int n6, ClipboardAssistance clipboardAssistance) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_ENTER");
        }
        try {
            object = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragEnter(n2, n3, n4, n5, GlassViewEventHandler.actionToTransferMode(n6), clipboardAssistance));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction((TransferMode)((Object)object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleDragLeave(View view, ClipboardAssistance clipboardAssistance) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_LEAVE");
        }
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragLeave(clipboardAssistance);
                return null;
            });
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    @Override
    public int handleDragDrop(View object, int n2, int n3, int n4, int n5, int n6, ClipboardAssistance clipboardAssistance) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_DROP");
        }
        try {
            object = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragDrop(n2, n3, n4, n5, GlassViewEventHandler.actionToTransferMode(n6), clipboardAssistance));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction((TransferMode)((Object)object));
    }

    @Override
    public int handleDragOver(View object, int n2, int n3, int n4, int n5, int n6, ClipboardAssistance clipboardAssistance) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_OVER");
        }
        try {
            object = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragOver(n2, n3, n4, n5, GlassViewEventHandler.actionToTransferMode(n6), clipboardAssistance));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction((TransferMode)((Object)object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleDragStart(View view, int n2, int n3, int n4, int n5, int n6, ClipboardAssistance clipboardAssistance) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_START");
        }
        this.dropSourceAssistant = clipboardAssistance;
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragStart(n2, n3, n4, n5, n6, clipboardAssistance);
                return null;
            });
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleDragEnd(View view, int n2) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_END");
        }
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragEnd(GlassViewEventHandler.actionToTransferMode(n2), this.dropSourceAssistant);
                return null;
            });
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleViewEvent(View view, long l2, int n2) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("VIEW_EVENT: " + ViewEvent.getTypeString(n2));
        }
        this.viewNotification.view = view;
        this.viewNotification.time = l2;
        this.viewNotification.type = n2;
        try {
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.viewNotification, this.scene.getAccessControlContext()));
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleScrollGestureEvent(View view, long l2, int n2, int n3, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, int n8, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SCROLL_GESTURE_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12;
                    double d13;
                    EventType<ScrollEvent> eventType = switch (n2) {
                        case 1 -> ScrollEvent.SCROLL_STARTED;
                        case 2 -> ScrollEvent.SCROLL;
                        case 3 -> ScrollEvent.SCROLL_FINISHED;
                        default -> throw new RuntimeException("Unknown scroll event type: " + n2);
                    };
                    view = ((View)view).getWindow();
                    if (view != null) {
                        d13 = ((Window)((Object)view)).getPlatformScaleX();
                        d12 = ((Window)((Object)view)).getPlatformScaleY();
                        if ((view = ((Window)((Object)view)).getScreen()) != null) {
                            d11 = ((Screen)((Object)view)).getPlatformX();
                            d10 = ((Screen)((Object)view)).getPlatformY();
                            d9 = ((Screen)((Object)view)).getX();
                            d8 = ((Screen)((Object)view)).getY();
                        } else {
                            d8 = 0.0;
                            d9 = 0.0;
                            d10 = 0.0;
                            d11 = 0.0;
                        }
                    } else {
                        d12 = 1.0;
                        d13 = 1.0;
                        d8 = 0.0;
                        d9 = 0.0;
                        d10 = 0.0;
                        d11 = 0.0;
                    }
                    this.scene.sceneListener.scrollEvent(eventType, d2 / d13, d3 / d12, d4 / d13, d5 / d12, d6, d7, n4, 0, 0, 0, 0, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5 / d13, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6 / d12, n7 == Integer.MAX_VALUE ? Double.NaN : d9 + ((double)n7 - d11) / d13, n8 == Integer.MAX_VALUE ? Double.NaN : d8 + ((double)n8 - d10) / d12, (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2, bl3);
                }
                return null;
            }, this.scene.getAccessControlContext()));
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleZoomGestureEvent(View view, long l2, int n2, int n3, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, double d2, double d3, double d4, double d5) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("ZOOM_GESTURE_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    EventType<ZoomEvent> eventType = switch (n2) {
                        case 1 -> ZoomEvent.ZOOM_STARTED;
                        case 2 -> ZoomEvent.ZOOM;
                        case 3 -> ZoomEvent.ZOOM_FINISHED;
                        default -> throw new RuntimeException("Unknown scroll event type: " + n2);
                    };
                    view = ((View)view).getWindow();
                    if (view != null) {
                        d9 = ((Window)((Object)view)).getPlatformScaleX();
                        d8 = ((Window)((Object)view)).getPlatformScaleY();
                        if ((view = ((Window)((Object)view)).getScreen()) != null) {
                            d7 = ((Screen)((Object)view)).getPlatformX();
                            d6 = ((Screen)((Object)view)).getPlatformY();
                            d5 = ((Screen)((Object)view)).getX();
                            d4 = ((Screen)((Object)view)).getY();
                        } else {
                            d4 = 0.0;
                            d5 = 0.0;
                            d6 = 0.0;
                            d7 = 0.0;
                        }
                    } else {
                        d8 = 1.0;
                        d9 = 1.0;
                        d4 = 0.0;
                        d5 = 0.0;
                        d6 = 0.0;
                        d7 = 0.0;
                    }
                    this.scene.sceneListener.zoomEvent(eventType, d2, d4, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4 / d9, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5 / d8, n6 == Integer.MAX_VALUE ? Double.NaN : d5 + ((double)n6 - d7) / d9, n7 == Integer.MAX_VALUE ? Double.NaN : d4 + ((double)n7 - d6) / d8, (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2, bl3);
                }
                return null;
            }, this.scene.getAccessControlContext()));
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleRotateGestureEvent(View view, long l2, int n2, int n3, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, double d2, double d3) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("ROTATE_GESTURE_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    EventType<RotateEvent> eventType = switch (n2) {
                        case 1 -> RotateEvent.ROTATION_STARTED;
                        case 2 -> RotateEvent.ROTATE;
                        case 3 -> RotateEvent.ROTATION_FINISHED;
                        default -> throw new RuntimeException("Unknown scroll event type: " + n2);
                    };
                    view = ((View)view).getWindow();
                    if (view != null) {
                        d9 = ((Window)((Object)view)).getPlatformScaleX();
                        d8 = ((Window)((Object)view)).getPlatformScaleY();
                        if ((view = ((Window)((Object)view)).getScreen()) != null) {
                            d7 = ((Screen)((Object)view)).getPlatformX();
                            d6 = ((Screen)((Object)view)).getPlatformY();
                            d5 = ((Screen)((Object)view)).getX();
                            d4 = ((Screen)((Object)view)).getY();
                        } else {
                            d4 = 0.0;
                            d5 = 0.0;
                            d6 = 0.0;
                            d7 = 0.0;
                        }
                    } else {
                        d8 = 1.0;
                        d9 = 1.0;
                        d4 = 0.0;
                        d5 = 0.0;
                        d6 = 0.0;
                        d7 = 0.0;
                    }
                    this.scene.sceneListener.rotateEvent(eventType, d2, d3, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4 / d9, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5 / d8, n6 == Integer.MAX_VALUE ? Double.NaN : d5 + ((double)n6 - d7) / d9, n7 == Integer.MAX_VALUE ? Double.NaN : d4 + ((double)n7 - d6) / d8, (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2, bl3);
                }
                return null;
            }, this.scene.getAccessControlContext()));
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleSwipeGestureEvent(View view, long l2, int n2, int n3, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SWIPE_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    EventType<SwipeEvent> eventType = switch (n5) {
                        case 1 -> SwipeEvent.SWIPE_UP;
                        case 2 -> SwipeEvent.SWIPE_DOWN;
                        case 3 -> SwipeEvent.SWIPE_LEFT;
                        case 4 -> SwipeEvent.SWIPE_RIGHT;
                        default -> throw new RuntimeException("Unknown swipe event direction: " + n5);
                    };
                    view = ((View)view).getWindow();
                    if (view != null) {
                        d7 = ((Window)((Object)view)).getPlatformScaleX();
                        d6 = ((Window)((Object)view)).getPlatformScaleY();
                        if ((view = ((Window)((Object)view)).getScreen()) != null) {
                            d5 = ((Screen)((Object)view)).getPlatformX();
                            d4 = ((Screen)((Object)view)).getPlatformY();
                            d3 = ((Screen)((Object)view)).getX();
                            d2 = ((Screen)((Object)view)).getY();
                        } else {
                            d2 = 0.0;
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        }
                    } else {
                        d6 = 1.0;
                        d7 = 1.0;
                        d2 = 0.0;
                        d3 = 0.0;
                        d4 = 0.0;
                        d5 = 0.0;
                    }
                    this.scene.sceneListener.swipeEvent(eventType, n4, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6 / d7, n7 == Integer.MAX_VALUE ? Double.NaN : (double)n7 / d6, n8 == Integer.MAX_VALUE ? Double.NaN : d3 + ((double)n8 - d5) / d7, n9 == Integer.MAX_VALUE ? Double.NaN : d2 + ((double)n9 - d4) / d6, (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2);
                }
                return null;
            }, this.scene.getAccessControlContext()));
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        }
        catch (Throwable throwable) {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
            PulseLogger.newInput(null);
            throw throwable;
        }
        PulseLogger.newInput(null);
    }

    @Override
    public void handleBeginTouchEvent(View object, long l2, int n2, boolean bl2, int n3) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("BEGIN_TOUCH_EVENT");
        }
        object = this.scene.getWindowStage();
        try {
            if (object != null) {
                ((WindowStage)object).setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    this.scene.sceneListener.touchEventBegin(l2, n3, bl2, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (object != null) {
                ((WindowStage)object).setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyBeginTouchEvent(l2, n2, bl2, n3);
    }

    @Override
    public void handleNextTouchEvent(View view, long l2, int n2, long l3, int n3, int n4, int n5, int n6) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("NEXT_TOUCH_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    TouchPoint$State touchPoint$State = switch (n2) {
                        case 811 -> TouchPoint$State.PRESSED;
                        case 812 -> TouchPoint$State.MOVED;
                        case 814 -> TouchPoint$State.STATIONARY;
                        case 813 -> TouchPoint$State.RELEASED;
                        default -> throw new RuntimeException("Unknown touch state: " + n2);
                    };
                    view = ((View)view).getWindow();
                    if (view != null) {
                        d7 = ((Window)((Object)view)).getPlatformScaleX();
                        d6 = ((Window)((Object)view)).getPlatformScaleY();
                        if ((view = ((Window)((Object)view)).getScreen()) != null) {
                            d5 = ((Screen)((Object)view)).getPlatformX();
                            d4 = ((Screen)((Object)view)).getPlatformY();
                            d3 = ((Screen)((Object)view)).getX();
                            d2 = ((Screen)((Object)view)).getY();
                        } else {
                            d2 = 0.0;
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        }
                    } else {
                        d6 = 1.0;
                        d7 = 1.0;
                        d2 = 0.0;
                        d3 = 0.0;
                        d4 = 0.0;
                        d5 = 0.0;
                    }
                    this.scene.sceneListener.touchEventNext(touchPoint$State, l3, (double)n3 / d7, (double)n4 / d6, d3 + ((double)n5 - d5) / d7, d2 + ((double)n6 - d4) / d6);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyNextTouchEvent(l2, n2, l3, n3, n4, n5, n6);
    }

    @Override
    public void handleEndTouchEvent(View object, long l2) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("END_TOUCH_EVENT");
        }
        object = this.scene.getWindowStage();
        try {
            if (object != null) {
                ((WindowStage)object).setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    this.scene.sceneListener.touchEventEnd();
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (object != null) {
                ((WindowStage)object).setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyEndTouchEvent(l2);
    }

    @Override
    public Accessible getSceneAccessible() {
        if (this.scene != null && this.scene.sceneListener != null) {
            return this.scene.sceneListener.getSceneAccessible();
        }
        return null;
    }

    static {
        AccessController.doPrivileged(() -> {
            zoomGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.zoom", "false"));
            rotateGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.rotate", "false"));
            scrollGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.scroll", "false"));
            return null;
        });
    }
}

