/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.tk.CompletionListener;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;

final class PaintCollector
implements CompletionListener {
    private static volatile PaintCollector collector;
    private static final Comparator<GlassScene> DIRTY_SCENE_SORTER;
    private final List<GlassScene> dirtyScenes = new ArrayList<GlassScene>();
    private volatile CountDownLatch allWorkCompletedLatch = new CountDownLatch(0);
    private volatile boolean hasDirty;
    private final QuantumToolkit toolkit;
    private volatile boolean needsHint;

    static PaintCollector createInstance(QuantumToolkit quantumToolkit) {
        collector = new PaintCollector(quantumToolkit);
        return collector;
    }

    static PaintCollector getInstance() {
        return collector;
    }

    private PaintCollector(QuantumToolkit quantumToolkit) {
        this.toolkit = quantumToolkit;
    }

    final void waitForRenderingToComplete() {
        while (true) {
            try {
                this.allWorkCompletedLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    final boolean hasDirty() {
        return this.hasDirty;
    }

    private final void setDirty(boolean bl2) {
        this.hasDirty = bl2;
        if (this.hasDirty) {
            QuantumToolkit.getToolkit().requestNextPulse();
        }
    }

    final void addDirtyScene(GlassScene glassScene) {
        assert (Thread.currentThread() == QuantumToolkit.getFxUserThread());
        assert (glassScene != null);
        if (QuantumToolkit.verbose) {
            System.err.println("PC.addDirtyScene: " + System.nanoTime() + String.valueOf(glassScene));
        }
        if (!this.dirtyScenes.contains(glassScene)) {
            this.dirtyScenes.add(glassScene);
            this.setDirty(true);
        }
    }

    final void removeDirtyScene(GlassScene glassScene) {
        assert (Thread.currentThread() == QuantumToolkit.getFxUserThread());
        assert (glassScene != null);
        if (QuantumToolkit.verbose) {
            System.err.println("PC.removeDirtyScene: " + String.valueOf(glassScene));
        }
        this.dirtyScenes.remove(glassScene);
        PaintCollector paintCollector = this;
        paintCollector.setDirty(!paintCollector.dirtyScenes.isEmpty());
    }

    final CompletionListener getRendered() {
        return this;
    }

    @Override
    public final void done(RenderJob object) {
        assert (Thread.currentThread() != QuantumToolkit.getFxUserThread());
        if (!(object instanceof PaintRenderJob)) {
            throw new IllegalArgumentException("PaintCollector: invalid RenderJob");
        }
        object = (PaintRenderJob)object;
        if ((object = ((PaintRenderJob)object).getScene()) == null) {
            throw new IllegalArgumentException("PaintCollector: null scene");
        }
        ((GlassScene)object).frameRendered();
        if (this.allWorkCompletedLatch.getCount() == 1L) {
            if (this.needsHint && !this.toolkit.hasNativeSystemVsync()) {
                this.toolkit.vsyncHint();
            }
            Application.GetApplication().notifyRenderingFinished();
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.renderEnd();
            }
        }
        this.allWorkCompletedLatch.countDown();
    }

    final void liveRepaintRenderJob(ViewScene object) {
        object = ((ViewScene)object).getPainter();
        QuantumToolkit quantumToolkit = (QuantumToolkit)QuantumToolkit.getToolkit();
        quantumToolkit.pulse(false);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        QuantumToolkit.runWithoutRenderLock(() -> PaintCollector.lambda$liveRepaintRenderJob$2(quantumToolkit, (ViewPainter)object, countDownLatch));
    }

    final void renderAll() {
        assert (Thread.currentThread() == QuantumToolkit.getFxUserThread());
        if (QuantumToolkit.pulseDebug) {
            System.err.println("PC.renderAll(" + this.dirtyScenes.size() + "): " + System.nanoTime());
        }
        if (!this.hasDirty) {
            return;
        }
        assert (!this.dirtyScenes.isEmpty());
        Collections.sort(this.dirtyScenes, DIRTY_SCENE_SORTER);
        this.setDirty(false);
        this.needsHint = false;
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.renderStart();
        }
        if (!Application.GetApplication().hasWindowManager()) {
            List<Window> list = Window.getWindows();
            this.allWorkCompletedLatch = new CountDownLatch(list.size());
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = list.get(i2);
                if ((object = WindowStage.findWindowStage((Window)object)) == null) continue;
                if (this.dirtyScenes.indexOf(object = ((WindowStage)object).getViewScene()) != -1 && !this.needsHint) {
                    this.needsHint = ((ViewScene)object).isSynchronous();
                }
                if (!PlatformUtil.useEGL() || i2 == n2 - 1) {
                    ((GlassScene)object).setDoPresent(true);
                } else {
                    ((GlassScene)object).setDoPresent(false);
                }
                try {
                    ((ViewScene)object).repaint();
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throwable.printStackTrace();
                }
            }
        } else {
            this.allWorkCompletedLatch = new CountDownLatch(this.dirtyScenes.size());
            for (GlassScene glassScene : this.dirtyScenes) {
                if (!this.needsHint) {
                    this.needsHint = glassScene.isSynchronous();
                }
                glassScene.setDoPresent(true);
                try {
                    glassScene.repaint();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throwable.printStackTrace();
                }
            }
        }
        this.dirtyScenes.clear();
        if (this.toolkit.shouldWaitForRenderingToComplete()) {
            this.waitForRenderingToComplete();
        }
    }

    private static /* synthetic */ Object lambda$liveRepaintRenderJob$2(QuantumToolkit quantumToolkit, ViewPainter viewPainter, CountDownLatch countDownLatch) {
        ((Toolkit)quantumToolkit).addRenderJob(new RenderJob((Runnable)viewPainter, renderJob -> countDownLatch.countDown()));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    static {
        DIRTY_SCENE_SORTER = (glassScene, glassScene2) -> {
            int n2 = glassScene.isSynchronous() ? 1 : 0;
            int n3 = glassScene2.isSynchronous() ? 1 : 0;
            return n2 - n3;
        };
    }
}

