/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.image.impl.ByteRgb;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.PixelFormat$DataType;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

class PixelUtils {
    private static ImageFormatDescription[] supportedFormats = ImageStorage.getInstance().getSupportedDescriptions();

    private PixelUtils() {
    }

    protected static boolean supportedFormatType(String string) {
        ImageFormatDescription[] imageFormatDescriptionArray = supportedFormats;
        int n2 = supportedFormats.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ImageFormatDescription imageFormatDescription = imageFormatDescriptionArray[i2];
            for (String string2 : imageFormatDescription.getExtensions()) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static Pixels imageToPixels(Image object) {
        Application application;
        Object object2;
        block7: {
            block9: {
                block8: {
                    object2 = ((Image)object).getDataType();
                    application = Application.GetApplication();
                    int n2 = Pixels.getNativeFormat();
                    if (object2 != PixelFormat$DataType.BYTE) break block7;
                    object2 = (ByteBuffer)((Image)object).getPixelBuffer();
                    int n3 = ((Image)object).getWidth();
                    int n4 = ((Image)object).getHeight();
                    int n5 = ((Image)object).getScanlineStride();
                    if (((Image)object).getBytesPerPixelUnit() != 3) break block8;
                    switch (n2) {
                        case 2: {
                            byte[] byArray = new byte[n3 * n4 << 2];
                            ByteRgb.ToByteArgbConverter().convert((ByteBuffer)object2, 0, n5, byArray, 0, n3 << 2, n3, n4);
                            object2 = ByteBuffer.wrap(byArray);
                            break block9;
                        }
                        case 1: {
                            byte[] byArray = new byte[n3 * n4 << 2];
                            ByteRgb.ToByteBgraPreConverter().convert((ByteBuffer)object2, 0, n5, byArray, 0, n3 << 2, n3, n4);
                            object2 = ByteBuffer.wrap(byArray);
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException("unhandled native format: " + n2);
                        }
                    }
                }
                if (((Image)object).getPixelFormat() != PixelFormat.BYTE_BGRA_PRE) {
                    throw new IllegalArgumentException("non-RGB image format");
                }
            }
            object = application.createPixels(((Image)object).getWidth(), ((Image)object).getHeight(), (ByteBuffer)object2, ((Image)object).getPixelScale(), ((Image)object).getPixelScale());
            return object;
        }
        if (object2 == PixelFormat$DataType.INT) {
            if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
                throw new UnsupportedOperationException("INT_ARGB_PRE only supported for LITTLE_ENDIAN machines");
            }
            object2 = (IntBuffer)((Image)object).getPixelBuffer();
            object = application.createPixels(((Image)object).getWidth(), ((Image)object).getHeight(), (IntBuffer)object2, ((Image)object).getPixelScale(), ((Image)object).getPixelScale());
            return object;
        }
        throw new IllegalArgumentException("unhandled image type: " + String.valueOf(object2));
    }

    public static Image pixelsToImage(Pixels pixels) {
        Buffer buffer = pixels.getPixels();
        if (pixels.getBytesPerComponent() == 1) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(buffer.capacity());
            byteBuffer.put((ByteBuffer)buffer);
            byteBuffer.rewind();
            return Image.fromByteBgraPreData(byteBuffer, pixels.getWidth(), pixels.getHeight());
        }
        if (pixels.getBytesPerComponent() == 4) {
            IntBuffer intBuffer = IntBuffer.allocate(buffer.capacity());
            intBuffer.put((IntBuffer)buffer);
            intBuffer.rewind();
            return Image.fromIntArgbPreData((IntBuffer)buffer, pixels.getWidth(), pixels.getHeight());
        }
        throw new IllegalArgumentException("unhandled pixel buffer: " + buffer.getClass().getName());
    }
}

