/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Screen;
import com.sun.javafx.tk.CompletionListener;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.QuantumRenderer$QuantumThreadFactory;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Presentable;
import com.sun.prism.ResourceFactory;
import com.sun.prism.impl.PrismSettings;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import java.security.AccessController;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class QuantumRenderer
extends ThreadPoolExecutor {
    private static boolean usePurgatory = AccessController.doPrivileged(() -> Boolean.getBoolean("decora.purgatory"));
    private static final AtomicReference<QuantumRenderer> instanceReference = new AtomicReference<Object>(null);
    private Thread _renderer;
    private Throwable _initThrowable = null;
    private CountDownLatch initLatch = new CountDownLatch(1);

    private QuantumRenderer() {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.setThreadFactory(new QuantumRenderer$QuantumThreadFactory(this));
    }

    protected final Throwable initThrowable() {
        return this._initThrowable;
    }

    private void setInitThrowable(Throwable throwable) {
        this._initThrowable = throwable;
    }

    protected final void createResourceFactory() {
        Object object = new CountDownLatch(1);
        Object object2 = arg_0 -> QuantumRenderer.lambda$createResourceFactory$1((CountDownLatch)object, arg_0);
        Runnable runnable = () -> {
            ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
            assert (resourceFactory != null);
        };
        object2 = new RenderJob(runnable, (CompletionListener)object2);
        this.submit((Runnable)object2);
        try {
            ((CountDownLatch)object).await();
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace(System.err);
            return;
        }
    }

    protected final void disposePresentable(Presentable object) {
        assert (!Thread.currentThread().equals(this._renderer));
        if (object instanceof GraphicsResource) {
            object = (GraphicsResource)object;
            object = () -> QuantumRenderer.lambda$disposePresentable$3((GraphicsResource)object);
            object = new RenderJob((Runnable)object, null);
            this.submit((Runnable)object);
        }
    }

    protected final void stopRenderer() {
        AccessController.doPrivileged(() -> {
            this.shutdown();
            return null;
        });
        if (PrismSettings.verbose) {
            System.out.println("QuantumRenderer: shutdown");
        }
        assert (this.isShutdown());
        instanceReference.set(null);
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t2) {
        return (RenderJob)runnable;
    }

    protected final Future submitRenderJob(RenderJob renderJob) {
        return this.submit(renderJob);
    }

    @Override
    public final void afterExecute(Runnable object, Throwable throwable) {
        super.afterExecute((Runnable)object, throwable);
        if (usePurgatory) {
            object = Screen.getMainScreen();
            object = Renderer.getRenderer(PrFilterContext.getInstance((Screen)object));
            ((Renderer)object).releasePurgatory();
        }
    }

    final void checkRendererIdle() {
        if (PrismSettings.threadCheck) {
            StackTraceElement[] stackTraceElementArray = PaintCollector.getInstance();
            int n2 = ViewPainter.renderLock.isLocked() && !ViewPainter.renderLock.isHeldByCurrentThread() ? 1 : 0;
            if (n2 != 0) {
                System.err.println("ERROR: PrismPen / FX threads co-running: DIRTY: " + stackTraceElementArray.hasDirty());
                for (StackTraceElement stackTraceElement : QuantumToolkit.getFxUserThread().getStackTrace()) {
                    System.err.println("FX: " + String.valueOf(stackTraceElement));
                }
                for (StackTraceElement stackTraceElement : this._renderer.getStackTrace()) {
                    System.err.println("QR: " + String.valueOf(stackTraceElement));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized QuantumRenderer getInstance() {
        if (instanceReference.get() != null) return instanceReference.get();
        Class<QuantumRenderer> clazz = QuantumRenderer.class;
        synchronized (QuantumRenderer.class) {
            QuantumRenderer quantumRenderer;
            block7: {
                quantumRenderer = null;
                try {
                    quantumRenderer = new QuantumRenderer();
                    quantumRenderer.prestartCoreThread();
                    quantumRenderer.initLatch.await();
                }
                catch (Throwable throwable) {
                    if (quantumRenderer != null) {
                        quantumRenderer.setInitThrowable(throwable);
                    }
                    if (!PrismSettings.verbose) break block7;
                    throwable.printStackTrace();
                }
            }
            if (quantumRenderer != null && quantumRenderer.initThrowable() != null) {
                if (!PrismSettings.noFallback) throw new RuntimeException(quantumRenderer.initThrowable());
                System.err.println("Cannot initialize a graphics pipeline, and Prism fallback is disabled");
                throw new InternalError("Could not initialize prism toolkit, and the fallback is disabled.");
            }
            instanceReference.set(quantumRenderer);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instanceReference.get();
        }
    }

    private static /* synthetic */ void lambda$disposePresentable$3(GraphicsResource graphicsResource) {
        graphicsResource.dispose();
    }

    private static /* synthetic */ void lambda$createResourceFactory$1(CountDownLatch countDownLatch, RenderJob renderJob) {
        countDownLatch.countDown();
    }
}

