/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.GestureRecognizer;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer$CenterComputer;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer$MultiTouchTracker;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer$SwipeRecognitionState;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer$TouchPointTracker;
import com.sun.javafx.tk.quantum.ViewScene;
import java.security.AccessController;
import javafx.event.EventType;
import javafx.scene.input.SwipeEvent;

class SwipeGestureRecognizer
implements GestureRecognizer {
    private static final double TANGENT_30_DEGREES = 0.577;
    private static final double TANGENT_45_DEGREES = 1.0;
    private static final boolean VERBOSE = false;
    private static final double DISTANCE_THRESHOLD = 10.0;
    private static final double BACKWARD_DISTANCE_THRASHOLD = 5.0;
    private SwipeGestureRecognizer$SwipeRecognitionState state = SwipeGestureRecognizer$SwipeRecognitionState.IDLE;
    SwipeGestureRecognizer$MultiTouchTracker tracker = new SwipeGestureRecognizer$MultiTouchTracker(this);
    private ViewScene scene;

    SwipeGestureRecognizer(ViewScene viewScene) {
        this.scene = viewScene;
    }

    @Override
    public void notifyBeginTouchEvent(long l2, int n2, boolean bl2, int n3) {
        this.tracker.params(n2, bl2);
    }

    @Override
    public void notifyNextTouchEvent(long l2, int n2, long l3, int n3, int n4, int n5, int n6) {
        switch (n2) {
            case 811: {
                this.tracker.pressed(l3, l2, n3, n4, n5, n6);
                return;
            }
            case 812: 
            case 814: {
                this.tracker.progress(l3, l2, n5, n6);
                return;
            }
            case 813: {
                this.tracker.released(l3, l2, n3, n4, n5, n6);
                return;
            }
        }
        throw new RuntimeException("Error in swipe gesture recognition: unknown touch state: " + String.valueOf((Object)this.state));
    }

    @Override
    public void notifyEndTouchEvent(long l2) {
    }

    private EventType<SwipeEvent> calcSwipeType(SwipeGestureRecognizer$TouchPointTracker swipeGestureRecognizer$TouchPointTracker) {
        double d2;
        double d3;
        double d4 = swipeGestureRecognizer$TouchPointTracker.getDistanceX();
        double d5 = swipeGestureRecognizer$TouchPointTracker.getDistanceY();
        double d6 = Math.abs(d4);
        boolean bl2 = d6 > (d3 = Math.abs(d5));
        double d7 = bl2 ? d4 : d5;
        double d8 = bl2 ? d6 : d3;
        double d9 = bl2 ? d3 : d6;
        double d10 = bl2 ? swipeGestureRecognizer$TouchPointTracker.lengthX : swipeGestureRecognizer$TouchPointTracker.lengthY;
        double d11 = bl2 ? swipeGestureRecognizer$TouchPointTracker.maxDeviationY : swipeGestureRecognizer$TouchPointTracker.maxDeviationX;
        double d12 = d2 = bl2 ? swipeGestureRecognizer$TouchPointTracker.lastXMovement : swipeGestureRecognizer$TouchPointTracker.lastYMovement;
        if (d8 <= 10.0) {
            return null;
        }
        if (d9 > d8 * 0.577) {
            return null;
        }
        if (d11 > d8) {
            return null;
        }
        int n2 = Integer.getInteger("com.sun.javafx.gestures.swipe.maxduration", 300);
        if (swipeGestureRecognizer$TouchPointTracker.getDuration() > (long)n2) {
            return null;
        }
        if (d10 > d8 * 1.5) {
            return null;
        }
        if (Math.signum(d7) != Math.signum(d2) && Math.abs(d2) > 5.0) {
            return null;
        }
        if (bl2) {
            if (swipeGestureRecognizer$TouchPointTracker.getDistanceX() < 0.0) {
                return SwipeEvent.SWIPE_LEFT;
            }
            return SwipeEvent.SWIPE_RIGHT;
        }
        if (swipeGestureRecognizer$TouchPointTracker.getDistanceY() < 0.0) {
            return SwipeEvent.SWIPE_UP;
        }
        return SwipeEvent.SWIPE_DOWN;
    }

    private void handleSwipeType(EventType<SwipeEvent> eventType, SwipeGestureRecognizer$CenterComputer swipeGestureRecognizer$CenterComputer, int n2, int n3, boolean bl2) {
        if (eventType == null) {
            return;
        }
        AccessController.doPrivileged(() -> {
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.swipeEvent(eventType, n2, swipeGestureRecognizer$CenterComputer.getX(), swipeGestureRecognizer$CenterComputer.getY(), swipeGestureRecognizer$CenterComputer.getAbsX(), swipeGestureRecognizer$CenterComputer.getAbsY(), (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }
}

