/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.AffineBase;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPerspectiveCamera;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.SceneState;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Image;
import com.sun.prism.Presentable;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.Paint$Type;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

abstract class ViewPainter
implements Runnable {
    private static NodePath[] ROOT_PATHS = new NodePath[PrismSettings.dirtyRegionCount];
    protected static final ReentrantLock renderLock = new ReentrantLock();
    protected int penWidth = -1;
    protected int penHeight = -1;
    protected int viewWidth;
    protected int viewHeight;
    protected final SceneState sceneState;
    protected Presentable presentable;
    protected ResourceFactory factory;
    protected boolean freshBackBuffer;
    private int width;
    private int height;
    private NGNode root;
    private NGNode overlayRoot;
    private Rectangle dirtyRect;
    private RectBounds clip;
    private RectBounds dirtyRegionTemp;
    private DirtyRegionPool dirtyRegionPool;
    private DirtyRegionContainer dirtyRegionContainer;
    private Affine3D tx;
    private Affine3D scaleTx;
    private GeneralTransform3D viewProjTx;
    private GeneralTransform3D projTx;
    private RTTexture sceneBuffer;

    protected ViewPainter(GlassScene glassScene) {
        this.sceneState = glassScene.getSceneState();
        if (this.sceneState == null) {
            throw new NullPointerException("Scene state is null");
        }
        if (PrismSettings.dirtyOptsEnabled) {
            this.tx = new Affine3D();
            this.viewProjTx = new GeneralTransform3D();
            this.projTx = new GeneralTransform3D();
            this.scaleTx = new Affine3D();
            this.clip = new RectBounds();
            this.dirtyRect = new Rectangle();
            this.dirtyRegionTemp = new RectBounds();
            this.dirtyRegionPool = new DirtyRegionPool(PrismSettings.dirtyRegionCount);
            this.dirtyRegionContainer = this.dirtyRegionPool.checkOut();
        }
    }

    protected final void setRoot(NGNode nGNode) {
        this.root = nGNode;
    }

    protected final void setOverlayRoot(NGNode nGNode) {
        this.overlayRoot = nGNode;
    }

    private void adjustPerspective(NGCamera nGCamera) {
        assert (PrismSettings.dirtyOptsEnabled);
        if (nGCamera instanceof NGPerspectiveCamera) {
            this.scaleTx.setToScale((double)this.width / 2.0, (double)(-this.height) / 2.0, 1.0);
            ((AffineBase)this.scaleTx).translate(1.0, -1.0);
            this.projTx.mul(this.scaleTx);
            this.viewProjTx = nGCamera.getProjViewTx(this.viewProjTx);
            this.projTx.mul(this.viewProjTx);
        }
    }

    protected void paintImpl(Graphics graphics) {
        int n2;
        int n3;
        if (this.width <= 0 || this.height <= 0 || graphics == null) {
            this.root.renderForcedContent(graphics);
            return;
        }
        Graphics graphics2 = graphics;
        float f2 = this.getPixelScaleFactorX();
        float f3 = this.getPixelScaleFactorY();
        graphics2.setPixelScaleFactors(f2, f3);
        int n4 = this.overlayRoot != null || this.freshBackBuffer || this.sceneState.getScene().isEntireSceneDirty() || this.sceneState.getScene().getDepthBuffer() || !PrismSettings.dirtyOptsEnabled ? 1 : 0;
        boolean bl2 = PrismSettings.showDirtyRegions || PrismSettings.showOverdraw;
        if (bl2 && !this.sceneState.getScene().getDepthBuffer()) {
            n3 = (int)Math.ceil((float)this.width * f2);
            n2 = (int)Math.ceil((float)this.height * f3);
            if (this.sceneBuffer != null) {
                this.sceneBuffer.lock();
                if (this.sceneBuffer.isSurfaceLost() || n3 != this.sceneBuffer.getContentWidth() || n2 != this.sceneBuffer.getContentHeight()) {
                    this.sceneBuffer.unlock();
                    this.sceneBuffer.dispose();
                    this.sceneBuffer = null;
                }
            }
            if (this.sceneBuffer == null) {
                this.sceneBuffer = graphics2.getResourceFactory().createRTTexture(n3, n2, Texture$WrapMode.CLAMP_TO_ZERO, false);
                n4 = 1;
            }
            this.sceneBuffer.contentsUseful();
            graphics2 = this.sceneBuffer.createGraphics();
            graphics2.setPixelScaleFactors(f2, f3);
            graphics2.scale(f2, f3);
        } else if (this.sceneBuffer != null) {
            this.sceneBuffer.dispose();
            this.sceneBuffer = null;
        }
        n3 = -1;
        if (n4 == 0) {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newPhase("Dirty Opts Computed");
            }
            this.clip.setBounds(0.0f, 0.0f, this.width, this.height);
            this.dirtyRegionTemp.makeEmpty();
            this.dirtyRegionContainer.reset();
            ((BaseTransform)this.tx).setToIdentity();
            this.projTx.setIdentity();
            ViewPainter viewPainter = this;
            viewPainter.adjustPerspective(viewPainter.sceneState.getCamera());
            n3 = this.root.accumulateDirtyRegions(this.clip, this.dirtyRegionTemp, this.dirtyRegionPool, this.dirtyRegionContainer, this.tx, this.projTx);
            this.dirtyRegionContainer.roundOut();
            if (n3 == 1) {
                this.root.doPreCulling(this.dirtyRegionContainer, this.tx, this.projTx);
            }
        }
        if ((n2 = n3 == 1 ? this.dirtyRegionContainer.size() : 0) > 0) {
            int n5;
            graphics2.setHasPreCullingBits(true);
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newPhase("Render Roots Discovered");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                NodePath nodePath = ViewPainter.getRootPath(n4);
                nodePath.clear();
                this.root.getRenderRoot(ViewPainter.getRootPath(n4), this.dirtyRegionContainer.getDirtyRegion(n4), n4, this.tx, this.projTx);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.addMessage(n2 + " different dirty regions to render");
                n4 = 0;
                while (n4 < n2) {
                    PulseLogger.addMessage("Dirty Region " + n4 + ": " + String.valueOf(this.dirtyRegionContainer.getDirtyRegion(n4)));
                    int n6 = n4++;
                    PulseLogger.addMessage("Render Root Path " + n6 + ": " + String.valueOf(ViewPainter.getRootPath(n6)));
                }
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED && PrismSettings.printRenderGraph) {
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList<NGNode> arrayList = new ArrayList<NGNode>();
                for (n5 = 0; n5 < n2; ++n5) {
                    RectBounds rectBounds;
                    Object object = this.dirtyRegionContainer.getDirtyRegion(n5);
                    if (!(((BaseBounds)rectBounds).getWidth() > 0.0f) || !(((BaseBounds)object).getHeight() > 0.0f) || ((NodePath)(object = ViewPainter.getRootPath(n5))).isEmpty()) continue;
                    arrayList.add(((NodePath)object).last());
                }
                this.root.printDirtyOpts(stringBuilder, arrayList);
                PulseLogger.addMessage(stringBuilder.toString());
            }
            for (n4 = 0; n4 < n2; ++n4) {
                int n7;
                RectBounds rectBounds;
                RectBounds rectBounds2 = this.dirtyRegionContainer.getDirtyRegion(n4);
                if (!(((BaseBounds)rectBounds).getWidth() > 0.0f) || !(((BaseBounds)rectBounds2).getHeight() > 0.0f)) continue;
                this.dirtyRect.x = n5 = (int)Math.floor(((BaseBounds)rectBounds2).getMinX() * f2);
                this.dirtyRect.y = n7 = (int)Math.floor(((BaseBounds)rectBounds2).getMinY() * f3);
                this.dirtyRect.width = (int)Math.ceil(((BaseBounds)rectBounds2).getMaxX() * f2) - n5;
                this.dirtyRect.height = (int)Math.ceil(((BaseBounds)rectBounds2).getMaxY() * f3) - n7;
                graphics2.setClipRect(this.dirtyRect);
                graphics2.setClipRectIndex(n4);
                this.doPaint(graphics2, ViewPainter.getRootPath(n4));
                ViewPainter.getRootPath(n4).clear();
            }
        } else {
            graphics2.setHasPreCullingBits(false);
            graphics2.setClipRect(null);
            this.doPaint(graphics2, null);
        }
        this.root.renderForcedContent(graphics2);
        if (this.overlayRoot != null) {
            this.overlayRoot.render(graphics2);
        }
        if (bl2) {
            if (this.sceneBuffer != null) {
                graphics2.sync();
                graphics.clear();
                graphics.drawTexture(this.sceneBuffer, 0.0f, 0.0f, this.width, this.height, this.sceneBuffer.getContentX(), this.sceneBuffer.getContentY(), this.sceneBuffer.getContentX() + this.sceneBuffer.getContentWidth(), this.sceneBuffer.getContentY() + this.sceneBuffer.getContentHeight());
                this.sceneBuffer.unlock();
            }
            if (PrismSettings.showOverdraw) {
                if (n2 > 0) {
                    for (n4 = 0; n4 < n2; ++n4) {
                        Rectangle rectangle = new Rectangle(this.dirtyRegionContainer.getDirtyRegion(n4));
                        graphics.setClipRectIndex(n4);
                        this.paintOverdraw(graphics, rectangle);
                        graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else {
                    Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
                    assert (graphics.getClipRectIndex() == 0);
                    this.paintOverdraw(graphics, rectangle);
                    graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else if (n2 > 0) {
                graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                for (n4 = 0; n4 < n2; ++n4) {
                    RectBounds rectBounds = this.dirtyRegionContainer.getDirtyRegion(n4);
                    graphics.fillRect(((BaseBounds)rectBounds).getMinX(), ((BaseBounds)rectBounds).getMinY(), ((BaseBounds)rectBounds).getWidth(), ((BaseBounds)rectBounds).getHeight());
                }
            } else {
                graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                graphics.fillRect(0.0f, 0.0f, this.width, this.height);
            }
            this.root.clearPainted();
        }
    }

    private void paintOverdraw(Graphics graphics, Rectangle rectangle) {
        Object object = new int[rectangle.width * rectangle.height];
        this.root.drawDirtyOpts(BaseTransform.IDENTITY_TRANSFORM, this.projTx, rectangle, (int[])object, graphics.getClipRectIndex());
        object = Image.fromIntArgbPreData((int[])object, rectangle.width, rectangle.height);
        object = this.factory.getCachedTexture((Image)object, Texture$WrapMode.CLAMP_TO_EDGE);
        graphics.drawTexture((Texture)object, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0.0f, 0.0f, rectangle.width, rectangle.height);
        object.unlock();
    }

    private static NodePath getRootPath(int n2) {
        if (ROOT_PATHS[n2] == null) {
            ViewPainter.ROOT_PATHS[n2] = new NodePath();
        }
        return ROOT_PATHS[n2];
    }

    protected void disposePresentable() {
        if (this.presentable instanceof GraphicsResource) {
            ((GraphicsResource)((Object)this.presentable)).dispose();
        }
        this.presentable = null;
    }

    protected boolean validateStageGraphics() {
        if (!this.sceneState.isValid()) {
            return false;
        }
        ViewPainter viewPainter = this;
        viewPainter.width = viewPainter.viewWidth = this.sceneState.getWidth();
        ViewPainter viewPainter2 = this;
        viewPainter2.height = viewPainter2.viewHeight = this.sceneState.getHeight();
        return this.sceneState.isWindowVisible() && !this.sceneState.isWindowMinimized();
    }

    protected float getPixelScaleFactorX() {
        if (this.presentable == null) {
            return 1.0f;
        }
        return this.presentable.getPixelScaleFactorX();
    }

    protected float getPixelScaleFactorY() {
        if (this.presentable == null) {
            return 1.0f;
        }
        return this.presentable.getPixelScaleFactorY();
    }

    private void doPaint(Graphics graphics, NodePath nodePath) {
        if (nodePath != null) {
            if (nodePath.isEmpty()) {
                this.root.clearDirtyTree();
                return;
            }
            assert (nodePath.getCurrentNode() == this.root);
        }
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newPhase("Painting");
        }
        Object object = this.sceneState.getScene();
        ((GlassScene)object).clearEntireSceneDirty();
        graphics.setLights(((GlassScene)object).getLights());
        graphics.setDepthBuffer(((GlassScene)object).getDepthBuffer());
        object = this.sceneState.getClearColor();
        if (object != null) {
            graphics.clear((Color)object);
        }
        if ((object = this.sceneState.getCurrentPaint()) != null) {
            if (((Paint)object).getType() != Paint$Type.COLOR) {
                graphics.getRenderTarget().setOpaque(((Paint)object).isOpaque());
            }
            graphics.setPaint((Paint)object);
            graphics.fillQuad(0.0f, 0.0f, this.width, this.height);
        }
        graphics.setCamera(this.sceneState.getCamera());
        graphics.setRenderRoot(nodePath);
        this.root.render(graphics);
    }
}

