/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.util;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DataURI {
    private final String originalUri;
    private final String originalData;
    private final String mimeType;
    private final String mimeSubtype;
    private final Map<String, String> parameters;
    private final boolean base64;
    private final byte[] data;

    public static boolean matchScheme(String string) {
        if (string == null || string.length() < 6) {
            return false;
        }
        return (string = string.stripLeading()).length() > 5 && "data:".equalsIgnoreCase(string.substring(0, 5));
    }

    public static DataURI tryParse(String string) {
        if (!DataURI.matchScheme(string)) {
            return null;
        }
        int n2 = (string = string.trim()).indexOf(44, 5);
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid URI: " + string);
        }
        String string2 = "text";
        String string3 = "plain";
        boolean bl2 = false;
        String[] stringArray = string.substring(5, n2).split(";");
        Map<String, String> map = Collections.emptyMap();
        if (stringArray.length > 0) {
            int n3 = 0;
            int n4 = stringArray[0].indexOf(47);
            if (n4 > 0) {
                string2 = stringArray[0].substring(0, n4);
                string3 = stringArray[0].substring(n4 + 1);
                n3 = 1;
            }
            while (n3 < stringArray.length) {
                String string4 = stringArray[n3];
                int n5 = string4.indexOf(61);
                if (n5 < 0) {
                    if (n3 < stringArray.length - 1) {
                        throw new IllegalArgumentException("Invalid URI: " + string);
                    }
                    bl2 = "base64".equalsIgnoreCase(stringArray[stringArray.length - 1]);
                } else {
                    if (map.isEmpty()) {
                        map = new HashMap<String, String>();
                    }
                    map.put(string4.substring(0, n5).toLowerCase(), string4.substring(n5 + 1));
                }
                ++n3;
            }
        }
        String string5 = string.substring(n2 + 1);
        Charset charset = Charset.defaultCharset();
        boolean bl3 = bl2;
        return new DataURI(string, string5, string2, string3, map, bl3, bl3 ? Base64.getDecoder().decode(string5) : URLDecoder.decode(string5.replace("+", "%2B"), charset).getBytes(charset));
    }

    private DataURI(String string, String string2, String string3, String string4, Map<String, String> map, boolean bl2, byte[] byArray) {
        this.originalUri = string;
        this.originalData = string2;
        this.mimeType = string3;
        this.mimeSubtype = string4;
        this.parameters = map;
        this.base64 = bl2;
        this.data = byArray;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMimeSubtype() {
        return this.mimeSubtype;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        if (this.originalData.length() < 32) {
            return this.originalUri;
        }
        return this.originalUri.substring(0, this.originalUri.length() - this.originalData.length()) + this.originalData.substring(0, 14) + "..." + this.originalData.substring(this.originalData.length() - 14);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataURI)) {
            return false;
        }
        object = (DataURI)object;
        return this.base64 == ((DataURI)object).base64 && Objects.equals(this.mimeType, ((DataURI)object).mimeType) && Objects.equals(this.mimeSubtype, ((DataURI)object).mimeSubtype) && Arrays.equals(this.data, ((DataURI)object).data);
    }

    public int hashCode() {
        int n2 = Objects.hash(this.mimeType, this.mimeSubtype, this.base64);
        n2 = n2 * 31 + Arrays.hashCode(this.data);
        return n2;
    }
}

