/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheConst$BucketStats;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class ArrayCacheConst$CacheStats {
    final String name;
    final ArrayCacheConst$BucketStats[] bucketStats;
    int resize = 0;
    int oversize = 0;
    long totalInitial = 0L;

    ArrayCacheConst$CacheStats(String string) {
        this.name = string;
        this.bucketStats = new ArrayCacheConst$BucketStats[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            this.bucketStats[i2] = new ArrayCacheConst$BucketStats();
        }
    }

    final void reset() {
        this.resize = 0;
        this.oversize = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            this.bucketStats[i2].reset();
        }
    }

    final long dumpStats() {
        long l2 = 0L;
        if (MarlinConst.DO_STATS) {
            ArrayCacheConst$BucketStats arrayCacheConst$BucketStats;
            int n2;
            for (n2 = 0; n2 < 8; ++n2) {
                arrayCacheConst$BucketStats = this.bucketStats[n2];
                if (arrayCacheConst$BucketStats.maxSize == 0) continue;
                l2 += (long)(this.getByteFactor() * (arrayCacheConst$BucketStats.maxSize * ArrayCacheConst.ARRAY_SIZES[n2]));
            }
            if (this.totalInitial != 0L || l2 != 0L || this.resize != 0 || this.oversize != 0) {
                MarlinUtils.logInfo(this.name + ": resize: " + this.resize + " - oversize: " + this.oversize + " - initial: " + this.getTotalInitialBytes() + " bytes (" + this.totalInitial + " elements) - cache: " + l2 + " bytes");
            }
            if (l2 != 0L) {
                MarlinUtils.logInfo(this.name + ": usage stats:");
                for (n2 = 0; n2 < 8; ++n2) {
                    arrayCacheConst$BucketStats = this.bucketStats[n2];
                    if (arrayCacheConst$BucketStats.getOp == 0) continue;
                    MarlinUtils.logInfo("  Bucket[" + ArrayCacheConst.ARRAY_SIZES[n2] + "]: get: " + arrayCacheConst$BucketStats.getOp + " - put: " + arrayCacheConst$BucketStats.returnOp + " - create: " + arrayCacheConst$BucketStats.createOp + " :: max size: " + arrayCacheConst$BucketStats.maxSize);
                }
            }
        }
        return l2;
    }

    private int getByteFactor() {
        int n2 = 1;
        if (this.name.contains("Int") || this.name.contains("Float")) {
            n2 = 4;
        } else if (this.name.contains("Double")) {
            n2 = 8;
        }
        return n2;
    }

    final long getTotalInitialBytes() {
        return (long)this.getByteFactor() * this.totalInitial;
    }
}

