/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.util.Arrays;

public final class ArrayCacheConst
implements MarlinConst {
    static final int BUCKETS = 8;
    static final int MIN_ARRAY_SIZE = 4096;
    static final int MAX_ARRAY_SIZE;
    static final int THRESHOLD_SMALL_ARRAY_SIZE = 0x400000;
    static final int THRESHOLD_ARRAY_SIZE;
    static final long THRESHOLD_HUGE_ARRAY_SIZE;
    static final int[] ARRAY_SIZES;

    private ArrayCacheConst() {
    }

    static int getBucket(int n2) {
        for (int i2 = 0; i2 < ARRAY_SIZES.length; ++i2) {
            if (n2 > ARRAY_SIZES[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int getNewSize(int n2, int n3) {
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("array exceeds maximum capacity !");
        }
        assert (n2 >= 0);
        if (n2 > THRESHOLD_ARRAY_SIZE) {
            int n4 = n2;
            n2 = n4 + (n4 >> 1);
        } else {
            n2 <<= 1;
        }
        if (n2 < n3) {
            n2 = (n3 >> 12) + 1 << 12;
        }
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        return n2;
    }

    public static long getNewLargeSize(long l2, long l3) {
        long l4;
        if (l3 >> 31 != 0L) {
            throw new ArrayIndexOutOfBoundsException("array exceeds maximum capacity !");
        }
        assert (l2 >= 0L);
        if (l2 > THRESHOLD_HUGE_ARRAY_SIZE) {
            long l5 = l2;
            l4 = l5 + (l5 >> 2);
        } else if (l2 > (long)THRESHOLD_ARRAY_SIZE) {
            long l6 = l2;
            l4 = l6 + (l6 >> 1);
        } else {
            l4 = l2 > 0x400000L ? l2 << 1 : l2 << 2;
        }
        if (l4 < l3) {
            l4 = (l3 >> 12) + 1L << 12;
        }
        if (l4 > Integer.MAX_VALUE) {
            l4 = Integer.MAX_VALUE;
        }
        return l4;
    }

    static {
        ARRAY_SIZES = new int[8];
        int n2 = 4096;
        int n3 = 2;
        int n4 = 0;
        while (n4 < 8) {
            ArrayCacheConst.ARRAY_SIZES[n4] = n2;
            if (DO_TRACE) {
                MarlinUtils.logInfo("arraySize[" + n4 + "]: " + n2);
            }
            if (n2 >= 0x400000) {
                n3 = 1;
            }
            ++n4;
            n2 <<= n3;
        }
        MAX_ARRAY_SIZE = n2 >> n3;
        if (MAX_ARRAY_SIZE <= 0) {
            throw new IllegalStateException("Invalid max array size !");
        }
        THRESHOLD_ARRAY_SIZE = 0x1000000;
        THRESHOLD_HUGE_ARRAY_SIZE = 0x3000000L;
        if (DO_STATS) {
            MarlinUtils.logInfo("ArrayCache.BUCKETS        = 8");
            MarlinUtils.logInfo("ArrayCache.MIN_ARRAY_SIZE = 4096");
            MarlinUtils.logInfo("ArrayCache.MAX_ARRAY_SIZE = " + MAX_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.ARRAY_SIZES = " + Arrays.toString(ARRAY_SIZES));
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_ARRAY_SIZE = " + THRESHOLD_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_HUGE_ARRAY_SIZE = " + THRESHOLD_HUGE_ARRAY_SIZE);
        }
    }
}

