/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheDouble;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class ArrayCacheDouble$Reference {
    final double[] initial;
    private final ArrayCacheDouble cache;

    ArrayCacheDouble$Reference(ArrayCacheDouble arrayCacheDouble, int n2) {
        this.cache = arrayCacheDouble;
        this.initial = ArrayCacheDouble.createArray(n2);
        if (MarlinConst.DO_STATS) {
            arrayCacheDouble.stats.totalInitial += (long)n2;
        }
    }

    final double[] getArray(int n2) {
        if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            return this.cache.getCacheBucket(n2).getArray();
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.oversize;
        }
        if (MarlinConst.DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo("ArrayCacheDouble(Dirty): getArray[oversize]: length=\t" + n2);
        }
        return ArrayCacheDouble.createArray(n2);
    }

    final double[] widenArray(double[] dArray, int n2, int n3) {
        int n4 = dArray.length;
        if (MarlinConst.DO_CHECKS && n4 >= n3) {
            return dArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.resize;
        }
        double[] dArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        this.putArray(dArray, 0, n2);
        if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo("ArrayCacheDouble(Dirty): widenArray[" + dArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
        }
        return dArray2;
    }

    final boolean doCleanRef(double[] dArray) {
        return dArray != this.initial;
    }

    final double[] putArray(double[] dArray) {
        return this.putArray(dArray, 0, dArray.length);
    }

    final double[] putArray(double[] dArray, int n2, int n3) {
        if (dArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE && dArray != this.initial) {
            this.cache.getCacheBucket(dArray.length).putArray(dArray);
        }
        return this.initial;
    }
}

