/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheConst$CacheStats;
import com.sun.marlin.ArrayCacheIntClean$Bucket;
import com.sun.marlin.ArrayCacheIntClean$Reference;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public final class ArrayCacheIntClean {
    private final int bucketCapacity;
    private WeakReference<ArrayCacheIntClean$Bucket[]> refBuckets = null;
    final ArrayCacheConst$CacheStats stats;

    ArrayCacheIntClean(int n2) {
        this.bucketCapacity = n2;
        this.stats = MarlinConst.DO_STATS ? new ArrayCacheConst$CacheStats("ArrayCacheInt(Clean)") : null;
    }

    final ArrayCacheIntClean$Bucket getCacheBucket(int n2) {
        n2 = ArrayCacheConst.getBucket(n2);
        return this.getBuckets()[n2];
    }

    private ArrayCacheIntClean$Bucket[] getBuckets() {
        ArrayCacheIntClean$Bucket[] arrayCacheIntClean$BucketArray = this.refBuckets != null ? (ArrayCacheIntClean$Bucket[])this.refBuckets.get() : null;
        if (arrayCacheIntClean$BucketArray == null) {
            arrayCacheIntClean$BucketArray = new ArrayCacheIntClean$Bucket[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                arrayCacheIntClean$BucketArray[i2] = new ArrayCacheIntClean$Bucket(ArrayCacheConst.ARRAY_SIZES[i2], this.bucketCapacity, MarlinConst.DO_STATS ? this.stats.bucketStats[i2] : null);
            }
            this.refBuckets = new WeakReference<ArrayCacheIntClean$Bucket[]>(arrayCacheIntClean$BucketArray);
        }
        return arrayCacheIntClean$BucketArray;
    }

    final ArrayCacheIntClean$Reference createRef(int n2) {
        return new ArrayCacheIntClean$Reference(this, n2);
    }

    static int[] createArray(int n2) {
        return new int[n2];
    }

    static void fill(int[] nArray, int n2, int n3, int n4) {
        Arrays.fill(nArray, n2, n3, n4);
        if (MarlinConst.DO_CHECKS) {
            ArrayCacheIntClean.check(nArray, n2, n3, n4);
        }
    }

    public static void check(int[] nArray, int n2, int n3, int n4) {
        if (MarlinConst.DO_CHECKS) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] == n4) continue;
                MarlinUtils.logException("Invalid value at: " + i2 + " = " + nArray[i2] + " from: " + n2 + " to: " + n3 + "\n" + Arrays.toString(nArray), new Throwable());
                Arrays.fill(nArray, n4);
                return;
            }
        }
    }
}

