/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheByte$Reference;
import com.sun.marlin.ArrayCacheDouble$Reference;
import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.RendererContext;
import com.sun.marlin.stats.Histogram;
import com.sun.marlin.stats.StatLong;
import java.util.Arrays;

final class Helpers$PolyStack {
    private static final byte TYPE_LINETO = 0;
    private static final byte TYPE_QUADTO = 1;
    private static final byte TYPE_CUBICTO = 2;
    private static final int INITIAL_CURVES_COUNT = MarlinConst.INITIAL_EDGES_COUNT << 1;
    private static final int INITIAL_TYPES_COUNT = MarlinConst.INITIAL_EDGES_COUNT;
    double[] curves;
    int end;
    byte[] curveTypes;
    int numCurves;
    final ArrayCacheDouble$Reference curves_ref;
    final ArrayCacheByte$Reference curveTypes_ref;
    int curveTypesUseMark;
    int curvesUseMark;
    private final StatLong stat_polystack_types;
    private final StatLong stat_polystack_curves;
    private final Histogram hist_polystack_curves;
    private final StatLong stat_array_polystack_curves;
    private final StatLong stat_array_polystack_curveTypes;

    Helpers$PolyStack(RendererContext rendererContext) {
        this(rendererContext, null, null, null, null, null);
    }

    Helpers$PolyStack(RendererContext rendererContext, StatLong statLong, StatLong statLong2, Histogram histogram, StatLong statLong3, StatLong statLong4) {
        this.curves_ref = rendererContext.newDirtyDoubleArrayRef(INITIAL_CURVES_COUNT);
        this.curves = this.curves_ref.initial;
        this.curveTypes_ref = rendererContext.newDirtyByteArrayRef(INITIAL_TYPES_COUNT);
        this.curveTypes = this.curveTypes_ref.initial;
        this.numCurves = 0;
        this.end = 0;
        if (MarlinConst.DO_STATS) {
            this.curveTypesUseMark = 0;
            this.curvesUseMark = 0;
        }
        this.stat_polystack_types = statLong;
        this.stat_polystack_curves = statLong2;
        this.hist_polystack_curves = histogram;
        this.stat_array_polystack_curves = statLong3;
        this.stat_array_polystack_curveTypes = statLong4;
    }

    final void dispose() {
        this.end = 0;
        this.numCurves = 0;
        if (MarlinConst.DO_STATS) {
            this.stat_polystack_types.add(this.curveTypesUseMark);
            this.stat_polystack_curves.add(this.curvesUseMark);
            ((StatLong)this.hist_polystack_curves).add(this.curvesUseMark);
            this.curveTypesUseMark = 0;
            this.curvesUseMark = 0;
        }
        if (this.curves_ref.doCleanRef(this.curves)) {
            this.curves = this.curves_ref.putArray(this.curves);
        }
        if (this.curveTypes_ref.doCleanRef(this.curveTypes)) {
            this.curveTypes = this.curveTypes_ref.putArray(this.curveTypes);
        }
    }

    private void ensureSpace(int n2) {
        if (this.curves.length - this.end < n2) {
            if (MarlinConst.DO_STATS) {
                this.stat_array_polystack_curves.add(this.end + n2);
            }
            this.curves = this.curves_ref.widenArray(this.curves, this.end, this.end + n2);
        }
        if (this.curveTypes.length <= this.numCurves) {
            if (MarlinConst.DO_STATS) {
                this.stat_array_polystack_curveTypes.add(this.numCurves + 1);
            }
            this.curveTypes = this.curveTypes_ref.widenArray(this.curveTypes, this.numCurves, this.numCurves + 1);
        }
    }

    final void pushCubic(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.ensureSpace(6);
        this.curveTypes[this.numCurves++] = 2;
        double[] dArray = this.curves;
        int n2 = this.end;
        dArray[n2++] = d6;
        dArray[n2++] = d7;
        dArray[n2++] = d4;
        dArray[n2++] = d5;
        dArray[n2++] = d2;
        dArray[n2++] = d3;
        this.end = n2;
    }

    final void pushQuad(double d2, double d3, double d4, double d5) {
        this.ensureSpace(4);
        this.curveTypes[this.numCurves++] = 1;
        double[] dArray = this.curves;
        int n2 = this.end;
        dArray[n2++] = d4;
        dArray[n2++] = d5;
        dArray[n2++] = d2;
        dArray[n2++] = d3;
        this.end = n2;
    }

    final void pushLine(double d2, double d3) {
        this.ensureSpace(2);
        this.curveTypes[this.numCurves++] = 0;
        this.curves[this.end++] = d2;
        this.curves[this.end++] = d3;
    }

    final void pullAll(DPathConsumer2D dPathConsumer2D) {
        int n2 = this.numCurves;
        if (n2 == 0) {
            return;
        }
        if (MarlinConst.DO_STATS) {
            if (this.numCurves > this.curveTypesUseMark) {
                this.curveTypesUseMark = this.numCurves;
            }
            if (this.end > this.curvesUseMark) {
                this.curvesUseMark = this.end;
            }
        }
        byte[] byArray = this.curveTypes;
        double[] dArray = this.curves;
        int n3 = 0;
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            switch (byArray[i2]) {
                case 0: {
                    dPathConsumer2D.lineTo(dArray[n3], dArray[n3 + 1]);
                    n3 += 2;
                    continue block5;
                }
                case 2: {
                    dPathConsumer2D.curveTo(dArray[n3], dArray[n3 + 1], dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5]);
                    n3 += 6;
                    continue block5;
                }
                case 1: {
                    dPathConsumer2D.quadTo(dArray[n3], dArray[n3 + 1], dArray[n3 + 2], dArray[n3 + 3]);
                    n3 += 4;
                }
            }
        }
        this.numCurves = 0;
        this.end = 0;
    }

    final void popAll(DPathConsumer2D dPathConsumer2D) {
        int n2 = this.numCurves;
        if (n2 == 0) {
            return;
        }
        if (MarlinConst.DO_STATS) {
            if (this.numCurves > this.curveTypesUseMark) {
                this.curveTypesUseMark = this.numCurves;
            }
            if (this.end > this.curvesUseMark) {
                this.curvesUseMark = this.end;
            }
        }
        byte[] byArray = this.curveTypes;
        double[] dArray = this.curves;
        int n3 = this.end;
        block5: while (n2 != 0) {
            switch (byArray[--n2]) {
                case 0: {
                    dPathConsumer2D.lineTo(dArray[n3 -= 2], dArray[n3 + 1]);
                    continue block5;
                }
                case 2: {
                    dPathConsumer2D.curveTo(dArray[n3 -= 6], dArray[n3 + 1], dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5]);
                    continue block5;
                }
                case 1: {
                    dPathConsumer2D.quadTo(dArray[n3 -= 4], dArray[n3 + 1], dArray[n3 + 2], dArray[n3 + 3]);
                    continue block5;
                }
            }
        }
        this.numCurves = 0;
        this.end = 0;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.numCurves;
        int n3 = this.end;
        while (n2 != 0) {
            int n4;
            switch (this.curveTypes[--n2]) {
                case 0: {
                    n4 = 2;
                    stringBuilder.append("line: ");
                    break;
                }
                case 1: {
                    n4 = 4;
                    stringBuilder.append("quad: ");
                    break;
                }
                case 2: {
                    n4 = 6;
                    stringBuilder.append("cubic: ");
                    break;
                }
                default: {
                    n4 = 0;
                }
            }
            int n5 = n3 -= n4;
            stringBuilder.append(Arrays.toString(Arrays.copyOfRange(this.curves, n5, n5 + n4))).append("\n");
        }
        return stringBuilder.toString();
    }
}

