/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheIntClean;
import com.sun.marlin.FloatMath;
import com.sun.marlin.MarlinAlphaConsumer;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.OffHeapArray;
import com.sun.prism.impl.shape.MaskData;
import java.nio.ByteBuffer;
import java.util.Arrays;
import sun.misc.Unsafe;

public final class MaskMarlinAlphaConsumer
implements MarlinAlphaConsumer {
    int x;
    int y;
    int width;
    int height;
    final byte[] alphas;
    final ByteBuffer alphabuffer;
    final MaskData maskdata = new MaskData();
    boolean useFastFill;
    int fastFillThreshold;
    OffHeapArray ALPHA_MAP_USED = null;
    static final byte[] ALPHA_MAP;
    static final OffHeapArray ALPHA_MAP_UNSAFE;
    static final byte[] ALPHA_MAP_NO_AA;
    static final OffHeapArray ALPHA_MAP_UNSAFE_NO_AA;

    public MaskMarlinAlphaConsumer(int n2) {
        this.alphas = new byte[n2];
        this.alphabuffer = ByteBuffer.wrap(this.alphas);
    }

    public final void setBoundsNoClone(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        this.maskdata.update(this.alphabuffer, n2, n3, n4, n5);
        boolean bl2 = this.useFastFill = n4 >= 32;
        if (this.useFastFill) {
            this.fastFillThreshold = n4 >= 128 ? n4 >> 1 : n4 >> 2;
        }
    }

    @Override
    public final int getOriginX() {
        return this.x;
    }

    @Override
    public final int getOriginY() {
        return this.y;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public final int getAlphaLength() {
        return this.alphas.length;
    }

    public final MaskData getMaskData() {
        return this.maskdata;
    }

    @Override
    public final void setMaxAlpha(int n2) {
        this.ALPHA_MAP_USED = n2 == 1 ? ALPHA_MAP_UNSAFE_NO_AA : ALPHA_MAP_UNSAFE;
    }

    private static byte[] buildAlphaMap(int n2) {
        byte[] byArray = new byte[n2 << 1];
        int n3 = n2 >> 2;
        int n4 = 0;
        while (n4 <= n2) {
            int n5 = n4++;
            byArray[n5] = (byte)((n5 * 255 + n3) / n2);
        }
        return byArray;
    }

    @Override
    public final boolean supportBlockFlags() {
        return true;
    }

    @Override
    public final void clearAlphas(int n2) {
        int n3 = this.width;
        int n4 = n2 = (n2 - this.y) * n3;
        Arrays.fill(this.alphas, n4, n4 + n3, (byte)0);
    }

    @Override
    public final void setAndClearRelativeAlphas(int[] nArray, int n2, int n3, int n4) {
        byte[] byArray = this.alphas;
        int n5 = this.width;
        n2 = (n2 - this.y) * n5;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l2 = this.ALPHA_MAP_USED.address;
        int n6 = Math.min(n4 -= this.x, this.width);
        int n7 = this.useFastFill && n6 - (n3 -= this.x) < this.fastFillThreshold ? 1 : 0;
        if (n7 != 0) {
            int n8 = n2;
            Arrays.fill(byArray, n8, n8 + n5, (byte)0);
            int n9 = 0;
            for (n7 = n3; n7 < n6; ++n7) {
                byArray[n2 + n7] = unsafe.getByte(l2 + (long)(n9 += nArray[n7]));
            }
        } else {
            for (n7 = 0; n7 < n3; ++n7) {
                byArray[n2 + n7] = 0;
            }
            int n10 = 0;
            while (n7 < n6) {
                byArray[n2 + n7] = unsafe.getByte(l2 + (long)(n10 += nArray[n7]));
                ++n7;
            }
            while (n7 < n5) {
                byArray[n2 + n7] = 0;
                ++n7;
            }
        }
        ArrayCacheIntClean.fill(nArray, n3, n4 + 1, 0);
    }

    @Override
    public final void setAndClearRelativeAlphas(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        byte[] byArray = this.alphas;
        int n5 = this.width;
        n2 = (n2 - this.y) * n5;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l2 = this.ALPHA_MAP_USED.address;
        int n6 = Math.min(n4 -= this.x, this.width);
        int n7 = this.useFastFill && n6 - (n3 -= this.x) < this.fastFillThreshold ? 1 : 0;
        int n8 = MarlinConst.BLOCK_SIZE_LG;
        int n9 = n3 >> n8;
        int n10 = (n6 >> n8) + 1;
        nArray[n10] = 0;
        int n11 = 0;
        int n12 = Integer.MAX_VALUE;
        if (n7 != 0) {
            int n13 = n3;
            int n14 = n2;
            Arrays.fill(byArray, n14, n14 + n5, (byte)0);
            for (int i2 = n9; i2 <= n10; ++i2) {
                if (nArray[i2] != 0) {
                    nArray[i2] = 0;
                    if (n12 != Integer.MAX_VALUE) continue;
                    n12 = i2;
                    continue;
                }
                if (n12 == Integer.MAX_VALUE) continue;
                n7 = FloatMath.max(n12 << n8, n3);
                n12 = Integer.MAX_VALUE;
                int n15 = FloatMath.min((i2 << n8) + 1, n6);
                for (int i3 = n7; i3 < n15; ++i3) {
                    int n16 = nArray2[i3];
                    if (n16 == 0) continue;
                    nArray2[i3] = 0;
                    if (i3 != n13) {
                        if (n11 == 0) {
                            n13 = i3;
                        } else {
                            n7 = unsafe.getByte(l2 + (long)n11);
                            do {
                                byArray[n2 + n13] = n7;
                            } while (++n13 < i3);
                        }
                    }
                    n11 += n16;
                }
            }
            if (n11 != 0) {
                n7 = unsafe.getByte(l2 + (long)n11);
                while (n13 < n6) {
                    byArray[n2 + n13] = n7;
                    ++n13;
                }
            }
        } else {
            int n17;
            for (n17 = 0; n17 < n3; ++n17) {
                byArray[n2 + n17] = 0;
            }
            for (int i4 = n9; i4 <= n10; ++i4) {
                if (nArray[i4] != 0) {
                    nArray[i4] = 0;
                    if (n12 != Integer.MAX_VALUE) continue;
                    n12 = i4;
                    continue;
                }
                if (n12 == Integer.MAX_VALUE) continue;
                n7 = FloatMath.max(n12 << n8, n3);
                n12 = Integer.MAX_VALUE;
                int n18 = FloatMath.min((i4 << n8) + 1, n6);
                for (int i5 = n7; i5 < n18; ++i5) {
                    int n19 = nArray2[i5];
                    if (n19 == 0) continue;
                    nArray2[i5] = 0;
                    if (i5 != n17) {
                        n7 = unsafe.getByte(l2 + (long)n11);
                        do {
                            byArray[n2 + n17] = n7;
                        } while (++n17 < i5);
                    }
                    n11 += n19;
                }
            }
            if (n11 != 0) {
                n7 = unsafe.getByte(l2 + (long)n11);
                while (n17 < n6) {
                    byArray[n2 + n17] = n7;
                    ++n17;
                }
            }
            while (n17 < n5) {
                byArray[n2 + n17] = 0;
                ++n17;
            }
        }
        nArray2[n6] = 0;
        if (MarlinConst.DO_CHECKS) {
            ArrayCacheIntClean.check(nArray, n9, n10, 0);
            ArrayCacheIntClean.check(nArray2, n3, n4 + 1, 0);
        }
    }

    static {
        Unsafe unsafe = OffHeapArray.UNSAFE;
        byte[] byArray = MaskMarlinAlphaConsumer.buildAlphaMap(MarlinConst.MAX_AA_ALPHA);
        ALPHA_MAP = byArray;
        ALPHA_MAP_UNSAFE = new OffHeapArray(ALPHA_MAP, ALPHA_MAP.length);
        long l2 = MaskMarlinAlphaConsumer.ALPHA_MAP_UNSAFE.address;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            unsafe.putByte(l2 + (long)i2, byArray[i2]);
        }
        byte[] byArray2 = MaskMarlinAlphaConsumer.buildAlphaMap(1);
        ALPHA_MAP_NO_AA = byArray2;
        ALPHA_MAP_UNSAFE_NO_AA = new OffHeapArray(ALPHA_MAP_NO_AA, ALPHA_MAP_NO_AA.length);
        l2 = MaskMarlinAlphaConsumer.ALPHA_MAP_UNSAFE_NO_AA.address;
        for (int i3 = 0; i3 < byArray2.length; ++i3) {
            unsafe.putByte(l2 + (long)i3, byArray2[i3]);
        }
    }
}

