/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.OffHeapArray$1;
import java.security.AccessController;
import sun.misc.Unsafe;

final class OffHeapArray {
    static final Unsafe UNSAFE;
    static final int SIZE_INT;
    long address;
    long length;
    int used;

    OffHeapArray(Object object, long l2) {
        this.address = UNSAFE.allocateMemory(l2);
        this.length = l2;
        this.used = 0;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.allocateMemory =   " + l2 + " to addr = " + this.address);
        }
        MarlinUtils.getCleaner().register(object, this::free);
    }

    final void resize(long l2) {
        this.address = UNSAFE.reallocateMemory(this.address, l2);
        this.length = l2;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.reallocateMemory = " + l2 + " to addr = " + this.address);
        }
    }

    final void free() {
        UNSAFE.freeMemory(this.address);
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.freeMemory =       " + this.length + " at addr = " + this.address);
        }
        this.address = 0L;
    }

    final void fill(byte by2) {
        UNSAFE.setMemory(this.address, this.length, by2);
    }

    static {
        Unsafe unsafe;
        UNSAFE = unsafe = AccessController.doPrivileged(new OffHeapArray$1());
        SIZE_INT = Unsafe.ARRAY_INT_INDEX_SCALE;
    }
}

