/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.prism.GraphicsPipeline$ShaderModel;
import com.sun.prism.GraphicsPipeline$ShaderType;
import com.sun.prism.ResourceFactory;
import com.sun.prism.impl.PrismSettings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GraphicsPipeline {
    private FontFactory fontFactory;
    private final Set<Runnable> disposeHooks = new HashSet<Runnable>();
    protected Map deviceDetails = null;
    private static GraphicsPipeline installedPipeline;

    public abstract boolean init();

    public void dispose() {
        this.notifyDisposeHooks();
        installedPipeline = null;
    }

    public void addDisposeHook(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Set<Runnable> set = this.disposeHooks;
        synchronized (set) {
            this.disposeHooks.add(runnable);
            return;
        }
    }

    private void notifyDisposeHooks() {
        Object object;
        Object object2 = this.disposeHooks;
        synchronized (object2) {
            object = new ArrayList<Runnable>(this.disposeHooks);
            this.disposeHooks.clear();
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            object = (Runnable)object2.next();
            object.run();
        }
    }

    public abstract int getAdapterOrdinal(Screen var1);

    public abstract ResourceFactory getResourceFactory(Screen var1);

    public abstract ResourceFactory getDefaultResourceFactory(List<Screen> var1);

    public abstract boolean is3DSupported();

    public boolean isMSAASupported() {
        return false;
    }

    public abstract boolean isVsyncSupported();

    public abstract boolean supportsShaderType(GraphicsPipeline$ShaderType var1);

    public abstract boolean supportsShaderModel(GraphicsPipeline$ShaderModel var1);

    public boolean supportsShader(GraphicsPipeline$ShaderType graphicsPipeline$ShaderType, GraphicsPipeline$ShaderModel graphicsPipeline$ShaderModel) {
        return this.supportsShaderType(graphicsPipeline$ShaderType) && this.supportsShaderModel(graphicsPipeline$ShaderModel);
    }

    public static ResourceFactory getDefaultResourceFactory() {
        List<Screen> list = Screen.getScreens();
        return GraphicsPipeline.getPipeline().getDefaultResourceFactory(list);
    }

    public FontFactory getFontFactory() {
        if (this.fontFactory == null) {
            this.fontFactory = PrismFontFactory.getFontFactory();
        }
        return this.fontFactory;
    }

    public Map getDeviceDetails() {
        return this.deviceDetails;
    }

    protected void setDeviceDetails(Map map) {
        this.deviceDetails = map;
    }

    public static GraphicsPipeline createPipeline() {
        if (PrismSettings.tryOrder.isEmpty()) {
            if (PrismSettings.verbose) {
                System.out.println("No Prism pipelines specified");
            }
            return null;
        }
        if (installedPipeline != null) {
            throw new IllegalStateException("pipeline already created:" + String.valueOf(installedPipeline));
        }
        for (String string : PrismSettings.tryOrder) {
            if ("j2d".equals(string)) {
                System.err.println("WARNING: The prism-j2d pipeline should not be used as the software");
                System.err.println("fallback pipeline. It is no longer tested nor intended to be used for");
                System.err.println("on-screen rendering. Please use the prism-sw pipeline instead by setting");
                System.err.println("the \"prism.order\" system property to \"sw\" rather than \"j2d\".");
            }
            if (PrismSettings.verbose && ("j2d".equals(string) || "sw".equals(string))) {
                System.err.println("*** Fallback to Prism SW pipeline");
            }
            String string2 = string;
            String iterator2 = "com.sun.prism." + string2 + "." + string2.toUpperCase() + "Pipeline";
            try {
                if (PrismSettings.verbose) {
                    System.out.println("Prism pipeline name = " + iterator2);
                }
                Class<?> clazz = Class.forName(iterator2);
                if (PrismSettings.verbose) {
                    System.out.println("(X) Got class = " + String.valueOf(clazz));
                }
                Object object = clazz.getMethod("getInstance", null);
                if ((object = (GraphicsPipeline)((Method)object).invoke(null, null)) != null && ((GraphicsPipeline)object).init()) {
                    if (PrismSettings.verbose) {
                        System.out.println("Initialized prism pipeline: " + clazz.getName());
                    }
                    installedPipeline = object;
                    return installedPipeline;
                }
                if (object != null) {
                    ((GraphicsPipeline)object).dispose();
                    object = null;
                }
                if (!PrismSettings.verbose) continue;
                System.err.println("GraphicsPipeline.createPipeline: error initializing pipeline " + iterator2);
                if (object == null) {
                    System.err.println("Reason: could not create an instance");
                    continue;
                }
                System.err.println("Reason: could not initialize the instance");
            }
            catch (Throwable throwable) {
                if (!PrismSettings.verbose) continue;
                System.err.println("GraphicsPipeline.createPipeline failed for " + iterator2);
                throwable.printStackTrace();
            }
        }
        StringBuffer stringBuffer = new StringBuffer("Graphics Device initialization failed for :  ");
        Iterator<String> iterator = PrismSettings.tryOrder.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(", ");
                stringBuffer.append(iterator.next());
            }
        }
        System.err.println(stringBuffer);
        return null;
    }

    public static GraphicsPipeline getPipeline() {
        return installedPipeline;
    }

    public boolean isEffectSupported() {
        return true;
    }

    public boolean isUploading() {
        return PrismSettings.forceUploadingPainter;
    }
}

