/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.PixelSetter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.ByteBgraPre;
import com.sun.javafx.image.impl.ByteGray;
import com.sun.javafx.image.impl.ByteGrayAlpha;
import com.sun.javafx.image.impl.ByteGrayAlphaPre;
import com.sun.javafx.image.impl.ByteRgb;
import com.sun.javafx.image.impl.ByteRgba;
import com.sun.javafx.tk.PlatformImage;
import com.sun.prism.Image$Accessor;
import com.sun.prism.Image$ByteAccess;
import com.sun.prism.Image$ByteRgbAccess;
import com.sun.prism.Image$IntAccess;
import com.sun.prism.Image$ScaledAccessor;
import com.sun.prism.Image$Serial;
import com.sun.prism.Image$UnsupportedAccess;
import com.sun.prism.PixelFormat;
import com.sun.prism.PixelFormat$DataType;
import com.sun.prism.impl.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritablePixelFormat;

public class Image
implements PlatformImage {
    static final WritablePixelFormat<ByteBuffer> FX_ByteBgraPre_FORMAT = javafx.scene.image.PixelFormat.getByteBgraPreInstance();
    static final WritablePixelFormat<IntBuffer> FX_IntArgbPre_FORMAT = javafx.scene.image.PixelFormat.getIntArgbPreInstance();
    static final javafx.scene.image.PixelFormat<ByteBuffer> FX_ByteRgb_FORMAT = javafx.scene.image.PixelFormat.getByteRgbInstance();
    private final Buffer pixelBuffer;
    private final int minX;
    private final int minY;
    private final int width;
    private final int height;
    private final int scanlineStride;
    private final PixelFormat pixelFormat;
    private final float pixelScale;
    private Image$Serial serial = new Image$Serial();
    private Image$Accessor<?> pixelaccessor;
    static javafx.scene.image.PixelFormat<ByteBuffer> FX_ByteGray_FORMAT;

    public static Image fromIntArgbPreData(int[] nArray, int n2, int n3) {
        return new Image(PixelFormat.INT_ARGB_PRE, nArray, n2, n3);
    }

    public static Image fromIntArgbPreData(IntBuffer intBuffer, int n2, int n3) {
        return new Image(PixelFormat.INT_ARGB_PRE, intBuffer, n2, n3);
    }

    public static Image fromIntArgbPreData(IntBuffer intBuffer, int n2, int n3, int n4) {
        return new Image(PixelFormat.INT_ARGB_PRE, intBuffer, n2, n3, 0, 0, n4);
    }

    public static Image fromIntArgbPreData(IntBuffer intBuffer, int n2, int n3, int n4, float f2) {
        return new Image(PixelFormat.INT_ARGB_PRE, intBuffer, n2, n3, 0, 0, n4, f2);
    }

    public static Image fromByteBgraPreData(byte[] byArray, int n2, int n3) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, byArray, n2, n3);
    }

    public static Image fromByteBgraPreData(byte[] byArray, int n2, int n3, float f2) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, ByteBuffer.wrap(byArray), n2, n3, 0, 0, 0, f2);
    }

    public static Image fromByteBgraPreData(ByteBuffer byteBuffer, int n2, int n3) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, byteBuffer, n2, n3);
    }

    public static Image fromPixelBufferPreData(PixelFormat pixelFormat, Buffer buffer, int n2, int n3) {
        return new Image(pixelFormat, buffer, n2, n3);
    }

    public static Image fromByteBgraPreData(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, byteBuffer, n2, n3, 0, 0, n4);
    }

    public static Image fromByteBgraPreData(ByteBuffer byteBuffer, int n2, int n3, int n4, float f2) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, byteBuffer, n2, n3, 0, 0, n4, f2);
    }

    public static Image fromByteRgbData(byte[] byArray, int n2, int n3) {
        return new Image(PixelFormat.BYTE_RGB, byArray, n2, n3);
    }

    public static Image fromByteRgbData(ByteBuffer byteBuffer, int n2, int n3) {
        return new Image(PixelFormat.BYTE_RGB, byteBuffer, n2, n3);
    }

    public static Image fromByteRgbData(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        return new Image(PixelFormat.BYTE_RGB, byteBuffer, n2, n3, 0, 0, n4);
    }

    public static Image fromByteRgbData(ByteBuffer byteBuffer, int n2, int n3, int n4, float f2) {
        return new Image(PixelFormat.BYTE_RGB, byteBuffer, n2, n3, 0, 0, n4, f2);
    }

    public static Image fromByteGrayData(byte[] byArray, int n2, int n3) {
        return new Image(PixelFormat.BYTE_GRAY, byArray, n2, n3);
    }

    public static Image fromByteGrayData(ByteBuffer byteBuffer, int n2, int n3) {
        return new Image(PixelFormat.BYTE_GRAY, byteBuffer, n2, n3);
    }

    public static Image fromByteGrayData(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        return new Image(PixelFormat.BYTE_GRAY, byteBuffer, n2, n3, 0, 0, n4);
    }

    public static Image fromByteGrayData(ByteBuffer byteBuffer, int n2, int n3, int n4, float f2) {
        return new Image(PixelFormat.BYTE_GRAY, byteBuffer, n2, n3, 0, 0, n4, f2);
    }

    public static Image fromByteAlphaData(byte[] byArray, int n2, int n3) {
        return new Image(PixelFormat.BYTE_ALPHA, byArray, n2, n3);
    }

    public static Image fromByteAlphaData(ByteBuffer byteBuffer, int n2, int n3) {
        return new Image(PixelFormat.BYTE_ALPHA, byteBuffer, n2, n3);
    }

    public static Image fromByteAlphaData(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        return new Image(PixelFormat.BYTE_ALPHA, byteBuffer, n2, n3, 0, 0, n4);
    }

    public static Image fromByteApple422Data(byte[] byArray, int n2, int n3) {
        return new Image(PixelFormat.BYTE_APPLE_422, byArray, n2, n3);
    }

    public static Image fromByteApple422Data(ByteBuffer byteBuffer, int n2, int n3) {
        return new Image(PixelFormat.BYTE_APPLE_422, byteBuffer, n2, n3);
    }

    public static Image fromByteApple422Data(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        return new Image(PixelFormat.BYTE_APPLE_422, byteBuffer, n2, n3, 0, 0, n4);
    }

    public static Image fromFloatMapData(FloatBuffer floatBuffer, int n2, int n3) {
        return new Image(PixelFormat.FLOAT_XYZW, floatBuffer, n2, n3);
    }

    public static Image convertImageFrame(ImageFrame imageFrame) {
        ByteBuffer byteBuffer = (ByteBuffer)imageFrame.getImageData();
        Object object = imageFrame.getImageType();
        int n2 = imageFrame.getWidth();
        int n3 = imageFrame.getHeight();
        int n4 = imageFrame.getStride();
        float f2 = imageFrame.getPixelScale();
        switch (object) {
            case GRAY: {
                return Image.fromByteGrayData(byteBuffer, n2, n3, n4, f2);
            }
            case RGB: {
                return Image.fromByteRgbData(byteBuffer, n2, n3, n4, f2);
            }
            case RGBA: {
                ByteBgra.ToByteBgraPreConverter().convert(byteBuffer, 0, n4, byteBuffer, 0, n4, n2, n3);
            }
            case RGBA_PRE: {
                ByteRgba.ToByteBgraConverter().convert(byteBuffer, 0, n4, byteBuffer, 0, n4, n2, n3);
                return Image.fromByteBgraPreData(byteBuffer, n2, n3, n4, f2);
            }
            case GRAY_ALPHA: {
                ByteGrayAlpha.ToByteGrayAlphaPreConverter().convert(byteBuffer, 0, n4, byteBuffer, 0, n4, n2, n3);
            }
            case GRAY_ALPHA_PRE: {
                if (n4 != n2 << 1) {
                    throw new AssertionError((Object)"Bad stride for GRAY_ALPHA");
                }
                object = new byte[n2 * n3 << 2];
                ByteGrayAlphaPre.ToByteBgraPreConverter().convert(byteBuffer, 0, n4, (byte[])object, 0, n2 << 2, n2, n3);
                return Image.fromByteBgraPreData((byte[])object, n2, n3, f2);
            }
        }
        throw new RuntimeException("Unknown image type: " + String.valueOf(object));
    }

    private Image(PixelFormat pixelFormat, int[] nArray, int n2, int n3) {
        this(pixelFormat, IntBuffer.wrap(nArray), n2, n3, 0, 0, 0, 1.0f);
    }

    private Image(PixelFormat pixelFormat, byte[] byArray, int n2, int n3) {
        this(pixelFormat, ByteBuffer.wrap(byArray), n2, n3, 0, 0, 0, 1.0f);
    }

    private Image(PixelFormat pixelFormat, Buffer buffer, int n2, int n3) {
        this(pixelFormat, buffer, n2, n3, 0, 0, 0, 1.0f);
    }

    private Image(PixelFormat pixelFormat, Buffer buffer, int n2, int n3, int n4, int n5, int n6) {
        this(pixelFormat, buffer, n2, n3, n4, n5, n6, 1.0f);
    }

    private Image(PixelFormat pixelFormat, Buffer buffer, int n2, int n3, int n4, int n5, int n6, float f2) {
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format not supported " + pixelFormat.name());
        }
        if (n6 == 0) {
            n6 = n2 * pixelFormat.getBytesPerPixelUnit();
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Pixel buffer must be non-null");
        }
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("Image dimensions must be > 0");
        }
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException("Image minX and minY must be >= 0");
        }
        if ((n4 + n2) * pixelFormat.getBytesPerPixelUnit() > n6) {
            throw new IllegalArgumentException("Image scanlineStride is too small");
        }
        if (n6 % pixelFormat.getBytesPerPixelUnit() != 0) {
            throw new IllegalArgumentException("Image scanlineStride must be a multiple of the pixel stride");
        }
        this.pixelFormat = pixelFormat;
        this.pixelBuffer = buffer;
        this.width = n2;
        this.height = n3;
        this.minX = n4;
        this.minY = n5;
        this.scanlineStride = n6;
        this.pixelScale = f2;
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public PixelFormat$DataType getDataType() {
        return this.pixelFormat.getDataType();
    }

    public int getBytesPerPixelUnit() {
        return this.pixelFormat.getBytesPerPixelUnit();
    }

    public Buffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    @Override
    public float getPixelScale() {
        return this.pixelScale;
    }

    public int getRowLength() {
        return this.scanlineStride / this.pixelFormat.getBytesPerPixelUnit();
    }

    public boolean isTightlyPacked() {
        return this.minX == 0 && this.minY == 0 && this.width == this.getRowLength();
    }

    public Image createSubImage(int n2, int n3, int n4, int n5) {
        if (n4 <= 0 || n5 <= 0) {
            throw new IllegalArgumentException("Subimage dimensions must be > 0");
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Subimage minX and minY must be >= 0");
        }
        if (n2 + n4 > this.width) {
            throw new IllegalArgumentException("Subimage minX+width must be <= width of parent image");
        }
        if (n3 + n5 > this.height) {
            throw new IllegalArgumentException("Subimage minY+height must be <= height of parent image");
        }
        Image image = new Image(this.pixelFormat, this.pixelBuffer, n4, n5, this.minX + n2, this.minY + n3, this.scanlineStride);
        new Image(this.pixelFormat, this.pixelBuffer, n4, n5, this.minX + n2, this.minY + n3, this.scanlineStride).serial = this.serial;
        return image;
    }

    public Image createPackedCopy() {
        int n2 = this.width * this.pixelFormat.getBytesPerPixelUnit();
        Buffer buffer = Image.createPackedBuffer(this.pixelBuffer, this.pixelFormat, this.minX, this.minY, this.width, this.height, this.scanlineStride);
        return new Image(this.pixelFormat, buffer, this.width, this.height, 0, 0, n2);
    }

    public Image createPackedCopyIfNeeded() {
        int n2 = this.width * this.pixelFormat.getBytesPerPixelUnit();
        if (n2 == this.scanlineStride && this.minX == 0 && this.minY == 0) {
            return this;
        }
        return this.createPackedCopy();
    }

    public static Buffer createPackedBuffer(Buffer buffer, PixelFormat object, int n2, int n3, int n4, int n5, int n6) {
        if (n6 % ((PixelFormat)((Object)object)).getBytesPerPixelUnit() != 0) {
            throw new IllegalArgumentException("Image scanlineStride must be a multiple of the pixel stride");
        }
        if (object == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format unsupported " + String.valueOf(object));
        }
        int n7 = ((PixelFormat)((Object)object)).getElemsPerPixelUnit();
        n6 /= ((PixelFormat)((Object)object)).getBytesPerPixelUnit();
        int n8 = (n4 *= n7) * n5;
        n2 = n2 * n7 + n3 * (n6 *= n7);
        n3 = 0;
        switch (((PixelFormat)((Object)object)).getDataType()) {
            case BYTE: {
                object = (ByteBuffer)buffer;
                ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n8);
                for (int i2 = 0; i2 < n5; ++i2) {
                    ((ByteBuffer)object).limit(n2 + n4);
                    ((ByteBuffer)object).position(n2);
                    byteBuffer.limit(n3 + n4);
                    byteBuffer.position(n3);
                    byteBuffer.put((ByteBuffer)object);
                    n2 += n6;
                    n3 += n4;
                }
                object = byteBuffer;
                break;
            }
            case INT: {
                IntBuffer intBuffer = (IntBuffer)buffer;
                object = BufferUtil.newIntBuffer(n8);
                for (n7 = 0; n7 < n5; ++n7) {
                    intBuffer.limit(n2 + n4);
                    intBuffer.position(n2);
                    ((IntBuffer)object).limit(n3 + n4);
                    ((IntBuffer)object).position(n3);
                    ((IntBuffer)object).put(intBuffer);
                    n2 += n6;
                    n3 += n4;
                }
                break;
            }
            case FLOAT: {
                FloatBuffer floatBuffer = (FloatBuffer)buffer;
                object = BufferUtil.newFloatBuffer(n8);
                for (n8 = 0; n8 < n5; ++n8) {
                    floatBuffer.limit(n2 + n4);
                    floatBuffer.position(n2);
                    ((FloatBuffer)object).limit(n3 + n4);
                    ((FloatBuffer)object).position(n3);
                    ((FloatBuffer)object).put(floatBuffer);
                    n2 += n6;
                    n3 += n4;
                }
                break;
            }
            default: {
                throw new InternalError("Unknown data type");
            }
        }
        Buffer buffer2 = buffer;
        buffer2.limit(buffer2.capacity());
        buffer.rewind();
        Object object2 = object;
        ((Buffer)object2).limit(((Buffer)object2).capacity());
        ((Buffer)object).rewind();
        return object;
    }

    public Image iconify(ByteBuffer byteBuffer, int n2, int n3) {
        if (this.pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format not supported " + String.valueOf((Object)this.pixelFormat));
        }
        int n4 = this.getBytesPerPixelUnit();
        int n5 = n2 * n4;
        ByteToIntPixelConverter byteToIntPixelConverter = n4 == 1 ? ByteGray.ToIntArgbPreConverter() : (this.pixelFormat == PixelFormat.BYTE_BGRA_PRE ? ByteBgraPre.ToIntArgbPreConverter() : ByteRgb.ToIntArgbPreConverter());
        int[] nArray = new int[n2 * n3];
        int n6 = n2;
        byteToIntPixelConverter.convert(byteBuffer, 0, n5, nArray, 0, n6, n6, n3);
        return new Image(PixelFormat.INT_ARGB_PRE, nArray, n2, n3);
    }

    public String toString() {
        return super.toString() + " [format=" + String.valueOf((Object)this.pixelFormat) + " width=" + this.width + " height=" + this.height + " scanlineStride=" + this.scanlineStride + " minX=" + this.minX + " minY=" + this.minY + " pixelBuffer=" + String.valueOf(this.pixelBuffer) + " bpp=" + this.getBytesPerPixelUnit() + "]";
    }

    public Image$Serial getSerial() {
        return this.serial;
    }

    private void updateSerial() {
        this.updateSerial(null);
    }

    private void updateSerial(Rectangle rectangle) {
        this.serial.update(rectangle);
    }

    public Image promoteByteRgbToByteBgra() {
        ByteBuffer byteBuffer = (ByteBuffer)this.pixelBuffer;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.width * this.height << 2);
        int n2 = this.minY * this.scanlineStride + this.minX * 3;
        ByteRgb.ToByteBgraPreConverter().convert(byteBuffer, n2, this.scanlineStride, byteBuffer2, 0, this.width << 2, this.width, this.height);
        return new Image(PixelFormat.BYTE_BGRA_PRE, byteBuffer2, this.width, this.height, 0, 0, this.width << 2, this.getPixelScale());
    }

    private Image$Accessor<?> getPixelAccessor() {
        if (this.pixelaccessor == null) {
            switch (this.getPixelFormat()) {
                default: {
                    this.pixelaccessor = new Image$UnsupportedAccess(this);
                    break;
                }
                case BYTE_GRAY: {
                    this.pixelaccessor = new Image$ByteAccess(this, Image.getGrayFXPixelFormat(), ByteGray.getter, null, (ByteBuffer)this.pixelBuffer, 1);
                    break;
                }
                case BYTE_RGB: {
                    Image image = this;
                    this.pixelaccessor = new Image$ByteRgbAccess(image, (ByteBuffer)image.pixelBuffer);
                    break;
                }
                case BYTE_BGRA_PRE: {
                    this.pixelaccessor = new Image$ByteAccess(this, FX_ByteBgraPre_FORMAT, (ByteBuffer)this.pixelBuffer, 4);
                    break;
                }
                case INT_ARGB_PRE: {
                    this.pixelaccessor = new Image$IntAccess(this, FX_IntArgbPre_FORMAT, (IntBuffer)this.pixelBuffer);
                }
            }
            if (this.pixelScale != 1.0f) {
                Image image = this;
                this.pixelaccessor = new Image$ScaledAccessor(image, image.pixelaccessor, this.pixelScale);
            }
        }
        return this.pixelaccessor;
    }

    @Override
    public void bufferDirty(Rectangle rectangle) {
        this.updateSerial(rectangle);
    }

    @Override
    public javafx.scene.image.PixelFormat<?> getPlatformPixelFormat() {
        return this.getPixelAccessor().getPlatformPixelFormat();
    }

    @Override
    public boolean isWritable() {
        return this.getPixelAccessor().isWritable();
    }

    @Override
    public PlatformImage promoteToWritableImage() {
        return this.getPixelAccessor().promoteToWritableImage();
    }

    @Override
    public int getArgb(int n2, int n3) {
        return this.getPixelAccessor().getArgb(n2, n3);
    }

    @Override
    public void setArgb(int n2, int n3, int n4) {
        this.getPixelAccessor().setArgb(n2, n3, n4);
        this.updateSerial();
    }

    @Override
    public <T extends Buffer> void getPixels(int n2, int n3, int n4, int n5, WritablePixelFormat<T> writablePixelFormat, T t2, int n6) {
        this.getPixelAccessor().getPixels(n2, n3, n4, n5, writablePixelFormat, t2, n6);
    }

    @Override
    public void getPixels(int n2, int n3, int n4, int n5, WritablePixelFormat<ByteBuffer> writablePixelFormat, byte[] byArray, int n6, int n7) {
        this.getPixelAccessor().getPixels(n2, n3, n4, n5, writablePixelFormat, byArray, n6, n7);
    }

    @Override
    public void getPixels(int n2, int n3, int n4, int n5, WritablePixelFormat<IntBuffer> writablePixelFormat, int[] nArray, int n6, int n7) {
        this.getPixelAccessor().getPixels(n2, n3, n4, n5, writablePixelFormat, nArray, n6, n7);
    }

    @Override
    public <T extends Buffer> void setPixels(int n2, int n3, int n4, int n5, javafx.scene.image.PixelFormat<T> pixelFormat, T t2, int n6) {
        this.getPixelAccessor().setPixels(n2, n3, n4, n5, pixelFormat, t2, n6);
        this.updateSerial();
    }

    @Override
    public void setPixels(int n2, int n3, int n4, int n5, javafx.scene.image.PixelFormat<ByteBuffer> pixelFormat, byte[] byArray, int n6, int n7) {
        this.getPixelAccessor().setPixels(n2, n3, n4, n5, pixelFormat, byArray, n6, n7);
        this.updateSerial();
    }

    @Override
    public void setPixels(int n2, int n3, int n4, int n5, javafx.scene.image.PixelFormat<IntBuffer> pixelFormat, int[] nArray, int n6, int n7) {
        this.getPixelAccessor().setPixels(n2, n3, n4, n5, pixelFormat, nArray, n6, n7);
        this.updateSerial();
    }

    @Override
    public void setPixels(int n2, int n3, int n4, int n5, PixelReader pixelReader, int n6, int n7) {
        this.getPixelAccessor().setPixels(n2, n3, n4, n5, pixelReader, n6, n7);
        this.updateSerial();
    }

    public boolean isOpaque() {
        return this.pixelFormat.isOpaque();
    }

    static <I extends Buffer> PixelSetter<I> getSetterIfWritable(javafx.scene.image.PixelFormat<I> pixelFormat) {
        if (pixelFormat instanceof WritablePixelFormat) {
            return PixelUtils.getSetter((WritablePixelFormat)pixelFormat);
        }
        return null;
    }

    static javafx.scene.image.PixelFormat<ByteBuffer> getGrayFXPixelFormat() {
        if (FX_ByteGray_FORMAT == null) {
            int[] nArray = new int[256];
            int n2 = -16777216;
            for (int i2 = 0; i2 < 256; ++i2) {
                nArray[i2] = n2;
                n2 += 65793;
            }
            FX_ByteGray_FORMAT = javafx.scene.image.PixelFormat.createByteIndexedPremultipliedInstance(nArray);
        }
        return FX_ByteGray_FORMAT;
    }
}

