/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RenderTarget;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

public class ES2Graphics
extends BaseShaderGraphics {
    private final ES2Context context;

    private ES2Graphics(ES2Context eS2Context, RenderTarget renderTarget) {
        super(eS2Context, renderTarget);
        this.context = eS2Context;
    }

    static ES2Graphics create(ES2Context eS2Context, RenderTarget renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        return new ES2Graphics(eS2Context, renderTarget);
    }

    static void clearBuffers(ES2Context eS2Context, Color color, boolean bl2, boolean bl3, boolean bl4) {
        eS2Context.getGLContext().clearBuffers(color, bl2, bl3, bl4);
    }

    @Override
    public void clear(Color color) {
        ((BaseContext)this.context).validateClearOp(this);
        this.getRenderTarget().setOpaque(((Paint)color).isOpaque());
        ES2Graphics.clearBuffers(this.context, color, true, this.isDepthBuffer(), false);
    }

    @Override
    public void sync() {
        this.context.flushVertexBuffer();
        this.context.getGLContext().finish();
    }

    void forceRenderTarget() {
        this.context.forceRenderTarget(this);
    }

    @Override
    public void transform(BaseTransform baseTransform) {
        if (!GraphicsPipeline.getPipeline().is3DSupported() && !baseTransform.is2D()) {
            return;
        }
        super.transform(baseTransform);
    }

    @Override
    public void translate(float f2, float f3, float f4) {
        if (!GraphicsPipeline.getPipeline().is3DSupported() && f4 != 0.0f) {
            return;
        }
        super.translate(f2, f3, f4);
    }

    @Override
    public void scale(float f2, float f3, float f4) {
        if (!GraphicsPipeline.getPipeline().is3DSupported() && f4 != 1.0f) {
            return;
        }
        super.scale(f2, f3, f4);
    }

    @Override
    public void setCamera(NGCamera nGCamera) {
        if (GraphicsPipeline.getPipeline().is3DSupported()) {
            super.setCamera(nGCamera);
        }
    }
}

