/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Graphics;
import com.sun.prism.es2.ES2RTTextureData;
import com.sun.prism.es2.ES2RenderTarget;
import com.sun.prism.es2.ES2Texture;
import com.sun.prism.es2.ES2TextureResource;
import com.sun.prism.es2.ES2VramPool;
import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.PrismTrace;
import java.nio.Buffer;

class ES2RTTexture
extends ES2Texture<ES2RTTextureData>
implements RTTexture,
ReadbackRenderTarget,
ES2RenderTarget {
    private boolean opaque;

    private ES2RTTexture(ES2Context eS2Context, ES2TextureResource<ES2RTTextureData> eS2TextureResource, Texture$WrapMode texture$WrapMode, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(eS2Context, eS2TextureResource, PixelFormat.BYTE_BGRA_PRE, texture$WrapMode, n2, n3, n4, n5, n6, n7, n8, n9, false);
        PrismTrace.rttCreated((long)((ES2RTTextureData)eS2TextureResource.getResource()).getFboID(), n2, n3, PixelFormat.BYTE_BGRA_PRE.getBytesPerPixelUnit());
        this.opaque = false;
    }

    void attachDepthBuffer(ES2Context eS2Context) {
        ES2RTTextureData eS2RTTextureData = (ES2RTTextureData)((ES2TextureResource)this.resource).getResource();
        int n2 = eS2RTTextureData.getDepthBufferID();
        if (n2 != 0) {
            return;
        }
        n2 = this.isMSAA() ? eS2Context.getGLContext().getSampleSize() : 0;
        n2 = eS2Context.getGLContext().createDepthBuffer(this.getPhysicalWidth(), this.getPhysicalHeight(), n2);
        eS2RTTextureData.setDepthBufferID(n2);
    }

    private void createAndAttachMSAABuffer(ES2Context object) {
        ES2RTTextureData eS2RTTextureData = (ES2RTTextureData)((ES2TextureResource)this.resource).getResource();
        int n2 = eS2RTTextureData.getMSAARenderBufferID();
        if (n2 != 0) {
            return;
        }
        object = ((ES2Context)object).getGLContext();
        n2 = ((GLContext)object).createRenderBuffer(this.getPhysicalWidth(), this.getPhysicalHeight(), ((GLContext)object).getSampleSize());
        eS2RTTextureData.setMSAARenderBufferID(n2);
    }

    static int getCompatibleDimension(ES2Context object, int n2, Texture$WrapMode texture$WrapMode) {
        object = ((ES2Context)object).getGLContext();
        boolean bl2 = switch (texture$WrapMode) {
            case Texture$WrapMode.CLAMP_NOT_NEEDED -> false;
            case Texture$WrapMode.CLAMP_TO_ZERO -> !((GLContext)object).canClampToZero();
            default -> throw new IllegalArgumentException("wrap mode not supported for RT textures: " + String.valueOf((Object)texture$WrapMode));
            case Texture$WrapMode.CLAMP_TO_EDGE_SIMULATED, Texture$WrapMode.CLAMP_TO_ZERO_SIMULATED, Texture$WrapMode.REPEAT_SIMULATED -> throw new IllegalArgumentException("Cannot request simulated wrap mode: " + String.valueOf((Object)texture$WrapMode));
        };
        int n3 = bl2 ? n2 + 2 : n2;
        int n4 = ((GLContext)object).getMaxTextureSize();
        int n5 = ((GLContext)object).canCreateNonPowTwoTextures() ? (n3 <= n4 ? n3 : 0) : ES2RTTexture.nextPowerOfTwo(n3, n4);
        if (n5 == 0) {
            throw new RuntimeException("Requested texture dimension (" + n2 + ") requires dimension (" + n5 + ") that exceeds maximum texture size (" + n4 + ")");
        }
        n5 = Math.max(n5, PrismSettings.minRTTSize);
        if (bl2) {
            return n5 - 2;
        }
        return n5;
    }

    static ES2RTTexture create(ES2Context eS2Context, int n2, int n3, Texture$WrapMode texture$WrapMode, boolean bl2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        GLContext gLContext = eS2Context.getGLContext();
        int n9 = switch (texture$WrapMode) {
            case Texture$WrapMode.CLAMP_NOT_NEEDED -> 0;
            case Texture$WrapMode.CLAMP_TO_ZERO -> !gLContext.canClampToZero() ? 1 : 0;
            default -> throw new IllegalArgumentException("wrap mode not supported for RT textures: " + String.valueOf((Object)texture$WrapMode));
            case Texture$WrapMode.CLAMP_TO_EDGE_SIMULATED, Texture$WrapMode.CLAMP_TO_ZERO_SIMULATED, Texture$WrapMode.REPEAT_SIMULATED -> throw new IllegalArgumentException("Cannot request simulated wrap mode: " + String.valueOf((Object)texture$WrapMode));
        };
        if (n9 != 0) {
            n8 = 1;
            n7 = 1;
            n6 = n2 + 2;
            n5 = n3 + 2;
            texture$WrapMode = texture$WrapMode.simulatedVersion();
        } else {
            n8 = 0;
            n7 = 0;
            n6 = n2;
            n5 = n3;
        }
        int n10 = gLContext.getMaxTextureSize();
        if (gLContext.canCreateNonPowTwoTextures()) {
            n6 = n6 <= n10 ? n6 : 0;
            n5 = n5 <= n10 ? n5 : 0;
        } else {
            n6 = ES2RTTexture.nextPowerOfTwo(n6, n10);
            n5 = ES2RTTexture.nextPowerOfTwo(n5, n10);
        }
        if (n6 == 0 || n5 == 0) {
            throw new RuntimeException("Requested texture dimensions (" + n2 + "x" + n3 + ") require dimensions (" + n6 + "x" + n5 + ") that exceed maximum texture size (" + n10 + ")");
        }
        ES2VramPool eS2VramPool = ES2VramPool.instance;
        n10 = PrismSettings.minRTTSize;
        long l2 = eS2VramPool.estimateRTTextureSize(n6 = Math.max(n6, n10), n5 = Math.max(n5, n10), false);
        if (!eS2VramPool.prepareForAllocation(l2)) {
            return null;
        }
        if (n9 != 0) {
            n9 = n6 - 2;
            n4 = n5 - 2;
        } else {
            n9 = n6;
            n4 = n5;
        }
        gLContext.setActiveTextureUnit(0);
        int n11 = gLContext.getBoundFBO();
        int n12 = gLContext.getBoundTexture();
        int n13 = 0;
        if (!bl2) {
            n13 = gLContext.createTexture(n6, n5);
        }
        int n14 = 0;
        if ((n13 != 0 || bl2) && (n14 = gLContext.createFBO(n13)) == 0) {
            gLContext.deleteTexture(n13);
            n13 = 0;
        }
        Object object = new ES2RTTextureData(eS2Context, n13, n14, n6, n5, l2);
        object = new ES2TextureResource<ES2RTTextureData>((ES2RTTextureData)object);
        ES2RTTexture eS2RTTexture = new ES2RTTexture(eS2Context, (ES2TextureResource<ES2RTTextureData>)object, texture$WrapMode, n6, n5, n8, n7, n2, n3, n9, n4);
        if (bl2) {
            eS2RTTexture.createAndAttachMSAABuffer(eS2Context);
        }
        gLContext.bindFBO(n11);
        gLContext.setBoundTexture(n12);
        return eS2RTTexture;
    }

    @Override
    public Texture getBackBuffer() {
        return this;
    }

    @Override
    public Graphics createGraphics() {
        return ES2Graphics.create(this.context, this);
    }

    @Override
    public int[] getPixels() {
        return null;
    }

    @Override
    public boolean readPixels(Buffer buffer, int n2, int n3, int n4, int n5) {
        this.context.flushVertexBuffer();
        GLContext gLContext = this.context.getGLContext();
        int n6 = gLContext.getBoundFBO();
        int n7 = this.getFboID();
        boolean bl2 = n6 != n7;
        if (bl2) {
            gLContext.bindFBO(n7);
        }
        boolean bl3 = gLContext.readPixels(buffer, n2, n3, n4, n5);
        if (bl2) {
            gLContext.bindFBO(n6);
        }
        return bl3;
    }

    @Override
    public boolean readPixels(Buffer buffer) {
        return this.readPixels(buffer, this.getContentX(), this.getContentY(), this.getContentWidth(), this.getContentHeight());
    }

    @Override
    public int getFboID() {
        return ((ES2RTTextureData)((ES2TextureResource)this.resource).getResource()).getFboID();
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.context.getAssociatedScreen();
    }

    @Override
    public void update(Image image) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n2, int n3) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n2, int n3, int n4, int n5, boolean bl2) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean bl2) {
        this.opaque = bl2;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public boolean isMSAA() {
        return ((ES2RTTextureData)((ES2TextureResource)this.resource).getResource()).getMSAARenderBufferID() != 0;
    }
}

