/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Shader$ES2ShaderDisposerRecord;
import com.sun.prism.es2.ES2Shader$Uniform;
import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.BaseGraphicsResource;
import com.sun.prism.ps.Shader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ES2Shader
extends BaseGraphicsResource
implements Shader {
    private int programID;
    private final ES2Context context;
    private final Map<String, ES2Shader$Uniform> uniforms = new HashMap<String, ES2Shader$Uniform>();
    private final int maxTexCoordIndex;
    private final boolean isPixcoordUsed;
    private boolean valid;
    private float[] currentMatrix;

    /*
     * WARNING - void declaration
     */
    private ES2Shader(ES2Context eS2Context, int n2, int n3, int[] object2, Map<String, Integer> map, int n4, boolean bl2) throws RuntimeException {
        super(new ES2Shader$ES2ShaderDisposerRecord(eS2Context, n3, (int[])object2, n2));
        void var5_8;
        void var7_10;
        void var6_9;
        this.context = eS2Context;
        this.programID = n2;
        this.maxTexCoordIndex = var6_9;
        this.isPixcoordUsed = var7_10;
        boolean bl3 = this.valid = n2 != 0;
        if (this.valid && var5_8 != null) {
            n3 = eS2Context.getShaderProgram();
            eS2Context.setShaderProgram(n2);
            for (String string : var5_8.keySet()) {
                this.setConstant(string, (Integer)var5_8.get(string));
            }
            eS2Context.setShaderProgram(n3);
        }
    }

    static ES2Shader createFromSource(ES2Context eS2Context, String string, String[] objectArray, Map<String, Integer> map, Map<String, Integer> map2, int n2, boolean bl2) {
        GLContext gLContext = eS2Context.getGLContext();
        if (!gLContext.isShaderCompilerSupported()) {
            throw new RuntimeException("Shader compiler not available on this device");
        }
        if (string == null || objectArray == null || objectArray.length == 0) {
            throw new RuntimeException("Both vertexShaderSource and fragmentShaderSource must be specified");
        }
        int n3 = gLContext.compileShader(string, true);
        if (n3 == 0) {
            throw new RuntimeException("Error creating vertex shader");
        }
        int[] nArray = new int[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            nArray[i2] = gLContext.compileShader(objectArray[i2], false);
            if (nArray[i2] != 0) continue;
            gLContext.deleteShader(n3);
            throw new RuntimeException("Error creating fragment shader");
        }
        String[] stringArray = new String[map2.size()];
        objectArray = new int[stringArray.length];
        int n4 = 0;
        Iterator<String> iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            stringArray[n4] = string2 = iterator.next();
            objectArray[n4] = (String)((Object)map2.get(string2));
            ++n4;
        }
        int n5 = gLContext.createProgram(n3, nArray, stringArray, (int[])objectArray);
        if (n5 == 0) {
            throw new RuntimeException("Error creating shader program");
        }
        return new ES2Shader(eS2Context, n5, n3, nArray, map, n2, bl2);
    }

    static ES2Shader createFromSource(ES2Context eS2Context, String string, InputStream stringArray, Map<String, Integer> map, Map<String, Integer> map2, int n2, boolean bl2) {
        stringArray = new String[]{ES2Shader.readStreamIntoString((InputStream)stringArray)};
        return ES2Shader.createFromSource(eS2Context, string, stringArray, map, map2, n2, bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readStreamIntoString(InputStream closeable) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        closeable = new BufferedReader(new InputStreamReader((InputStream)closeable));
        try {
            int n2;
            char[] cArray = new char[1024];
            while ((n2 = ((Reader)closeable).read(cArray)) >= 0) {
                stringBuffer.append(String.valueOf(cArray, 0, n2));
            }
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeException("Error reading shader stream");
            }
            catch (Throwable throwable) {
                try {
                    ((BufferedReader)closeable).close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    throw new RuntimeException("Error closing reader");
                }
            }
        }
        try {
            ((BufferedReader)closeable).close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error closing reader");
        }
    }

    public int getProgramObject() {
        return this.programID;
    }

    public int getMaxTexCoordIndex() {
        return this.maxTexCoordIndex;
    }

    public boolean isPixcoordUsed() {
        return this.isPixcoordUsed;
    }

    private ES2Shader$Uniform getUniform(String string) {
        ES2Shader$Uniform eS2Shader$Uniform = this.uniforms.get(string);
        if (eS2Shader$Uniform == null) {
            int n2 = this.context.getGLContext().getUniformLocation(this.programID, string);
            eS2Shader$Uniform = new ES2Shader$Uniform();
            new ES2Shader$Uniform().location = n2;
            this.uniforms.put(string, eS2Shader$Uniform);
        }
        return eS2Shader$Uniform;
    }

    @Override
    public void enable() throws RuntimeException {
        this.context.updateShaderProgram(this.programID);
    }

    @Override
    public void disable() throws RuntimeException {
        this.context.updateShaderProgram(0);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setConstant(String object, int n2) throws RuntimeException {
        int[] nArray;
        object = this.getUniform((String)object);
        if (((ES2Shader$Uniform)object).location == -1) {
            return;
        }
        if (((ES2Shader$Uniform)object).values == null) {
            ((ES2Shader$Uniform)object).values = new int[1];
        }
        if ((nArray = (int[])((ES2Shader$Uniform)object).values)[0] != n2) {
            nArray[0] = n2;
            this.context.getGLContext().uniform1i(((ES2Shader$Uniform)object).location, n2);
        }
    }

    @Override
    public void setConstant(String object, int n2, int n3) throws RuntimeException {
        int[] nArray;
        object = this.getUniform((String)object);
        if (((ES2Shader$Uniform)object).location == -1) {
            return;
        }
        if (((ES2Shader$Uniform)object).values == null) {
            ((ES2Shader$Uniform)object).values = new int[2];
        }
        if ((nArray = (int[])((ES2Shader$Uniform)object).values)[0] != n2 || nArray[1] != n3) {
            nArray[0] = n2;
            nArray[1] = n3;
            this.context.getGLContext().uniform2i(((ES2Shader$Uniform)object).location, n2, n3);
        }
    }

    @Override
    public void setConstant(String object, int n2, int n3, int n4) throws RuntimeException {
        int[] nArray;
        object = this.getUniform((String)object);
        if (((ES2Shader$Uniform)object).location == -1) {
            return;
        }
        if (((ES2Shader$Uniform)object).values == null) {
            ((ES2Shader$Uniform)object).values = new int[3];
        }
        if ((nArray = (int[])((ES2Shader$Uniform)object).values)[0] != n2 || nArray[1] != n3 || nArray[2] != n4) {
            nArray[0] = n2;
            nArray[1] = n3;
            nArray[2] = n4;
            this.context.getGLContext().uniform3i(((ES2Shader$Uniform)object).location, n2, n3, n4);
        }
    }

    @Override
    public void setConstant(String object, int n2, int n3, int n4, int n5) throws RuntimeException {
        int[] nArray;
        object = this.getUniform((String)object);
        if (((ES2Shader$Uniform)object).location == -1) {
            return;
        }
        if (((ES2Shader$Uniform)object).values == null) {
            ((ES2Shader$Uniform)object).values = new int[4];
        }
        if ((nArray = (int[])((ES2Shader$Uniform)object).values)[0] != n2 || nArray[1] != n3 || nArray[2] != n4 || nArray[3] != n5) {
            nArray[0] = n2;
            nArray[1] = n3;
            nArray[2] = n4;
            nArray[3] = n5;
            this.context.getGLContext().uniform4i(((ES2Shader$Uniform)object).location, n2, n3, n4, n5);
        }
    }

    @Override
    public void setConstant(String object, float f2) throws RuntimeException {
        float[] fArray;
        object = this.getUniform((String)object);
        if (((ES2Shader$Uniform)object).location == -1) {
            return;
        }
        if (((ES2Shader$Uniform)object).values == null) {
            ((ES2Shader$Uniform)object).values = new float[1];
        }
        if ((fArray = (float[])((ES2Shader$Uniform)object).values)[0] != f2) {
            fArray[0] = f2;
            this.context.getGLContext().uniform1f(((ES2Shader$Uniform)object).location, f2);
        }
    }

    @Override
    public void setConstant(String object, float f2, float f3) throws RuntimeException {
        float[] fArray;
        object = this.getUniform((String)object);
        if (((ES2Shader$Uniform)object).location == -1) {
            return;
        }
        if (((ES2Shader$Uniform)object).values == null) {
            ((ES2Shader$Uniform)object).values = new float[2];
        }
        if ((fArray = (float[])((ES2Shader$Uniform)object).values)[0] != f2 || fArray[1] != f3) {
            fArray[0] = f2;
            fArray[1] = f3;
            this.context.getGLContext().uniform2f(((ES2Shader$Uniform)object).location, f2, f3);
        }
    }

    @Override
    public void setConstant(String object, float f2, float f3, float f4) throws RuntimeException {
        float[] fArray;
        object = this.getUniform((String)object);
        if (((ES2Shader$Uniform)object).location == -1) {
            return;
        }
        if (((ES2Shader$Uniform)object).values == null) {
            ((ES2Shader$Uniform)object).values = new float[3];
        }
        if ((fArray = (float[])((ES2Shader$Uniform)object).values)[0] != f2 || fArray[1] != f3 || fArray[2] != f4) {
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            this.context.getGLContext().uniform3f(((ES2Shader$Uniform)object).location, f2, f3, f4);
        }
    }

    @Override
    public void setConstant(String object, float f2, float f3, float f4, float f5) throws RuntimeException {
        float[] fArray;
        object = this.getUniform((String)object);
        if (((ES2Shader$Uniform)object).location == -1) {
            return;
        }
        if (((ES2Shader$Uniform)object).values == null) {
            ((ES2Shader$Uniform)object).values = new float[4];
        }
        if ((fArray = (float[])((ES2Shader$Uniform)object).values)[0] != f2 || fArray[1] != f3 || fArray[2] != f4 || fArray[3] != f5) {
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            fArray[3] = f5;
            this.context.getGLContext().uniform4f(((ES2Shader$Uniform)object).location, f2, f3, f4, f5);
        }
    }

    @Override
    public void setConstants(String string, IntBuffer intBuffer, int n2, int n3) throws RuntimeException {
        int n4 = this.getUniform((String)string).location;
        if (n4 == -1) {
            return;
        }
        this.context.getGLContext().uniform4iv(n4, n3, intBuffer);
    }

    @Override
    public void setConstants(String string, FloatBuffer floatBuffer, int n2, int n3) throws RuntimeException {
        int n4 = this.getUniform((String)string).location;
        if (n4 == -1) {
            return;
        }
        this.context.getGLContext().uniform4fv(n4, n3, floatBuffer);
    }

    public void setMatrix(String string, float[] fArray) throws RuntimeException {
        int n2 = this.getUniform((String)string).location;
        if (n2 == -1) {
            return;
        }
        if (this.currentMatrix == null) {
            this.currentMatrix = new float[16];
        }
        if (!Arrays.equals(this.currentMatrix, fArray)) {
            this.context.getGLContext().uniformMatrix4fv(n2, false, fArray);
            System.arraycopy(fArray, 0, this.currentMatrix, 0, fArray.length);
        }
    }

    @Override
    public void dispose() throws RuntimeException {
        if (this.programID != 0) {
            this.disposerRecord.dispose();
            this.programID = 0;
        }
        this.valid = false;
    }
}

