/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.prism.impl.Disposer$Record;
import com.sun.prism.impl.Disposer$Target;
import com.sun.prism.impl.PrismSettings;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.LinkedList;

public class Disposer {
    private static Disposer disposerInstance;
    private static final int WEAK = 0;
    private static final int PHANTOM = 1;
    private static final int SOFT = 2;
    private static int refType;
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Hashtable records = new Hashtable();
    private final LinkedList<Disposer$Record> disposalQueue = new LinkedList();

    private Disposer() {
    }

    public static void addRecord(Object object, Disposer$Record disposer$Record) {
        disposerInstance.add(object, disposer$Record);
    }

    public static void disposeRecord(Disposer$Record disposer$Record) {
        disposerInstance.addToDisposalQueue(disposer$Record);
    }

    public static void cleanUp() {
        if (!Thread.currentThread().getName().startsWith("QuantumRenderer")) {
            QuantumToolkit.runInRenderThreadAndWait(() -> Disposer.cleanUp());
            return;
        }
        disposerInstance.disposeUnreachables();
        disposerInstance.processDisposalQueue();
    }

    private synchronized void add(Object reference, Disposer$Record disposer$Record) {
        if (reference instanceof Disposer$Target) {
            reference = ((Disposer$Target)((Object)reference)).getDisposerReferent();
        }
        reference = refType == 1 ? new PhantomReference<Object>(reference, this.queue) : (refType == 2 ? new SoftReference<PhantomReference<Object>>((PhantomReference<Object>)reference, this.queue) : new WeakReference<PhantomReference<Object>>((PhantomReference<Object>)reference, this.queue));
        this.records.put(reference, disposer$Record);
    }

    private synchronized void addToDisposalQueue(Disposer$Record disposer$Record) {
        this.disposalQueue.add(disposer$Record);
    }

    private synchronized void disposeUnreachables() {
        Object object;
        while ((object = this.queue.poll()) != null) {
            try {
                ((Reference)object).clear();
                object = (Disposer$Record)this.records.remove(object);
                object.dispose();
            }
            catch (Exception exception) {
                System.out.println("Exception while removing reference: " + String.valueOf(exception));
                exception.printStackTrace();
            }
        }
    }

    private synchronized void processDisposalQueue() {
        while (!this.disposalQueue.isEmpty()) {
            this.disposalQueue.remove().dispose();
        }
    }

    static {
        refType = 1;
        String string = PrismSettings.refType;
        if (string != null) {
            if (string.equals("weak")) {
                refType = 0;
                if (PrismSettings.verbose) {
                    System.err.println("Using WEAK refs");
                }
            } else if (string.equals("soft")) {
                refType = 2;
                if (PrismSettings.verbose) {
                    System.err.println("Using SOFT refs");
                }
            } else {
                refType = 1;
                if (PrismSettings.verbose) {
                    System.err.println("Using PHANTOM refs");
                }
            }
        }
        disposerInstance = new Disposer();
    }
}

