/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.prism.PixelSource;
import com.sun.prism.impl.BufferUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

public class QueuedPixelSource
implements PixelSource {
    private volatile Pixels beingConsumed;
    private volatile Pixels enqueued;
    private final List<WeakReference<Pixels>> saved = new ArrayList<WeakReference<Pixels>>(3);
    private final boolean useDirectBuffers;

    public QueuedPixelSource(boolean bl2) {
        this.useDirectBuffers = bl2;
    }

    @Override
    public synchronized Pixels getLatestPixels() {
        if (this.beingConsumed != null) {
            throw new IllegalStateException("already consuming pixels: " + String.valueOf(this.beingConsumed));
        }
        if (this.enqueued != null) {
            this.beingConsumed = this.enqueued;
            this.enqueued = null;
        }
        return this.beingConsumed;
    }

    @Override
    public synchronized void doneWithPixels(Pixels pixels) {
        if (this.beingConsumed != pixels) {
            throw new IllegalStateException("wrong pixels buffer: " + String.valueOf(pixels) + " != " + String.valueOf(this.beingConsumed));
        }
        this.beingConsumed = null;
    }

    @Override
    public synchronized void skipLatestPixels() {
        if (this.beingConsumed != null) {
            throw new IllegalStateException("cannot skip while processing: " + String.valueOf(this.beingConsumed));
        }
        this.enqueued = null;
    }

    private boolean usesSameBuffer(Pixels pixels, Pixels pixels2) {
        if (pixels == pixels2) {
            return true;
        }
        if (pixels == null || pixels2 == null) {
            return false;
        }
        return pixels.getBuffer() == pixels2.getBuffer();
    }

    public synchronized Pixels getUnusedPixels(int n2, int n3, float f2, float f3) {
        int n4 = 0;
        IntBuffer intBuffer = null;
        while (n4 < this.saved.size()) {
            Object object = this.saved.get(n4);
            if ((object = (Pixels)((Reference)object).get()) == null) {
                this.saved.remove(n4);
                continue;
            }
            if (this.usesSameBuffer((Pixels)object, this.beingConsumed) || this.usesSameBuffer((Pixels)object, this.enqueued)) {
                ++n4;
                continue;
            }
            if (((Pixels)object).getWidthUnsafe() == n2 && ((Pixels)object).getHeightUnsafe() == n3 && ((Pixels)object).getScaleXUnsafe() == f2 && ((Pixels)object).getScaleYUnsafe() == f3) {
                return object;
            }
            this.saved.remove(n4);
            intBuffer = (IntBuffer)((Pixels)object).getPixels();
            if (intBuffer.capacity() >= n2 * n3) break;
            intBuffer = null;
        }
        if (intBuffer == null) {
            int n5 = n2 * n3;
            intBuffer = this.useDirectBuffers ? BufferUtil.newIntBuffer(n5) : IntBuffer.allocate(n5);
        }
        Pixels pixels = Application.GetApplication().createPixels(n2, n3, intBuffer, f2, f3);
        this.saved.add(new WeakReference<Pixels>(pixels));
        return pixels;
    }

    public synchronized void enqueuePixels(Pixels pixels) {
        this.enqueued = pixels;
    }
}

